<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Familias extends CI_Controller {

	public function __construct(){
		parent::__construct(); $this->load->model("Phuyu_model");
	}

	public function index(){
		if ($this->input->is_ajax_request()) {
			if (isset($_SESSION["phuyu_usuario"])) {
				$this->load->view("almacen/familias/index");
			}else{
				$this->load->view("phuyu/505");
			}
		}else{
			$this->load->view("phuyu/404");
		}
	}

	public function lista(){
		if ($this->input->is_ajax_request()) {
			$this->request = json_decode(file_get_contents('php://input'));
			$limit = 10; $offset = $this->request->pagina * $limit - $limit;

			$lista = $this->db->query("select f.*,l.descripcion AS linea from almacen.familias f JOIN almacen.lineas l ON f.codlinea = l.codlinea where UPPER(f.descripcion) like UPPER('%".$this->request->buscar."%') and f.estado=1 order by codfamilia desc offset ".$offset." limit ".$limit)->result_array();

			$total = $this->db->query("select count(*) as total from almacen.familias f JOIN almacen.lineas l ON f.codlinea = l.codlinea where UPPER(f.descripcion) like UPPER('%".$this->request->buscar."%') and f.estado=1")->result_array();

			$paginas = floor($total[0]["total"] / $limit);
			if ( ($total[0]["total"] % $limit)!=0 ) {
				$paginas = $paginas + 1;
			}

			$paginacion = array();
			$paginacion["total"] = $total[0]["total"];
			$paginacion["actual"] = $this->request->pagina;
			$paginacion["ultima"] = $paginas;
			$paginacion["desde"] = $offset;
			$paginacion["hasta"] = $offset + $limit;

			echo json_encode(array("lista" => $lista,"paginacion" => $paginacion));
		}else{
			$this->load->view("phuyu/404");
		}
	}

	function listado($codlinea){
		if ($this->input->is_ajax_request()) {
			$familias = $this->db->query("select *from almacen.familias where codlinea='".$codlinea."' AND estado = 1 order by codfamilia")->result_array();
			$html = '<option value="">SELECCIONE</option>';
			foreach ($familias as $key => $value) {
				$html .= '<option value="'.$value["codfamilia"].'">'.$value["descripcion"].'</option>';
			}
			echo $html;
		}
	}

	public function nuevo(){
		if ($this->input->is_ajax_request()) {
			if (isset($_SESSION["phuyu_usuario"])) {
				$lineas = $this->db->query("select * from almacen.lineas where estado=1")->result_array();
				$this->load->view("almacen/familias/nuevo",compact("lineas"));
			}else{
				$this->load->view("phuyu/505");
			}
		}else{
			$this->load->view("phuyu/404");
		}
	}

	function guardar(){
		if ($this->input->is_ajax_request()) {
			$campos = ["codlinea","descripcion"];
			$this->request = json_decode(file_get_contents('php://input'));
			$valores = [$this->request->codlinea,$this->request->descripcion];

			if($this->request->codregistro=="") {
				$estado = $this->Phuyu_model->phuyu_guardar("almacen.familias", $campos, $valores);
			}else{
				$estado = $this->Phuyu_model->phuyu_editar("almacen.familias", $campos, $valores, "codfamilia", $this->request->codregistro);
			}
			echo $estado;
		}else{
			$this->load->view("phuyu/404");
		}
	}

	function editar(){
		if ($this->input->is_ajax_request()) {
			$this->request = json_decode(file_get_contents('php://input'));
			$info = $this->db->query("select codfamilia as codregistro,* from almacen.familias where codfamilia=".$this->request->codregistro)->result_array();
			echo json_encode($info);
		}else{
			$this->load->view("phuyu/404");
		}
	}

	function eliminar(){
		if ($this->input->is_ajax_request()) {
			$this->request = json_decode(file_get_contents('php://input'));
			$estado = $this->Phuyu_model->phuyu_eliminar("almacen.familias", "codfamilia", $this->request->codregistro);
			echo $estado;
		}else{
			$this->load->view("phuyu/404");
		}
	}
}