<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Ingresos extends CI_Controller {

	public function __construct(){
		parent::__construct(); 
		$this->load->model("Phuyu_model"); $this->load->model("Kardex_model");
	}

	public function index(){
		if ($this->input->is_ajax_request()) {
			if (isset($_SESSION["phuyu_codusuario"])) {
				$this->load->view("almacen/ingresos/index");
			}else{
				$this->load->view("phuyu/505");
			}
		}else{
			$this->load->view("phuyu/404");
		}
	}

	public function lista(){
		if ($this->input->is_ajax_request()) {
			$this->request = json_decode(file_get_contents('php://input'));
			$limit = 10; $offset = $this->request->pagina * $limit - $limit;

			$lista = $this->db->query("select kardex.codkardex,kardex.codalmacen_ref,kardex.codmovimientotipo, kardex.codcomprobantetipo, kardex.seriecomprobante,kardex.nrocomprobante, kardex.fechakardex,round(kardex.importe,2) as importe,kardex.seriecomprobante_ref,kardex.nrocomprobante_ref, usuarios.usuario,tipos.descripcion as tipomovimiento,comprobantes.descripcion as tipo,kardex.estado from kardex.kardex as kardex inner join seguridad.usuarios as usuarios on (kardex.codusuario=usuarios.codusuario) inner join caja.comprobantetipos as comprobantes on(kardex.codcomprobantetipo_ref=comprobantes.codcomprobantetipo) inner join almacen.movimientotipos as tipos on(kardex.codmovimientotipo=tipos.codmovimientotipo) where codalmacen=".$_SESSION["phuyu_codalmacen"]." and (UPPER(usuarios.usuario) like UPPER('%".$this->request->buscar."%') or UPPER(tipos.descripcion) like UPPER('%".$this->request->buscar."%') or UPPER(kardex.seriecomprobante) like UPPER('%".$this->request->buscar."%') or UPPER(kardex.nrocomprobante) like UPPER('%".$this->request->buscar."%') ) and tipos.tipo=1 and kardex.codmovimientotipo<>2 order by kardex.codkardex desc offset ".$offset." limit ".$limit)->result_array();

			foreach ($lista as $key => $value) {
            	if($value["codalmacen_ref"] > 0){
					$info = $this->db->query("select descripcion from almacen.almacenes where codalmacen=".$value["codalmacen_ref"])->result_array();
					$lista[$key]["destino"] = $info[0]["descripcion"];
				}else{
					$lista[$key]["destino"] = '-';
				}
			}
			
			$total = $this->db->query("select count(*) as total from kardex.kardex as kardex inner join seguridad.usuarios as usuarios on (kardex.codusuario=usuarios.codusuario) inner join caja.comprobantetipos as comprobantes on(kardex.codcomprobantetipo_ref=comprobantes.codcomprobantetipo) inner join almacen.movimientotipos as tipos on(kardex.codmovimientotipo=tipos.codmovimientotipo) where codalmacen=".$_SESSION["phuyu_codalmacen"]." and (UPPER(usuarios.usuario) like UPPER('%".$this->request->buscar."%') or UPPER(tipos.descripcion) like UPPER('%".$this->request->buscar."%') or UPPER(kardex.seriecomprobante) like UPPER('%".$this->request->buscar."%') or UPPER(kardex.nrocomprobante) like UPPER('%".$this->request->buscar."%') ) and tipos.tipo=1 and kardex.codmovimientotipo<>2")->result_array();

			$paginas = floor($total[0]["total"] / $limit);
			if ( ($total[0]["total"] % $limit)!=0 ) {
				$paginas = $paginas + 1;
			}

			$paginacion = array();
			$paginacion["total"] = $total[0]["total"];
			$paginacion["actual"] = $this->request->pagina;
			$paginacion["ultima"] = $paginas;
			$paginacion["desde"] = $offset;
			$paginacion["hasta"] = $offset + $limit;

			echo json_encode(array("lista" => $lista,"paginacion" => $paginacion));
		}else{
			$this->load->view("phuyu/404");
		}
	}

	public function nuevo(){
		if ($this->input->is_ajax_request()) {
			if (isset($_SESSION["phuyu_usuario"])) {
				$movimientos = $this->db->query("select *from almacen.movimientotipos where codmovimientotipo<>2 and tipo=1 and estado=1")->result_array();
				$serie = $this->db->query("select ct.abreviatura as comprobante,c.codcomprobantetipo, c.seriecomprobante from caja.comprobantes as c inner join caja.comprobantetipos as ct on(c.codcomprobantetipo=ct.codcomprobantetipo) where c.codcomprobantetipo=3 and c.codsucursal=".$_SESSION["phuyu_codsucursal"]." and c.codalmacen=".$_SESSION["phuyu_codalmacen"]." and c.estado=1")->result_array();
				$tipocomprobantes = $this->db->query("select *from caja.comprobantetipos where codcomprobantetipo>=10 and estado=1 order by codcomprobantetipo")->result_array();
				$almacenes = $this->db->query("select almacen.*, sucursal.descripcion as sucursal from almacen.almacenes as almacen inner join public.sucursales as sucursal on(almacen.codsucursal=sucursal.codsucursal) where almacen.codalmacen<>".$_SESSION["phuyu_codalmacen"]." and almacen.estado=1")->result_array();
				$this->load->view("almacen/ingresos/nuevo",compact("movimientos","serie","tipocomprobantes","almacenes"));
			}else{
				$this->load->view("phuyu/505");
			}
		}else{
			$this->load->view("phuyu/404");
		}
	}

	function ver($codregistro){
		if ($this->input->is_ajax_request()) {
			if (isset($_SESSION["phuyu_codusuario"])){
				$info = $this->db->query("select kardex.*,personas.*,comprobantes.descripcion as tipo from kardex.kardex as kardex inner join public.personas as personas on (kardex.codpersona=personas.codpersona) inner join caja.comprobantetipos as comprobantes on(kardex.codcomprobantetipo=comprobantes.codcomprobantetipo) where kardex.codkardex=".$codregistro)->result_array();

				$detalle = $this->db->query("select kd.*,p.descripcion as producto,u.descripcion as unidad from kardex.kardexdetalle as kd inner join almacen.productos as p on(kd.codproducto=p.codproducto) inner join almacen.unidades as u on(kd.codunidad=u.codunidad) where kd.codkardex=".$codregistro." and kd.estado=1 order by kd.item")->result_array();

				$this->load->view("almacen/ingresos/ver",compact("info","detalle")); 
			}else{
	            $this->load->view("inicio/505");
	        }
	    }else{
			$this->load->view("inicio/404");
		}
	}
	
	function guardar(){
		if ($this->input->is_ajax_request()) {
			if (isset( $_SESSION["phuyu_codusuario"]) ) {
				$this->request = json_decode(file_get_contents('php://input'));
				//echo 1; exit;

				$this->db->trans_begin();

				// REGISTRO KARDEX //
				$campos = ["codsucursal","codalmacen","codalmacen_ref","codpersona","codusuario","codmovimientotipo","fechakardex","fechacomprobante","codcomprobantetipo","seriecomprobante","codcomprobantetipo_ref","seriecomprobante_ref","nrocomprobante_ref","valorventa","porcigv","igv","importe","descripcion"];
				$valores = [
					(int)$_SESSION["phuyu_codsucursal"],
					(int)$_SESSION["phuyu_codalmacen"],
					(int)$this->request->campos->codalmacen_ref,1,
					(int)$_SESSION["phuyu_codusuario"],
					(int)$this->request->campos->codmovimientotipo,
					$this->request->campos->fechakardex,$this->request->campos->fechakardex,
					(int)$this->request->campos->codcomprobantetipo,
					$this->request->campos->seriecomprobante,
					(int)$this->request->campos->codcomprobantetipo_ref,
					$this->request->campos->seriecomprobante_ref,
					$this->request->campos->nrocomprobante_ref,
					(double)$this->request->totales->valorventa,
					(double)$_SESSION["phuyu_igv"],
					(double)$this->request->totales->igv,
					(double)$this->request->totales->importe,
					$this->request->campos->descripcion
				];
				$codkardex = $this->Phuyu_model->phuyu_guardar("kardex.kardex", $campos, $valores, "true");

				// REGISTRO KARDEX ALMACEN //
				$campos = ["codsucursal","codalmacen","codalmacen_ref","codkardex","codusuario","codmovimientotipo","fechakardex","codcomprobantetipo","seriecomprobante"];
				$valores = [
					(int)$_SESSION["phuyu_codsucursal"],
					(int)$_SESSION["phuyu_codalmacen"],
					(int)$this->request->campos->codalmacen_ref,
					(int)$codkardex,
					(int)$_SESSION["phuyu_codusuario"],
					(int)$this->request->campos->codmovimientotipo,
					$this->request->campos->fechakardex,
					(int)$this->request->campos->codcomprobantetipo,
					$this->request->campos->seriecomprobante
				];
				$codkardexalmacen = $this->Phuyu_model->phuyu_guardar("kardex.kardexalmacen", $campos, $valores, "true");
				
				$nro_comprobante = $this->Kardex_model->phuyu_kardexcorrelativo($codkardex,$codkardexalmacen,$this->request->campos->codcomprobantetipo,$this->request->campos->seriecomprobante);

				// REGISTRO KARDEX DETALLE Y KARDEX ALMACEN DETALLE //
				$item = 0;
				foreach ($this->request->detalle as $key => $value) { 
					$item = $item + 1;

					$this->request->detalle[$key]->fechaproduccion = ($this->request->detalle[$key]->fechaproduccion=="") ? null : $this->request->detalle[$key]->fechaproduccion;
					$this->request->detalle[$key]->fechavencimiento = ($this->request->detalle[$key]->fechavencimiento=="") ? null : $this->request->detalle[$key]->fechavencimiento;
					$this->request->detalle[$key]->fecharegistrosanitario = ($this->request->detalle[$key]->fecharegistrosanitario=="") ? null : $this->request->detalle[$key]->fecharegistrosanitario; 

					if(!isset($this->request->detalle[$key]->itemorigen) || empty($this->request->detalle[$key]->itemorigen)){
						$this->request->detalle[$key]->itemorigen = 0;
					}
					if(!isset($this->request->detalle[$key]->codkardexorigen)){
						$this->request->detalle[$key]->codkardexorigen = 0;
					}

					$factorventa = $this->db->query("Select *from almacen.productoubicacion WHERE codproducto=".$this->request->detalle[$key]->codproducto." AND codunidad=".$this->request->detalle[$key]->codunidad." AND codalmacen=".$_SESSION["phuyu_codalmacen"]." AND estado=1")->result_array();

					$cantidadlote = (double)$this->request->detalle[$key]->cantidad;

					$cantidadloteconvertido = (double)$this->request->detalle[$key]->cantidad*(double)$factorventa[0]["factor"];

					$campos = ["codkardex","codproducto","codunidad","item","cantidad","preciobruto","preciosinigv","preciounitario","preciorefunitario","codafectacionigv","valorventa","subtotal","registrosanitario","fecharegistrosanitario","fechavencimiento","fechaproduccion","loteproduccion","stockkardex","stockkardexconvertido","itemdestino","codkardexdestino"];
					$valores =[
						(int)$codkardex,
						(int)$this->request->detalle[$key]->codproducto,
						(int)$this->request->detalle[$key]->codunidad, $item,
						(double)$this->request->detalle[$key]->cantidad,
						(double)$this->request->detalle[$key]->precio,
						(double)$this->request->detalle[$key]->precio,
						(double)$this->request->detalle[$key]->precio,
						(double)$this->request->detalle[$key]->precio,'10',
						(double)$this->request->detalle[$key]->subtotal,
						(double)$this->request->detalle[$key]->subtotal,
						$this->request->detalle[$key]->registrosanitario,
						$this->request->detalle[$key]->fecharegistrosanitario,
						$this->request->detalle[$key]->fechavencimiento,
						$this->request->detalle[$key]->fechaproduccion,
						$this->request->detalle[$key]->loteproduccion,
						(double)$cantidadlote,
						$cantidadloteconvertido,
						$this->request->detalle[$key]->itemorigen,
						$this->request->detalle[$key]->codkardexorigen
					];
					$estado = $this->Phuyu_model->phuyu_guardar("kardex.kardexdetalle", $campos, $valores);

					$campos =["codkardexalmacen","codproducto","codunidad","item","codalmacen","codsucursal","cantidad"];
					$valores =[
						(int)$codkardexalmacen,
						(int)$this->request->detalle[$key]->codproducto,
						(int)$this->request->detalle[$key]->codunidad, $item,
						(int)$_SESSION["phuyu_codalmacen"],
						(int)$_SESSION["phuyu_codsucursal"],
						(double)$this->request->detalle[$key]->cantidad
					];
					$estado = $this->Phuyu_model->phuyu_guardar("kardex.kardexalmacendetalle", $campos, $valores);

					$existe_ubi = $this->db->query("select *from almacen.productoubicacion where codalmacen=".$_SESSION["phuyu_codalmacen"]." and codproducto=".$this->request->detalle[$key]->codproducto." and codunidad=".$this->request->detalle[$key]->codunidad)->result_array();
					
					if (count($existe_ubi)>0) {
						$stock = round($existe_ubi[0]["stockactual"] + $this->request->detalle[$key]->cantidad,3);

						$campos = ["stockactual"]; $valores = [(double)$stock];
						$f = ["codalmacen","codproducto","codunidad"]; 
						$v = [(int)$_SESSION["phuyu_codalmacen"],(int)$this->request->detalle[$key]->codproducto,(int)$this->request->detalle[$key]->codunidad];
						$estado = $this->Phuyu_model->phuyu_editar_1("almacen.productoubicacion", $campos, $valores, $f, $v);
					}else{
						$campos = ["codalmacen","codproducto","codunidad","codsucursal","stockactual","stockactualreal"];
						$valores =[
							(int)$_SESSION["phuyu_codalmacen"],
							(int)$this->request->detalle[$key]->codproducto,
							(int)$this->request->detalle[$key]->codunidad,
							(int)$_SESSION["phuyu_codsucursal"],
							(double)$this->request->detalle[$key]->cantidad,
							(double)$this->request->detalle[$key]->cantidad
						];
						$estado = $this->Phuyu_model->phuyu_guardar("almacen.productoubicacion", $campos, $valores);
					}

					// AUMENTAMOS EL STOCKACTUALCONVERTIDO

					$stockconvertido = $this->db->query("select *from almacen.productoubicacion where codalmacen=".$_SESSION["phuyu_codalmacen"]." and codproducto=".$this->request->detalle[$key]->codproducto)->result_array();

					$factor = $this->db->query("select *from almacen.productounidades where codproducto=".$this->request->detalle[$key]->codproducto." and codunidad=".$this->request->detalle[$key]->codunidad)->result_array();

					foreach ($stockconvertido as $k => $val) {
						$stockc = 0;
						$productounidad = $this->db->query("select *from almacen.productounidades where codproducto=".$this->request->detalle[$key]->codproducto." and codunidad=".$val["codunidad"])->result_array();
						$stockc = ((float)$this->request->detalle[$key]->cantidad*(float)$factor[0]["factor"])/(float)$productounidad[0]["factor"];
						
                        $stockc = (double)$val["stockactualconvertido"] + $stockc;
						$campos = ["stockactualconvertido"]; $valores = [(double)$stockc];
						$f = ["codalmacen","codproducto","codunidad"]; 
						$v = [(int)$_SESSION["phuyu_codalmacen"],(int)$this->request->detalle[$key]->codproducto,(int)$val["codunidad"]];
						$estado = $this->Phuyu_model->phuyu_editar_1("almacen.productoubicacion", $campos, $valores, $f, $v);
					}
				}

				if ($this->db->trans_status() === FALSE){
				    $this->db->trans_rollback(); $estado = 0;
				}else{
					if ($estado!=1) {
						$this->db->trans_rollback(); $estado = 0;
					}
					$this->db->trans_commit();
				}
				echo $estado;
			}else{
				echo "e";
			}
		}else{
			$this->load->view("phuyu/404");
		}
	}

	function editar(){
		if ($this->input->is_ajax_request()) {
			if (isset( $_SESSION["phuyu_codusuario"]) ) {
				$this->request = json_decode(file_get_contents('php://input'));
				$info = $this->db->query("select codkardex,fechacomprobante,fechakardex, seriecomprobante, nrocomprobante, descripcion,codmovimientotipo from kardex.kardex where codkardex=".$this->request->codregistro)->result_array();
				$movimientos = $this->db->query("select *from almacen.movimientotipos where codmovimientotipo<>2 and tipo=1 and estado=1")->result_array();
				$this->load->view("almacen/ingresos/editar",compact("info","movimientos"));
			}else{
				$this->load->view("phuyu/505");
			}
		}else{
			$this->load->view("phuyu/404");
		}
	}

	function editar_guardar(){
		if ($this->input->is_ajax_request()) {
			$this->request = json_decode(file_get_contents('php://input'));

			$campos = ["codmovimientotipo","fechacomprobante","fechakardex","descripcion"];
			$valores = [
				$this->request->codmovimientotipo,
				$this->request->fechacomprobante,
				$this->request->fechakardex,
				$this->request->descripcion
			];
			$estado = $this->Phuyu_model->phuyu_editar("kardex.kardex", $campos, $valores, "codkardex",$this->request->codregistro);

			$campos = ["fechakardex"]; $valores = [$this->request->fechakardex];
			$estado_u = $this->Phuyu_model->phuyu_editar("kardex.kardexalmacen", $campos, $valores, "codkardex",$this->request->codregistro);
			echo $estado;
		}
	}

	function eliminar(){
		if ($this->input->is_ajax_request()) {
			$this->request = json_decode(file_get_contents('php://input'));
			$this->db->trans_begin();
            
            //VERIFICAMOS SI SE HICIERON VENTAS DEL INGRESO
			$existe = $this->db->query("Select *from kardex.kardexdetalle kd inner join kardex.kardex k ON k.codkardex = kd.codkardex where codkardexdestino=".$this->request->codregistro." AND k.estado = 1 ")->result_array();

			if(count($existe) > 0){
				echo 2; exit;
			}

			// ACTUALIZAMOS PRODUCTOS UBICACION //
			$kardexalmacen = $this->db->query("select codkardexalmacen from kardex.kardexalmacen where codkardex=".$this->request->codregistro)->result_array();

			$info = $this->db->query("select *from kardex.kardexdetalle where codkardex=".$this->request->codregistro)->result_array();
			foreach ($info as $key => $value) {
				$existe = $this->db->query("select *from almacen.productoubicacion where codalmacen=".$_SESSION["phuyu_codalmacen"]." and codproducto=".$value["codproducto"]." and codunidad=".$value["codunidad"])->result_array();
				$stock = $existe[0]["stockactual"] - $value["cantidad"];

				$campos = ["stockactual"]; $valores = [(double)$stock];
				$f = ["codalmacen","codproducto","codunidad"];
				$v = [(int)$_SESSION["phuyu_codalmacen"],(int)$value["codproducto"],(int)$value["codunidad"]];
				$estado = $this->Phuyu_model->phuyu_editar_1("almacen.productoubicacion", $campos, $valores, $f, $v);

				// DISMINUIMOS EL STOCKACTUALCONVERTIDO

				$stockconvertido = $this->db->query("select *from almacen.productoubicacion where codalmacen=".$_SESSION["phuyu_codalmacen"]." and codproducto=".$value["codproducto"])->result_array();

				$factor = $this->db->query("select *from almacen.productounidades where codproducto=".$value["codproducto"]." and codunidad=".$value["codunidad"])->result_array();

				foreach ($stockconvertido as $k => $val) {
					$stockc = 0;
					$productounidad = $this->db->query("select *from almacen.productounidades where codproducto=".$value["codproducto"]." and codunidad=".$val["codunidad"])->result_array();

					$stockc = ((float)$value["cantidad"]*(float)$factor[0]["factor"])/(float)$productounidad[0]["factor"];
					$stockc = $val["stockactualconvertido"] - $stockc;
                    $campos = ["stockactualconvertido"]; $valores = [(double)$stockc];
					$f = ["codalmacen","codproducto","codunidad"];
					$v = [(int)$_SESSION["phuyu_codalmacen"],(int)$value["codproducto"],(int)$val["codunidad"]];
					$estado = $this->Phuyu_model->phuyu_editar_1("almacen.productoubicacion", $campos, $valores, $f, $v);
				}
			}
			$estado = $this->Phuyu_model->phuyu_eliminar("kardex.kardex", "codkardex", $this->request->codregistro);
			$estado = $this->Phuyu_model->phuyu_eliminar("kardex.kardexalmacen", "codkardexalmacen", $kardexalmacen[0]["codkardexalmacen"]);

			// REGISTRO KARDEX ANULADOS //
			$campos = ["codkardex","codsucursal","codusuario","fechaanulacion","observaciones"];
			$valores =[
				(int)$this->request->codregistro, (int)$_SESSION["phuyu_codsucursal"], (int)$_SESSION["phuyu_codusuario"], date("Y-m-d"),
				"SALIDA DE ALMACEN ANULADO"
			];
			$estado = $this->Phuyu_model->phuyu_guardar("kardex.kardexanulados", $campos, $valores);

			// REGISTRO KARDEX ALMACEN ANULADOS //
			$campos = ["codkardexalmacen","codsucursal","codusuario","fechaanulacion","observaciones"];
			$valores =[
				(int)$kardexalmacen[0]["codkardexalmacen"], (int)$_SESSION["phuyu_codsucursal"], (int)$_SESSION["phuyu_codusuario"], date("Y-m-d"),
				"SALIDA DE ALMACEN ANULADO"
			];
			$estado = $this->Phuyu_model->phuyu_guardar("kardex.kardexalmacenanulado", $campos, $valores);

			if ($this->db->trans_status() === FALSE){
			    $this->db->trans_rollback(); $estado = 0;
			}else{
				if ($estado!=1) {
					$this->db->trans_rollback(); $estado = 0;
				}
				$this->db->trans_commit();
			}
			echo $estado;
		}else{
			$this->load->view("phuyu/404");
		}
	}

	// Transferecias de almacen //
	function transferencias(){
		if ($this->input->is_ajax_request()) {
			$transferencias = $this->db->query("select k.codkardex,k.fechakardex,k.seriecomprobante,k.nrocomprobante,k.seriecomprobante_ref, k.nrocomprobante_ref,round(k.importe,2) as importe, a.descripcion as almacen from kardex.kardex as k inner join almacen.almacenes as a on(k.codalmacen=a.codalmacen) where k.codalmacen_ref=".$_SESSION["phuyu_codalmacen"]." and k.transferido=0 and k.codmovimientotipo=30 and k.estado=1")->result_array();
			echo json_encode($transferencias);
		}else{
			$this->load->view("phuyu/404");
		}
	}

	function transferencia_detalle($codkardex){
		if ($this->input->is_ajax_request()) {
			$detalle = $this->db->query("select kd.*,p.descripcion as producto, u.descripcion as unidad from kardex.kardexdetalle as kd inner join almacen.productos as p on(kd.codproducto=p.codproducto) inner join almacen.unidades as u on(kd.codunidad=u.codunidad) where codkardex=".$codkardex)->result_array();
			echo json_encode($detalle);
		}else{
			$this->load->view("phuyu/404");
		}
	}

	function guardar_transferencia(){
		if ($this->input->is_ajax_request()) {
			if (isset( $_SESSION["phuyu_codusuario"]) ) {
				$this->request = json_decode(file_get_contents('php://input'));

				$this->db->trans_begin();

				// REGISTRO KARDEX //
				$info = $this->db->query("select *from kardex.kardex where codkardex=".$this->request->kardex_ref)->result_array();
				$series = $this->db->query("select seriecomprobante from caja.comprobantes where codcomprobantetipo=3 and codsucursal=".$_SESSION["phuyu_codsucursal"]." and codalmacen=".$_SESSION["phuyu_codalmacen"]." and estado=1")->result_array();

				$campos = ["codkardex_ref","codsucursal","codalmacen","codalmacen_ref","codpersona","codusuario","codmovimientotipo","fechakardex","fechacomprobante","codcomprobantetipo","seriecomprobante","codcomprobantetipo_ref","seriecomprobante_ref","nrocomprobante_ref","descripcion"];
				$valores = [
					(int)$this->request->kardex_ref,
					(int)$_SESSION["phuyu_codsucursal"],
					(int)$_SESSION["phuyu_codalmacen"],
					(int)$info[0]["codalmacen"],1,
					(int)$_SESSION["phuyu_codusuario"],12,date("Y-m-d"),date("Y-m-d"),3,
					$series[0]["seriecomprobante"],
					(int)$info[0]["codcomprobantetipo_ref"],
					$info[0]["seriecomprobante_ref"],
					$info[0]["nrocomprobante_ref"],
					"INGRESO POR TRANSFERENCIA"
				];
				$codkardex = $this->Phuyu_model->phuyu_guardar("kardex.kardex", $campos, $valores, "true");

				// REGISTRO KARDEX ALMACEN //
				$campos = ["codsucursal","codalmacen","codalmacen_ref","codkardex","codusuario","codmovimientotipo","fechakardex","codcomprobantetipo","seriecomprobante"];
				$valores = [
					(int)$_SESSION["phuyu_codsucursal"],
					(int)$_SESSION["phuyu_codalmacen"],
					(int)$info[0]["codalmacen"],
					(int)$codkardex,
					(int)$_SESSION["phuyu_codusuario"],12,date("Y-m-d"),3,
					$series[0]["seriecomprobante"]
				];
				$codkardexalmacen = $this->Phuyu_model->phuyu_guardar("kardex.kardexalmacen", $campos, $valores, "true");
				$nro_comprobante = $this->Kardex_model->phuyu_kardexcorrelativo($codkardex,$codkardexalmacen,3,$series[0]["seriecomprobante"]);

				// REGISTRO KARDEX DETALLE Y KARDEX ALMACEN DETALLE //
				$item = 0; $subtotal = 0; $igv = 0; $total = 0;
				foreach ($this->request->detalle as $key => $value) { 
					$item = $item + 1;
					$subtotal = $subtotal + (double)$this->request->detalle[$key]->subtotal;
					$igv = $igv + (double)$this->request->detalle[$key]->igv;
					$total = $total + (double)$this->request->detalle[$key]->subtotal;

					$fechavencimiento = null;
					$fechaproduccion = null;
					$loteproduccion = "";
					$registrosanitario = "";
					$fecharegistrosanitario = null;

					if($this->request->detalle[$key]->codkardex > 0){
						$kardexorigen = $this->db->query("select  *from kardex.kardexdetalle where codproducto=".$this->request->detalle[$key]->codproducto." AND codkardex=".$this->request->detalle[$key]->codkardex." AND item=".$this->request->detalle[$key]->item." and estado=1")->result_array();

						$fechavencimiento = $kardexorigen[0]["fechavencimiento"];
						$fechaproduccion = $kardexorigen[0]["fechaproduccion"];
						$loteproduccion = $kardexorigen[0]["loteproduccion"];
						$registrosanitario = $kardexorigen[0]["registrosanitario"];
						$fecharegistrosanitario=$kardexorigen[0]["fecharegistrosanitario"];
					}

					$campos = ["codkardex","codproducto","codunidad","item","cantidad","preciobruto","preciosinigv","preciounitario","preciorefunitario","codafectacionigv","valorventa","subtotal","stockkardex","stockkardexconvertido","itemdestino","codkardexdestino","registrosanitario","fecharegistrosanitario","fechavencimiento","fechaproduccion","loteproduccion"];
					$valores =[
						(int)$codkardex,
						(int)$this->request->detalle[$key]->codproducto,
						(int)$this->request->detalle[$key]->codunidad, $item,
						(double)$this->request->detalle[$key]->cantidad,
						(double)$this->request->detalle[$key]->preciounitario,
						(double)$this->request->detalle[$key]->preciounitario,
						(double)$this->request->detalle[$key]->preciounitario,
						(double)$this->request->detalle[$key]->preciounitario,
						$this->request->detalle[$key]->codafectacionigv,
						(double)$this->request->detalle[$key]->subtotal,
						(double)$this->request->detalle[$key]->subtotal,
						(double)$this->request->detalle[$key]->stockkardex,
						(double)$this->request->detalle[$key]->stockkardexconvertido,
						$this->request->detalle[$key]->item,
						$this->request->detalle[$key]->codkardex,
						$registrosanitario,$fecharegistrosanitario,$fechavencimiento,$fechaproduccion,$loteproduccion
					];
					$estado = $this->Phuyu_model->phuyu_guardar("kardex.kardexdetalle", $campos, $valores);

					$campos = ["codkardexalmacen","codproducto","codunidad","codalmacen","item","codsucursal","cantidad"];
					$valores =[
						(int)$codkardexalmacen,
						(int)$this->request->detalle[$key]->codproducto,
						(int)$this->request->detalle[$key]->codunidad,
						(int)$_SESSION["phuyu_codalmacen"], $item,
						(int)$_SESSION["phuyu_codsucursal"],
						(double)$this->request->detalle[$key]->cantidad
					];
					$estado = $this->Phuyu_model->phuyu_guardar("kardex.kardexalmacendetalle", $campos, $valores);

					$existe_ubi = $this->db->query("select *from almacen.productoubicacion where codalmacen=".$_SESSION["phuyu_codalmacen"]." and codproducto=".$this->request->detalle[$key]->codproducto." and codunidad=".$this->request->detalle[$key]->codunidad)->result_array();
					
					if (count($existe_ubi)>0) {
						$stock = round($existe_ubi[0]["stockactual"] + $this->request->detalle[$key]->cantidad,3);

						$campos = ["stockactual"]; $valores = [(double)$stock];
						$f = ["codalmacen","codproducto","codunidad"]; 
						$v = [(int)$_SESSION["phuyu_codalmacen"],(int)$this->request->detalle[$key]->codproducto,(int)$this->request->detalle[$key]->codunidad];
						$estado = $this->Phuyu_model->phuyu_editar_1("almacen.productoubicacion", $campos, $valores, $f, $v);
					}else{
						$campos = ["codalmacen","codproducto","codunidad","codsucursal","stockactual","stockactualreal"];
						$valores =[
							(int)$_SESSION["phuyu_codalmacen"],
							(int)$this->request->detalle[$key]->codproducto,
							(int)$this->request->detalle[$key]->codunidad,
							(int)$_SESSION["phuyu_codsucursal"],
							(double)$this->request->detalle[$key]->cantidad,
							(double)$this->request->detalle[$key]->cantidad
						];
						$estado = $this->Phuyu_model->phuyu_guardar("almacen.productoubicacion", $campos, $valores);
					}

					// AUMENTAMOS EL STOCKACTUALCONVERTIDO

					$stockconvertido = $this->db->query("select *from almacen.productoubicacion where codalmacen=".$_SESSION["phuyu_codalmacen"]." and codproducto=".$this->request->detalle[$key]->codproducto)->result_array();

					$factor = $this->db->query("select *from almacen.productounidades where codproducto=".$this->request->detalle[$key]->codproducto." and codunidad=".$this->request->detalle[$key]->codunidad)->result_array();

					foreach ($stockconvertido as $k => $val) {
						$stockc = 0;
						$productounidad = $this->db->query("select *from almacen.productounidades where codproducto=".$this->request->detalle[$key]->codproducto." and codunidad=".$val["codunidad"])->result_array();
						$stockc = ((float)$this->request->detalle[$key]->cantidad*(float)$factor[0]["factor"])/(float)$productounidad[0]["factor"];
						
                        $stockc = (double)$val["stockactualconvertido"] + $stockc;
						$campos = ["stockactualconvertido"]; $valores = [(double)$stockc];
						$f = ["codalmacen","codproducto","codunidad"]; 
						$v = [(int)$_SESSION["phuyu_codalmacen"],(int)$this->request->detalle[$key]->codproducto,(int)$val["codunidad"]];
						$estado = $this->Phuyu_model->phuyu_editar_1("almacen.productoubicacion", $campos, $valores, $f, $v);
				    }
				}

				$campos = ["valorventa","porcigv","igv","importe"]; $valores = [$subtotal,$_SESSION["phuyu_igv"],$igv,$total];
				$estado = $this->Phuyu_model->phuyu_editar("kardex.kardex", $campos, $valores, "codkardex", $codkardex);

				$campos = ["transferido"]; $valores = [1];
				$estado = $this->Phuyu_model->phuyu_editar("kardex.kardex", $campos, $valores, "codkardex", $this->request->kardex_ref);

				if ($this->db->trans_status() === FALSE){
				    $this->db->trans_rollback(); $estado = 0;
				}else{
					if ($estado!=1) {
						$this->db->trans_rollback(); $estado = 0;
					}
					$this->db->trans_commit();
				}
				echo $estado;
			}else{
				echo "e";
			}
		}
	}
}