<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Principioactivo extends CI_Controller {

	public function __construct(){
		parent::__construct(); $this->load->model("Phuyu_model");
	}

	public function index(){
		if ($this->input->is_ajax_request()) {
			if (isset($_SESSION["phuyu_usuario"])) {
				$this->load->view("almacen/principioactivo/index");
			}else{
				$this->load->view("phuyu/505");
			}
		}else{
			$this->load->view("phuyu/404");
		}
	}

	public function lista(){
		if ($this->input->is_ajax_request()) {
			$this->request = json_decode(file_get_contents('php://input'));
			$limit = 10; $offset = $this->request->pagina * $limit - $limit;

			$lista = $this->db->query("select p.*, f.descripcion AS familia, l.descripcion AS linea from almacen.principioactivo p JOIN almacen.familias f ON p.codfamilia = f.codfamilia JOIN almacen.lineas l ON p.codlinea = l.codlinea where UPPER(p.descripcion) like UPPER('%".$this->request->buscar."%') and p.estado=1 order by codprincipioactivo desc offset ".$offset." limit ".$limit)->result_array();

			$total = $this->db->query("select count(*) as total from almacen.principioactivo p JOIN almacen.familias f ON p.codfamilia = f.codfamilia JOIN almacen.lineas l ON p.codlinea = l.codlinea where UPPER(p.descripcion) like UPPER('%".$this->request->buscar."%') and p.estado=1")->result_array();

			$paginas = floor($total[0]["total"] / $limit);
			if ( ($total[0]["total"] % $limit)!=0 ) {
				$paginas = $paginas + 1;
			}

			$paginacion = array();
			$paginacion["total"] = $total[0]["total"];
			$paginacion["actual"] = $this->request->pagina;
			$paginacion["ultima"] = $paginas;
			$paginacion["desde"] = $offset;
			$paginacion["hasta"] = $offset + $limit;

			echo json_encode(array("lista" => $lista,"paginacion" => $paginacion));
		}else{
			$this->load->view("phuyu/404");
		}
	}

	public function nuevo(){
		if ($this->input->is_ajax_request()) {
			if (isset($_SESSION["phuyu_usuario"])) {
				$familias = $this->db->query("select * from almacen.familias where estado=1")->result_array();
				$lineas = $this->db->query("select * from almacen.lineas where estado=1")->result_array();
				$this->load->view("almacen/principioactivo/nuevo",compact("familias","lineas"));
			}else{
				$this->load->view("phuyu/505");
			}
		}else{
			$this->load->view("phuyu/404");
		}
	}

	function guardar(){
		if ($this->input->is_ajax_request()) {
			$campos = ["descripcion","codfamilia","codlinea"];
			$this->request = json_decode(file_get_contents('php://input'));
			$valores = [$this->request->descripcion,$this->request->codfamilia,$this->request->codlinea];

			if($this->request->codregistro=="") {
				$estado = $this->Phuyu_model->phuyu_guardar("almacen.principioactivo", $campos, $valores);
			}else{
				$estado = $this->Phuyu_model->phuyu_editar("almacen.principioactivo", $campos, $valores, "codprincipioactivo", $this->request->codregistro);
			}
			echo $estado;
		}else{
			$this->load->view("phuyu/404");
		}
	}

	function lineas(){
		if ($this->input->is_ajax_request()) {
			$this->request = json_decode(file_get_contents('php://input'));

			$info = $this->db->query("select *from almacen.principioactivo where codprincipioactivo=".$this->request->codregistro)->result_array();

			$familias = $this->db->query("select * from almacen.familias where codfamilia=".$info[0]["codfamilia"])->result_array();
			$data["familias"] = $familias;
			echo json_encode($data);
		}else{
			$this->load->view("phuyu/404");
		}
	}

	function editar(){
		if ($this->input->is_ajax_request()) {
			$this->request = json_decode(file_get_contents('php://input'));
			$info = $this->db->query("select codprincipioactivo as codregistro,* from almacen.principioactivo where codprincipioactivo=".$this->request->codregistro)->result_array();
			echo json_encode($info);
		}else{
			$this->load->view("phuyu/404");
		}
	}

	function eliminar(){
		if ($this->input->is_ajax_request()) {
			$this->request = json_decode(file_get_contents('php://input'));
			$estado = $this->Phuyu_model->phuyu_eliminar("almacen.principioactivo", "codprincipioactivo", $this->request->codregistro);
			echo $estado;
		}else{
			$this->load->view("phuyu/404");
		}
	}
}