<?php defined('BASEPATH') or exit('No direct script access allowed');

class Control extends CI_Controller
{

	public function __construct()
	{
		parent::__construct();
		$this->load->model("Phuyu_model");
	}

	public function index()
	{
		if ($this->input->is_ajax_request()) {
			if (isset($_SESSION["phuyu_usuario"])) {
				$sucursales = $this->db->query("select codsucursal,descripcion from sucursales where estado=1 order by codsucursal")->result_array();
				$this->load->view("asistencias/control/index", compact("sucursales"));
			} else {
				$this->load->view("phuyu/505");
			}
		} else {
			$this->load->view("phuyu/404");
		}
	}

	public function nuevo()
	{
		if ($this->input->is_ajax_request()) {
			$this->request = json_decode(file_get_contents('php://input'));
			if (isset($_SESSION["phuyu_usuario"])) {
				// Datos de empleado
				$this->db->select('personas.*');
				$this->db->from('empleados');
				$this->db->join('personas', 'personas.codpersona = empleados.codpersona');
				$this->db->where('empleados.codpersona', $this->request->codempleado);
				$empleado = $this->db->get()->row();

				// Datos de asistencias diaria
				// $this->db->select('*');
				$this->db->from('asistencias');
				$this->db->where('codempleado', $this->request->codempleado);
				$this->db->where('fecha', date('d-m-Y'));
				$asistencias = $this->db->get()->result_array();

				$this->load->view("asistencias/control/nuevo", compact("empleado", "asistencias"));
			} else {
				$this->load->view("phuyu/505");
			}
		} else {
			$this->load->view("phuyu/404");
		}
	}

	function guardar()
	{
		if ($this->input->is_ajax_request()) {
			$campos = ["codempleado", "fecha", "hora", "turno", "tipo", "observacion", "estado"];
			$this->request = json_decode(file_get_contents('php://input'));
			$valores = [
				$this->request->codempleado,
				$this->request->fecha,
				$this->request->hora,
				$this->request->turno,
				$this->request->tipo,
				$this->request->observacion,
				1
			];

			if ($this->request->codregistro == "") {
				$estado = $this->Phuyu_model->phuyu_guardar("public.asistencias", $campos, $valores);
			} else {
				$estado = $this->Phuyu_model->phuyu_editar("pubic.asistencias", $campos, $valores, "codasistencia", $this->request->codregistro);
			}
			echo $estado;
		} else {
			$this->load->view("phuyu/404");
		}
	}

	// function editar(){
	// 	if ($this->input->is_ajax_request()) {
	// 		$this->request = json_decode(file_get_contents('php://input'));
	// 		$info = $this->db->query("select asistencias.codasistencia as codregistro, * from public.asistencias where codasistencia=".$this->request->codregistro)->result_array();
	// 		echo json_encode($info);
	// 	}else{
	// 		$this->load->view("phuyu/404");
	// 	}
	// }

	function eliminar(){
		if ($this->input->is_ajax_request()) {
			$this->request = json_decode(file_get_contents('php://input'));
			$estado = $this->Phuyu_model->phuyu_eliminar("public.asistencias", "codasistencia", $this->request->codregistro);
			echo $estado;
		}else{
			$this->load->view("phuyu/404");
		}
	}

	public function sueldo()
	{
		if ($this->input->is_ajax_request()) {
			$this->request = json_decode(file_get_contents('php://input'));
			if (isset($_SESSION["phuyu_usuario"])) {
				// Datos de empleado
				$this->db->select('personas.*, empleados.sueldohora');
				$this->db->from('empleados');
				$this->db->join('personas', 'personas.codpersona = empleados.codpersona');
				$this->db->where('empleados.codpersona', $this->request->codempleado);
				$empleado = $this->db->get()->row();

				$this->load->view("asistencias/control/sueldo", compact("empleado",));
			} else {
				$this->load->view("phuyu/505");
			}
		} else {
			$this->load->view("phuyu/404");
		}
	}

	public function sueldo_monto()
	{
		if ($this->input->is_ajax_request()) {
			$this->request = json_decode(file_get_contents('php://input'));
			// if (isset($_SESSION["phuyu_usuario"])) {

			$sueldoHora = $this->db->get_where('empleados', ['codpersona' => $this->request->codempleado])->row()->sueldohora;

			$this->db->select("*, CONCAT(fecha,' ',hora) as fechac");
			$this->db->from('asistencias');
			$this->db->where('codempleado', $this->request->codempleado);
			$this->db->where('fecha >=', $this->request->fecha1);
			$this->db->where('fecha <=', $this->request->fecha2);
			$this->db->order_by('fecha', 'asc');
			$this->db->order_by('hora', 'asc');
			$asistencias = $this->db->get()->result_array();

			$horas = 0;
			foreach ($asistencias as $key => $value) {
				if ($value['tipo'] == 'salida') {
					$entrada = $asistencias[$key - 1]['fechac'];
					$salida = $value['fechac'];

					$fecha_inicio = $entrada;
					$fecha_fin = $salida;

					// Convierte las fechas en formato Unix
					$fecha_inicio_unix = strtotime($fecha_inicio);
					$fecha_fin_unix = strtotime($fecha_fin);

					// Calcula la diferencia en segundos
					$diferencia_segundos = $fecha_fin_unix - $fecha_inicio_unix;

					// Convierte la diferencia en horas
					$horas_transcurridas = round($diferencia_segundos / 3600, 2);
					$horas = $horas + $horas_transcurridas;
				}
			}

			echo json_encode(['horas' => $horas, 'sueldo' => $sueldoHora, 'total' => round($horas * $sueldoHora, 2)]);


			// $this->load->view("asistencias/control/sueldo", compact("empleado",));
			// 	} else {
			// 		$this->load->view("phuyu/505");
			// 	}
			// } else {
			// 	$this->load->view("phuyu/404");
		}
	}
}
