<?php defined('BASEPATH') or exit('No direct script access allowed');

class Lista extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model("Phuyu_model");
    }

    public function index()
    {
        if ($this->input->is_ajax_request()) {
            if (isset($_SESSION["phuyu_usuario"])) {
                $sucursales = $this->db->query("select codsucursal,descripcion from sucursales where estado=1 order by codsucursal")->result_array();
                $this->load->view("asistencias/lista/index", compact("sucursales"));
            } else {
                $this->load->view("phuyu/505");
            }
        } else {
            $this->load->view("phuyu/404");
        }
    }

    public function lista()
    {
        if ($this->input->is_ajax_request()) {
            $this->request = json_decode(file_get_contents('php://input'));
            $limit = 8;
            $offset = $this->request->pagina * $limit - $limit;

            if ($this->request->fecha1 != '') {
                $fecha1 = $this->request->fecha1;
            } else {
                $fecha1 = date('Y-m-d');
            }

            if ($this->request->fecha2 != '') {
                $fecha2 = $this->request->fecha2;
            } else {
                $fecha2 = date('Y-m-d');
            }
            $this->db->from('asistencias');
            $this->db->join('empleados', 'empleados.codpersona = asistencias.codempleado');
            $this->db->join('personas', 'personas.codpersona = empleados.codpersona');
            $this->db->where('asistencias.fecha >=', $fecha1);
            $this->db->where('asistencias.fecha <=', $fecha2);
            $this->db->where('asistencias.estado', 1);
            $resultado = $this->db->get();

            $total = $resultado->num_rows();
            $lista = $resultado->result_array();

            $paginas = floor($total / $limit);
            if (($total % $limit) != 0) {
                $paginas = $paginas + 1;
            }

            $paginacion = array();
            $paginacion["total"] = $total;
            $paginacion["actual"] = $this->request->pagina;
            $paginacion["ultima"] = $paginas;
            $paginacion["desde"] = $offset;
            $paginacion["hasta"] = $offset + $limit;

            echo json_encode(array("lista" => $lista, "paginacion" => $paginacion));
        } else {
            $this->load->view("phuyu/404");
        }
    }

    public function nuevo()
    {
        if ($this->input->is_ajax_request()) {
            $this->request = json_decode(file_get_contents('php://input'));
            if (isset($_SESSION["phuyu_usuario"])) {
                // Datos de empleado
                $this->db->select('personas.*');
                $this->db->from('empleados');
                $this->db->join('personas', 'personas.codpersona = empleados.codpersona');
                $this->db->where('empleados.codpersona', $this->request->codempleado);
                $empleado = $this->db->get()->row();

                // Datos de asistencias diaria
                // $this->db->select('*');
                $this->db->from('asistencias');
                $this->db->where('codempleado', $this->request->codempleado);
                $this->db->where('fecha', date('d-m-Y'));
                $this->db->where('estado', 1);
                $asistencias = $this->db->get()->result_array();

                $this->load->view("asistencias/control/nuevo", compact("empleado", "asistencias"));
            } else {
                $this->load->view("phuyu/505");
            }
        } else {
            $this->load->view("phuyu/404");
        }
    }

    function guardar()
    {
        if ($this->input->is_ajax_request()) {
            $campos = ["codempleado", "fecha", "hora", "turno", "tipo", "observacion"];
            $this->request = json_decode(file_get_contents('php://input'));
            $valores = [
                $this->request->codempleado,
                date('d-m-Y'),
                date('H:i:s'),
                $this->request->turno,
                $this->request->tipo,
                $this->request->observacion
            ];

            if ($this->request->codregistro == "") {
                $estado = $this->Phuyu_model->phuyu_guardar("public.asistencias", $campos, $valores);
            } else {
                $estado = $this->Phuyu_model->phuyu_editar("pubic.asistencias", $campos, $valores, "codasistencia", $this->request->codregistro);
            }
            echo $estado;
        } else {
            $this->load->view("phuyu/404");
        }
    }

    // function editar(){
    // 	if ($this->input->is_ajax_request()) {
    // 		$this->request = json_decode(file_get_contents('php://input'));
    // 		$info = $this->db->query("select public.personas.codpersona as codregistro, * from public.personas inner join public.empleados on(public.personas.codpersona=public.empleados.codpersona) where public.empleados.codpersona=".$this->request->codregistro)->result_array();
    // 		echo json_encode($info);
    // 	}else{
    // 		$this->load->view("phuyu/404");
    // 	}
    // }

    // function eliminar(){
    // 	if ($this->input->is_ajax_request()) {
    // 		$this->request = json_decode(file_get_contents('php://input'));
    // 		$estado = $this->Phuyu_model->phuyu_eliminar("public.empleados", "codpersona", $this->request->codregistro);
    // 		echo $estado;
    // 	}else{
    // 		$this->load->view("phuyu/404");
    // 	}
    // }
}
