<?php

class Kardex_model extends CI_Model
{

	public function __construct()
	{
		parent::__construct();
	}

	function phuyu_kardex($campos, $totales, $operacion = 0)
	{
		$data = array(
			"codsucursal" => (int)$_SESSION["phuyu_codsucursal"],
			"codalmacen" => (int)$_SESSION["phuyu_codalmacen"],
			"codusuario" => (int)$_SESSION["phuyu_codusuario"],
			"codpersona" => (int)$campos->codpersona,
			"codmovimientotipo" => (int)$campos->codmovimientotipo,
			"condicionpago" => (int)$campos->condicionpago,
			"codmoneda" => (int)$campos->codmoneda,
			"tipocambio" => (float)$campos->tipocambio,
			"fechacomprobante" => $campos->fechacomprobante,
			"fechakardex" => $campos->fechakardex,
			"hora" => date('H:i:s'),
			"codcomprobantetipo" => (int)$campos->codcomprobantetipo,
			"seriecomprobante" => $campos->seriecomprobante,
			"nrocomprobante" => $campos->nro,
			"valorventa" => (float)$totales->valorventa,
			"porcdescuento" => (float)$campos->porcdescuento,
			"descglobal" => (float)$totales->descglobal,
			"descuentos" => (float)$totales->descuentos,
			"porcigv" => (float)$_SESSION["phuyu_igv"],
			"igv" => (float)$totales->igv,
			"porcicbper" => (float)$_SESSION["phuyu_icbper"],
			"icbper" => (float)$totales->icbper,
			"importe" => (float)$totales->importe,
			"flete" => (float)$totales->flete,
			"gastos" => (float)$totales->gastos,
			"retirar" => (int)$campos->retirar,
			"descripcion" => $campos->descripcion,
			"nroplaca" => $campos->nroplaca,
			"cliente" => $campos->cliente,
			"direccion" => $campos->direccion,
			"codempleado" => (int)$campos->codempleado,
			"codcentrocosto" => (int)$campos->codcentrocosto,
			"afectacaja" => (int)$campos->afectacaja
		);
		$estado = $this->db->insert("kardex.kardex", $data);
		$codkardex = $this->db->insert_id("kardex.kardex_codkardex_seq");

		/* GENERAR CORRELATIVO DEL KARDEX */

		if ($operacion == 0 || $campos->codcomprobantetipo == 13) {
			$actual = $this->db->query("select nrocorrelativo 
			from caja.comprobantes 
			where codcomprobantetipo=" . $campos->codcomprobantetipo . " and seriecomprobante='" . $campos->seriecomprobante . "' 
			and codsucursal=" . $_SESSION["phuyu_codsucursal"] . "
			 and estado=1")->result_array();

			$nrocorrelativo = (int)($actual[0]["nrocorrelativo"]) + 1;
			$data = array(
				"nrocorrelativo" => $nrocorrelativo
			);
			$this->db->where("codsucursal", $_SESSION["phuyu_codsucursal"]);
			$this->db->where("codcomprobantetipo", $campos->codcomprobantetipo);
			$this->db->where("seriecomprobante", $campos->seriecomprobante);
			$estado = $this->db->update("caja.comprobantes", $data);

			$nrocorrelativo = str_pad($nrocorrelativo, 8, "0", STR_PAD_LEFT);
			$data = array(
				"nrocomprobante" => $nrocorrelativo
			);
			$this->db->where("codkardex", $codkardex);
			$estado = $this->db->update("kardex.kardex", $data);
		}

		return $codkardex;
	}

	function phuyu_kardexalmacen($codkardex, $comprobantealmacen, $campos)
	{
		$serie = $this->db->query("select seriecomprobante from caja.comprobantes where codcomprobantetipo=" . $comprobantealmacen . " and codsucursal=" . $_SESSION["phuyu_codsucursal"] . " and codalmacen=" . $_SESSION["phuyu_codalmacen"] . " and estado=1")->result_array();

		$data = array(
			"codsucursal" => (int)$_SESSION["phuyu_codsucursal"], "codalmacen" => (int)$_SESSION["phuyu_codalmacen"],
			"codusuario" => (int)$_SESSION["phuyu_codusuario"],
			"codkardex" => (int)$codkardex,
			"codmovimientotipo" => (int)$campos->codmovimientotipo,
			"fechakardex" => $campos->fechakardex,
			"codcomprobantetipo" => $comprobantealmacen, "seriecomprobante" => $serie[0]["seriecomprobante"]
		);
		$estado = $this->db->insert("kardex.kardexalmacen", $data);
		$codkardexalmacen = $this->db->insert_id("kardex.kardexalmacen_codkardexalmacen_seq");

		/* GENERAR CORRELATIVO DEL KARDEX ALMACEN */

		$actual = $this->db->query("select nrocorrelativo from caja.comprobantes where codcomprobantetipo=" . $comprobantealmacen . " and seriecomprobante='" . $serie[0]["seriecomprobante"] . "' and codsucursal=" . $_SESSION["phuyu_codsucursal"] . " and estado=1")->result_array();

		$nrocorrelativo = (int)($actual[0]["nrocorrelativo"]) + 1;
		$data = array(
			"nrocorrelativo" => $nrocorrelativo
		);
		$this->db->where("codsucursal", $_SESSION["phuyu_codsucursal"]);
		$this->db->where("codcomprobantetipo", $comprobantealmacen);
		$this->db->where("seriecomprobante", $serie[0]["seriecomprobante"]);
		$estado = $this->db->update("caja.comprobantes", $data);

		$nrocorrelativo = str_pad($nrocorrelativo, 8, "0", STR_PAD_LEFT);
		$data = array(
			"nrocomprobante" => $nrocorrelativo
		);
		$this->db->where("codkardexalmacen", $codkardexalmacen);
		$estado = $this->db->update("kardex.kardexalmacen", $data);

		return $codkardexalmacen;
	}

	function phuyu_kardexdetalle(
		$codkardex,
		$codkardexalmacen,
		$detalle,
		$retirar,
		$operacion = 0,
		$codpedido = 0,
		$codproforma = 0
	) {
		$item = 0;
		$estado = 1;
		$informacion['success'] = true;
		foreach ($detalle as $key => $value) {
			if (!isset($detalle[$key]->flete)) {
				$detalle[$key]->flete = 0;
			}

			if (!isset($detalle[$key]->itemorigen) || empty($detalle[$key]->itemorigen)) {
				$detalle[$key]->itemorigen = 0;
			}
			if (!isset($detalle[$key]->codkardexorigen)) {
				$detalle[$key]->codkardexorigen = 0;
			}

			$producto = $this->db->query("select pr.*,u.descripcion AS unidad from almacen.productounidades pr inner join almacen.unidades u ON pr.codunidad = u.codunidad where pr.codproducto=" . $detalle[$key]->codproducto . " and pr.codunidad=" . $detalle[$key]->codunidad)->result_array();

			if ($operacion == 0) {
				$preciocompra = (float)$producto[0]['preciocompra'];
				$preciocosto = (float)$producto[0]['preciocosto'];
			} else {
				$preciocompra = (float)$detalle[$key]->precio;
				$preciocosto = (float)$detalle[$key]->precio + (float)$detalle[$key]->flete;

				$data = array(
					"preciocompra" => (float)$preciocompra,
					"preciocosto" => (float)$detalle[$key]->precio + (float)$detalle[$key]->flete
				);

				$this->db->where("codproducto", $detalle[$key]->codproducto);
				$this->db->where("codunidad", $detalle[$key]->codunidad);
				$estado = $this->db->update("almacen.productounidades", $data);
			}

			$cantidadlote = 0;
			$cantidadloteconvertido = 0;

			if ($operacion == 1) {
				$factorventa = $this->db->query("Select *from almacen.productoubicacion WHERE codproducto=" . $detalle[$key]->codproducto . " AND codunidad=" . $detalle[$key]->codunidad . " AND codalmacen=" . $_SESSION["phuyu_codalmacen"] . " AND estado=1")->result_array();

				$cantidadlote = (float)$detalle[$key]->cantidad;

				$cantidadloteconvertido = (float)$detalle[$key]->cantidad * (float)$factorventa[0]["factor"];
				$detalle[$key]->fechaproduccion = ($detalle[$key]->fechaproduccion == "") ? null : $detalle[$key]->fechaproduccion;
				$detalle[$key]->fecharegistrosanitario = ($detalle[$key]->fecharegistrosanitario == "") ? null : $detalle[$key]->fecharegistrosanitario;
			} else {
				if ($detalle[$key]->codkardexorigen > 0) {
					$kardexorigen = $this->db->query("select  *from kardex.kardexdetalle where codproducto=" . $detalle[$key]->codproducto . " AND codkardex=" . $detalle[$key]->codkardexorigen . " AND item=" . $detalle[$key]->itemorigen . " and estado=1")->result_array();

					if (count($kardexorigen) == 0) {
						echo '1' . $detalle[$key]->codkardexorigen . '   ' . $detalle[$key]->codproducto . '    ' . $detalle[$key]->codunidad;
						exit;
					}

					$factorventa = $this->db->query("Select *from almacen.productoubicacion WHERE codproducto=" . $detalle[$key]->codproducto . " AND codunidad=" . $detalle[$key]->codunidad . " AND codalmacen=" . $_SESSION["phuyu_codalmacen"] . " AND estado=1")->result_array();

					if (count($factorventa) == 0) {
						echo '2' . $detalle[$key]->codkardexorigen . '   ' . $detalle[$key]->codproducto . '   ' . $detalle[$key]->codunidad;
						exit;
					}

					$factorlote = $this->db->query("Select *from almacen.productoubicacion WHERE codproducto=" . $detalle[$key]->codproducto . " AND codunidad=" . $kardexorigen[0]["codunidad"] . " AND codalmacen=" . $_SESSION["phuyu_codalmacen"] . " AND estado=1")->result_array();

					if (count($factorlote) == 0) {
						echo '3' . $detalle[$key]->codkardexorigen . '   ' . $detalle[$key]->codproducto . '   ' . $detalle[$key]->codunidad;
						exit;
					}

					$cantidadlote = ((float)$detalle[$key]->cantidad * (float)$factorventa[0]["factor"]) / (float)$factorlote[0]["factor"];

					$cantidadloteconvertido = (float)$detalle[$key]->cantidad * (float)$factorventa[0]["factor"];
					$detalle[$key]->fechavencimiento = $kardexorigen[0]["fechavencimiento"];
					$detalle[$key]->fechaproduccion = $kardexorigen[0]["fechaproduccion"];
					$detalle[$key]->loteproduccion = $kardexorigen[0]["loteproduccion"];
					$detalle[$key]->registrosanitario = $kardexorigen[0]["registrosanitario"];
					$detalle[$key]->fecharegistrosanitario = $kardexorigen[0]["fecharegistrosanitario"];

					//UNIDAD BRUTO

					$data = array(
						"stockkardex" => (float)$kardexorigen[0]["stockkardex"] - (float)$cantidadlote,
						"stockkardexconvertido" => (float)$kardexorigen[0]["stockkardexconvertido"] - (float)$cantidadloteconvertido
					);

					$this->db->where("codkardex", $detalle[$key]->codkardexorigen);
					$this->db->where("codproducto", $detalle[$key]->codproducto);
					$this->db->where("item", $detalle[$key]->itemorigen);
					$estado = $this->db->update("kardex.kardexdetalle", $data);
				} else {
					$detalle[$key]->fechavencimiento = null;
					$detalle[$key]->fechaproduccion = null;
					$detalle[$key]->loteproduccion = "";
					$detalle[$key]->registrosanitario = "";
					$detalle[$key]->fecharegistrosanitario = null;
				}
			}

			$item = $item + 1;
			$data = array(
				"codkardex" => (int)$codkardex,
				"codproducto" => (int)$detalle[$key]->codproducto, "codunidad" => (int)$detalle[$key]->codunidad, "item" => $item,
				"cantidad" => (float)$detalle[$key]->cantidad,
				"preciobruto" => (float)$detalle[$key]->preciobruto,
				"porcdescuento" => (float)$detalle[$key]->porcdescuento,
				"descuento" => (float)$detalle[$key]->descuento,
				"preciosinigv" => (float)$detalle[$key]->preciosinigv,
				"preciounitario" => (float)$detalle[$key]->precio,
				"preciorefunitario" => (float)$detalle[$key]->preciorefunitario,
				"codafectacionigv" => $detalle[$key]->codafectacionigv,
				"igv" => (float)$detalle[$key]->igv,
				"conicbper" => (float)$detalle[$key]->conicbper,
				"icbper" => (float)$detalle[$key]->icbper,
				"valorventa" => (float)$detalle[$key]->valorventa,
				"subtotal" => (float)$detalle[$key]->subtotal,
				"descripcion" => $detalle[$key]->descripcion,
				"recoger" => (int)$retirar,
				"flete" => $detalle[$key]->flete,
				"preciocompra" => $preciocompra,
				"preciocosto" => $preciocosto,
				"registrosanitario" => $detalle[$key]->registrosanitario,
				"fecharegistrosanitario" => $detalle[$key]->fecharegistrosanitario,
				"fechavencimiento" => $detalle[$key]->fechavencimiento,
				"fechaproduccion" => $detalle[$key]->fechaproduccion,
				"loteproduccion" => $detalle[$key]->loteproduccion,
				"stockkardex" => (float)$cantidadlote,
				"stockkardexconvertido" => $cantidadloteconvertido,
				"itemdestino" => $detalle[$key]->itemorigen,
				"codkardexdestino" => $detalle[$key]->codkardexorigen
			);
			$estado = $this->db->insert("kardex.kardexdetalle", $data);

			$cantidad_recoger = 0;
			if ($retirar == true) {
				$data = array(
					"codkardexalmacen" => (int)$codkardexalmacen,
					"codproducto" => (int)$detalle[$key]->codproducto, "codunidad" => (int)$detalle[$key]->codunidad, "item" => $item,
					"codalmacen" => (int)$_SESSION["phuyu_codalmacen"], "codsucursal" => (int)$_SESSION["phuyu_codsucursal"],
					"cantidad" => (float)$detalle[$key]->cantidad
				);
				$estado = $this->db->insert("kardex.kardexalmacendetalle", $data);
			} else {
				$cantidad_recoger = (float)$detalle[$key]->cantidad;
			}

			$existe = $this->db->query("select *from almacen.productoubicacion where codalmacen=" . $_SESSION["phuyu_codalmacen"] . " and codproducto=" . $detalle[$key]->codproducto . " and codunidad=" . $detalle[$key]->codunidad)->result_array();
			if (count($existe) == 0) {
				$data = array(
					"codalmacen" => (int)$_SESSION["phuyu_codalmacen"],
					"codproducto" => (int)$detalle[$key]->codproducto,
					"codunidad" => (int)$detalle[$key]->codunidad,
					"codsucursal" => (int)$_SESSION["phuyu_codsucursal"],
					"stockactual" => 0, "stockactualreal" => 0
				);
				$estado = $this->db->insert("almacen.productoubicacion", $data);

				$existe = $this->db->query("select *from almacen.productoubicacion where codalmacen=" . $_SESSION["phuyu_codalmacen"] . " and codproducto=" . $detalle[$key]->codproducto . " and codunidad=" . $detalle[$key]->codunidad)->result_array();
			}

			if ($_SESSION["phuyu_stockalmacen"] == 1 && ($existe[0]["stockactualconvertido"] < $detalle[$key]->cantidad) && $detalle[$key]->control == 1) {

				$informacion['success'] = false;
				$informacion['stock'][$key] = $existe[0]["stockactualconvertido"];
				$informacion['producto'][$key] = $detalle[$key]->producto;
				$informacion['unidad'][$key] = $producto[0]["unidad"];
			}

			if ($operacion == 0) {
				$data = array(
					"stockactual" => (float)round(($existe[0]["stockactual"] - $detalle[$key]->cantidad), 3),
					"ventarecogo" => (float)$existe[0]["ventarecogo"] + (float)$cantidad_recoger
				);
			} else {
				$data = array(
					"stockactual" => (float)round(($existe[0]["stockactual"] + $detalle[$key]->cantidad), 3),
					"comprarecogo" => (float)$existe[0]["comprarecogo"] + (float)$cantidad_recoger
				);
			}
			$this->db->where("codalmacen", $_SESSION["phuyu_codalmacen"]);
			$this->db->where("codproducto", $detalle[$key]->codproducto);
			$this->db->where("codunidad", $detalle[$key]->codunidad);
			$estado = $this->db->update("almacen.productoubicacion", $data);

			$stockconvertido = $this->db->query("select *from almacen.productoubicacion where codalmacen=" . $_SESSION["phuyu_codalmacen"] . " and codproducto=" . $detalle[$key]->codproducto)->result_array();

			$factor = $this->db->query("select *from almacen.productounidades where codproducto=" . $detalle[$key]->codproducto . " and codunidad=" . $detalle[$key]->codunidad)->result_array();

			foreach ($stockconvertido as $k => $value) {
				$productounidad = $this->db->query("select *from almacen.productounidades where codproducto=" . $detalle[$key]->codproducto . " and codunidad=" . $value["codunidad"])->result_array();

				$stockc = ((float)$detalle[$key]->cantidad * (float)$factor[0]["factor"]) / (float)$productounidad[0]["factor"];

				if ($operacion == 0) {
					$data = array(
						"stockactualconvertido" => (float)round(($value["stockactualconvertido"] - $stockc), 3)
					);
				} else {
					$data = array(
						"stockactualconvertido" => (float)round(($value["stockactualconvertido"] + $stockc), 3)
					);
				}

				$this->db->where("codalmacen", $_SESSION["phuyu_codalmacen"]);
				$this->db->where("codproducto", $detalle[$key]->codproducto);
				$this->db->where("codunidad", $value["codunidad"]);
				$estado = $this->db->update("almacen.productoubicacion", $data);
			}

			if ($codpedido != 0) {
				if (isset($detalle[$key]->itempedido)) {
					$data = array(
						"codpedido" => (int)$codpedido,
						"codproducto" => (int)$detalle[$key]->codproducto,
						"codunidad" => (int)$detalle[$key]->codunidad,
						"itempedido" => (int)$detalle[$key]->itempedido,
						"codkardex" => (int)$codkardex,
						"itemkardex" => $item
					);

					$kardexpedido = $this->db->insert("kardex.kardexpedido", $data);
				}
			}

			if ($codproforma != 0) {
				if (isset($detalle[$key]->itemproforma)) {
					$data = array(
						"codproforma" => (int)$codproforma,
						"codproducto" => (int)$detalle[$key]->codproducto,
						"codunidad" => (int)$detalle[$key]->codunidad,
						"itemproforma" => (int)$detalle[$key]->itemproforma,
						"codkardex" => (int)$codkardex,
						"itemkardex" => $item
					);

					$kardexproforma = $this->db->insert("kardex.kardexproforma", $data);
				}
			}
		}
		return $informacion;
	}

	function phuyu_correlativo($codkardex, $codcomprobantetipo, $seriecomprobante)
	{
		$actual = $this->db->query("select nrocorrelativo from caja.comprobantes where codcomprobantetipo=" . $codcomprobantetipo . " and seriecomprobante='" . $seriecomprobante . "' and codsucursal=" . $_SESSION["phuyu_codsucursal"] . " and estado=1")->result_array();

		$nrocorrelativo = (int)($actual[0]["nrocorrelativo"]) + 1;
		$data = array(
			"nrocorrelativo" => $nrocorrelativo
		);
		$this->db->where("codsucursal", $_SESSION["phuyu_codsucursal"]);
		$this->db->where("codcomprobantetipo", $codcomprobantetipo);
		$this->db->where("seriecomprobante", $seriecomprobante);
		$estado = $this->db->update("caja.comprobantes", $data);

		// ACTUALIZAMOS EL NRO COMPROBANTE DE KARDEX //

		$nrocorrelativo = str_pad($nrocorrelativo, 8, "0", STR_PAD_LEFT);
		$data = array(
			"nrocomprobante" => $nrocorrelativo
		);
		$this->db->where("codkardex", $codkardex);
		$estado = $this->db->update("kardex.kardex", $data);

		return $estado;
	}

	function phuyu_kardexcorrelativo($codkardex, $codkardexalmacen, $codcomprobantetipo, $seriecomprobante)
	{
		$actual = $this->db->query("select nrocorrelativo from caja.comprobantes where codcomprobantetipo=" . $codcomprobantetipo . " and seriecomprobante='" . $seriecomprobante . "' and codsucursal=" . $_SESSION["phuyu_codsucursal"] . " and estado=1")->result_array();

		$nrocorrelativo = (int)($actual[0]["nrocorrelativo"]) + 1;
		$data = array(
			"nrocorrelativo" => $nrocorrelativo
		);
		$this->db->where("codsucursal", $_SESSION["phuyu_codsucursal"]);
		$this->db->where("codcomprobantetipo", $codcomprobantetipo);
		$this->db->where("seriecomprobante", $seriecomprobante);
		$estado = $this->db->update("caja.comprobantes", $data);

		// ACTUALIZAMOS EL NRO COMPROBANTE DE KARDEX //

		$nrocorrelativo = str_pad($nrocorrelativo, 8, "0", STR_PAD_LEFT);
		$data = array(
			"nrocomprobante" => $nrocorrelativo
		);
		$this->db->where("codkardex", $codkardex);
		$estado = $this->db->update("kardex.kardex", $data);

		$this->db->where("codkardexalmacen", $codkardexalmacen);
		$estado = $this->db->update("kardex.kardexalmacen", $data);

		return $estado;
	}

	function phuyu_kardexalmacencorrelativo($codkardexalmacen, $codcomprobantetipo, $seriecomprobante)
	{
		$actual = $this->db->query("select nrocorrelativo from caja.comprobantes where codcomprobantetipo=" . $codcomprobantetipo . " and seriecomprobante='" . $seriecomprobante . "' and codsucursal=" . $_SESSION["phuyu_codsucursal"] . " and estado=1")->result_array();

		$nrocorrelativo = (int)($actual[0]["nrocorrelativo"]) + 1;
		$data = array(
			"nrocorrelativo" => $nrocorrelativo
		);
		$this->db->where("codsucursal", $_SESSION["phuyu_codsucursal"]);
		$this->db->where("codcomprobantetipo", $codcomprobantetipo);
		$this->db->where("seriecomprobante", $seriecomprobante);
		$estado = $this->db->update("caja.comprobantes", $data);

		// ACTUALIZAMOS EL NRO COMPROBANTE DE KARDEX //

		$nrocorrelativo = str_pad($nrocorrelativo, 8, "0", STR_PAD_LEFT);
		$data = array(
			"nrocomprobante" => $nrocorrelativo
		);
		$this->db->where("codkardexalmacen", $codkardexalmacen);
		$estado = $this->db->update("kardex.kardexalmacen", $data);

		return $estado;
	}
}
