<div id="phuyu_ingresos">
	
	<div class="phuyu_body">
		<div class="card">
			<div class="card-header">
		        <div class="row">
					<div class="col-md-8 col-xs-12"> <h5>LISTA DE INGRESOS ALMACEN</h5> </div>
				</div>
			    <div class="row">
			    	<div class="col-md-8 phuyu_header_button">
				    	<button type="button" class="btn btn-success" v-on:click="phuyu_nuevo()"> <i class="fa fa-plus-square"></i> Nuevo Ingreso</button>
				    	<button type="button" class="btn btn-info" v-on:click="phuyu_ver()"> <i class="fa fa-file"></i> Ver Ingreso </button>
					    <button type="button" class="btn btn-warning" v-on:click="phuyu_editar()"> <i class="fa fa-edit"></i> Editar </button>
					    <button type="button" class="btn btn-danger" v-on:click="phuyu_eliminar()"> <i class="fa fa-trash-o"></i> Eliminar </button>
					    <button type="button" class="btn btn-primary" v-on:click="phuyu_trasferencias()">
					        <span class="badge bg-green"> <b style="color:#fff;">Ver</b> </span> 
					        <i class="fa fa-exchange"></i> Transferencias
					    </button>
				    </div>
				    <div class="col-md-4 col-xs-12">
				    	<input type="text" class="form-control" v-model="buscar" v-on:keyup="phuyu_buscar()" placeholder="BUSCAR REGISTRO . . .">
				    </div>
			    </div>
			</div>
			<div class="card-body" v-if="!cargando">
				<div class="phuyu_cargando" v-if="cargando">
					<img src="<?php echo base_url();?>public/img/phuyu_loading.gif"> <h5>CARGANDO DATOS</h5>
				</div>
				<div class="table-responsive">
					<table class="table table-bordered table-condensed">
						<thead>
							<tr>
								<th width="5px;"> <center> <i class="fa fa-circle-o"></i> </center> </th>
								<th>TIPO MOVIMIENTO</th>
								<th>FECHA</th>
								<th>COMPROBANTE</th>
								<th>COMPROBANTE REF.</th>
								<th>IMPORTE</th>
								<th>ESTADO</th>
							</tr>
						</thead>
						<tbody>
							<tr v-for="dato in datos" v-bind:class="[dato.estado==0 ? 'phuyu_anulado':'']">
								<td> <input type="radio" v-if="dato.estado!=0" name="phuyu_seleccionar" v-on:click="phuyu_seleccionar(dato.codkardex)"> </td>
								<td>{{dato.tipomovimiento}}<br>
                                    <span v-if="dato.codmovimientotipo==12">Destino: {{dato.destino}}</span>
									<span v-if="dato.codmovimientotipo!=12"></span>
								</td>
								<td>{{dato.fechakardex}}</td>
								<td>{{dato.seriecomprobante}} - {{dato.nrocomprobante}}</td>
								<td>{{dato.tipo}} ({{dato.seriecomprobante_ref}} - {{dato.nrocomprobante_ref}})</td>
								<td>S/. {{dato.importe}}</td>
								<td>
									<span class="label label-danger" v-if="dato.estado==0">ANULADO</span>
									<span class="label label-warning" v-if="dato.estado==1">ACTIVO</span>
								</td>
							</tr>
						</tbody>
					</table>
				</div>
				<?php include("application/views/phuyu/phuyu_paginacion.php");?>
			</div>
		</div>
	</div>

	<div id="modal_transferencias" class="modal fade" tabindex="-1" role="dialog" aria-hidden="true">
		<div class="modal-dialog modal-lg">
			<div class="modal-content" v-show="transferencias==1" align="center">
				<div class="modal-header">
					<h4 class="modal-title" style="letter-spacing:1px;">
						<i class="fa fa-exchange" style="font-size:80px"></i> <br> <b>LISTA DE TRANFERENCIAS A ESTE ALMACEN</b> 
					</h4>
				</div>
				<div class="modal-body" style="height:270px;">
					<div class="col-md-6 col-xs-12" v-for="dato in listatransferencias">
						<div class="x_panel">
							<h4>
								<span class="label label-danger" style="color:#fff;">FECHA TRANSFERIDO: {{dato.fechakardex}}</span>
							</h4> <hr>
							<div style="text-align:left;">
								<h5>ALMACEN ORIGEN: {{dato.almacen}}</h5>
								<h5>DOCUMENTO: {{dato.seriecomprobante}} - {{dato.nrocomprobante}}</h5>
								<h5>DOCUMENTO REFERENCIA: {{dato.seriecomprobante_ref}} - {{dato.nrocomprobante_ref}}</h5>
								<h5 align="center"> 
									<span class="label label-warning">TOTAL IMPORTE TRANSFERIDO: S/. {{dato.importe}}</span>
								</h5>
								<h5 align="center"> 
									<button type="button" class="btn btn-success" v-on:click="phuyu_detalle(dato)">VER DETALLE</button> 
								</h5>
							</div>
						</div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-danger" data-dismiss="modal">CERRAR</button>
				</div>
			</div>

			<div class="modal-content" v-show="transferencias==0" align="center">
				<div class="modal-header"> <h4 class="modal-title"> 
					<b>LISTA DE PRODUCTOS <span class="label label-warning">{{texto_transferencia}}</span></b> </h4> 
				</div>
				<div class="modal-body" style="height:450px;">
					<form id="formulario_trans" class="form-horizontal" v-on:submit.prevent="phuyu_guardartransferencia()">
						<table class="table table-bordered">
							<thead>
								<tr align="center" >
									<th width="40%">PRODUCTO</th>
									<th width="20%">UNIDAD</th>
									<th width="20%">CANTIDAD</th>
									<th width="20%">SUBTOTAL</th>
								</tr>
							</thead>
							<tbody>
								<tr v-for="(dato, index) in detalletransferencia">
									<td>
										<input type="hidden" class="phuyu-input-inv" v-model="dato.codproducto" readonly>
										<input type="text" class="phuyu-input-inv" v-model="dato.producto" readonly> 
									</td>
									<td>
										<input type="hidden" class="phuyu-input-inv" v-model="dato.codunidad" readonly>
										<input type="text" class="phuyu-input-inv" v-model="dato.unidad" readonly>
									</td>
									<td> 
										<input type="number" step="0.001" class="phuyu-input-inv" v-model="dato.cantidad" v-on:keyup="phuyu_calcular(dato)"  min="0.001" required>
										<input type="hidden" step="0.01" class="phuyu-input-inv" v-model="dato.preciounitario" v-on:keyup="phuyu_calcular(dato)" min="0.01" > 
										<input type="hidden" v-model="dato.stockkardex"> <input type="hidden" v-model="dato.stockkardexconvertido"> <input type="hidden" v-model="dato.codkardex" > <input type="hidden" v-model="dato.item" > 
									</td>
									<td> 
										<input type="number" step="0.01" class="phuyu-input-inv" v-model="dato.subtotal" readonly> 
									</td>
								</tr>
							</tbody>
						</table>
						<div class="modal-footer">
							<button type="submit" class="btn btn-success" v-bind:disabled="estado_envio==1">ACEPTAR TRANSFERENCIA</button>
							<button type="button" class="btn btn-danger" data-dismiss="modal">CERRAR</button>
						</div>
					</form>
				</div>
			</div>
		</div>
	</div>
</div>

<script src="<?php echo base_url();?>phuyu/phuyu_almacen/ingresos.js"> </script>