--
-- PostgreSQL database dump
--

-- Dumped from database version 12.12
-- Dumped by pg_dump version 12.12

-- Started on 2023-05-08 17:25:19

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

--
-- TOC entry 10 (class 2615 OID 191916)
-- Name: almacen; Type: SCHEMA; Schema: -; Owner: phuyu15
--

CREATE SCHEMA almacen;


ALTER SCHEMA almacen OWNER TO phuyu15;

--
-- TOC entry 8 (class 2615 OID 191917)
-- Name: caja; Type: SCHEMA; Schema: -; Owner: phuyu15
--

CREATE SCHEMA caja;


ALTER SCHEMA caja OWNER TO phuyu15;

--
-- TOC entry 12 (class 2615 OID 191918)
-- Name: kardex; Type: SCHEMA; Schema: -; Owner: phuyu15
--

CREATE SCHEMA kardex;


ALTER SCHEMA kardex OWNER TO phuyu15;

--
-- TOC entry 6 (class 2615 OID 191919)
-- Name: seguridad; Type: SCHEMA; Schema: -; Owner: phuyu15
--

CREATE SCHEMA seguridad;


ALTER SCHEMA seguridad OWNER TO phuyu15;

--
-- TOC entry 7 (class 2615 OID 191920)
-- Name: sunat; Type: SCHEMA; Schema: -; Owner: phuyu15
--

CREATE SCHEMA sunat;


ALTER SCHEMA sunat OWNER TO phuyu15;

--
-- TOC entry 13 (class 2615 OID 191921)
-- Name: ventas; Type: SCHEMA; Schema: -; Owner: phuyu15
--

CREATE SCHEMA ventas;


ALTER SCHEMA ventas OWNER TO phuyu15;

SET default_tablespace = '';

SET default_table_access_method = heap;

--
-- TOC entry 208 (class 1259 OID 191922)
-- Name: almacenes; Type: TABLE; Schema: almacen; Owner: phuyu15
--

CREATE TABLE almacen.almacenes (
    codalmacen integer NOT NULL,
    codsucursal integer NOT NULL,
    descripcion character varying(100),
    direccion character varying(100),
    telefonos character varying(50),
    controlstock integer DEFAULT 1,
    estado integer DEFAULT 1,
    principal integer DEFAULT 0,
    codubigeo integer,
    despachodirecto integer DEFAULT 0,
    conpedido integer DEFAULT 0
);


ALTER TABLE almacen.almacenes OWNER TO phuyu15;

--
-- TOC entry 209 (class 1259 OID 191930)
-- Name: almacenes_codalmacen_seq; Type: SEQUENCE; Schema: almacen; Owner: phuyu15
--

CREATE SEQUENCE almacen.almacenes_codalmacen_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE almacen.almacenes_codalmacen_seq OWNER TO phuyu15;

--
-- TOC entry 4246 (class 0 OID 0)
-- Dependencies: 209
-- Name: almacenes_codalmacen_seq; Type: SEQUENCE OWNED BY; Schema: almacen; Owner: phuyu15
--

ALTER SEQUENCE almacen.almacenes_codalmacen_seq OWNED BY almacen.almacenes.codalmacen;


--
-- TOC entry 210 (class 1259 OID 191932)
-- Name: atenciones; Type: TABLE; Schema: almacen; Owner: phuyu15
--

CREATE TABLE almacen.atenciones (
    codatencion integer NOT NULL,
    descripcion character varying(100),
    impresora character varying(150),
    copias integer,
    estado integer DEFAULT 1
);


ALTER TABLE almacen.atenciones OWNER TO phuyu15;

--
-- TOC entry 211 (class 1259 OID 191936)
-- Name: atenciones_codatencion_seq; Type: SEQUENCE; Schema: almacen; Owner: phuyu15
--

CREATE SEQUENCE almacen.atenciones_codatencion_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE almacen.atenciones_codatencion_seq OWNER TO phuyu15;

--
-- TOC entry 4248 (class 0 OID 0)
-- Dependencies: 211
-- Name: atenciones_codatencion_seq; Type: SEQUENCE OWNED BY; Schema: almacen; Owner: phuyu15
--

ALTER SEQUENCE almacen.atenciones_codatencion_seq OWNED BY almacen.atenciones.codatencion;


--
-- TOC entry 212 (class 1259 OID 191938)
-- Name: clase; Type: TABLE; Schema: almacen; Owner: phuyu15
--

CREATE TABLE almacen.clase (
    codclase integer NOT NULL,
    descripcion character varying(100),
    estado integer DEFAULT 1,
    abreviatura character varying(10),
    codlinea integer DEFAULT 0,
    codfamilia integer DEFAULT 0
);


ALTER TABLE almacen.clase OWNER TO phuyu15;

--
-- TOC entry 213 (class 1259 OID 191944)
-- Name: clase_codclase_seq; Type: SEQUENCE; Schema: almacen; Owner: phuyu15
--

CREATE SEQUENCE almacen.clase_codclase_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE almacen.clase_codclase_seq OWNER TO phuyu15;

--
-- TOC entry 4250 (class 0 OID 0)
-- Dependencies: 213
-- Name: clase_codclase_seq; Type: SEQUENCE OWNED BY; Schema: almacen; Owner: phuyu15
--

ALTER SEQUENCE almacen.clase_codclase_seq OWNED BY almacen.clase.codclase;


--
-- TOC entry 214 (class 1259 OID 191946)
-- Name: familias; Type: TABLE; Schema: almacen; Owner: phuyu15
--

CREATE TABLE almacen.familias (
    codfamilia integer NOT NULL,
    descripcion character varying(100),
    estado integer DEFAULT 1,
    abreviatura character varying(10),
    codlinea integer DEFAULT 0
);


ALTER TABLE almacen.familias OWNER TO phuyu15;

--
-- TOC entry 215 (class 1259 OID 191951)
-- Name: familias_codfamilia_seq; Type: SEQUENCE; Schema: almacen; Owner: phuyu15
--

CREATE SEQUENCE almacen.familias_codfamilia_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE almacen.familias_codfamilia_seq OWNER TO phuyu15;

--
-- TOC entry 4252 (class 0 OID 0)
-- Dependencies: 215
-- Name: familias_codfamilia_seq; Type: SEQUENCE OWNED BY; Schema: almacen; Owner: phuyu15
--

ALTER SEQUENCE almacen.familias_codfamilia_seq OWNED BY almacen.familias.codfamilia;


--
-- TOC entry 216 (class 1259 OID 191953)
-- Name: guiasr; Type: TABLE; Schema: almacen; Owner: phuyu15
--

CREATE TABLE almacen.guiasr (
    codguiar integer NOT NULL,
    codpersona integer NOT NULL,
    codusuario integer,
    codcomprobantetipo integer,
    seriecomprobante character varying(4),
    nrocomprobante character varying(10),
    codmodalidadtraslado integer,
    codmotivotraslado integer DEFAULT 0,
    fechatraslado date DEFAULT now(),
    codigopuerto character(3),
    transbordo smallint,
    peso numeric(18,4) DEFAULT 0,
    nropaquetes integer,
    nrocontenedor integer DEFAULT 1,
    descripcionmotivo character varying(200),
    observaciones character varying(500) DEFAULT 0,
    codempleado integer,
    codubigeopartida integer,
    direccionpartida character varying(100),
    codubigeollegada integer,
    direccionllegada character varying(100),
    coddocumentotipotransportista integer,
    documentotransportista character varying(13),
    razonsocialtransportista character varying(100),
    nroplaca character varying(50),
    coddocumentotipoconductor integer,
    documentoconductor character varying(13),
    razonsocialconductor character varying(100),
    codalmacen integer,
    codsucursal integer,
    estado integer DEFAULT 1,
    codmovimientotipo integer,
    tipomovimiento integer,
    fechaguia date,
    marca character varying(50),
    destinatario character varying(150),
    licenciaconductor character varying(50),
    codremitente integer,
    razonsocialremitente character varying(100),
    coddestinatario integer,
    codproveedor integer,
    razonsocialproveedor character varying(150),
    constancia character varying(50)
);


ALTER TABLE almacen.guiasr OWNER TO phuyu15;

--
-- TOC entry 217 (class 1259 OID 191965)
-- Name: guiasr_codguiar_seq; Type: SEQUENCE; Schema: almacen; Owner: phuyu15
--

CREATE SEQUENCE almacen.guiasr_codguiar_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE almacen.guiasr_codguiar_seq OWNER TO phuyu15;

--
-- TOC entry 4254 (class 0 OID 0)
-- Dependencies: 217
-- Name: guiasr_codguiar_seq; Type: SEQUENCE OWNED BY; Schema: almacen; Owner: phuyu15
--

ALTER SEQUENCE almacen.guiasr_codguiar_seq OWNED BY almacen.guiasr.codguiar;


--
-- TOC entry 218 (class 1259 OID 191967)
-- Name: guiasrdetalle; Type: TABLE; Schema: almacen; Owner: phuyu15
--

CREATE TABLE almacen.guiasrdetalle (
    codguiar integer NOT NULL,
    codproducto integer NOT NULL,
    codunidad integer NOT NULL,
    item integer NOT NULL,
    detalle character varying(100),
    cantidad numeric(18,2),
    estado smallint,
    peso numeric(16,2)
);


ALTER TABLE almacen.guiasrdetalle OWNER TO phuyu15;

--
-- TOC entry 219 (class 1259 OID 191970)
-- Name: guiast; Type: TABLE; Schema: almacen; Owner: phuyu15
--

CREATE TABLE almacen.guiast (
    codguiat integer NOT NULL,
    codpersona integer NOT NULL,
    codusuario integer,
    codcomprobantetipo integer,
    seriecomprobante character varying(4),
    nrocomprobante character varying(10),
    codmodalidadtraslado integer,
    codmotivotraslado integer DEFAULT 0,
    fechatraslado date DEFAULT now(),
    codigopuerto character(3),
    transbordo smallint,
    peso numeric(18,4) DEFAULT 0,
    nropaquetes integer,
    nrocontenedor integer DEFAULT 1,
    descripcionmotivo character varying(200),
    observaciones character varying(200) DEFAULT 0,
    codempleado integer,
    codubigeopartida integer,
    direccionpartida character varying(100),
    codubigeollegada integer,
    direccionllegada character varying(100),
    coddocumentotipotransportista integer,
    documentotransportista character varying(13),
    razonsocialtransportista character varying(100),
    nroplaca character varying(8),
    coddocumentotipoconductor integer,
    documentoconductor character varying(13),
    razonsocialconductor character varying(100),
    codalmacen integer,
    codsucursal integer,
    estado integer DEFAULT 1,
    codmovimientotipo integer,
    tipomovimiento integer,
    fechaguia date
);


ALTER TABLE almacen.guiast OWNER TO phuyu15;

--
-- TOC entry 220 (class 1259 OID 191982)
-- Name: guiast_codguiat_seq; Type: SEQUENCE; Schema: almacen; Owner: phuyu15
--

CREATE SEQUENCE almacen.guiast_codguiat_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE almacen.guiast_codguiat_seq OWNER TO phuyu15;

--
-- TOC entry 4257 (class 0 OID 0)
-- Dependencies: 220
-- Name: guiast_codguiat_seq; Type: SEQUENCE OWNED BY; Schema: almacen; Owner: phuyu15
--

ALTER SEQUENCE almacen.guiast_codguiat_seq OWNED BY almacen.guiast.codguiat;


--
-- TOC entry 221 (class 1259 OID 191984)
-- Name: guiastdetalle; Type: TABLE; Schema: almacen; Owner: phuyu15
--

CREATE TABLE almacen.guiastdetalle (
    codguiat integer NOT NULL,
    codproducto integer NOT NULL,
    codunidad integer NOT NULL,
    item integer NOT NULL,
    detalle character varying(100),
    cantidad numeric(18,2),
    estado smallint
);


ALTER TABLE almacen.guiastdetalle OWNER TO phuyu15;

--
-- TOC entry 222 (class 1259 OID 191987)
-- Name: inventariodetalle; Type: TABLE; Schema: almacen; Owner: phuyu15
--

CREATE TABLE almacen.inventariodetalle (
    codinventario integer NOT NULL,
    codproducto integer NOT NULL,
    codunidad integer NOT NULL,
    cantidad numeric(18,4) DEFAULT 0,
    preciocosto numeric(18,4) DEFAULT 0,
    precioventa numeric(18,4) DEFAULT 0,
    importecosto numeric(18,4) DEFAULT 0,
    igvcosto numeric(18,4) DEFAULT 0,
    importe numeric(18,4) DEFAULT 0,
    registrosanitario character varying(12),
    fecharegistrosanitario date,
    fechavencimiento date,
    fechaproduccion date,
    loteproduccion character varying(12),
    cantidadconvertida numeric(18,4) DEFAULT 0
);


ALTER TABLE almacen.inventariodetalle OWNER TO phuyu15;

--
-- TOC entry 223 (class 1259 OID 191997)
-- Name: inventarios; Type: TABLE; Schema: almacen; Owner: phuyu15
--

CREATE TABLE almacen.inventarios (
    codinventario integer NOT NULL,
    codsucursal integer NOT NULL,
    codalmacen integer,
    codmovimientotipo integer,
    codusuario integer,
    fechaapertura date DEFAULT now(),
    fechacierre date,
    descripcion character varying(100),
    tipoinventario integer DEFAULT 0,
    importecosto numeric(18,4) DEFAULT 0,
    igvcosto numeric(18,4) DEFAULT 0,
    importe numeric(18,4) DEFAULT 0,
    estado integer DEFAULT 1,
    codkardex_ingreso integer DEFAULT 0,
    codkardex_salida integer DEFAULT 0
);


ALTER TABLE almacen.inventarios OWNER TO phuyu15;

--
-- TOC entry 224 (class 1259 OID 192008)
-- Name: inventarios_codinventario_seq; Type: SEQUENCE; Schema: almacen; Owner: phuyu15
--

CREATE SEQUENCE almacen.inventarios_codinventario_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE almacen.inventarios_codinventario_seq OWNER TO phuyu15;

--
-- TOC entry 4261 (class 0 OID 0)
-- Dependencies: 224
-- Name: inventarios_codinventario_seq; Type: SEQUENCE OWNED BY; Schema: almacen; Owner: phuyu15
--

ALTER SEQUENCE almacen.inventarios_codinventario_seq OWNED BY almacen.inventarios.codinventario;


--
-- TOC entry 225 (class 1259 OID 192010)
-- Name: kardexguiasr; Type: TABLE; Schema: almacen; Owner: phuyu15
--

CREATE TABLE almacen.kardexguiasr (
    codguiar integer NOT NULL,
    codkardex integer NOT NULL,
    codalmacen integer,
    codsucursal integer,
    codcomprobantetipok integer DEFAULT 0,
    seriecomprobantek character varying(4),
    nrocomprobantek character varying(10),
    codcomprobantetipogr integer DEFAULT 0,
    seriecomprobantegr character varying(4),
    nrocomprobantegr character varying(10),
    estado integer DEFAULT 1
);


ALTER TABLE almacen.kardexguiasr OWNER TO phuyu15;

--
-- TOC entry 226 (class 1259 OID 192016)
-- Name: kardexguiasrdetalle; Type: TABLE; Schema: almacen; Owner: phuyu15
--

CREATE TABLE almacen.kardexguiasrdetalle (
    codguiar integer NOT NULL,
    codkardex integer NOT NULL,
    codalmacen integer,
    codsucursal integer,
    codproducto integer NOT NULL,
    codunidad integer NOT NULL,
    itemgr integer NOT NULL,
    itemgk integer NOT NULL,
    cantidad numeric(18,4)
);


ALTER TABLE almacen.kardexguiasrdetalle OWNER TO phuyu15;

--
-- TOC entry 227 (class 1259 OID 192019)
-- Name: lineas; Type: TABLE; Schema: almacen; Owner: phuyu15
--

CREATE TABLE almacen.lineas (
    codlinea integer NOT NULL,
    descripcion character varying(100),
    estado integer DEFAULT 1,
    color character varying(20) DEFAULT 'ffffff'::character varying,
    background character varying(20) DEFAULT '211783'::character varying,
    abreviatura character varying(10)
);


ALTER TABLE almacen.lineas OWNER TO phuyu15;

--
-- TOC entry 228 (class 1259 OID 192025)
-- Name: lineas_codlinea_seq; Type: SEQUENCE; Schema: almacen; Owner: phuyu15
--

CREATE SEQUENCE almacen.lineas_codlinea_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE almacen.lineas_codlinea_seq OWNER TO phuyu15;

--
-- TOC entry 4265 (class 0 OID 0)
-- Dependencies: 228
-- Name: lineas_codlinea_seq; Type: SEQUENCE OWNED BY; Schema: almacen; Owner: phuyu15
--

ALTER SEQUENCE almacen.lineas_codlinea_seq OWNED BY almacen.lineas.codlinea;


--
-- TOC entry 229 (class 1259 OID 192027)
-- Name: marcas; Type: TABLE; Schema: almacen; Owner: phuyu15
--

CREATE TABLE almacen.marcas (
    codmarca integer NOT NULL,
    descripcion character varying(100),
    estado integer DEFAULT 1,
    abreviatura character varying(10)
);


ALTER TABLE almacen.marcas OWNER TO phuyu15;

--
-- TOC entry 230 (class 1259 OID 192031)
-- Name: marcas_codmarca_seq; Type: SEQUENCE; Schema: almacen; Owner: phuyu15
--

CREATE SEQUENCE almacen.marcas_codmarca_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE almacen.marcas_codmarca_seq OWNER TO phuyu15;

--
-- TOC entry 4267 (class 0 OID 0)
-- Dependencies: 230
-- Name: marcas_codmarca_seq; Type: SEQUENCE OWNED BY; Schema: almacen; Owner: phuyu15
--

ALTER SEQUENCE almacen.marcas_codmarca_seq OWNED BY almacen.marcas.codmarca;


--
-- TOC entry 231 (class 1259 OID 192033)
-- Name: modalidadtraslado; Type: TABLE; Schema: almacen; Owner: phuyu15
--

CREATE TABLE almacen.modalidadtraslado (
    codmodalidadtraslado integer NOT NULL,
    modalidadtraslado character varying(100),
    oficial character varying(2),
    estado smallint
);


ALTER TABLE almacen.modalidadtraslado OWNER TO phuyu15;

--
-- TOC entry 232 (class 1259 OID 192036)
-- Name: modalidadtraslado_codmodalidadtraslado_seq; Type: SEQUENCE; Schema: almacen; Owner: phuyu15
--

CREATE SEQUENCE almacen.modalidadtraslado_codmodalidadtraslado_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE almacen.modalidadtraslado_codmodalidadtraslado_seq OWNER TO phuyu15;

--
-- TOC entry 4269 (class 0 OID 0)
-- Dependencies: 232
-- Name: modalidadtraslado_codmodalidadtraslado_seq; Type: SEQUENCE OWNED BY; Schema: almacen; Owner: phuyu15
--

ALTER SEQUENCE almacen.modalidadtraslado_codmodalidadtraslado_seq OWNED BY almacen.modalidadtraslado.codmodalidadtraslado;


--
-- TOC entry 233 (class 1259 OID 192038)
-- Name: motivotraslado; Type: TABLE; Schema: almacen; Owner: phuyu15
--

CREATE TABLE almacen.motivotraslado (
    codmotivotraslado integer NOT NULL,
    descripcion character varying(200),
    oficial character varying(2),
    tipo integer,
    estado smallint
);


ALTER TABLE almacen.motivotraslado OWNER TO phuyu15;

--
-- TOC entry 234 (class 1259 OID 192041)
-- Name: motivotraslado_codmotivotraslado_seq; Type: SEQUENCE; Schema: almacen; Owner: phuyu15
--

CREATE SEQUENCE almacen.motivotraslado_codmotivotraslado_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE almacen.motivotraslado_codmotivotraslado_seq OWNER TO phuyu15;

--
-- TOC entry 4271 (class 0 OID 0)
-- Dependencies: 234
-- Name: motivotraslado_codmotivotraslado_seq; Type: SEQUENCE OWNED BY; Schema: almacen; Owner: phuyu15
--

ALTER SEQUENCE almacen.motivotraslado_codmotivotraslado_seq OWNED BY almacen.motivotraslado.codmotivotraslado;


--
-- TOC entry 235 (class 1259 OID 192043)
-- Name: movimientotipos; Type: TABLE; Schema: almacen; Owner: phuyu15
--

CREATE TABLE almacen.movimientotipos (
    codmovimientotipo integer NOT NULL,
    descripcion character varying(100),
    tipo integer,
    oficial character varying(3),
    origen integer DEFAULT 0,
    estado integer DEFAULT 1
);


ALTER TABLE almacen.movimientotipos OWNER TO phuyu15;

--
-- TOC entry 236 (class 1259 OID 192048)
-- Name: movimientotipos_codmovimientotipo_seq; Type: SEQUENCE; Schema: almacen; Owner: phuyu15
--

CREATE SEQUENCE almacen.movimientotipos_codmovimientotipo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE almacen.movimientotipos_codmovimientotipo_seq OWNER TO phuyu15;

--
-- TOC entry 4273 (class 0 OID 0)
-- Dependencies: 236
-- Name: movimientotipos_codmovimientotipo_seq; Type: SEQUENCE OWNED BY; Schema: almacen; Owner: phuyu15
--

ALTER SEQUENCE almacen.movimientotipos_codmovimientotipo_seq OWNED BY almacen.movimientotipos.codmovimientotipo;


--
-- TOC entry 237 (class 1259 OID 192050)
-- Name: presentacion; Type: TABLE; Schema: almacen; Owner: phuyu15
--

CREATE TABLE almacen.presentacion (
    codpresentacion integer NOT NULL,
    descripcion character varying(100),
    oficial character varying(3),
    estado integer DEFAULT 1
);


ALTER TABLE almacen.presentacion OWNER TO phuyu15;

--
-- TOC entry 238 (class 1259 OID 192054)
-- Name: presentacion_codpresentacion_seq; Type: SEQUENCE; Schema: almacen; Owner: phuyu15
--

CREATE SEQUENCE almacen.presentacion_codpresentacion_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE almacen.presentacion_codpresentacion_seq OWNER TO phuyu15;

--
-- TOC entry 4275 (class 0 OID 0)
-- Dependencies: 238
-- Name: presentacion_codpresentacion_seq; Type: SEQUENCE OWNED BY; Schema: almacen; Owner: phuyu15
--

ALTER SEQUENCE almacen.presentacion_codpresentacion_seq OWNED BY almacen.presentacion.codpresentacion;


--
-- TOC entry 239 (class 1259 OID 192056)
-- Name: principioactivo; Type: TABLE; Schema: almacen; Owner: phuyu15
--

CREATE TABLE almacen.principioactivo (
    codprincipioactivo integer NOT NULL,
    codfamilia integer DEFAULT 0 NOT NULL,
    codlinea integer DEFAULT 0 NOT NULL,
    codempresa integer DEFAULT 1 NOT NULL,
    codigo character varying(20),
    descripcion character varying(200),
    estado integer DEFAULT 1
);


ALTER TABLE almacen.principioactivo OWNER TO phuyu15;

--
-- TOC entry 240 (class 1259 OID 192063)
-- Name: principioactivo_codprincipioactivo_seq; Type: SEQUENCE; Schema: almacen; Owner: phuyu15
--

CREATE SEQUENCE almacen.principioactivo_codprincipioactivo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE almacen.principioactivo_codprincipioactivo_seq OWNER TO phuyu15;

--
-- TOC entry 4277 (class 0 OID 0)
-- Dependencies: 240
-- Name: principioactivo_codprincipioactivo_seq; Type: SEQUENCE OWNED BY; Schema: almacen; Owner: phuyu15
--

ALTER SEQUENCE almacen.principioactivo_codprincipioactivo_seq OWNED BY almacen.principioactivo.codprincipioactivo;


--
-- TOC entry 241 (class 1259 OID 192065)
-- Name: productos; Type: TABLE; Schema: almacen; Owner: phuyu15
--

CREATE TABLE almacen.productos (
    codproducto integer NOT NULL,
    codfamilia integer DEFAULT 0 NOT NULL,
    codlinea integer DEFAULT 0 NOT NULL,
    codmarca integer DEFAULT 0 NOT NULL,
    codempresa integer DEFAULT 1 NOT NULL,
    codigo character varying(20),
    descripcion character varying(200),
    afectoicbper integer DEFAULT 0,
    controlstock integer DEFAULT 1,
    afectoigvcompra integer DEFAULT 1,
    afectoigvventa integer DEFAULT 0,
    foto character varying(50) DEFAULT 'default.png'::character varying,
    estado integer DEFAULT 1,
    calcular integer DEFAULT 0,
    paraventa integer DEFAULT 1,
    codatencion integer DEFAULT 0,
    caracteristicas character varying(255),
    codoficial character varying(20),
    sexo integer DEFAULT 0,
    codmodelo integer DEFAULT 0,
    codcolor integer,
    codtalla integer DEFAULT 0,
    concaducidad integer DEFAULT 0,
    conrecetamedica integer DEFAULT 0,
    codpresentacion integer DEFAULT 0,
    codprincipioactivo integer DEFAULT 0,
    indicaciones character varying(100),
    composicion character varying(100),
    viaadministracion character varying(50),
    advertencias character varying(100),
    precauciones character varying(120),
    contraindicaciones character varying(100),
    almacenamiento character varying(50)
);


ALTER TABLE almacen.productos OWNER TO phuyu15;

--
-- TOC entry 4278 (class 0 OID 0)
-- Dependencies: 241
-- Name: COLUMN productos.concaducidad; Type: COMMENT; Schema: almacen; Owner: phuyu15
--

COMMENT ON COLUMN almacen.productos.concaducidad IS '0: No tiene caducidad

1: Si tiene caducidad';


--
-- TOC entry 4279 (class 0 OID 0)
-- Dependencies: 241
-- Name: COLUMN productos.conrecetamedica; Type: COMMENT; Schema: almacen; Owner: phuyu15
--

COMMENT ON COLUMN almacen.productos.conrecetamedica IS '0: Sin receta medica

1: con receta medica';


--
-- TOC entry 4280 (class 0 OID 0)
-- Dependencies: 241
-- Name: COLUMN productos.indicaciones; Type: COMMENT; Schema: almacen; Owner: phuyu15
--

COMMENT ON COLUMN almacen.productos.indicaciones IS 'Graba las indicaciones del producto. Se utiliza para botica';


--
-- TOC entry 4281 (class 0 OID 0)
-- Dependencies: 241
-- Name: COLUMN productos.composicion; Type: COMMENT; Schema: almacen; Owner: phuyu15
--

COMMENT ON COLUMN almacen.productos.composicion IS 'Graba la composición del producto. Se utiliza para botica';


--
-- TOC entry 4282 (class 0 OID 0)
-- Dependencies: 241
-- Name: COLUMN productos.viaadministracion; Type: COMMENT; Schema: almacen; Owner: phuyu15
--

COMMENT ON COLUMN almacen.productos.viaadministracion IS 'Se utiliza para botica';


--
-- TOC entry 4283 (class 0 OID 0)
-- Dependencies: 241
-- Name: COLUMN productos.advertencias; Type: COMMENT; Schema: almacen; Owner: phuyu15
--

COMMENT ON COLUMN almacen.productos.advertencias IS 'Se utiliza para botica';


--
-- TOC entry 4284 (class 0 OID 0)
-- Dependencies: 241
-- Name: COLUMN productos.precauciones; Type: COMMENT; Schema: almacen; Owner: phuyu15
--

COMMENT ON COLUMN almacen.productos.precauciones IS 'Se utiliza para botica';


--
-- TOC entry 4285 (class 0 OID 0)
-- Dependencies: 241
-- Name: COLUMN productos.contraindicaciones; Type: COMMENT; Schema: almacen; Owner: phuyu15
--

COMMENT ON COLUMN almacen.productos.contraindicaciones IS 'Se utiliza para botica';


--
-- TOC entry 4286 (class 0 OID 0)
-- Dependencies: 241
-- Name: COLUMN productos.almacenamiento; Type: COMMENT; Schema: almacen; Owner: phuyu15
--

COMMENT ON COLUMN almacen.productos.almacenamiento IS 'Se utiliza para botica';


--
-- TOC entry 242 (class 1259 OID 192091)
-- Name: productos_codproducto_seq; Type: SEQUENCE; Schema: almacen; Owner: phuyu15
--

CREATE SEQUENCE almacen.productos_codproducto_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE almacen.productos_codproducto_seq OWNER TO phuyu15;

--
-- TOC entry 4288 (class 0 OID 0)
-- Dependencies: 242
-- Name: productos_codproducto_seq; Type: SEQUENCE OWNED BY; Schema: almacen; Owner: phuyu15
--

ALTER SEQUENCE almacen.productos_codproducto_seq OWNED BY almacen.productos.codproducto;


--
-- TOC entry 243 (class 1259 OID 192093)
-- Name: productoubicacion; Type: TABLE; Schema: almacen; Owner: phuyu15
--

CREATE TABLE almacen.productoubicacion (
    codalmacen integer NOT NULL,
    codproducto integer NOT NULL,
    codunidad integer NOT NULL,
    codsucursal integer,
    stockactual numeric(18,4) DEFAULT 0,
    stockactualreal numeric(18,4) DEFAULT 0,
    preciostockvalorizado numeric(18,6) DEFAULT 0,
    ventarecogo numeric(18,4) DEFAULT 0,
    comprarecogo numeric(18,4) DEFAULT 0,
    stockminimo numeric(18,4) DEFAULT 0,
    stockmaximo numeric(18,4) DEFAULT 0,
    estado integer DEFAULT 1,
    stockactualconvertido numeric(18,4) DEFAULT 0,
    factor numeric(18,6) DEFAULT 1,
    preciocompra numeric(18,4) DEFAULT 0,
    pventapublico numeric(18,4) DEFAULT 0,
    pventamin numeric(18,4) DEFAULT 0,
    pventacredito numeric(18,4) DEFAULT 0,
    pventaxmayor numeric(18,4) DEFAULT 0,
    pventaadicional numeric(18,4) DEFAULT 0,
    preciocosto numeric(18,4) DEFAULT 0,
    gastos numeric(18,4) DEFAULT 0,
    codigobarra character varying(30)
);


ALTER TABLE almacen.productoubicacion OWNER TO phuyu15;

--
-- TOC entry 244 (class 1259 OID 192114)
-- Name: productounidades; Type: TABLE; Schema: almacen; Owner: phuyu15
--

CREATE TABLE almacen.productounidades (
    codproducto integer NOT NULL,
    codunidad integer NOT NULL,
    codsucursal integer DEFAULT 1,
    factor numeric(18,6) DEFAULT 1,
    preciocompra numeric(18,4) DEFAULT 0,
    pventapublico numeric(18,4) DEFAULT 0,
    pventamin numeric(18,4) DEFAULT 0,
    pventacredito numeric(18,4) DEFAULT 0,
    pventaxmayor numeric(18,4) DEFAULT 0,
    pventaadicional numeric(18,4) DEFAULT 0,
    preciocosto numeric(18,4) DEFAULT 0,
    gastos numeric(18,4) DEFAULT 0,
    codigobarra character varying(30),
    estado integer DEFAULT 1,
    unidad character varying(30)
);


ALTER TABLE almacen.productounidades OWNER TO phuyu15;

--
-- TOC entry 245 (class 1259 OID 192128)
-- Name: unidades; Type: TABLE; Schema: almacen; Owner: phuyu15
--

CREATE TABLE almacen.unidades (
    codunidad integer NOT NULL,
    descripcion character varying(100),
    oficial character varying(3),
    estado integer DEFAULT 1
);


ALTER TABLE almacen.unidades OWNER TO phuyu15;

--
-- TOC entry 246 (class 1259 OID 192132)
-- Name: unidades_codunidad_seq; Type: SEQUENCE; Schema: almacen; Owner: phuyu15
--

CREATE SEQUENCE almacen.unidades_codunidad_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE almacen.unidades_codunidad_seq OWNER TO phuyu15;

--
-- TOC entry 4292 (class 0 OID 0)
-- Dependencies: 246
-- Name: unidades_codunidad_seq; Type: SEQUENCE OWNED BY; Schema: almacen; Owner: phuyu15
--

ALTER SEQUENCE almacen.unidades_codunidad_seq OWNED BY almacen.unidades.codunidad;


--
-- TOC entry 247 (class 1259 OID 192134)
-- Name: v_productounidades; Type: VIEW; Schema: almacen; Owner: phuyu15
--

CREATE VIEW almacen.v_productounidades AS
 SELECT pub.codalmacen,
    pun.codproducto,
    a.descripcion AS almacen,
    string_agg(((((((((((((((((((un.codunidad || '|'::text) || (un.descripcion)::text) || '|'::text) || (un.oficial)::text) || '|'::text) || round(pub.stockactualconvertido, 2)) || '|'::text) || round(pub.stockactual, 2)) || '|'::text) || round(pun.pventapublico, 2)) || '|'::text) || COALESCE(pun.pventamin, (0)::numeric)) || '|'::text) || COALESCE(pun.pventacredito, (0)::numeric)) || '|'::text) || pun.factor) || '|'::text) || pun.preciocosto), ';'::text) AS unidades
   FROM (((almacen.productounidades pun
     JOIN almacen.productoubicacion pub ON (((pun.codproducto = pub.codproducto) AND (pun.codunidad = pub.codunidad))))
     JOIN almacen.unidades un ON ((pun.codunidad = un.codunidad)))
     JOIN almacen.almacenes a ON ((pub.codalmacen = a.codalmacen)))
  WHERE (pub.estado = 1)
  GROUP BY pub.codalmacen, pun.codproducto, a.descripcion;


ALTER TABLE almacen.v_productounidades OWNER TO phuyu15;

--
-- TOC entry 248 (class 1259 OID 192139)
-- Name: vehiculos; Type: TABLE; Schema: almacen; Owner: phuyu15
--

CREATE TABLE almacen.vehiculos (
    codvehiculo integer NOT NULL,
    nroplaca character varying(50),
    codvehiculocategoria integer,
    codvehiculomarca integer,
    aniofabricacion integer,
    codvehiculomodelo integer,
    nrocertinscripcion character varying(50),
    configuracionvehicular character varying(20),
    color character varying(50),
    nroserie character varying(50),
    nromotor character varying(50),
    codpersona integer,
    codusuario integer,
    descripcion character varying(200),
    caracteristicas character varying(500),
    codconductor integer,
    conductor character varying(100),
    licenciadeconducir character varying(50),
    constancia character varying(100),
    estado integer DEFAULT 1
);


ALTER TABLE almacen.vehiculos OWNER TO phuyu15;

--
-- TOC entry 4293 (class 0 OID 0)
-- Dependencies: 248
-- Name: COLUMN vehiculos.codvehiculocategoria; Type: COMMENT; Schema: almacen; Owner: phuyu15
--

COMMENT ON COLUMN almacen.vehiculos.codvehiculocategoria IS '1: Motocicletas

2: Mototaxis

3: Camionetas

4: Automoviles

5: Camiones';


--
-- TOC entry 249 (class 1259 OID 192146)
-- Name: vehiculos_codvehiculo_seq; Type: SEQUENCE; Schema: almacen; Owner: phuyu15
--

CREATE SEQUENCE almacen.vehiculos_codvehiculo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE almacen.vehiculos_codvehiculo_seq OWNER TO phuyu15;

--
-- TOC entry 4295 (class 0 OID 0)
-- Dependencies: 249
-- Name: vehiculos_codvehiculo_seq; Type: SEQUENCE OWNED BY; Schema: almacen; Owner: phuyu15
--

ALTER SEQUENCE almacen.vehiculos_codvehiculo_seq OWNED BY almacen.vehiculos.codvehiculo;


--
-- TOC entry 250 (class 1259 OID 192148)
-- Name: vehiculoscategorias; Type: TABLE; Schema: almacen; Owner: phuyu15
--

CREATE TABLE almacen.vehiculoscategorias (
    codvehiculocategoria integer NOT NULL,
    descripcion character varying(100),
    estado integer DEFAULT 1
);


ALTER TABLE almacen.vehiculoscategorias OWNER TO phuyu15;

--
-- TOC entry 251 (class 1259 OID 192152)
-- Name: vehiculoscategorias_codvehiculocategoria_seq; Type: SEQUENCE; Schema: almacen; Owner: phuyu15
--

CREATE SEQUENCE almacen.vehiculoscategorias_codvehiculocategoria_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE almacen.vehiculoscategorias_codvehiculocategoria_seq OWNER TO phuyu15;

--
-- TOC entry 4297 (class 0 OID 0)
-- Dependencies: 251
-- Name: vehiculoscategorias_codvehiculocategoria_seq; Type: SEQUENCE OWNED BY; Schema: almacen; Owner: phuyu15
--

ALTER SEQUENCE almacen.vehiculoscategorias_codvehiculocategoria_seq OWNED BY almacen.vehiculoscategorias.codvehiculocategoria;


--
-- TOC entry 252 (class 1259 OID 192154)
-- Name: vehiculosmarcas; Type: TABLE; Schema: almacen; Owner: phuyu15
--

CREATE TABLE almacen.vehiculosmarcas (
    codvehiculomarca integer NOT NULL,
    descripcion character varying(100),
    estado integer DEFAULT 1
);


ALTER TABLE almacen.vehiculosmarcas OWNER TO phuyu15;

--
-- TOC entry 253 (class 1259 OID 192158)
-- Name: vehiculosmarcas_codvehiculomarca_seq; Type: SEQUENCE; Schema: almacen; Owner: phuyu15
--

CREATE SEQUENCE almacen.vehiculosmarcas_codvehiculomarca_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE almacen.vehiculosmarcas_codvehiculomarca_seq OWNER TO phuyu15;

--
-- TOC entry 4299 (class 0 OID 0)
-- Dependencies: 253
-- Name: vehiculosmarcas_codvehiculomarca_seq; Type: SEQUENCE OWNED BY; Schema: almacen; Owner: phuyu15
--

ALTER SEQUENCE almacen.vehiculosmarcas_codvehiculomarca_seq OWNED BY almacen.vehiculosmarcas.codvehiculomarca;


--
-- TOC entry 254 (class 1259 OID 192160)
-- Name: vehiculosmodelos; Type: TABLE; Schema: almacen; Owner: phuyu15
--

CREATE TABLE almacen.vehiculosmodelos (
    codvehiculomodelo integer NOT NULL,
    codvehiculomarca integer NOT NULL,
    descripcion character varying(100),
    estado integer DEFAULT 1
);


ALTER TABLE almacen.vehiculosmodelos OWNER TO phuyu15;

--
-- TOC entry 255 (class 1259 OID 192164)
-- Name: vehiculosmodelos_codvehiculomodelo_seq; Type: SEQUENCE; Schema: almacen; Owner: phuyu15
--

CREATE SEQUENCE almacen.vehiculosmodelos_codvehiculomodelo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE almacen.vehiculosmodelos_codvehiculomodelo_seq OWNER TO phuyu15;

--
-- TOC entry 4301 (class 0 OID 0)
-- Dependencies: 255
-- Name: vehiculosmodelos_codvehiculomodelo_seq; Type: SEQUENCE OWNED BY; Schema: almacen; Owner: phuyu15
--

ALTER SEQUENCE almacen.vehiculosmodelos_codvehiculomodelo_seq OWNED BY almacen.vehiculosmodelos.codvehiculomodelo;


--
-- TOC entry 256 (class 1259 OID 192166)
-- Name: bancos; Type: TABLE; Schema: caja; Owner: phuyu15
--

CREATE TABLE caja.bancos (
    codbanco integer NOT NULL,
    descripcion character varying(100),
    abreviatura character varying(10),
    oficial character varying(5),
    tipobanco integer DEFAULT 1,
    estado integer DEFAULT 1
);


ALTER TABLE caja.bancos OWNER TO phuyu15;

--
-- TOC entry 257 (class 1259 OID 192171)
-- Name: bancos_codbanco_seq; Type: SEQUENCE; Schema: caja; Owner: phuyu15
--

CREATE SEQUENCE caja.bancos_codbanco_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE caja.bancos_codbanco_seq OWNER TO phuyu15;

--
-- TOC entry 4303 (class 0 OID 0)
-- Dependencies: 257
-- Name: bancos_codbanco_seq; Type: SEQUENCE OWNED BY; Schema: caja; Owner: phuyu15
--

ALTER SEQUENCE caja.bancos_codbanco_seq OWNED BY caja.bancos.codbanco;


--
-- TOC entry 258 (class 1259 OID 192173)
-- Name: cajas; Type: TABLE; Schema: caja; Owner: phuyu15
--

CREATE TABLE caja.cajas (
    codcaja integer NOT NULL,
    codsucursal integer NOT NULL,
    descripcion character varying(100),
    direccion character varying(100),
    telefonos character varying(50),
    estado integer DEFAULT 1,
    saldarautomaticamente integer DEFAULT 0
);


ALTER TABLE caja.cajas OWNER TO phuyu15;

--
-- TOC entry 259 (class 1259 OID 192178)
-- Name: cajas_codcaja_seq; Type: SEQUENCE; Schema: caja; Owner: phuyu15
--

CREATE SEQUENCE caja.cajas_codcaja_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE caja.cajas_codcaja_seq OWNER TO phuyu15;

--
-- TOC entry 4305 (class 0 OID 0)
-- Dependencies: 259
-- Name: cajas_codcaja_seq; Type: SEQUENCE OWNED BY; Schema: caja; Owner: phuyu15
--

ALTER SEQUENCE caja.cajas_codcaja_seq OWNED BY caja.cajas.codcaja;


--
-- TOC entry 260 (class 1259 OID 192180)
-- Name: centrocostos; Type: TABLE; Schema: caja; Owner: phuyu15
--

CREATE TABLE caja.centrocostos (
    codcentrocosto integer NOT NULL,
    descripcion character varying(100),
    centrocosto character varying(10),
    ctacontableabono character varying(20),
    ctacontablecargo character varying(20),
    ctacontabledebe character varying(20),
    ctacontablehaber character varying(20),
    estado integer DEFAULT 1
);


ALTER TABLE caja.centrocostos OWNER TO phuyu15;

--
-- TOC entry 261 (class 1259 OID 192184)
-- Name: centrocostos_codcentrocosto_seq; Type: SEQUENCE; Schema: caja; Owner: phuyu15
--

CREATE SEQUENCE caja.centrocostos_codcentrocosto_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE caja.centrocostos_codcentrocosto_seq OWNER TO phuyu15;

--
-- TOC entry 4307 (class 0 OID 0)
-- Dependencies: 261
-- Name: centrocostos_codcentrocosto_seq; Type: SEQUENCE OWNED BY; Schema: caja; Owner: phuyu15
--

ALTER SEQUENCE caja.centrocostos_codcentrocosto_seq OWNED BY caja.centrocostos.codcentrocosto;


--
-- TOC entry 262 (class 1259 OID 192186)
-- Name: comprobantes; Type: TABLE; Schema: caja; Owner: phuyu15
--

CREATE TABLE caja.comprobantes (
    codcomprobantetipo integer NOT NULL,
    seriecomprobante character varying(4) NOT NULL,
    nrocorrelativo integer DEFAULT 1,
    codsucursal integer NOT NULL,
    codcaja integer DEFAULT 0,
    codalmacen integer DEFAULT 0,
    nroinicial integer DEFAULT 0,
    nroitems integer DEFAULT 0,
    codcomprobantetipo_ref integer,
    seriecomprobante_ref character varying(4),
    impresion integer DEFAULT 1,
    formato character varying(10) DEFAULT 'a4'::character varying,
    orientacion character varying(10) DEFAULT 'p'::character varying,
    impresora character varying(100),
    estado integer DEFAULT 1
);


ALTER TABLE caja.comprobantes OWNER TO phuyu15;

--
-- TOC entry 263 (class 1259 OID 192198)
-- Name: comprobantetipos; Type: TABLE; Schema: caja; Owner: phuyu15
--

CREATE TABLE caja.comprobantetipos (
    codcomprobantetipo integer NOT NULL,
    descripcion character varying(100),
    abreviatura character varying(3),
    oficial character varying(3),
    origen integer DEFAULT 1,
    control integer DEFAULT 0,
    estado integer DEFAULT 1
);


ALTER TABLE caja.comprobantetipos OWNER TO phuyu15;

--
-- TOC entry 264 (class 1259 OID 192204)
-- Name: comprobantetipos_codcomprobantetipo_seq; Type: SEQUENCE; Schema: caja; Owner: phuyu15
--

CREATE SEQUENCE caja.comprobantetipos_codcomprobantetipo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE caja.comprobantetipos_codcomprobantetipo_seq OWNER TO phuyu15;

--
-- TOC entry 4310 (class 0 OID 0)
-- Dependencies: 264
-- Name: comprobantetipos_codcomprobantetipo_seq; Type: SEQUENCE OWNED BY; Schema: caja; Owner: phuyu15
--

ALTER SEQUENCE caja.comprobantetipos_codcomprobantetipo_seq OWNED BY caja.comprobantetipos.codcomprobantetipo;


--
-- TOC entry 265 (class 1259 OID 192206)
-- Name: conceptos; Type: TABLE; Schema: caja; Owner: phuyu15
--

CREATE TABLE caja.conceptos (
    codconcepto integer NOT NULL,
    descripcion character varying(100),
    abreviatura character varying(20),
    tipo integer,
    estado integer DEFAULT 1
);


ALTER TABLE caja.conceptos OWNER TO phuyu15;

--
-- TOC entry 266 (class 1259 OID 192210)
-- Name: conceptos_codconcepto_seq; Type: SEQUENCE; Schema: caja; Owner: phuyu15
--

CREATE SEQUENCE caja.conceptos_codconcepto_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE caja.conceptos_codconcepto_seq OWNER TO phuyu15;

--
-- TOC entry 4312 (class 0 OID 0)
-- Dependencies: 266
-- Name: conceptos_codconcepto_seq; Type: SEQUENCE OWNED BY; Schema: caja; Owner: phuyu15
--

ALTER SEQUENCE caja.conceptos_codconcepto_seq OWNED BY caja.conceptos.codconcepto;


--
-- TOC entry 267 (class 1259 OID 192212)
-- Name: controldiario; Type: TABLE; Schema: caja; Owner: phuyu15
--

CREATE TABLE caja.controldiario (
    codcontroldiario integer NOT NULL,
    codcaja integer NOT NULL,
    codusuario integer,
    codusuariocierre integer,
    codsucursal integer,
    fechaapertura date DEFAULT now(),
    fechacierre date,
    saldoinicialcaja numeric(18,4) DEFAULT 0,
    saldofinalcaja numeric(18,4) DEFAULT 0,
    totalingresoscaja numeric(18,4) DEFAULT 0,
    totalegresoscaja numeric(18,4) DEFAULT 0,
    ajustecaja numeric(18,4) DEFAULT 0,
    saldoinicialbanco numeric(18,4) DEFAULT 0,
    saldofinalbanco numeric(18,4) DEFAULT 0,
    totalingresosbanco numeric(18,4) DEFAULT 0,
    totalegresosbanco numeric(18,4) DEFAULT 0,
    ajustebanco numeric(18,4) DEFAULT 0,
    codigodiario character varying(8),
    cerrado integer DEFAULT 1,
    estado integer DEFAULT 1
);


ALTER TABLE caja.controldiario OWNER TO phuyu15;

--
-- TOC entry 268 (class 1259 OID 192228)
-- Name: controldiario_codcontroldiario_seq; Type: SEQUENCE; Schema: caja; Owner: phuyu15
--

CREATE SEQUENCE caja.controldiario_codcontroldiario_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE caja.controldiario_codcontroldiario_seq OWNER TO phuyu15;

--
-- TOC entry 4314 (class 0 OID 0)
-- Dependencies: 268
-- Name: controldiario_codcontroldiario_seq; Type: SEQUENCE OWNED BY; Schema: caja; Owner: phuyu15
--

ALTER SEQUENCE caja.controldiario_codcontroldiario_seq OWNED BY caja.controldiario.codcontroldiario;


--
-- TOC entry 269 (class 1259 OID 192230)
-- Name: ctasctes; Type: TABLE; Schema: caja; Owner: phuyu15
--

CREATE TABLE caja.ctasctes (
    codctacte integer NOT NULL,
    codbanco integer,
    codmoneda integer,
    codpersona integer,
    nroctacte character varying(50),
    descripcion character varying(100),
    estado integer DEFAULT 1
);


ALTER TABLE caja.ctasctes OWNER TO phuyu15;

--
-- TOC entry 270 (class 1259 OID 192234)
-- Name: ctasctes_codctacte_seq; Type: SEQUENCE; Schema: caja; Owner: phuyu15
--

CREATE SEQUENCE caja.ctasctes_codctacte_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE caja.ctasctes_codctacte_seq OWNER TO phuyu15;

--
-- TOC entry 4316 (class 0 OID 0)
-- Dependencies: 270
-- Name: ctasctes_codctacte_seq; Type: SEQUENCE OWNED BY; Schema: caja; Owner: phuyu15
--

ALTER SEQUENCE caja.ctasctes_codctacte_seq OWNED BY caja.ctasctes.codctacte;


--
-- TOC entry 271 (class 1259 OID 192236)
-- Name: monedas; Type: TABLE; Schema: caja; Owner: phuyu15
--

CREATE TABLE caja.monedas (
    codmoneda integer NOT NULL,
    descripcion character varying(100),
    simbolo character varying(3),
    oficial character varying(3),
    tipo integer DEFAULT 1,
    estado integer DEFAULT 1
);


ALTER TABLE caja.monedas OWNER TO phuyu15;

--
-- TOC entry 272 (class 1259 OID 192241)
-- Name: monedas_codmoneda_seq; Type: SEQUENCE; Schema: caja; Owner: phuyu15
--

CREATE SEQUENCE caja.monedas_codmoneda_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE caja.monedas_codmoneda_seq OWNER TO phuyu15;

--
-- TOC entry 4318 (class 0 OID 0)
-- Dependencies: 272
-- Name: monedas_codmoneda_seq; Type: SEQUENCE OWNED BY; Schema: caja; Owner: phuyu15
--

ALTER SEQUENCE caja.monedas_codmoneda_seq OWNED BY caja.monedas.codmoneda;


--
-- TOC entry 273 (class 1259 OID 192243)
-- Name: movimientos; Type: TABLE; Schema: caja; Owner: phuyu15
--

CREATE TABLE caja.movimientos (
    codmovimiento integer NOT NULL,
    codcontroldiario integer NOT NULL,
    codcaja integer NOT NULL,
    codconcepto integer NOT NULL,
    codpersona integer NOT NULL,
    codusuario integer,
    tipomovimiento integer,
    codcomprobantetipo integer,
    seriecomprobante character varying(4),
    nrocomprobante character varying(10),
    codkardex integer DEFAULT 0,
    fechamovimiento date DEFAULT now(),
    codcomprobantetipo_ref integer,
    seriecomprobante_ref character varying(4),
    nrocomprobante_ref character varying(10),
    importe numeric(18,4) DEFAULT 0,
    referencia character varying(200),
    condicionpago integer DEFAULT 1,
    estado integer DEFAULT 1,
    codcaja_ref integer,
    transferido integer DEFAULT 0,
    codempleado integer
);


ALTER TABLE caja.movimientos OWNER TO phuyu15;

--
-- TOC entry 274 (class 1259 OID 192252)
-- Name: movimientos_codmovimiento_seq; Type: SEQUENCE; Schema: caja; Owner: phuyu15
--

CREATE SEQUENCE caja.movimientos_codmovimiento_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE caja.movimientos_codmovimiento_seq OWNER TO phuyu15;

--
-- TOC entry 4320 (class 0 OID 0)
-- Dependencies: 274
-- Name: movimientos_codmovimiento_seq; Type: SEQUENCE OWNED BY; Schema: caja; Owner: phuyu15
--

ALTER SEQUENCE caja.movimientos_codmovimiento_seq OWNED BY caja.movimientos.codmovimiento;


--
-- TOC entry 275 (class 1259 OID 192254)
-- Name: movimientosdetalle; Type: TABLE; Schema: caja; Owner: phuyu15
--

CREATE TABLE caja.movimientosdetalle (
    codmovimiento integer NOT NULL,
    codtipopago integer NOT NULL,
    codcontroldiario integer NOT NULL,
    codcaja integer NOT NULL,
    codmoneda integer DEFAULT 1,
    tipocambio numeric(18,4) DEFAULT 1,
    codctacte integer,
    fechadocbanco date,
    nrodocbanco character varying(30),
    urldocbanco character varying(200),
    importe numeric(18,4) DEFAULT 0,
    importeentregado numeric(18,4) DEFAULT 0,
    vuelto numeric(18,4) DEFAULT 0,
    estado integer DEFAULT 1
);


ALTER TABLE caja.movimientosdetalle OWNER TO phuyu15;

--
-- TOC entry 276 (class 1259 OID 192263)
-- Name: tipocambios; Type: TABLE; Schema: caja; Owner: phuyu15
--

CREATE TABLE caja.tipocambios (
    codtipocambio integer NOT NULL,
    codmoneda integer,
    compra numeric(10,4),
    venta numeric(10,4),
    fecha date DEFAULT now(),
    estado integer DEFAULT 1
);


ALTER TABLE caja.tipocambios OWNER TO phuyu15;

--
-- TOC entry 277 (class 1259 OID 192268)
-- Name: tipocambios_codtipocambio_seq; Type: SEQUENCE; Schema: caja; Owner: phuyu15
--

CREATE SEQUENCE caja.tipocambios_codtipocambio_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE caja.tipocambios_codtipocambio_seq OWNER TO phuyu15;

--
-- TOC entry 4323 (class 0 OID 0)
-- Dependencies: 277
-- Name: tipocambios_codtipocambio_seq; Type: SEQUENCE OWNED BY; Schema: caja; Owner: phuyu15
--

ALTER SEQUENCE caja.tipocambios_codtipocambio_seq OWNED BY caja.tipocambios.codtipocambio;


--
-- TOC entry 278 (class 1259 OID 192270)
-- Name: tipopagos; Type: TABLE; Schema: caja; Owner: phuyu15
--

CREATE TABLE caja.tipopagos (
    codtipopago integer NOT NULL,
    descripcion character varying(100),
    ingreso integer,
    egreso integer,
    abono integer,
    cargo integer,
    estado integer DEFAULT 1
);


ALTER TABLE caja.tipopagos OWNER TO phuyu15;

--
-- TOC entry 279 (class 1259 OID 192274)
-- Name: tipopagos_codtipopago_seq; Type: SEQUENCE; Schema: caja; Owner: phuyu15
--

CREATE SEQUENCE caja.tipopagos_codtipopago_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE caja.tipopagos_codtipopago_seq OWNER TO phuyu15;

--
-- TOC entry 4325 (class 0 OID 0)
-- Dependencies: 279
-- Name: tipopagos_codtipopago_seq; Type: SEQUENCE OWNED BY; Schema: caja; Owner: phuyu15
--

ALTER SEQUENCE caja.tipopagos_codtipopago_seq OWNED BY caja.tipopagos.codtipopago;


--
-- TOC entry 280 (class 1259 OID 192276)
-- Name: creditoconceptos; Type: TABLE; Schema: kardex; Owner: phuyu15
--

CREATE TABLE kardex.creditoconceptos (
    codcreditoconcepto integer NOT NULL,
    descripcion character varying(100),
    tipo integer,
    estado integer DEFAULT 1
);


ALTER TABLE kardex.creditoconceptos OWNER TO phuyu15;

--
-- TOC entry 281 (class 1259 OID 192280)
-- Name: creditoconceptos_codcreditoconcepto_seq; Type: SEQUENCE; Schema: kardex; Owner: phuyu15
--

CREATE SEQUENCE kardex.creditoconceptos_codcreditoconcepto_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE kardex.creditoconceptos_codcreditoconcepto_seq OWNER TO phuyu15;

--
-- TOC entry 4327 (class 0 OID 0)
-- Dependencies: 281
-- Name: creditoconceptos_codcreditoconcepto_seq; Type: SEQUENCE OWNED BY; Schema: kardex; Owner: phuyu15
--

ALTER SEQUENCE kardex.creditoconceptos_codcreditoconcepto_seq OWNED BY kardex.creditoconceptos.codcreditoconcepto;


--
-- TOC entry 282 (class 1259 OID 192282)
-- Name: creditos; Type: TABLE; Schema: kardex; Owner: phuyu15
--

CREATE TABLE kardex.creditos (
    codcredito integer NOT NULL,
    codsucursal integer NOT NULL,
    codcaja integer NOT NULL,
    codcreditoconcepto integer NOT NULL,
    codpersona integer NOT NULL,
    codmovimiento integer,
    codusuario integer NOT NULL,
    codempleado integer DEFAULT 0,
    codmoneda integer DEFAULT 1,
    tipocambio numeric(18,4) DEFAULT 1,
    codkardex integer,
    tipo integer,
    fechacredito date DEFAULT now(),
    fechainicio date DEFAULT now(),
    fechavencimiento date,
    fecha date DEFAULT now(),
    hora time without time zone DEFAULT now(),
    nrodias integer DEFAULT 0,
    nrocuotas integer DEFAULT 1,
    importe numeric(18,4) DEFAULT 0,
    tasainteres numeric(18,4) DEFAULT 0,
    tasainteresmora numeric(18,4) DEFAULT 0,
    interes numeric(18,4) DEFAULT 0,
    saldo numeric(18,4) DEFAULT 0,
    saldomora numeric(18,4) DEFAULT 0,
    total numeric(18,4) DEFAULT 0,
    tipocuota integer DEFAULT 0,
    estado integer DEFAULT 1,
    referencia character varying(255)
);


ALTER TABLE kardex.creditos OWNER TO phuyu15;

--
-- TOC entry 283 (class 1259 OID 192303)
-- Name: creditos_codcredito_seq; Type: SEQUENCE; Schema: kardex; Owner: phuyu15
--

CREATE SEQUENCE kardex.creditos_codcredito_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE kardex.creditos_codcredito_seq OWNER TO phuyu15;

--
-- TOC entry 4329 (class 0 OID 0)
-- Dependencies: 283
-- Name: creditos_codcredito_seq; Type: SEQUENCE OWNED BY; Schema: kardex; Owner: phuyu15
--

ALTER SEQUENCE kardex.creditos_codcredito_seq OWNED BY kardex.creditos.codcredito;


--
-- TOC entry 284 (class 1259 OID 192305)
-- Name: creditosanulados; Type: TABLE; Schema: kardex; Owner: phuyu15
--

CREATE TABLE kardex.creditosanulados (
    codcredito integer NOT NULL,
    codsucursal integer NOT NULL,
    fechaanulacion date,
    codusuario integer,
    fecha date DEFAULT now(),
    hora time without time zone DEFAULT now(),
    observaciones character varying(100)
);


ALTER TABLE kardex.creditosanulados OWNER TO phuyu15;

--
-- TOC entry 285 (class 1259 OID 192310)
-- Name: cuotas; Type: TABLE; Schema: kardex; Owner: phuyu15
--

CREATE TABLE kardex.cuotas (
    codcredito integer NOT NULL,
    nrocuota integer NOT NULL,
    codsucursal integer NOT NULL,
    fechavence date DEFAULT now(),
    fechapago date DEFAULT now(),
    fecha date DEFAULT now(),
    importe numeric(18,4) DEFAULT 0,
    saldo numeric(18,4) DEFAULT 0,
    saldomora numeric(18,4) DEFAULT 0,
    interesmora numeric(18,4) DEFAULT 0,
    interes numeric(18,4) DEFAULT 0,
    total numeric(18,4) DEFAULT 0,
    estado integer DEFAULT 1
);


ALTER TABLE kardex.cuotas OWNER TO phuyu15;

--
-- TOC entry 286 (class 1259 OID 192323)
-- Name: cuotaspagos; Type: TABLE; Schema: kardex; Owner: phuyu15
--

CREATE TABLE kardex.cuotaspagos (
    codcredito integer NOT NULL,
    nrocuota integer NOT NULL,
    codsucursal integer NOT NULL,
    codmovimiento integer NOT NULL,
    codusuario integer,
    importe numeric(18,4) DEFAULT 0,
    saldocuota numeric(18,4) DEFAULT 0,
    fecha date DEFAULT now(),
    hora time without time zone DEFAULT now(),
    estado integer DEFAULT 1
);


ALTER TABLE kardex.cuotaspagos OWNER TO phuyu15;

--
-- TOC entry 287 (class 1259 OID 192331)
-- Name: kardex; Type: TABLE; Schema: kardex; Owner: phuyu15
--

CREATE TABLE kardex.kardex (
    codkardex integer NOT NULL,
    codkardex_ref integer,
    codsucursal integer,
    codalmacen integer,
    codalmacen_ref integer,
    codpersona integer,
    codusuario integer,
    codmovimientotipo integer,
    condicionpago integer DEFAULT 1,
    codcredito integer DEFAULT 0,
    codmoneda integer DEFAULT 1,
    tipocambio numeric(18,4) DEFAULT 1,
    codmotivonota integer DEFAULT 0,
    fecha date DEFAULT now(),
    hora time without time zone DEFAULT now(),
    fechakardex date DEFAULT now(),
    codcomprobantetipo integer DEFAULT 0,
    seriecomprobante character varying(4),
    nrocomprobante character varying(10),
    codcomprobantetipo_ref integer DEFAULT 0,
    seriecomprobante_ref character varying(4),
    nrocomprobante_ref character varying(10),
    valorventa numeric(18,4) DEFAULT 0,
    porcdescuento numeric(18,4) DEFAULT 0,
    descglobal numeric(18,4) DEFAULT 0,
    porcigv numeric(18,4) DEFAULT 0,
    igv numeric(18,4) DEFAULT 0,
    importe numeric(18,4) DEFAULT 0,
    retirar integer DEFAULT 0,
    flete numeric(18,4) DEFAULT 0,
    estiba numeric(18,4) DEFAULT 0,
    gastos numeric(18,4) DEFAULT 0,
    descripcion character varying(400),
    transferido integer DEFAULT 0,
    afectacaja integer DEFAULT 1,
    cliente character varying(255),
    direccion character varying(255),
    estado integer DEFAULT 1,
    nroplaca character varying(200),
    codempleado integer DEFAULT 0,
    fechacomprobante date DEFAULT now(),
    descuentos numeric(18,4) DEFAULT 0,
    codcentrocosto integer DEFAULT 0,
    icbper numeric(18,6) DEFAULT 0,
    isc numeric(18,4) DEFAULT 0,
    porcicbper numeric(18,4) DEFAULT 0,
    codguiar integer
);


ALTER TABLE kardex.kardex OWNER TO phuyu15;

--
-- TOC entry 4333 (class 0 OID 0)
-- Dependencies: 287
-- Name: COLUMN kardex.icbper; Type: COMMENT; Schema: kardex; Owner: phuyu15
--

COMMENT ON COLUMN kardex.kardex.icbper IS 'Guarda el importe del icbper';


--
-- TOC entry 288 (class 1259 OID 192367)
-- Name: kardex_codkardex_seq; Type: SEQUENCE; Schema: kardex; Owner: phuyu15
--

CREATE SEQUENCE kardex.kardex_codkardex_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE kardex.kardex_codkardex_seq OWNER TO phuyu15;

--
-- TOC entry 4335 (class 0 OID 0)
-- Dependencies: 288
-- Name: kardex_codkardex_seq; Type: SEQUENCE OWNED BY; Schema: kardex; Owner: phuyu15
--

ALTER SEQUENCE kardex.kardex_codkardex_seq OWNED BY kardex.kardex.codkardex;


--
-- TOC entry 289 (class 1259 OID 192369)
-- Name: kardexalmacen; Type: TABLE; Schema: kardex; Owner: phuyu15
--

CREATE TABLE kardex.kardexalmacen (
    codkardexalmacen integer NOT NULL,
    codsucursal integer,
    codalmacen integer,
    codalmacen_ref integer,
    codkardex integer,
    codusuario integer,
    codmovimientotipo integer,
    fechakardex date,
    movimiento integer DEFAULT 1,
    codcomprobantetipo integer,
    seriecomprobante character varying(4),
    nrocomprobante character varying(10),
    estado integer DEFAULT 1
);


ALTER TABLE kardex.kardexalmacen OWNER TO phuyu15;

--
-- TOC entry 290 (class 1259 OID 192374)
-- Name: kardexalmacen_codkardexalmacen_seq; Type: SEQUENCE; Schema: kardex; Owner: phuyu15
--

CREATE SEQUENCE kardex.kardexalmacen_codkardexalmacen_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE kardex.kardexalmacen_codkardexalmacen_seq OWNER TO phuyu15;

--
-- TOC entry 4337 (class 0 OID 0)
-- Dependencies: 290
-- Name: kardexalmacen_codkardexalmacen_seq; Type: SEQUENCE OWNED BY; Schema: kardex; Owner: phuyu15
--

ALTER SEQUENCE kardex.kardexalmacen_codkardexalmacen_seq OWNED BY kardex.kardexalmacen.codkardexalmacen;


--
-- TOC entry 291 (class 1259 OID 192376)
-- Name: kardexalmacenanulado; Type: TABLE; Schema: kardex; Owner: phuyu15
--

CREATE TABLE kardex.kardexalmacenanulado (
    codkardexalmacen integer NOT NULL,
    codsucursal integer NOT NULL,
    codusuario integer,
    fechaanulacion date,
    hora time without time zone DEFAULT now(),
    observaciones character varying(100)
);


ALTER TABLE kardex.kardexalmacenanulado OWNER TO phuyu15;

--
-- TOC entry 292 (class 1259 OID 192380)
-- Name: kardexalmacendetalle; Type: TABLE; Schema: kardex; Owner: phuyu15
--

CREATE TABLE kardex.kardexalmacendetalle (
    codkardexalmacen integer NOT NULL,
    codproducto integer NOT NULL,
    codunidad integer NOT NULL,
    codalmacen integer,
    item integer NOT NULL,
    codsucursal integer,
    cantidad numeric(18,4) DEFAULT 0,
    estado integer DEFAULT 1
);


ALTER TABLE kardex.kardexalmacendetalle OWNER TO phuyu15;

--
-- TOC entry 293 (class 1259 OID 192385)
-- Name: kardexanulados; Type: TABLE; Schema: kardex; Owner: phuyu15
--

CREATE TABLE kardex.kardexanulados (
    codkardex integer NOT NULL,
    codsucursal integer NOT NULL,
    codusuario integer,
    fechaanulacion date,
    fecha date DEFAULT now(),
    hora time without time zone DEFAULT now(),
    observaciones character varying(100)
);


ALTER TABLE kardex.kardexanulados OWNER TO phuyu15;

--
-- TOC entry 294 (class 1259 OID 192390)
-- Name: kardexdetalle; Type: TABLE; Schema: kardex; Owner: phuyu15
--

CREATE TABLE kardex.kardexdetalle (
    codkardex integer NOT NULL,
    codproducto integer NOT NULL,
    codunidad integer NOT NULL,
    item integer NOT NULL,
    cantidad numeric(18,4) DEFAULT 0,
    preciounitario numeric(18,6) DEFAULT 0,
    porcdescuento numeric(18,2) DEFAULT 0,
    descuento numeric(18,2) DEFAULT 0,
    subtotal numeric(18,4) DEFAULT 0,
    preciosinigv numeric(18,6) DEFAULT 0,
    preciorefunitario numeric(18,6) DEFAULT 0,
    igv numeric(18,4) DEFAULT 0,
    codafectacionigv character(2) DEFAULT 0,
    recoger integer DEFAULT 0,
    recogido numeric(18,4) DEFAULT 0,
    valorventa numeric(18,4) DEFAULT 0,
    descripcion text,
    estado integer DEFAULT 1,
    preciobruto numeric(18,6) DEFAULT 0,
    conicbper integer DEFAULT 0,
    icbper numeric(18,6) DEFAULT 0,
    cantidadguia numeric(18,4) DEFAULT 0,
    flete numeric(18,4) DEFAULT 0,
    estiba numeric(18,4) DEFAULT 0,
    gastos numeric(18,4) DEFAULT 0,
    preciocompra numeric(18,6) DEFAULT 0,
    preciocosto numeric(18,6) DEFAULT 0,
    registrosanitario character varying(12),
    fecharegistrosanitario date,
    fechavencimiento date,
    fechaproduccion date,
    loteproduccion character varying(12),
    stockkardex numeric(18,4) DEFAULT 0,
    codkardexdestino integer,
    stockkardexconvertido numeric(18,4) DEFAULT 0,
    itemdestino integer DEFAULT 0
);


ALTER TABLE kardex.kardexdetalle OWNER TO phuyu15;

--
-- TOC entry 295 (class 1259 OID 192421)
-- Name: kardexpedido; Type: TABLE; Schema: kardex; Owner: phuyu15
--

CREATE TABLE kardex.kardexpedido (
    codpedido integer NOT NULL,
    codproducto integer NOT NULL,
    itempedido integer NOT NULL,
    codkardex integer NOT NULL,
    itemkardex integer NOT NULL,
    codunidad integer DEFAULT 0 NOT NULL
);


ALTER TABLE kardex.kardexpedido OWNER TO phuyu15;

--
-- TOC entry 296 (class 1259 OID 192425)
-- Name: kardexproforma; Type: TABLE; Schema: kardex; Owner: phuyu15
--

CREATE TABLE kardex.kardexproforma (
    codproforma integer NOT NULL,
    codproducto integer NOT NULL,
    itemproforma integer NOT NULL,
    codkardex integer NOT NULL,
    itemkardex integer NOT NULL,
    codunidad integer DEFAULT 0 NOT NULL
);


ALTER TABLE kardex.kardexproforma OWNER TO phuyu15;

--
-- TOC entry 297 (class 1259 OID 192429)
-- Name: motivonotas; Type: TABLE; Schema: kardex; Owner: phuyu15
--

CREATE TABLE kardex.motivonotas (
    codmotivonota integer NOT NULL,
    descripcion character varying(100),
    oficial character varying(2) NOT NULL,
    tipo integer,
    estado integer DEFAULT 1
);


ALTER TABLE kardex.motivonotas OWNER TO phuyu15;

--
-- TOC entry 298 (class 1259 OID 192433)
-- Name: motivonotas_codmotivonota_seq; Type: SEQUENCE; Schema: kardex; Owner: phuyu15
--

CREATE SEQUENCE kardex.motivonotas_codmotivonota_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE kardex.motivonotas_codmotivonota_seq OWNER TO phuyu15;

--
-- TOC entry 4345 (class 0 OID 0)
-- Dependencies: 298
-- Name: motivonotas_codmotivonota_seq; Type: SEQUENCE OWNED BY; Schema: kardex; Owner: phuyu15
--

ALTER SEQUENCE kardex.motivonotas_codmotivonota_seq OWNED BY kardex.motivonotas.codmotivonota;


--
-- TOC entry 299 (class 1259 OID 192435)
-- Name: pedidos; Type: TABLE; Schema: kardex; Owner: phuyu15
--

CREATE TABLE kardex.pedidos (
    codpedido integer NOT NULL,
    codkardex integer,
    codsucursal integer,
    codalmacen integer,
    codpersona integer,
    codusuario integer,
    fecha date DEFAULT now(),
    hora time without time zone DEFAULT now(),
    fechapedido date DEFAULT now(),
    porcdescuento numeric(18,4) DEFAULT 0,
    porcigv numeric(18,4) DEFAULT 0,
    igv numeric(18,4) DEFAULT 0,
    importe numeric(18,4) DEFAULT 0,
    descripcion character varying(200),
    cliente character varying(255),
    direccion character varying(255),
    codempleado integer,
    estado integer DEFAULT 1,
    valorventa numeric(18,4) DEFAULT 0,
    descglobal numeric(18,4) DEFAULT 0,
    descuentos numeric(18,4) DEFAULT 0,
    tipopedido integer DEFAULT 0,
    afectastock integer DEFAULT 1,
    afectacaja integer DEFAULT 1,
    condicionpago integer,
    codcomprobantetiporeferencia integer,
    seriecomprobantereferencia character varying(4),
    nrocomprobantereferencia character varying(10),
    codcomprobantetipo integer,
    seriecomprobante character varying(4),
    nrocomprobante character varying(10),
    estadoproceso integer DEFAULT 0
);


ALTER TABLE kardex.pedidos OWNER TO phuyu15;

--
-- TOC entry 300 (class 1259 OID 192456)
-- Name: pedidos_codpedido_seq; Type: SEQUENCE; Schema: kardex; Owner: phuyu15
--

CREATE SEQUENCE kardex.pedidos_codpedido_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE kardex.pedidos_codpedido_seq OWNER TO phuyu15;

--
-- TOC entry 4347 (class 0 OID 0)
-- Dependencies: 300
-- Name: pedidos_codpedido_seq; Type: SEQUENCE OWNED BY; Schema: kardex; Owner: phuyu15
--

ALTER SEQUENCE kardex.pedidos_codpedido_seq OWNED BY kardex.pedidos.codpedido;


--
-- TOC entry 301 (class 1259 OID 192458)
-- Name: pedidosdetalle; Type: TABLE; Schema: kardex; Owner: phuyu15
--

CREATE TABLE kardex.pedidosdetalle (
    codpedido integer NOT NULL,
    codproducto integer NOT NULL,
    codunidad integer NOT NULL,
    item integer NOT NULL,
    cantidad numeric(18,4) DEFAULT 0,
    preciounitario numeric(18,6) DEFAULT 0,
    porcdescuento numeric(18,2) DEFAULT 0,
    descuento numeric(18,2) DEFAULT 0,
    subtotal numeric(18,4) DEFAULT 0,
    preciorefunitario numeric(18,6) DEFAULT 0,
    igv numeric(18,4) DEFAULT 0,
    codafectacionigv character(2) DEFAULT 0,
    descripcion text,
    estado integer DEFAULT 1,
    preciobruto numeric(18,6) DEFAULT 0,
    preciosinigv numeric(18,6) DEFAULT 0,
    valorventa numeric(18,4) DEFAULT 0,
    fecha date DEFAULT now(),
    hora time(6) without time zone DEFAULT now(),
    atencion integer DEFAULT 1,
    cantidaddespachada numeric(18,4) DEFAULT 0,
    cantidadcomprobante numeric(18,4) DEFAULT 0,
    conicbper integer DEFAULT 0,
    icbper numeric(18,6) DEFAULT 0
);


ALTER TABLE kardex.pedidosdetalle OWNER TO phuyu15;

--
-- TOC entry 302 (class 1259 OID 192483)
-- Name: proformas; Type: TABLE; Schema: kardex; Owner: phuyu15
--

CREATE TABLE kardex.proformas (
    codproforma integer NOT NULL,
    codkardex integer,
    codsucursal integer,
    codalmacen integer,
    codpersona integer,
    codusuario integer,
    fecha date DEFAULT now(),
    hora time without time zone DEFAULT now(),
    fechaproforma date DEFAULT now(),
    porcdescuento numeric(18,4) DEFAULT 0,
    porcigv numeric(18,4) DEFAULT 0,
    igv numeric(18,4) DEFAULT 0,
    importe numeric(18,4) DEFAULT 0,
    descripcion character varying(200),
    razonsocial character varying(255),
    direccion character varying(255),
    codempleado integer,
    estado integer DEFAULT 1,
    codcomprobante integer,
    valorventa numeric(18,4) DEFAULT 0,
    descglobal numeric(18,4) DEFAULT 0,
    descuentos numeric(18,4) DEFAULT 0,
    tipoproforma integer DEFAULT 0,
    afectastock integer DEFAULT 1,
    afectacaja integer DEFAULT 1,
    codcomprobantetipo integer,
    seriecomprobante character varying(4),
    nrocomprobante character varying(10),
    condicionpago integer,
    estadoproceso integer DEFAULT 0
);


ALTER TABLE kardex.proformas OWNER TO phuyu15;

--
-- TOC entry 303 (class 1259 OID 192504)
-- Name: proformas_codproforma_seq; Type: SEQUENCE; Schema: kardex; Owner: phuyu15
--

CREATE SEQUENCE kardex.proformas_codproforma_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE kardex.proformas_codproforma_seq OWNER TO phuyu15;

--
-- TOC entry 4350 (class 0 OID 0)
-- Dependencies: 303
-- Name: proformas_codproforma_seq; Type: SEQUENCE OWNED BY; Schema: kardex; Owner: phuyu15
--

ALTER SEQUENCE kardex.proformas_codproforma_seq OWNED BY kardex.proformas.codproforma;


--
-- TOC entry 304 (class 1259 OID 192506)
-- Name: proformasdetalle; Type: TABLE; Schema: kardex; Owner: phuyu15
--

CREATE TABLE kardex.proformasdetalle (
    codproforma integer NOT NULL,
    codproducto integer NOT NULL,
    codunidad integer NOT NULL,
    item integer NOT NULL,
    cantidad numeric(18,4) DEFAULT 0,
    preciounitario numeric(18,6) DEFAULT 0,
    porcdescuento numeric(18,2) DEFAULT 0,
    descuento numeric(18,2) DEFAULT 0,
    subtotal numeric(18,4) DEFAULT 0,
    preciorefunitario numeric(18,6) DEFAULT 0,
    igv numeric(18,4) DEFAULT 0,
    codafectacionigv character(2) DEFAULT 0,
    descripcion text,
    estado integer DEFAULT 1,
    preciobruto numeric(18,6) DEFAULT 0,
    preciosinigv numeric(18,6) DEFAULT 0,
    valorventa numeric(18,4) DEFAULT 0,
    fecha date DEFAULT now(),
    hora time(6) without time zone DEFAULT now(),
    atencion integer DEFAULT 1,
    cantidaddespachada numeric(18,4) DEFAULT 0,
    cantidadcomprobante numeric(18,4) DEFAULT 0,
    conicbper integer DEFAULT 0,
    icbper numeric(18,6) DEFAULT 0
);


ALTER TABLE kardex.proformasdetalle OWNER TO phuyu15;

--
-- TOC entry 305 (class 1259 OID 192531)
-- Name: v_kardexdetalle; Type: VIEW; Schema: kardex; Owner: phuyu15
--

CREATE VIEW kardex.v_kardexdetalle AS
 SELECT k.codkardex,
    k.codkardex_ref,
    k.codsucursal,
    k.codalmacen,
    k.codalmacen_ref,
    k.codpersona,
    k.codusuario,
    k.codmovimientotipo,
    k.condicionpago,
    k.codcredito,
    k.codmoneda,
    k.tipocambio,
    k.codmotivonota,
    k.codempleado,
    k.fecha,
    k.hora,
    k.fechakardex,
    k.fechacomprobante,
    k.codcomprobantetipo,
    k.seriecomprobante,
    k.nrocomprobante,
    k.codcomprobantetipo_ref,
    k.seriecomprobante_ref,
    k.nrocomprobante_ref,
    k.valorventa AS valorventak,
    k.porcdescuento AS porcdescuentok,
    k.descglobal,
    k.descuentos,
    k.porcigv,
    k.igv AS igvtotal,
    k.importe,
    k.retirar,
    k.flete,
    k.estiba,
    k.gastos,
    k.descripcion AS descripcionk,
    k.transferido,
    k.afectacaja,
    k.cliente,
    k.direccion,
    k.nroplaca,
    k.codcentrocosto,
    k.estado AS estadok,
    k.isc,
    k.porcicbper,
    k.icbper AS icbperk,
    kd.codproducto,
    kd.codunidad,
    kd.item,
    kd.cantidad,
    kd.preciobruto,
    kd.porcdescuento,
    kd.descuento,
    kd.preciosinigv,
    kd.preciounitario,
    kd.preciorefunitario,
    kd.codafectacionigv,
    kd.igv,
    kd.valorventa,
    kd.subtotal,
    kd.descripcion,
    kd.recoger,
    kd.recogido,
    kd.estado,
    kd.conicbper,
    kd.icbper
   FROM (kardex.kardex k
     JOIN kardex.kardexdetalle kd ON ((k.codkardex = kd.codkardex)))
  ORDER BY k.fechakardex, k.hora;


ALTER TABLE kardex.v_kardexdetalle OWNER TO phuyu15;

--
-- TOC entry 306 (class 1259 OID 192536)
-- Name: v_kardexdetalle_mt; Type: VIEW; Schema: kardex; Owner: phuyu15
--

CREATE VIEW kardex.v_kardexdetalle_mt AS
 SELECT k.codkardex,
    k.codkardex_ref,
    k.codsucursal,
    k.codalmacen,
    k.codalmacen_ref,
    k.codpersona,
    k.codusuario,
    k.codmovimientotipo,
    k.condicionpago,
    k.codcredito,
    k.codmoneda,
    k.tipocambio,
    k.codmotivonota,
    k.codempleado,
    k.fecha,
    k.hora,
    k.fechakardex,
    k.fechacomprobante,
    k.codcomprobantetipo,
    k.seriecomprobante,
    k.nrocomprobante,
    k.codcomprobantetipo_ref,
    k.seriecomprobante_ref,
    k.nrocomprobante_ref,
    k.valorventa AS valorventak,
    k.porcdescuento AS porcdescuentok,
    k.descglobal,
    k.descuentos,
    k.porcigv,
    k.igv AS igvtotal,
    k.importe,
    k.retirar,
    k.flete,
    k.estiba,
    k.gastos,
    k.descripcion AS descripcionk,
    k.transferido,
    k.afectacaja,
    k.cliente,
    k.direccion,
    k.nroplaca,
    k.codcentrocosto,
    k.estado AS estadok,
    k.isc,
    k.porcicbper,
    k.icbper AS icbperk,
    mt.tipo,
        CASE
            WHEN (mt.tipo = 1) THEN 1
            ELSE '-1'::integer
        END AS signo,
    mt.descripcion AS descripcionmt,
    kd.codproducto,
    kd.codunidad,
    kd.item,
    kd.cantidad,
    kd.preciobruto,
    kd.porcdescuento,
    kd.descuento,
    kd.preciosinigv,
    kd.preciounitario,
    kd.preciorefunitario,
    kd.codafectacionigv,
    kd.igv,
    kd.valorventa,
    kd.subtotal,
    kd.descripcion,
    kd.recoger,
    kd.recogido,
    kd.estado,
    kd.conicbper,
    kd.icbper
   FROM ((kardex.kardex k
     JOIN kardex.kardexdetalle kd ON ((k.codkardex = kd.codkardex)))
     JOIN almacen.movimientotipos mt ON ((k.codmovimientotipo = mt.codmovimientotipo)))
  ORDER BY k.fechakardex, k.hora;


ALTER TABLE kardex.v_kardexdetalle_mt OWNER TO phuyu15;

--
-- TOC entry 307 (class 1259 OID 192541)
-- Name: v_kardexdetalle_p; Type: VIEW; Schema: kardex; Owner: phuyu15
--

CREATE VIEW kardex.v_kardexdetalle_p AS
 SELECT k.codkardex,
    k.codkardex_ref,
    k.codsucursal,
    k.codalmacen,
    k.codalmacen_ref,
    k.codpersona,
    k.codusuario,
    k.codmovimientotipo,
    k.condicionpago,
    k.codcredito,
    k.codmoneda,
    k.tipocambio,
    k.codmotivonota,
    k.codempleado,
    k.fecha,
    k.hora,
    k.fechakardex,
    k.fechacomprobante,
    k.codcomprobantetipo,
    k.seriecomprobante,
    k.nrocomprobante,
    k.codcomprobantetipo_ref,
    k.seriecomprobante_ref,
    k.nrocomprobante_ref,
    k.valorventa AS valorventak,
    k.porcdescuento AS porcdescuentok,
    k.descglobal,
    k.descuentos,
    k.porcigv,
    k.igv AS igvtotal,
    k.importe,
    k.retirar,
    k.flete,
    k.estiba,
    k.gastos,
    k.descripcion AS descripcionk,
    k.transferido,
    k.afectacaja,
    k.cliente,
    k.direccion,
    k.nroplaca,
    k.codcentrocosto,
    k.estado AS estadok,
    k.isc,
    k.porcicbper,
    k.icbper AS icbperk,
    kd.codproducto,
    kd.codunidad,
    kd.item,
    kd.cantidad,
    kd.preciobruto,
    kd.porcdescuento,
    kd.descuento,
    kd.preciosinigv,
    kd.preciounitario,
    kd.preciorefunitario,
    kd.codafectacionigv,
    kd.igv,
    kd.valorventa,
    kd.subtotal,
    kd.descripcion AS descripcionkd,
    kd.recoger,
    kd.recogido,
    kd.estado,
    kd.conicbper,
    kd.icbper,
    p.codfamilia,
    p.codlinea,
    p.codmarca,
    p.codigo,
    p.descripcion AS descripcionp,
    p.estado AS estadop,
    p.caracteristicas
   FROM ((kardex.kardex k
     JOIN kardex.kardexdetalle kd ON ((k.codkardex = kd.codkardex)))
     JOIN almacen.productos p ON ((kd.codproducto = p.codproducto)));


ALTER TABLE kardex.v_kardexdetalle_p OWNER TO phuyu15;

--
-- TOC entry 308 (class 1259 OID 192546)
-- Name: documentotipos; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.documentotipos (
    coddocumentotipo integer NOT NULL,
    descripcion character varying(100),
    oficial character varying(2) NOT NULL,
    estado integer DEFAULT 1
);


ALTER TABLE public.documentotipos OWNER TO postgres;

--
-- TOC entry 309 (class 1259 OID 192550)
-- Name: personas; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.personas (
    codpersona integer NOT NULL,
    codubigeo integer DEFAULT 0,
    coddocumentotipo integer,
    tipopersona integer DEFAULT 1,
    documento character varying(20),
    razonsocial character varying(100),
    nombrecomercial character varying(100),
    direccion character varying(200),
    telefono character varying(100),
    fechanacimiento date,
    email character varying(100),
    sexo character varying(1),
    foto character varying(255) DEFAULT 'default.png'::character varying,
    estado integer DEFAULT 1,
    codsucursal integer
);


ALTER TABLE public.personas OWNER TO postgres;

--
-- TOC entry 310 (class 1259 OID 192560)
-- Name: v_kardexdetalle_pper; Type: VIEW; Schema: kardex; Owner: phuyu15
--

CREATE VIEW kardex.v_kardexdetalle_pper AS
 SELECT k.codkardex,
    k.codkardex_ref,
    k.codsucursal,
    k.codalmacen,
    k.codalmacen_ref,
    k.codpersona,
    k.codusuario,
    k.codmovimientotipo,
    k.condicionpago,
    k.codcredito,
    k.codmoneda,
    k.tipocambio,
    k.codmotivonota,
    k.codempleado,
    k.fecha,
    k.hora,
    k.fechakardex,
    k.fechacomprobante,
    k.codcomprobantetipo,
    k.seriecomprobante,
    k.nrocomprobante,
    k.codcomprobantetipo_ref,
    k.seriecomprobante_ref,
    k.nrocomprobante_ref,
    k.valorventa AS valorventak,
    k.porcdescuento AS porcdescuentok,
    k.descglobal,
    k.descuentos,
    k.porcigv,
    k.igv AS igvtotal,
    k.importe,
    k.retirar,
    k.flete,
    k.estiba,
    k.gastos,
    k.descripcion AS descripcionk,
    k.transferido,
    k.afectacaja,
    k.cliente,
    k.direccion,
    k.nroplaca,
    k.codcentrocosto,
    k.estado AS estadok,
    k.isc,
    k.porcicbper,
    k.icbper AS icbperk,
    kd.codproducto,
    kd.codunidad,
    kd.item,
    kd.cantidad,
    kd.preciobruto,
    kd.porcdescuento,
    kd.descuento,
    kd.preciosinigv,
    kd.preciounitario,
    kd.preciorefunitario,
    kd.codafectacionigv,
    kd.igv,
    kd.valorventa,
    kd.subtotal,
    kd.descripcion AS descripcionkd,
    kd.recoger,
    kd.recogido,
    kd.estado,
    kd.conicbper,
    kd.icbper,
    p.codfamilia,
    p.codlinea,
    p.codmarca,
    p.codigo,
    p.descripcion AS descripcionp,
    p.estado AS estadop,
    p.caracteristicas,
    per.coddocumentotipo,
    dt.descripcion AS descripciondt,
    per.documento,
    per.razonsocial
   FROM ((((kardex.kardex k
     JOIN kardex.kardexdetalle kd ON ((k.codkardex = kd.codkardex)))
     JOIN almacen.productos p ON ((kd.codproducto = p.codproducto)))
     JOIN public.personas per ON ((k.codpersona = per.codpersona)))
     JOIN public.documentotipos dt ON ((per.coddocumentotipo = dt.coddocumentotipo)));


ALTER TABLE kardex.v_kardexdetalle_pper OWNER TO phuyu15;

--
-- TOC entry 311 (class 1259 OID 192565)
-- Name: v_productofechavencimiento; Type: VIEW; Schema: kardex; Owner: phuyu15
--

CREATE VIEW kardex.v_productofechavencimiento AS
 SELECT k.codkardex,
    k.codsucursal,
    k.codalmacen,
    k.estado,
    kd.fechaproduccion,
    kd.fechavencimiento,
    kd.loteproduccion,
    kd.codproducto,
    kd.codunidad,
    kd.item,
    u.descripcion AS unidad,
    sum(round(kd.stockkardex, 2)) AS stockkardex,
    sum(kd.stockkardexconvertido) AS stockkardexconvertido
   FROM (((kardex.kardex k
     JOIN almacen.movimientotipos mt ON (((k.codmovimientotipo = mt.codmovimientotipo) AND (mt.tipo = 1))))
     JOIN kardex.kardexdetalle kd ON (((k.codkardex = kd.codkardex) AND (kd.fechavencimiento IS NOT NULL))))
     JOIN almacen.unidades u ON ((kd.codunidad = u.codunidad)))
  GROUP BY k.codkardex, k.codsucursal, k.codalmacen, kd.fechavencimiento, kd.fechaproduccion, kd.loteproduccion, kd.codproducto, kd.codunidad, kd.item, u.descripcion, k.estado;


ALTER TABLE kardex.v_productofechavencimiento OWNER TO phuyu15;

--
-- TOC entry 312 (class 1259 OID 192570)
-- Name: areas; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.areas (
    codarea integer NOT NULL,
    descripcion character varying(100),
    estado integer DEFAULT 1
);


ALTER TABLE public.areas OWNER TO postgres;

--
-- TOC entry 313 (class 1259 OID 192574)
-- Name: areas_codarea_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.areas_codarea_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.areas_codarea_seq OWNER TO postgres;

--
-- TOC entry 4352 (class 0 OID 0)
-- Dependencies: 313
-- Name: areas_codarea_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.areas_codarea_seq OWNED BY public.areas.codarea;


--
-- TOC entry 314 (class 1259 OID 192576)
-- Name: asistencias; Type: TABLE; Schema: public; Owner: phuyu15
--

CREATE TABLE public.asistencias (
    codempleado integer NOT NULL,
    fecha date NOT NULL,
    turno character varying(255) NOT NULL,
    tipo character varying(255) NOT NULL,
    observacion text,
    hora time(0) without time zone NOT NULL,
    codasistencia integer NOT NULL,
    estado integer
);


ALTER TABLE public.asistencias OWNER TO phuyu15;

--
-- TOC entry 315 (class 1259 OID 192582)
-- Name: cargos; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.cargos (
    codcargo integer NOT NULL,
    descripcion character varying(100),
    estado integer DEFAULT 1
);


ALTER TABLE public.cargos OWNER TO postgres;

--
-- TOC entry 316 (class 1259 OID 192586)
-- Name: cargos_codcargo_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.cargos_codcargo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.cargos_codcargo_seq OWNER TO postgres;

--
-- TOC entry 4353 (class 0 OID 0)
-- Dependencies: 316
-- Name: cargos_codcargo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.cargos_codcargo_seq OWNED BY public.cargos.codcargo;


--
-- TOC entry 317 (class 1259 OID 192588)
-- Name: documentotipos_coddocumentotipo_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.documentotipos_coddocumentotipo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.documentotipos_coddocumentotipo_seq OWNER TO postgres;

--
-- TOC entry 4354 (class 0 OID 0)
-- Dependencies: 317
-- Name: documentotipos_coddocumentotipo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.documentotipos_coddocumentotipo_seq OWNED BY public.documentotipos.coddocumentotipo;


--
-- TOC entry 318 (class 1259 OID 192590)
-- Name: empleados; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.empleados (
    codpersona integer NOT NULL,
    codarea integer,
    codcargo integer,
    codsucursal integer,
    tipoempleado integer DEFAULT 1,
    sueldotipo integer DEFAULT 1,
    sueldo numeric(18,2) DEFAULT 0,
    estado integer DEFAULT 1,
    sueldohora numeric(18,2) DEFAULT 0
);


ALTER TABLE public.empleados OWNER TO postgres;

--
-- TOC entry 319 (class 1259 OID 192598)
-- Name: empresas; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.empresas (
    codempresa integer NOT NULL,
    codpersona integer NOT NULL,
    igvsunat numeric(18,2) DEFAULT 18,
    icbpersunat numeric(18,2) DEFAULT 0.1,
    iscsunat numeric(18,2) DEFAULT 1,
    extrasunat numeric(18,2) DEFAULT 0,
    facturacion integer DEFAULT 0,
    slogan character varying(255),
    rubro integer DEFAULT 0,
    copiaseguridad character varying(100),
    logoauspiciador character varying(255) DEFAULT 'default.png'::character varying,
    claveseguridad character varying(100),
    itemrepetircomprobante integer DEFAULT 0,
    ubigeo character varying(6),
    departamento character varying(50),
    provincia character varying(50),
    distrito character varying(50),
    publicidad character varying(255),
    agradecimiento character varying(60),
    controlstocktipo integer DEFAULT 1,
    linkdescargacomprobantes character varying(150)
);


ALTER TABLE public.empresas OWNER TO postgres;

--
-- TOC entry 4355 (class 0 OID 0)
-- Dependencies: 319
-- Name: COLUMN empresas.controlstocktipo; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.empresas.controlstocktipo IS '1: stockactual

2: stockactualconvertido ';


--
-- TOC entry 320 (class 1259 OID 192613)
-- Name: empresas_codempresa_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.empresas_codempresa_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.empresas_codempresa_seq OWNER TO postgres;

--
-- TOC entry 4356 (class 0 OID 0)
-- Dependencies: 320
-- Name: empresas_codempresa_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.empresas_codempresa_seq OWNED BY public.empresas.codempresa;


--
-- TOC entry 321 (class 1259 OID 192615)
-- Name: personas_codpersona_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.personas_codpersona_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.personas_codpersona_seq OWNER TO postgres;

--
-- TOC entry 4357 (class 0 OID 0)
-- Dependencies: 321
-- Name: personas_codpersona_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.personas_codpersona_seq OWNED BY public.personas.codpersona;


--
-- TOC entry 322 (class 1259 OID 192617)
-- Name: rubros; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.rubros (
    codrubro integer NOT NULL,
    descripcion character varying(100),
    estado integer DEFAULT 1,
    concaducidad integer DEFAULT 0,
    controlstock integer DEFAULT 1
);


ALTER TABLE public.rubros OWNER TO postgres;

--
-- TOC entry 4358 (class 0 OID 0)
-- Dependencies: 322
-- Name: COLUMN rubros.concaducidad; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.rubros.concaducidad IS '0: No tiene caducidad

1: Si tiene caducidad';


--
-- TOC entry 323 (class 1259 OID 192623)
-- Name: rubros_codrubro_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.rubros_codrubro_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.rubros_codrubro_seq OWNER TO postgres;

--
-- TOC entry 4359 (class 0 OID 0)
-- Dependencies: 323
-- Name: rubros_codrubro_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.rubros_codrubro_seq OWNED BY public.rubros.codrubro;


--
-- TOC entry 324 (class 1259 OID 192625)
-- Name: socios; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.socios (
    codpersona integer NOT NULL,
    codsociotipo integer,
    usuario character varying(100),
    clave character varying(100),
    estado integer DEFAULT 1,
    codpatrocinador integer DEFAULT 0,
    licenciadeconducir character varying(50),
    conductor integer DEFAULT 0
);


ALTER TABLE public.socios OWNER TO postgres;

--
-- TOC entry 325 (class 1259 OID 192631)
-- Name: sociotipos; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sociotipos (
    codsociotipo integer NOT NULL,
    descripcion character varying(100),
    estado integer DEFAULT 1
);


ALTER TABLE public.sociotipos OWNER TO postgres;

--
-- TOC entry 326 (class 1259 OID 192635)
-- Name: sociotipos_codsociotipo_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.sociotipos_codsociotipo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sociotipos_codsociotipo_seq OWNER TO postgres;

--
-- TOC entry 4360 (class 0 OID 0)
-- Dependencies: 326
-- Name: sociotipos_codsociotipo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.sociotipos_codsociotipo_seq OWNED BY public.sociotipos.codsociotipo;


--
-- TOC entry 327 (class 1259 OID 192637)
-- Name: sucursales; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sucursales (
    codsucursal integer NOT NULL,
    codempresa integer NOT NULL,
    descripcion character varying(100),
    direccion character varying(255),
    telefonos character varying(50),
    codcomprobantetipo integer DEFAULT 0,
    seriecomprobante character varying(4),
    estado integer DEFAULT 1,
    principal integer DEFAULT 1,
    codubigeo integer,
    envioautomaticofe integer DEFAULT 0,
    envioautomaticobve integer DEFAULT 0,
    envioautomaticogre integer DEFAULT 0,
    coddespachotipo character(20)
);


ALTER TABLE public.sucursales OWNER TO postgres;

--
-- TOC entry 328 (class 1259 OID 192646)
-- Name: sucursales_codsucursal_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.sucursales_codsucursal_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sucursales_codsucursal_seq OWNER TO postgres;

--
-- TOC entry 4361 (class 0 OID 0)
-- Dependencies: 328
-- Name: sucursales_codsucursal_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.sucursales_codsucursal_seq OWNED BY public.sucursales.codsucursal;


--
-- TOC entry 329 (class 1259 OID 192648)
-- Name: ubigeo; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.ubigeo (
    codubigeo integer NOT NULL,
    ubidepartamento character(2),
    ubiprovincia character(2),
    ubidistrito character(2),
    departamento character varying(100),
    provincia character varying(100),
    distrito character varying(100)
);


ALTER TABLE public.ubigeo OWNER TO postgres;

--
-- TOC entry 330 (class 1259 OID 192651)
-- Name: ubigeo_codubigeo_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.ubigeo_codubigeo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.ubigeo_codubigeo_seq OWNER TO postgres;

--
-- TOC entry 4362 (class 0 OID 0)
-- Dependencies: 330
-- Name: ubigeo_codubigeo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.ubigeo_codubigeo_seq OWNED BY public.ubigeo.codubigeo;


--
-- TOC entry 331 (class 1259 OID 192653)
-- Name: webservice; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.webservice (
    codempresa integer NOT NULL,
    usuariosol character varying(100),
    clavesol character varying(100),
    envioemail character varying(100),
    claveemail character varying(100),
    certificado_pfx character varying(100),
    certificado_clave character varying(100),
    sunatose integer DEFAULT 0,
    serviceweb integer DEFAULT 1,
    servicesunat character varying(100),
    servicesunat_demo character varying(100),
    serviceose character varying(100),
    serviceose_demo character varying(100),
    servicesunatguia character varying(100),
    servicesunatguia_demo character varying(100),
    serviceoseguia character varying(100),
    serviceoseguia_demo character varying(100),
    servicesunatretencion character varying(100),
    servicesunatretencion_demo character varying(100),
    serviceoseretencion character varying(100),
    serviceoseretencion_demo character varying(100)
);


ALTER TABLE public.webservice OWNER TO postgres;

--
-- TOC entry 332 (class 1259 OID 192661)
-- Name: moduloperfiles; Type: TABLE; Schema: seguridad; Owner: phuyu15
--

CREATE TABLE seguridad.moduloperfiles (
    codmodulo integer NOT NULL,
    codperfil integer NOT NULL
);


ALTER TABLE seguridad.moduloperfiles OWNER TO phuyu15;

--
-- TOC entry 333 (class 1259 OID 192664)
-- Name: modulos; Type: TABLE; Schema: seguridad; Owner: phuyu15
--

CREATE TABLE seguridad.modulos (
    codmodulo integer NOT NULL,
    descripcion character varying(100),
    icono character varying(50),
    url character varying(50),
    codpadre integer,
    orden integer,
    estado integer DEFAULT 1
);


ALTER TABLE seguridad.modulos OWNER TO phuyu15;

--
-- TOC entry 334 (class 1259 OID 192668)
-- Name: modulos_codmodulo_seq; Type: SEQUENCE; Schema: seguridad; Owner: phuyu15
--

CREATE SEQUENCE seguridad.modulos_codmodulo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE seguridad.modulos_codmodulo_seq OWNER TO phuyu15;

--
-- TOC entry 4365 (class 0 OID 0)
-- Dependencies: 334
-- Name: modulos_codmodulo_seq; Type: SEQUENCE OWNED BY; Schema: seguridad; Owner: phuyu15
--

ALTER SEQUENCE seguridad.modulos_codmodulo_seq OWNED BY seguridad.modulos.codmodulo;


--
-- TOC entry 335 (class 1259 OID 192670)
-- Name: perfiles; Type: TABLE; Schema: seguridad; Owner: phuyu15
--

CREATE TABLE seguridad.perfiles (
    codperfil integer NOT NULL,
    descripcion character varying(100),
    estado integer DEFAULT 1
);


ALTER TABLE seguridad.perfiles OWNER TO phuyu15;

--
-- TOC entry 336 (class 1259 OID 192674)
-- Name: perfiles_codperfil_seq; Type: SEQUENCE; Schema: seguridad; Owner: phuyu15
--

CREATE SEQUENCE seguridad.perfiles_codperfil_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE seguridad.perfiles_codperfil_seq OWNER TO phuyu15;

--
-- TOC entry 4367 (class 0 OID 0)
-- Dependencies: 336
-- Name: perfiles_codperfil_seq; Type: SEQUENCE OWNED BY; Schema: seguridad; Owner: phuyu15
--

ALTER SEQUENCE seguridad.perfiles_codperfil_seq OWNED BY seguridad.perfiles.codperfil;


--
-- TOC entry 337 (class 1259 OID 192676)
-- Name: sucursalusuarios; Type: TABLE; Schema: seguridad; Owner: phuyu15
--

CREATE TABLE seguridad.sucursalusuarios (
    codsucursal integer NOT NULL,
    codusuario integer NOT NULL
);


ALTER TABLE seguridad.sucursalusuarios OWNER TO phuyu15;

--
-- TOC entry 338 (class 1259 OID 192679)
-- Name: usuarios; Type: TABLE; Schema: seguridad; Owner: phuyu15
--

CREATE TABLE seguridad.usuarios (
    codusuario integer NOT NULL,
    codempleado integer,
    codperfil integer NOT NULL,
    fecha date DEFAULT now(),
    usuario character varying(50),
    clave character varying(50),
    estado integer DEFAULT 1,
    editar_pventa integer DEFAULT 1
);


ALTER TABLE seguridad.usuarios OWNER TO phuyu15;

--
-- TOC entry 339 (class 1259 OID 192685)
-- Name: usuarios_codusuario_seq; Type: SEQUENCE; Schema: seguridad; Owner: phuyu15
--

CREATE SEQUENCE seguridad.usuarios_codusuario_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE seguridad.usuarios_codusuario_seq OWNER TO phuyu15;

--
-- TOC entry 4370 (class 0 OID 0)
-- Dependencies: 339
-- Name: usuarios_codusuario_seq; Type: SEQUENCE OWNED BY; Schema: seguridad; Owner: phuyu15
--

ALTER SEQUENCE seguridad.usuarios_codusuario_seq OWNED BY seguridad.usuarios.codusuario;


--
-- TOC entry 340 (class 1259 OID 192687)
-- Name: guiasunat; Type: TABLE; Schema: sunat; Owner: phuyu15
--

CREATE TABLE sunat.guiasunat (
    codguiar integer NOT NULL,
    codsucursal integer,
    codusuario integer,
    nombre_xml character varying(200),
    fecha timestamp without time zone DEFAULT now(),
    fechacreado date,
    fechaenvio date,
    codigorespuesta character varying(5),
    ruta_cdr character varying(100),
    descripcion_cdr character varying(500),
    estado integer DEFAULT 0
);


ALTER TABLE sunat.guiasunat OWNER TO phuyu15;

--
-- TOC entry 341 (class 1259 OID 192695)
-- Name: kardexsunat; Type: TABLE; Schema: sunat; Owner: phuyu15
--

CREATE TABLE sunat.kardexsunat (
    codkardex integer NOT NULL,
    codsucursal integer,
    codusuario integer,
    nombre_xml character varying(200),
    fecha timestamp without time zone DEFAULT now(),
    fechacreado date,
    fechaenvio date,
    codigorespuesta character varying(5),
    ruta_cdr character varying(100),
    descripcion_cdr character varying(500),
    estado integer DEFAULT 0
);


ALTER TABLE sunat.kardexsunat OWNER TO phuyu15;

--
-- TOC entry 342 (class 1259 OID 192703)
-- Name: kardexsunatanulados; Type: TABLE; Schema: sunat; Owner: phuyu15
--

CREATE TABLE sunat.kardexsunatanulados (
    codkardex integer NOT NULL,
    codresumentipo integer NOT NULL,
    nrocorrelativo integer NOT NULL,
    periodo character(8) NOT NULL,
    codempresa integer NOT NULL,
    codsucursal integer,
    fechaanulacion date,
    fechareferencia date,
    fecha date DEFAULT now(),
    hora time without time zone DEFAULT now(),
    motivobaja character varying(100),
    observaciones character varying(100),
    tipooperacion integer DEFAULT 0,
    estado integer DEFAULT 0
);


ALTER TABLE sunat.kardexsunatanulados OWNER TO phuyu15;

--
-- TOC entry 343 (class 1259 OID 192710)
-- Name: kardexsunatdetalle; Type: TABLE; Schema: sunat; Owner: phuyu15
--

CREATE TABLE sunat.kardexsunatdetalle (
    codkardex integer NOT NULL,
    codresumentipo integer NOT NULL,
    nrocorrelativo integer NOT NULL,
    periodo character(8) NOT NULL,
    codempresa integer NOT NULL,
    fecharesumen date,
    fechaenvio date,
    descripcion_cdr character varying(500),
    estado integer DEFAULT 0
);


ALTER TABLE sunat.kardexsunatdetalle OWNER TO phuyu15;

--
-- TOC entry 344 (class 1259 OID 192717)
-- Name: resumenes; Type: TABLE; Schema: sunat; Owner: phuyu15
--

CREATE TABLE sunat.resumenes (
    codresumentipo integer NOT NULL,
    nrocorrelativo integer NOT NULL,
    periodo character(8) NOT NULL,
    codempresa integer NOT NULL,
    codsucursal integer,
    codusuario integer,
    nombre_xml character varying(200),
    fecha timestamp without time zone DEFAULT now(),
    fecharesumen date,
    fechaenvio date,
    codigorespuesta character varying(5),
    ticket character varying(50),
    ruta_cdr character varying(100),
    descripcion_cdr character varying(500),
    estado integer DEFAULT 0
);


ALTER TABLE sunat.resumenes OWNER TO phuyu15;

--
-- TOC entry 345 (class 1259 OID 192725)
-- Name: resumentipos; Type: TABLE; Schema: sunat; Owner: phuyu15
--

CREATE TABLE sunat.resumentipos (
    codresumentipo integer NOT NULL,
    descripcion character varying(100),
    oficial character varying(2) NOT NULL,
    estado integer DEFAULT 1
);


ALTER TABLE sunat.resumentipos OWNER TO phuyu15;

--
-- TOC entry 346 (class 1259 OID 192729)
-- Name: resumentipos_codresumentipo_seq; Type: SEQUENCE; Schema: sunat; Owner: phuyu15
--

CREATE SEQUENCE sunat.resumentipos_codresumentipo_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE sunat.resumentipos_codresumentipo_seq OWNER TO phuyu15;

--
-- TOC entry 4377 (class 0 OID 0)
-- Dependencies: 346
-- Name: resumentipos_codresumentipo_seq; Type: SEQUENCE OWNED BY; Schema: sunat; Owner: phuyu15
--

ALTER SEQUENCE sunat.resumentipos_codresumentipo_seq OWNED BY sunat.resumentipos.codresumentipo;


--
-- TOC entry 347 (class 1259 OID 192731)
-- Name: det_traslado; Type: TABLE; Schema: ventas; Owner: phuyu15
--

CREATE TABLE ventas.det_traslado (
    id integer NOT NULL,
    producto_id integer,
    cantidad numeric(18,2),
    almacen_id integer,
    precio numeric(18,2),
    unidad_medida_id integer,
    precio_igv numeric(18,2),
    descuento numeric(6,2),
    igv_unitario numeric(6,2),
    cantidadub double precision,
    flete_unitario numeric(16,2),
    subtotal numeric(16,4),
    costo_unitario numeric(16,4),
    igv_total numeric(6,2),
    flete_total numeric(16,2),
    subtotal_igv numeric(16,4),
    traslado_id integer,
    stock_traslado numeric(16,2),
    descripcion character varying(200)
);


ALTER TABLE ventas.det_traslado OWNER TO phuyu15;

--
-- TOC entry 348 (class 1259 OID 192734)
-- Name: det_traslado_id_seq; Type: SEQUENCE; Schema: ventas; Owner: phuyu15
--

CREATE SEQUENCE ventas.det_traslado_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ventas.det_traslado_id_seq OWNER TO phuyu15;

--
-- TOC entry 4379 (class 0 OID 0)
-- Dependencies: 348
-- Name: det_traslado_id_seq; Type: SEQUENCE OWNED BY; Schema: ventas; Owner: phuyu15
--

ALTER SEQUENCE ventas.det_traslado_id_seq OWNED BY ventas.det_traslado.id;


--
-- TOC entry 349 (class 1259 OID 192736)
-- Name: detalle_compras; Type: TABLE; Schema: ventas; Owner: phuyu15
--

CREATE TABLE ventas.detalle_compras (
    id integer NOT NULL,
    producto_id integer,
    compra_id integer,
    cantidad numeric(18,2),
    almacen_id integer,
    precio numeric(18,2),
    unidad_medida_id integer,
    precio_igv numeric(18,2),
    descuento numeric(6,2),
    igv_unitario numeric(6,2),
    cantidadub double precision,
    flete_unitario numeric(16,2),
    subtotal numeric(16,4),
    costos numeric(16,4),
    igv_total numeric(6,2),
    flete_total numeric(16,2),
    subtotal_igv numeric(16,4),
    descripcion character varying(200)
);


ALTER TABLE ventas.detalle_compras OWNER TO phuyu15;

--
-- TOC entry 350 (class 1259 OID 192739)
-- Name: detalle_compras_id_seq; Type: SEQUENCE; Schema: ventas; Owner: phuyu15
--

CREATE SEQUENCE ventas.detalle_compras_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ventas.detalle_compras_id_seq OWNER TO phuyu15;

--
-- TOC entry 4381 (class 0 OID 0)
-- Dependencies: 350
-- Name: detalle_compras_id_seq; Type: SEQUENCE OWNED BY; Schema: ventas; Owner: phuyu15
--

ALTER SEQUENCE ventas.detalle_compras_id_seq OWNED BY ventas.detalle_compras.id;


--
-- TOC entry 351 (class 1259 OID 192741)
-- Name: detalle_ventas; Type: TABLE; Schema: ventas; Owner: phuyu15
--

CREATE TABLE ventas.detalle_ventas (
    id integer NOT NULL,
    producto_id integer,
    venta_id integer,
    cantidad numeric(18,2) DEFAULT 0,
    almacen_id integer,
    precio numeric(18,2),
    unidad_medida_id integer,
    igv numeric(6,2),
    descuento numeric(6,2),
    cantidadub numeric(16,2),
    descripcion character varying(200),
    costo_unitario numeric(16,4),
    cantidad_despachada numeric(18,4) DEFAULT 0
);


ALTER TABLE ventas.detalle_ventas OWNER TO phuyu15;

--
-- TOC entry 352 (class 1259 OID 192746)
-- Name: detalle_ventas_id_seq; Type: SEQUENCE; Schema: ventas; Owner: phuyu15
--

CREATE SEQUENCE ventas.detalle_ventas_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ventas.detalle_ventas_id_seq OWNER TO phuyu15;

--
-- TOC entry 4383 (class 0 OID 0)
-- Dependencies: 352
-- Name: detalle_ventas_id_seq; Type: SEQUENCE OWNED BY; Schema: ventas; Owner: phuyu15
--

ALTER SEQUENCE ventas.detalle_ventas_id_seq OWNED BY ventas.detalle_ventas.id;


--
-- TOC entry 3182 (class 2604 OID 192748)
-- Name: almacenes codalmacen; Type: DEFAULT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.almacenes ALTER COLUMN codalmacen SET DEFAULT nextval('almacen.almacenes_codalmacen_seq'::regclass);


--
-- TOC entry 3184 (class 2604 OID 192749)
-- Name: atenciones codatencion; Type: DEFAULT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.atenciones ALTER COLUMN codatencion SET DEFAULT nextval('almacen.atenciones_codatencion_seq'::regclass);


--
-- TOC entry 3188 (class 2604 OID 192750)
-- Name: clase codclase; Type: DEFAULT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.clase ALTER COLUMN codclase SET DEFAULT nextval('almacen.clase_codclase_seq'::regclass);


--
-- TOC entry 3191 (class 2604 OID 192751)
-- Name: familias codfamilia; Type: DEFAULT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.familias ALTER COLUMN codfamilia SET DEFAULT nextval('almacen.familias_codfamilia_seq'::regclass);


--
-- TOC entry 3198 (class 2604 OID 192752)
-- Name: guiasr codguiar; Type: DEFAULT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.guiasr ALTER COLUMN codguiar SET DEFAULT nextval('almacen.guiasr_codguiar_seq'::regclass);


--
-- TOC entry 3205 (class 2604 OID 192753)
-- Name: guiast codguiat; Type: DEFAULT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.guiast ALTER COLUMN codguiat SET DEFAULT nextval('almacen.guiast_codguiat_seq'::regclass);


--
-- TOC entry 3221 (class 2604 OID 192754)
-- Name: inventarios codinventario; Type: DEFAULT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.inventarios ALTER COLUMN codinventario SET DEFAULT nextval('almacen.inventarios_codinventario_seq'::regclass);


--
-- TOC entry 3228 (class 2604 OID 192755)
-- Name: lineas codlinea; Type: DEFAULT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.lineas ALTER COLUMN codlinea SET DEFAULT nextval('almacen.lineas_codlinea_seq'::regclass);


--
-- TOC entry 3230 (class 2604 OID 192756)
-- Name: marcas codmarca; Type: DEFAULT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.marcas ALTER COLUMN codmarca SET DEFAULT nextval('almacen.marcas_codmarca_seq'::regclass);


--
-- TOC entry 3231 (class 2604 OID 192757)
-- Name: modalidadtraslado codmodalidadtraslado; Type: DEFAULT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.modalidadtraslado ALTER COLUMN codmodalidadtraslado SET DEFAULT nextval('almacen.modalidadtraslado_codmodalidadtraslado_seq'::regclass);


--
-- TOC entry 3232 (class 2604 OID 192758)
-- Name: motivotraslado codmotivotraslado; Type: DEFAULT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.motivotraslado ALTER COLUMN codmotivotraslado SET DEFAULT nextval('almacen.motivotraslado_codmotivotraslado_seq'::regclass);


--
-- TOC entry 3235 (class 2604 OID 192759)
-- Name: movimientotipos codmovimientotipo; Type: DEFAULT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.movimientotipos ALTER COLUMN codmovimientotipo SET DEFAULT nextval('almacen.movimientotipos_codmovimientotipo_seq'::regclass);


--
-- TOC entry 3237 (class 2604 OID 192760)
-- Name: presentacion codpresentacion; Type: DEFAULT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.presentacion ALTER COLUMN codpresentacion SET DEFAULT nextval('almacen.presentacion_codpresentacion_seq'::regclass);


--
-- TOC entry 3242 (class 2604 OID 192761)
-- Name: principioactivo codprincipioactivo; Type: DEFAULT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.principioactivo ALTER COLUMN codprincipioactivo SET DEFAULT nextval('almacen.principioactivo_codprincipioactivo_seq'::regclass);


--
-- TOC entry 3263 (class 2604 OID 192762)
-- Name: productos codproducto; Type: DEFAULT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.productos ALTER COLUMN codproducto SET DEFAULT nextval('almacen.productos_codproducto_seq'::regclass);


--
-- TOC entry 3294 (class 2604 OID 192763)
-- Name: unidades codunidad; Type: DEFAULT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.unidades ALTER COLUMN codunidad SET DEFAULT nextval('almacen.unidades_codunidad_seq'::regclass);


--
-- TOC entry 3296 (class 2604 OID 192764)
-- Name: vehiculos codvehiculo; Type: DEFAULT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.vehiculos ALTER COLUMN codvehiculo SET DEFAULT nextval('almacen.vehiculos_codvehiculo_seq'::regclass);


--
-- TOC entry 3298 (class 2604 OID 192765)
-- Name: vehiculoscategorias codvehiculocategoria; Type: DEFAULT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.vehiculoscategorias ALTER COLUMN codvehiculocategoria SET DEFAULT nextval('almacen.vehiculoscategorias_codvehiculocategoria_seq'::regclass);


--
-- TOC entry 3300 (class 2604 OID 192766)
-- Name: vehiculosmarcas codvehiculomarca; Type: DEFAULT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.vehiculosmarcas ALTER COLUMN codvehiculomarca SET DEFAULT nextval('almacen.vehiculosmarcas_codvehiculomarca_seq'::regclass);


--
-- TOC entry 3302 (class 2604 OID 192767)
-- Name: vehiculosmodelos codvehiculomodelo; Type: DEFAULT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.vehiculosmodelos ALTER COLUMN codvehiculomodelo SET DEFAULT nextval('almacen.vehiculosmodelos_codvehiculomodelo_seq'::regclass);


--
-- TOC entry 3305 (class 2604 OID 192768)
-- Name: bancos codbanco; Type: DEFAULT; Schema: caja; Owner: phuyu15
--

ALTER TABLE ONLY caja.bancos ALTER COLUMN codbanco SET DEFAULT nextval('caja.bancos_codbanco_seq'::regclass);


--
-- TOC entry 3308 (class 2604 OID 192769)
-- Name: cajas codcaja; Type: DEFAULT; Schema: caja; Owner: phuyu15
--

ALTER TABLE ONLY caja.cajas ALTER COLUMN codcaja SET DEFAULT nextval('caja.cajas_codcaja_seq'::regclass);


--
-- TOC entry 3310 (class 2604 OID 192770)
-- Name: centrocostos codcentrocosto; Type: DEFAULT; Schema: caja; Owner: phuyu15
--

ALTER TABLE ONLY caja.centrocostos ALTER COLUMN codcentrocosto SET DEFAULT nextval('caja.centrocostos_codcentrocosto_seq'::regclass);


--
-- TOC entry 3323 (class 2604 OID 192771)
-- Name: comprobantetipos codcomprobantetipo; Type: DEFAULT; Schema: caja; Owner: phuyu15
--

ALTER TABLE ONLY caja.comprobantetipos ALTER COLUMN codcomprobantetipo SET DEFAULT nextval('caja.comprobantetipos_codcomprobantetipo_seq'::regclass);


--
-- TOC entry 3325 (class 2604 OID 192772)
-- Name: conceptos codconcepto; Type: DEFAULT; Schema: caja; Owner: phuyu15
--

ALTER TABLE ONLY caja.conceptos ALTER COLUMN codconcepto SET DEFAULT nextval('caja.conceptos_codconcepto_seq'::regclass);


--
-- TOC entry 3339 (class 2604 OID 192773)
-- Name: controldiario codcontroldiario; Type: DEFAULT; Schema: caja; Owner: phuyu15
--

ALTER TABLE ONLY caja.controldiario ALTER COLUMN codcontroldiario SET DEFAULT nextval('caja.controldiario_codcontroldiario_seq'::regclass);


--
-- TOC entry 3341 (class 2604 OID 192774)
-- Name: ctasctes codctacte; Type: DEFAULT; Schema: caja; Owner: phuyu15
--

ALTER TABLE ONLY caja.ctasctes ALTER COLUMN codctacte SET DEFAULT nextval('caja.ctasctes_codctacte_seq'::regclass);


--
-- TOC entry 3344 (class 2604 OID 192775)
-- Name: monedas codmoneda; Type: DEFAULT; Schema: caja; Owner: phuyu15
--

ALTER TABLE ONLY caja.monedas ALTER COLUMN codmoneda SET DEFAULT nextval('caja.monedas_codmoneda_seq'::regclass);


--
-- TOC entry 3351 (class 2604 OID 192776)
-- Name: movimientos codmovimiento; Type: DEFAULT; Schema: caja; Owner: phuyu15
--

ALTER TABLE ONLY caja.movimientos ALTER COLUMN codmovimiento SET DEFAULT nextval('caja.movimientos_codmovimiento_seq'::regclass);


--
-- TOC entry 3360 (class 2604 OID 192777)
-- Name: tipocambios codtipocambio; Type: DEFAULT; Schema: caja; Owner: phuyu15
--

ALTER TABLE ONLY caja.tipocambios ALTER COLUMN codtipocambio SET DEFAULT nextval('caja.tipocambios_codtipocambio_seq'::regclass);


--
-- TOC entry 3362 (class 2604 OID 192778)
-- Name: tipopagos codtipopago; Type: DEFAULT; Schema: caja; Owner: phuyu15
--

ALTER TABLE ONLY caja.tipopagos ALTER COLUMN codtipopago SET DEFAULT nextval('caja.tipopagos_codtipopago_seq'::regclass);


--
-- TOC entry 3364 (class 2604 OID 192779)
-- Name: creditoconceptos codcreditoconcepto; Type: DEFAULT; Schema: kardex; Owner: phuyu15
--

ALTER TABLE ONLY kardex.creditoconceptos ALTER COLUMN codcreditoconcepto SET DEFAULT nextval('kardex.creditoconceptos_codcreditoconcepto_seq'::regclass);


--
-- TOC entry 3383 (class 2604 OID 192780)
-- Name: creditos codcredito; Type: DEFAULT; Schema: kardex; Owner: phuyu15
--

ALTER TABLE ONLY kardex.creditos ALTER COLUMN codcredito SET DEFAULT nextval('kardex.creditos_codcredito_seq'::regclass);


--
-- TOC entry 3431 (class 2604 OID 192781)
-- Name: kardex codkardex; Type: DEFAULT; Schema: kardex; Owner: phuyu15
--

ALTER TABLE ONLY kardex.kardex ALTER COLUMN codkardex SET DEFAULT nextval('kardex.kardex_codkardex_seq'::regclass);


--
-- TOC entry 3434 (class 2604 OID 192782)
-- Name: kardexalmacen codkardexalmacen; Type: DEFAULT; Schema: kardex; Owner: phuyu15
--

ALTER TABLE ONLY kardex.kardexalmacen ALTER COLUMN codkardexalmacen SET DEFAULT nextval('kardex.kardexalmacen_codkardexalmacen_seq'::regclass);


--
-- TOC entry 3468 (class 2604 OID 192783)
-- Name: motivonotas codmotivonota; Type: DEFAULT; Schema: kardex; Owner: phuyu15
--

ALTER TABLE ONLY kardex.motivonotas ALTER COLUMN codmotivonota SET DEFAULT nextval('kardex.motivonotas_codmotivonota_seq'::regclass);


--
-- TOC entry 3484 (class 2604 OID 192784)
-- Name: pedidos codpedido; Type: DEFAULT; Schema: kardex; Owner: phuyu15
--

ALTER TABLE ONLY kardex.pedidos ALTER COLUMN codpedido SET DEFAULT nextval('kardex.pedidos_codpedido_seq'::regclass);


--
-- TOC entry 3519 (class 2604 OID 192785)
-- Name: proformas codproforma; Type: DEFAULT; Schema: kardex; Owner: phuyu15
--

ALTER TABLE ONLY kardex.proformas ALTER COLUMN codproforma SET DEFAULT nextval('kardex.proformas_codproforma_seq'::regclass);


--
-- TOC entry 3547 (class 2604 OID 192786)
-- Name: areas codarea; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.areas ALTER COLUMN codarea SET DEFAULT nextval('public.areas_codarea_seq'::regclass);


--
-- TOC entry 3549 (class 2604 OID 192787)
-- Name: cargos codcargo; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.cargos ALTER COLUMN codcargo SET DEFAULT nextval('public.cargos_codcargo_seq'::regclass);


--
-- TOC entry 3540 (class 2604 OID 192788)
-- Name: documentotipos coddocumentotipo; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.documentotipos ALTER COLUMN coddocumentotipo SET DEFAULT nextval('public.documentotipos_coddocumentotipo_seq'::regclass);


--
-- TOC entry 3564 (class 2604 OID 192789)
-- Name: empresas codempresa; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.empresas ALTER COLUMN codempresa SET DEFAULT nextval('public.empresas_codempresa_seq'::regclass);


--
-- TOC entry 3545 (class 2604 OID 192790)
-- Name: personas codpersona; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.personas ALTER COLUMN codpersona SET DEFAULT nextval('public.personas_codpersona_seq'::regclass);


--
-- TOC entry 3568 (class 2604 OID 192791)
-- Name: rubros codrubro; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.rubros ALTER COLUMN codrubro SET DEFAULT nextval('public.rubros_codrubro_seq'::regclass);


--
-- TOC entry 3573 (class 2604 OID 192792)
-- Name: sociotipos codsociotipo; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.sociotipos ALTER COLUMN codsociotipo SET DEFAULT nextval('public.sociotipos_codsociotipo_seq'::regclass);


--
-- TOC entry 3580 (class 2604 OID 192793)
-- Name: sucursales codsucursal; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.sucursales ALTER COLUMN codsucursal SET DEFAULT nextval('public.sucursales_codsucursal_seq'::regclass);


--
-- TOC entry 3581 (class 2604 OID 192794)
-- Name: ubigeo codubigeo; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.ubigeo ALTER COLUMN codubigeo SET DEFAULT nextval('public.ubigeo_codubigeo_seq'::regclass);


--
-- TOC entry 3585 (class 2604 OID 192795)
-- Name: modulos codmodulo; Type: DEFAULT; Schema: seguridad; Owner: phuyu15
--

ALTER TABLE ONLY seguridad.modulos ALTER COLUMN codmodulo SET DEFAULT nextval('seguridad.modulos_codmodulo_seq'::regclass);


--
-- TOC entry 3587 (class 2604 OID 192796)
-- Name: perfiles codperfil; Type: DEFAULT; Schema: seguridad; Owner: phuyu15
--

ALTER TABLE ONLY seguridad.perfiles ALTER COLUMN codperfil SET DEFAULT nextval('seguridad.perfiles_codperfil_seq'::regclass);


--
-- TOC entry 3591 (class 2604 OID 192797)
-- Name: usuarios codusuario; Type: DEFAULT; Schema: seguridad; Owner: phuyu15
--

ALTER TABLE ONLY seguridad.usuarios ALTER COLUMN codusuario SET DEFAULT nextval('seguridad.usuarios_codusuario_seq'::regclass);


--
-- TOC entry 3604 (class 2604 OID 192798)
-- Name: resumentipos codresumentipo; Type: DEFAULT; Schema: sunat; Owner: phuyu15
--

ALTER TABLE ONLY sunat.resumentipos ALTER COLUMN codresumentipo SET DEFAULT nextval('sunat.resumentipos_codresumentipo_seq'::regclass);


--
-- TOC entry 3605 (class 2604 OID 192799)
-- Name: det_traslado id; Type: DEFAULT; Schema: ventas; Owner: phuyu15
--

ALTER TABLE ONLY ventas.det_traslado ALTER COLUMN id SET DEFAULT nextval('ventas.det_traslado_id_seq'::regclass);


--
-- TOC entry 3606 (class 2604 OID 192800)
-- Name: detalle_compras id; Type: DEFAULT; Schema: ventas; Owner: phuyu15
--

ALTER TABLE ONLY ventas.detalle_compras ALTER COLUMN id SET DEFAULT nextval('ventas.detalle_compras_id_seq'::regclass);


--
-- TOC entry 3609 (class 2604 OID 192801)
-- Name: detalle_ventas id; Type: DEFAULT; Schema: ventas; Owner: phuyu15
--

ALTER TABLE ONLY ventas.detalle_ventas ALTER COLUMN id SET DEFAULT nextval('ventas.detalle_ventas_id_seq'::regclass);


--
-- TOC entry 4162 (class 2613 OID 26135)
-- Name: 26135; Type: BLOB; Schema: -; Owner: phuyu15
--

SELECT pg_catalog.lo_create('26135');


ALTER LARGE OBJECT 26135 OWNER TO phuyu15;

--
-- TOC entry 4163 (class 2613 OID 26141)
-- Name: 26141; Type: BLOB; Schema: -; Owner: phuyu15
--

SELECT pg_catalog.lo_create('26141');


ALTER LARGE OBJECT 26141 OWNER TO phuyu15;

--
-- TOC entry 4164 (class 2613 OID 26144)
-- Name: 26144; Type: BLOB; Schema: -; Owner: phuyu15
--

SELECT pg_catalog.lo_create('26144');


ALTER LARGE OBJECT 26144 OWNER TO phuyu15;

--
-- TOC entry 4165 (class 2613 OID 26151)
-- Name: 26151; Type: BLOB; Schema: -; Owner: phuyu15
--

SELECT pg_catalog.lo_create('26151');


ALTER LARGE OBJECT 26151 OWNER TO phuyu15;

--
-- TOC entry 4166 (class 2613 OID 26165)
-- Name: 26165; Type: BLOB; Schema: -; Owner: phuyu15
--

SELECT pg_catalog.lo_create('26165');


ALTER LARGE OBJECT 26165 OWNER TO phuyu15;

--
-- TOC entry 4167 (class 2613 OID 26168)
-- Name: 26168; Type: BLOB; Schema: -; Owner: phuyu15
--

SELECT pg_catalog.lo_create('26168');


ALTER LARGE OBJECT 26168 OWNER TO phuyu15;

--
-- TOC entry 4168 (class 2613 OID 27117)
-- Name: 27117; Type: BLOB; Schema: -; Owner: phuyu15
--

SELECT pg_catalog.lo_create('27117');


ALTER LARGE OBJECT 27117 OWNER TO phuyu15;

--
-- TOC entry 4169 (class 2613 OID 27120)
-- Name: 27120; Type: BLOB; Schema: -; Owner: phuyu15
--

SELECT pg_catalog.lo_create('27120');


ALTER LARGE OBJECT 27120 OWNER TO phuyu15;

--
-- TOC entry 4170 (class 2613 OID 27126)
-- Name: 27126; Type: BLOB; Schema: -; Owner: phuyu15
--

SELECT pg_catalog.lo_create('27126');


ALTER LARGE OBJECT 27126 OWNER TO phuyu15;

--
-- TOC entry 4171 (class 2613 OID 27129)
-- Name: 27129; Type: BLOB; Schema: -; Owner: phuyu15
--

SELECT pg_catalog.lo_create('27129');


ALTER LARGE OBJECT 27129 OWNER TO phuyu15;

--
-- TOC entry 4172 (class 2613 OID 27135)
-- Name: 27135; Type: BLOB; Schema: -; Owner: phuyu15
--

SELECT pg_catalog.lo_create('27135');


ALTER LARGE OBJECT 27135 OWNER TO phuyu15;

--
-- TOC entry 4173 (class 2613 OID 27138)
-- Name: 27138; Type: BLOB; Schema: -; Owner: phuyu15
--

SELECT pg_catalog.lo_create('27138');


ALTER LARGE OBJECT 27138 OWNER TO phuyu15;

--
-- TOC entry 4174 (class 2613 OID 27141)
-- Name: 27141; Type: BLOB; Schema: -; Owner: phuyu15
--

SELECT pg_catalog.lo_create('27141');


ALTER LARGE OBJECT 27141 OWNER TO phuyu15;

--
-- TOC entry 4175 (class 2613 OID 27208)
-- Name: 27208; Type: BLOB; Schema: -; Owner: phuyu15
--

SELECT pg_catalog.lo_create('27208');


ALTER LARGE OBJECT 27208 OWNER TO phuyu15;

--
-- TOC entry 4176 (class 2613 OID 27211)
-- Name: 27211; Type: BLOB; Schema: -; Owner: phuyu15
--

SELECT pg_catalog.lo_create('27211');


ALTER LARGE OBJECT 27211 OWNER TO phuyu15;

--
-- TOC entry 4177 (class 2613 OID 27214)
-- Name: 27214; Type: BLOB; Schema: -; Owner: phuyu15
--

SELECT pg_catalog.lo_create('27214');


ALTER LARGE OBJECT 27214 OWNER TO phuyu15;

--
-- TOC entry 4178 (class 2613 OID 27222)
-- Name: 27222; Type: BLOB; Schema: -; Owner: phuyu15
--

SELECT pg_catalog.lo_create('27222');


ALTER LARGE OBJECT 27222 OWNER TO phuyu15;

--
-- TOC entry 4179 (class 2613 OID 27228)
-- Name: 27228; Type: BLOB; Schema: -; Owner: phuyu15
--

SELECT pg_catalog.lo_create('27228');


ALTER LARGE OBJECT 27228 OWNER TO phuyu15;

--
-- TOC entry 4180 (class 2613 OID 27232)
-- Name: 27232; Type: BLOB; Schema: -; Owner: phuyu15
--

SELECT pg_catalog.lo_create('27232');


ALTER LARGE OBJECT 27232 OWNER TO phuyu15;

--
-- TOC entry 4181 (class 2613 OID 27514)
-- Name: 27514; Type: BLOB; Schema: -; Owner: phuyu15
--

SELECT pg_catalog.lo_create('27514');


ALTER LARGE OBJECT 27514 OWNER TO phuyu15;

--
-- TOC entry 4182 (class 2613 OID 27517)
-- Name: 27517; Type: BLOB; Schema: -; Owner: phuyu15
--

SELECT pg_catalog.lo_create('27517');


ALTER LARGE OBJECT 27517 OWNER TO phuyu15;

--
-- TOC entry 4183 (class 2613 OID 27522)
-- Name: 27522; Type: BLOB; Schema: -; Owner: phuyu15
--

SELECT pg_catalog.lo_create('27522');


ALTER LARGE OBJECT 27522 OWNER TO phuyu15;

--
-- TOC entry 4184 (class 2613 OID 27526)
-- Name: 27526; Type: BLOB; Schema: -; Owner: phuyu15
--

SELECT pg_catalog.lo_create('27526');


ALTER LARGE OBJECT 27526 OWNER TO phuyu15;

--
-- TOC entry 4185 (class 2613 OID 27529)
-- Name: 27529; Type: BLOB; Schema: -; Owner: phuyu15
--

SELECT pg_catalog.lo_create('27529');


ALTER LARGE OBJECT 27529 OWNER TO phuyu15;

--
-- TOC entry 4186 (class 2613 OID 28562)
-- Name: 28562; Type: BLOB; Schema: -; Owner: phuyu15
--

SELECT pg_catalog.lo_create('28562');


ALTER LARGE OBJECT 28562 OWNER TO phuyu15;

--
-- TOC entry 4187 (class 2613 OID 31613)
-- Name: 31613; Type: BLOB; Schema: -; Owner: phuyu15
--

SELECT pg_catalog.lo_create('31613');


ALTER LARGE OBJECT 31613 OWNER TO phuyu15;

--
-- TOC entry 4188 (class 2613 OID 32629)
-- Name: 32629; Type: BLOB; Schema: -; Owner: phuyu15
--

SELECT pg_catalog.lo_create('32629');


ALTER LARGE OBJECT 32629 OWNER TO phuyu15;

--
-- TOC entry 4189 (class 2613 OID 32707)
-- Name: 32707; Type: BLOB; Schema: -; Owner: phuyu15
--

SELECT pg_catalog.lo_create('32707');


ALTER LARGE OBJECT 32707 OWNER TO phuyu15;

--
-- TOC entry 4190 (class 2613 OID 33794)
-- Name: 33794; Type: BLOB; Schema: -; Owner: phuyu15
--

SELECT pg_catalog.lo_create('33794');


ALTER LARGE OBJECT 33794 OWNER TO phuyu15;

--
-- TOC entry 4191 (class 2613 OID 34830)
-- Name: 34830; Type: BLOB; Schema: -; Owner: phuyu15
--

SELECT pg_catalog.lo_create('34830');


ALTER LARGE OBJECT 34830 OWNER TO phuyu15;

--
-- TOC entry 4192 (class 2613 OID 34842)
-- Name: 34842; Type: BLOB; Schema: -; Owner: phuyu15
--

SELECT pg_catalog.lo_create('34842');


ALTER LARGE OBJECT 34842 OWNER TO phuyu15;

--
-- TOC entry 4193 (class 2613 OID 35860)
-- Name: 35860; Type: BLOB; Schema: -; Owner: phuyu15
--

SELECT pg_catalog.lo_create('35860');


ALTER LARGE OBJECT 35860 OWNER TO phuyu15;

--
-- TOC entry 4194 (class 2613 OID 35866)
-- Name: 35866; Type: BLOB; Schema: -; Owner: phuyu15
--

SELECT pg_catalog.lo_create('35866');


ALTER LARGE OBJECT 35866 OWNER TO phuyu15;

--
-- TOC entry 4195 (class 2613 OID 36822)
-- Name: 36822; Type: BLOB; Schema: -; Owner: phuyu15
--

SELECT pg_catalog.lo_create('36822');


ALTER LARGE OBJECT 36822 OWNER TO phuyu15;

--
-- TOC entry 4196 (class 2613 OID 36834)
-- Name: 36834; Type: BLOB; Schema: -; Owner: phuyu15
--

SELECT pg_catalog.lo_create('36834');


ALTER LARGE OBJECT 36834 OWNER TO phuyu15;

--
-- TOC entry 4197 (class 2613 OID 36837)
-- Name: 36837; Type: BLOB; Schema: -; Owner: phuyu15
--

SELECT pg_catalog.lo_create('36837');


ALTER LARGE OBJECT 36837 OWNER TO phuyu15;

--
-- TOC entry 4198 (class 2613 OID 36931)
-- Name: 36931; Type: BLOB; Schema: -; Owner: phuyu15
--

SELECT pg_catalog.lo_create('36931');


ALTER LARGE OBJECT 36931 OWNER TO phuyu15;

--
-- TOC entry 4199 (class 2613 OID 36942)
-- Name: 36942; Type: BLOB; Schema: -; Owner: phuyu15
--

SELECT pg_catalog.lo_create('36942');


ALTER LARGE OBJECT 36942 OWNER TO phuyu15;

--
-- TOC entry 4200 (class 2613 OID 36980)
-- Name: 36980; Type: BLOB; Schema: -; Owner: phuyu15
--

SELECT pg_catalog.lo_create('36980');


ALTER LARGE OBJECT 36980 OWNER TO phuyu15;

--
-- TOC entry 4201 (class 2613 OID 37261)
-- Name: 37261; Type: BLOB; Schema: -; Owner: phuyu15
--

SELECT pg_catalog.lo_create('37261');


ALTER LARGE OBJECT 37261 OWNER TO phuyu15;

--
-- TOC entry 4202 (class 2613 OID 37524)
-- Name: 37524; Type: BLOB; Schema: -; Owner: phuyu15
--

SELECT pg_catalog.lo_create('37524');


ALTER LARGE OBJECT 37524 OWNER TO phuyu15;

--
-- TOC entry 4203 (class 2613 OID 39145)
-- Name: 39145; Type: BLOB; Schema: -; Owner: phuyu15
--

SELECT pg_catalog.lo_create('39145');


ALTER LARGE OBJECT 39145 OWNER TO phuyu15;

--
-- TOC entry 4204 (class 2613 OID 39232)
-- Name: 39232; Type: BLOB; Schema: -; Owner: phuyu15
--

SELECT pg_catalog.lo_create('39232');


ALTER LARGE OBJECT 39232 OWNER TO phuyu15;

--
-- TOC entry 4205 (class 2613 OID 39265)
-- Name: 39265; Type: BLOB; Schema: -; Owner: phuyu15
--

SELECT pg_catalog.lo_create('39265');


ALTER LARGE OBJECT 39265 OWNER TO phuyu15;

--
-- TOC entry 4206 (class 2613 OID 39278)
-- Name: 39278; Type: BLOB; Schema: -; Owner: phuyu15
--

SELECT pg_catalog.lo_create('39278');


ALTER LARGE OBJECT 39278 OWNER TO phuyu15;

--
-- TOC entry 4207 (class 2613 OID 40509)
-- Name: 40509; Type: BLOB; Schema: -; Owner: phuyu15
--

SELECT pg_catalog.lo_create('40509');


ALTER LARGE OBJECT 40509 OWNER TO phuyu15;

--
-- TOC entry 4208 (class 2613 OID 40833)
-- Name: 40833; Type: BLOB; Schema: -; Owner: phuyu15
--

SELECT pg_catalog.lo_create('40833');


ALTER LARGE OBJECT 40833 OWNER TO phuyu15;

--
-- TOC entry 4209 (class 2613 OID 40844)
-- Name: 40844; Type: BLOB; Schema: -; Owner: phuyu15
--

SELECT pg_catalog.lo_create('40844');


ALTER LARGE OBJECT 40844 OWNER TO phuyu15;

--
-- TOC entry 4210 (class 2613 OID 40848)
-- Name: 40848; Type: BLOB; Schema: -; Owner: phuyu15
--

SELECT pg_catalog.lo_create('40848');


ALTER LARGE OBJECT 40848 OWNER TO phuyu15;

--
-- TOC entry 4211 (class 2613 OID 41091)
-- Name: 41091; Type: BLOB; Schema: -; Owner: phuyu15
--

SELECT pg_catalog.lo_create('41091');


ALTER LARGE OBJECT 41091 OWNER TO phuyu15;

--
-- TOC entry 4212 (class 2613 OID 41220)
-- Name: 41220; Type: BLOB; Schema: -; Owner: phuyu15
--

SELECT pg_catalog.lo_create('41220');


ALTER LARGE OBJECT 41220 OWNER TO phuyu15;

--
-- TOC entry 4213 (class 2613 OID 41258)
-- Name: 41258; Type: BLOB; Schema: -; Owner: phuyu15
--

SELECT pg_catalog.lo_create('41258');


ALTER LARGE OBJECT 41258 OWNER TO phuyu15;

--
-- TOC entry 4214 (class 2613 OID 41279)
-- Name: 41279; Type: BLOB; Schema: -; Owner: phuyu15
--

SELECT pg_catalog.lo_create('41279');


ALTER LARGE OBJECT 41279 OWNER TO phuyu15;

--
-- TOC entry 4215 (class 2613 OID 41289)
-- Name: 41289; Type: BLOB; Schema: -; Owner: phuyu15
--

SELECT pg_catalog.lo_create('41289');


ALTER LARGE OBJECT 41289 OWNER TO phuyu15;

--
-- TOC entry 4216 (class 2613 OID 43323)
-- Name: 43323; Type: BLOB; Schema: -; Owner: phuyu15
--

SELECT pg_catalog.lo_create('43323');


ALTER LARGE OBJECT 43323 OWNER TO phuyu15;

--
-- TOC entry 4217 (class 2613 OID 43326)
-- Name: 43326; Type: BLOB; Schema: -; Owner: phuyu15
--

SELECT pg_catalog.lo_create('43326');


ALTER LARGE OBJECT 43326 OWNER TO phuyu15;

--
-- TOC entry 4218 (class 2613 OID 43552)
-- Name: 43552; Type: BLOB; Schema: -; Owner: phuyu15
--

SELECT pg_catalog.lo_create('43552');


ALTER LARGE OBJECT 43552 OWNER TO phuyu15;

--
-- TOC entry 4219 (class 2613 OID 43573)
-- Name: 43573; Type: BLOB; Schema: -; Owner: phuyu15
--

SELECT pg_catalog.lo_create('43573');


ALTER LARGE OBJECT 43573 OWNER TO phuyu15;

--
-- TOC entry 4220 (class 2613 OID 43597)
-- Name: 43597; Type: BLOB; Schema: -; Owner: phuyu15
--

SELECT pg_catalog.lo_create('43597');


ALTER LARGE OBJECT 43597 OWNER TO phuyu15;

--
-- TOC entry 4221 (class 2613 OID 44722)
-- Name: 44722; Type: BLOB; Schema: -; Owner: phuyu15
--

SELECT pg_catalog.lo_create('44722');


ALTER LARGE OBJECT 44722 OWNER TO phuyu15;

--
-- TOC entry 4222 (class 2613 OID 45862)
-- Name: 45862; Type: BLOB; Schema: -; Owner: phuyu15
--

SELECT pg_catalog.lo_create('45862');


ALTER LARGE OBJECT 45862 OWNER TO phuyu15;

--
-- TOC entry 4223 (class 2613 OID 45865)
-- Name: 45865; Type: BLOB; Schema: -; Owner: phuyu15
--

SELECT pg_catalog.lo_create('45865');


ALTER LARGE OBJECT 45865 OWNER TO phuyu15;

--
-- TOC entry 4224 (class 2613 OID 45911)
-- Name: 45911; Type: BLOB; Schema: -; Owner: phuyu15
--

SELECT pg_catalog.lo_create('45911');


ALTER LARGE OBJECT 45911 OWNER TO phuyu15;

--
-- TOC entry 4225 (class 2613 OID 46268)
-- Name: 46268; Type: BLOB; Schema: -; Owner: phuyu15
--

SELECT pg_catalog.lo_create('46268');


ALTER LARGE OBJECT 46268 OWNER TO phuyu15;

--
-- TOC entry 4226 (class 2613 OID 47292)
-- Name: 47292; Type: BLOB; Schema: -; Owner: phuyu15
--

SELECT pg_catalog.lo_create('47292');


ALTER LARGE OBJECT 47292 OWNER TO phuyu15;

--
-- TOC entry 4227 (class 2613 OID 47647)
-- Name: 47647; Type: BLOB; Schema: -; Owner: phuyu15
--

SELECT pg_catalog.lo_create('47647');


ALTER LARGE OBJECT 47647 OWNER TO phuyu15;

--
-- TOC entry 4228 (class 2613 OID 47800)
-- Name: 47800; Type: BLOB; Schema: -; Owner: phuyu15
--

SELECT pg_catalog.lo_create('47800');


ALTER LARGE OBJECT 47800 OWNER TO phuyu15;

--
-- TOC entry 4229 (class 2613 OID 48199)
-- Name: 48199; Type: BLOB; Schema: -; Owner: phuyu15
--

SELECT pg_catalog.lo_create('48199');


ALTER LARGE OBJECT 48199 OWNER TO phuyu15;

--
-- TOC entry 4230 (class 2613 OID 48218)
-- Name: 48218; Type: BLOB; Schema: -; Owner: phuyu15
--

SELECT pg_catalog.lo_create('48218');


ALTER LARGE OBJECT 48218 OWNER TO phuyu15;

--
-- TOC entry 4231 (class 2613 OID 48227)
-- Name: 48227; Type: BLOB; Schema: -; Owner: phuyu15
--

SELECT pg_catalog.lo_create('48227');


ALTER LARGE OBJECT 48227 OWNER TO phuyu15;

--
-- TOC entry 4232 (class 2613 OID 48324)
-- Name: 48324; Type: BLOB; Schema: -; Owner: phuyu15
--

SELECT pg_catalog.lo_create('48324');


ALTER LARGE OBJECT 48324 OWNER TO phuyu15;

--
-- TOC entry 4233 (class 2613 OID 48327)
-- Name: 48327; Type: BLOB; Schema: -; Owner: phuyu15
--

SELECT pg_catalog.lo_create('48327');


ALTER LARGE OBJECT 48327 OWNER TO phuyu15;

--
-- TOC entry 4234 (class 2613 OID 48330)
-- Name: 48330; Type: BLOB; Schema: -; Owner: phuyu15
--

SELECT pg_catalog.lo_create('48330');


ALTER LARGE OBJECT 48330 OWNER TO phuyu15;

--
-- TOC entry 4235 (class 2613 OID 48333)
-- Name: 48333; Type: BLOB; Schema: -; Owner: phuyu15
--

SELECT pg_catalog.lo_create('48333');


ALTER LARGE OBJECT 48333 OWNER TO phuyu15;

--
-- TOC entry 4236 (class 2613 OID 48409)
-- Name: 48409; Type: BLOB; Schema: -; Owner: phuyu15
--

SELECT pg_catalog.lo_create('48409');


ALTER LARGE OBJECT 48409 OWNER TO phuyu15;

--
-- TOC entry 4237 (class 2613 OID 48412)
-- Name: 48412; Type: BLOB; Schema: -; Owner: phuyu15
--

SELECT pg_catalog.lo_create('48412');


ALTER LARGE OBJECT 48412 OWNER TO phuyu15;

--
-- TOC entry 4238 (class 2613 OID 48415)
-- Name: 48415; Type: BLOB; Schema: -; Owner: phuyu15
--

SELECT pg_catalog.lo_create('48415');


ALTER LARGE OBJECT 48415 OWNER TO phuyu15;

--
-- TOC entry 4023 (class 0 OID 191922)
-- Dependencies: 208
-- Data for Name: almacenes; Type: TABLE DATA; Schema: almacen; Owner: phuyu15
--

COPY almacen.almacenes (codalmacen, codsucursal, descripcion, direccion, telefonos, controlstock, estado, principal, codubigeo, despachodirecto, conpedido) FROM stdin;
1	1	SUCURSAL PRINCIPAL	Jr.Tahuantinsuyo N844	972895288	0	1	0	1740	0	1
\.


--
-- TOC entry 4025 (class 0 OID 191932)
-- Dependencies: 210
-- Data for Name: atenciones; Type: TABLE DATA; Schema: almacen; Owner: phuyu15
--

COPY almacen.atenciones (codatencion, descripcion, impresora, copias, estado) FROM stdin;
\.


--
-- TOC entry 4027 (class 0 OID 191938)
-- Dependencies: 212
-- Data for Name: clase; Type: TABLE DATA; Schema: almacen; Owner: phuyu15
--

COPY almacen.clase (codclase, descripcion, estado, abreviatura, codlinea, codfamilia) FROM stdin;
1	BOTICA	1	\N	1	1
0	SIN CLASE	1	\N	0	0
\.


--
-- TOC entry 4029 (class 0 OID 191946)
-- Dependencies: 214
-- Data for Name: familias; Type: TABLE DATA; Schema: almacen; Owner: phuyu15
--

COPY almacen.familias (codfamilia, descripcion, estado, abreviatura, codlinea) FROM stdin;
0	SIN FAMILIA	1	S/F	0
1	LLANTAS	1	\N	0
2	ACEITE	1	\N	0
3	CREMALLERA	1	\N	0
4	BATERIA	1	\N	0
5	ARRASTRE	1	\N	0
6	EJE	1	\N	0
7	BUJIA	1	\N	0
8	CAMARAS	1	\N	0
9	TUBO DE ESCAPE	1	\N	0
10	AMOR	1	\N	0
11	BOBINA	1	\N	0
12	VALVULA	1	\N	0
13	CABLES	1	\N	0
14	ESTRIBO	1	\N	0
15	RODAJE	1	\N	0
17	ZAPATA	1	\N	0
18	PLASTICOS	1	\N	0
19	CABEZAL	1	\N	0
20	TANQUES	1	\N	0
21	ARRANQUE	1	\N	0
23	TAPA	1	\N	0
24	CARGUERO	1	\N	0
25	CILINDRO	1	\N	0
26	EMPAQUES	1	\N	0
27	CDI	1	\N	0
28	CATALINA	1	\N	0
29	ELECTRICIDAD	1	\N	0
16	CARBURADOR	1	\N	0
30	CHAPA	1	\N	0
31	TAPABARRO	1	\N	0
32	RAYOS	1	\N	0
33	PISTON	1	\N	0
34	OSAKA	1	\N	0
35	CADENILLA	1	\N	0
37	DISCO EMBRIAGUE	1	\N	0
38	PEDAL	1	\N	0
40	PARADOR	1	\N	0
41	GRASA	1	\N	0
42	SILICONA	1	\N	0
43	SOLDIMIX	1	\N	0
44	BARRA	1	\N	0
46	PORTA CATALINA	1	\N	0
47	MASCARA	1	\N	0
48	SERVICIO	1	\N	0
49	BARRAS	0	\N	0
50	PERNOS	1	\N	0
51	YUGO	1	\N	0
52	MICA	1	\N	0
53	BALINES	1	\N	0
54	MANGUERA	1	\N	0
39	CIGUEÑAL	1	\N	0
55	MANIJA	1	\N	0
56	BOMBA	1	\N	0
57	BALANCIN	1	\N	0
58	BENDIX	1	\N	0
59	RETEN	1	\N	0
60	TUBO	1	\N	0
61	CORONA	1	\N	0
62	GUIA	1	\N	0
63	ALTERNADOR	1	\N	0
64	ARRANCADOR	1	\N	0
65	CLAXON	1	\N	0
66	AISLADOR	1	\N	0
36	ANILLOS	1	\N	0
67	BASE DE DISCO	1	\N	0
68	CANDADO DE CADENA	1	\N	0
69	PIÑON	1	\N	0
70	CAJA DE RETROCESO	1	\N	0
71	VARILLA DE FRENO	1	\N	0
72	MANUBRIOS	1	\N	0
73	PASTILLA DE FRENO	1	\N	0
74	SELECTOR	1	\N	0
75	FILTRO	1	\N	0
77	CAPUCHON BUJIA	1	\N	0
78	ESPEJO	1	\N	0
45	FARO	1	\N	0
79	TEMPLADOR	1	\N	0
80	PASTILLA	1	\N	0
81	CAJA CAMBIO	1	\N	0
82	CANASTILLA	1	\N	0
83	BOCAMAZA	1	\N	0
84	CRUCETA	1	\N	0
85	RECTIFICADOR	1	\N	0
86	PARCHE	1	\N	0
87	GRIFO PASE GASOLINA	1	\N	0
88	PORTA FARO	1	\N	0
89	BRAZO DE FRENO	1	\N	0
90	PIN DE FRENO	1	\N	0
91	HACHA	1	\N	0
92	MANO DE OBRA	1	\N	0
93	TABLERO	1	\N	0
94	MEDIALUNA	1	\N	0
95	FOCO	1	\N	0
96	BUJE	1	\N	0
97	JEBE	1	\N	0
22	ARO	1	\N	0
98	PIÑON TENSOR GUIA	1	\N	0
99	POLINES	1	\N	0
100	COMANDO	1	\N	0
101	VOLANTE	1	\N	0
102	TRAPECIO	1	\N	0
103	MEDIDO DE ACEITE	1	\N	0
104	LEVAS	1	\N	0
76	DISCO	1	\N	0
337	ACEITE	1	\N	2
338	sin linea	1	\N	0
339	llantas	1	\N	1
340	eso	1	\N	8
341	sn	1	\N	0
342	sl	1	\N	0
344	ninguno	1	\N	0
345	carburador	1	\N	0
343	unidad	1	\N	0
346	unidad	1	\N	17
\.


--
-- TOC entry 4031 (class 0 OID 191953)
-- Dependencies: 216
-- Data for Name: guiasr; Type: TABLE DATA; Schema: almacen; Owner: phuyu15
--

COPY almacen.guiasr (codguiar, codpersona, codusuario, codcomprobantetipo, seriecomprobante, nrocomprobante, codmodalidadtraslado, codmotivotraslado, fechatraslado, codigopuerto, transbordo, peso, nropaquetes, nrocontenedor, descripcionmotivo, observaciones, codempleado, codubigeopartida, direccionpartida, codubigeollegada, direccionllegada, coddocumentotipotransportista, documentotransportista, razonsocialtransportista, nroplaca, coddocumentotipoconductor, documentoconductor, razonsocialconductor, codalmacen, codsucursal, estado, codmovimientotipo, tipomovimiento, fechaguia, marca, destinatario, licenciaconductor, codremitente, razonsocialremitente, coddestinatario, codproveedor, razonsocialproveedor, constancia) FROM stdin;
\.


--
-- TOC entry 4033 (class 0 OID 191967)
-- Dependencies: 218
-- Data for Name: guiasrdetalle; Type: TABLE DATA; Schema: almacen; Owner: phuyu15
--

COPY almacen.guiasrdetalle (codguiar, codproducto, codunidad, item, detalle, cantidad, estado, peso) FROM stdin;
\.


--
-- TOC entry 4034 (class 0 OID 191970)
-- Dependencies: 219
-- Data for Name: guiast; Type: TABLE DATA; Schema: almacen; Owner: phuyu15
--

COPY almacen.guiast (codguiat, codpersona, codusuario, codcomprobantetipo, seriecomprobante, nrocomprobante, codmodalidadtraslado, codmotivotraslado, fechatraslado, codigopuerto, transbordo, peso, nropaquetes, nrocontenedor, descripcionmotivo, observaciones, codempleado, codubigeopartida, direccionpartida, codubigeollegada, direccionllegada, coddocumentotipotransportista, documentotransportista, razonsocialtransportista, nroplaca, coddocumentotipoconductor, documentoconductor, razonsocialconductor, codalmacen, codsucursal, estado, codmovimientotipo, tipomovimiento, fechaguia) FROM stdin;
\.


--
-- TOC entry 4036 (class 0 OID 191984)
-- Dependencies: 221
-- Data for Name: guiastdetalle; Type: TABLE DATA; Schema: almacen; Owner: phuyu15
--

COPY almacen.guiastdetalle (codguiat, codproducto, codunidad, item, detalle, cantidad, estado) FROM stdin;
\.


--
-- TOC entry 4037 (class 0 OID 191987)
-- Dependencies: 222
-- Data for Name: inventariodetalle; Type: TABLE DATA; Schema: almacen; Owner: phuyu15
--

COPY almacen.inventariodetalle (codinventario, codproducto, codunidad, cantidad, preciocosto, precioventa, importecosto, igvcosto, importe, registrosanitario, fecharegistrosanitario, fechavencimiento, fechaproduccion, loteproduccion, cantidadconvertida) FROM stdin;
\.


--
-- TOC entry 4038 (class 0 OID 191997)
-- Dependencies: 223
-- Data for Name: inventarios; Type: TABLE DATA; Schema: almacen; Owner: phuyu15
--

COPY almacen.inventarios (codinventario, codsucursal, codalmacen, codmovimientotipo, codusuario, fechaapertura, fechacierre, descripcion, tipoinventario, importecosto, igvcosto, importe, estado, codkardex_ingreso, codkardex_salida) FROM stdin;
\.


--
-- TOC entry 4040 (class 0 OID 192010)
-- Dependencies: 225
-- Data for Name: kardexguiasr; Type: TABLE DATA; Schema: almacen; Owner: phuyu15
--

COPY almacen.kardexguiasr (codguiar, codkardex, codalmacen, codsucursal, codcomprobantetipok, seriecomprobantek, nrocomprobantek, codcomprobantetipogr, seriecomprobantegr, nrocomprobantegr, estado) FROM stdin;
\.


--
-- TOC entry 4041 (class 0 OID 192016)
-- Dependencies: 226
-- Data for Name: kardexguiasrdetalle; Type: TABLE DATA; Schema: almacen; Owner: phuyu15
--

COPY almacen.kardexguiasrdetalle (codguiar, codkardex, codalmacen, codsucursal, codproducto, codunidad, itemgr, itemgk, cantidad) FROM stdin;
\.


--
-- TOC entry 4042 (class 0 OID 192019)
-- Dependencies: 227
-- Data for Name: lineas; Type: TABLE DATA; Schema: almacen; Owner: phuyu15
--

COPY almacen.lineas (codlinea, descripcion, estado, color, background, abreviatura) FROM stdin;
0	SIN LINEA	1	ffffff	211783	S/L
1	LLANTAS	1	ffffff	211783	\N
2	ACEITE	1	ffffff	211783	\N
3	CREMALLERA	1	ffffff	211783	\N
4	BATERIA	1	ffffff	211783	\N
5	ARRASTRE	1	ffffff	211783	\N
6	EJE	1	ffffff	211783	\N
7	BUJIA	1	ffffff	211783	\N
8	CAMARAS	1	ffffff	211783	\N
9	TUBO DE ESCAPE	1	ffffff	211783	\N
10	AMOR	1	ffffff	211783	\N
11	BOBINA	1	ffffff	211783	\N
12	VALVULA	1	ffffff	211783	\N
13	CABLES	1	ffffff	211783	\N
14	ESTRIBO	1	ffffff	211783	\N
15	RODAJE	1	ffffff	211783	\N
17	ZAPATA	1	ffffff	211783	\N
18	PLASTICOS	1	ffffff	211783	\N
19	CABEZAL	1	ffffff	211783	\N
20	TANQUES	1	ffffff	211783	\N
21	ARRANQUE	1	ffffff	211783	\N
23	TAPA	1	ffffff	211783	\N
24	CARGUERO	1	ffffff	211783	\N
25	CILINDRO	1	ffffff	211783	\N
26	EMPAQUES	1	ffffff	211783	\N
27	CDI	1	ffffff	211783	\N
28	CATALINA	1	ffffff	211783	\N
29	ELECTRICIDAD	1	ffffff	211783	\N
16	CARBURADOR	1	ffffff	211783	\N
30	CHAPA	1	ffffff	211783	\N
31	TAPABARRO	1	ffffff	211783	\N
32	RAYOS	1	ffffff	211783	\N
33	PISTON	1	ffffff	211783	\N
34	CADENILLA	1	ffffff	211783	\N
36	DISCO EMBRIAGUE	1	ffffff	211783	\N
37	PEDAL	1	ffffff	211783	\N
39	PARADOR	1	ffffff	211783	\N
40	GRASA	1	ffffff	211783	\N
41	SILICONA	1	ffffff	211783	\N
42	SOLDIMIX	1	ffffff	211783	\N
43	BARRA	1	ffffff	211783	\N
45	PORTA CATALINA	1	ffffff	211783	\N
46	MASCARA	1	ffffff	211783	\N
47	SERVICIO	1	ffffff	211783	\N
48	PERNOS	1	ffffff	211783	\N
49	YUGO	1	ffffff	211783	\N
50	MICA	1	ffffff	211783	\N
51	BALINES	1	ffffff	211783	\N
52	MANGUERA	1	ffffff	211783	\N
38	CIGUEÑAL	1	ffffff	211783	\N
53	MANIJA	1	ffffff	211783	\N
54	BOMBA	1	ffffff	211783	\N
55	BALANCIN	1	ffffff	211783	\N
56	BENDIX	1	ffffff	211783	\N
57	RETEN	1	ffffff	211783	\N
58	TUBO	1	ffffff	211783	\N
59	CORONA	1	ffffff	211783	\N
60	GUIA	1	ffffff	211783	\N
61	ALTERNADOR	1	ffffff	211783	\N
62	ARRANCADOR	1	ffffff	211783	\N
63	CLAXON	1	ffffff	211783	\N
64	AISLADOR	1	ffffff	211783	\N
35	ANILLOS	1	ffffff	211783	\N
65	BASE DE DISCO	1	ffffff	211783	\N
66	CANDADO DE CADENA	1	ffffff	211783	\N
67	PIÑON	1	ffffff	211783	\N
68	VARILLA DE FRENO	1	ffffff	211783	\N
69	MANUBRIOS	1	ffffff	211783	\N
70	PASTILLA DE FRENO	1	ffffff	211783	\N
71	SELECTOR	1	ffffff	211783	\N
72	FILTRO	1	ffffff	211783	\N
73	CAPUCHON BUJIA	1	ffffff	211783	\N
74	ESPEJO	1	ffffff	211783	\N
44	FARO	1	ffffff	211783	\N
75	TEMPLADOR	1	ffffff	211783	\N
76	PASTILLA	1	ffffff	211783	\N
77	CAJA CAMBIO	1	ffffff	211783	\N
78	CANASTILLA	1	ffffff	211783	\N
79	BOCAMAZA	1	ffffff	211783	\N
80	CRUCETA	1	ffffff	211783	\N
81	RECTIFICADOR	1	ffffff	211783	\N
82	PARCHE	1	ffffff	211783	\N
83	GRIFO PASE GASOLINA	1	ffffff	211783	\N
84	PORTA FARO	1	ffffff	211783	\N
85	BRAZO DE FRENO	1	ffffff	211783	\N
86	PIN DE FRENO	1	ffffff	211783	\N
87	HUACHA	1	ffffff	211783	\N
88	MANO DE OBRA	1	ffffff	211783	\N
89	TABLERO	1	ffffff	211783	\N
90	MEDIALUNA	1	ffffff	211783	\N
91	FOCO	1	ffffff	211783	\N
92	BUJE	1	ffffff	211783	\N
93	JEBE	1	ffffff	211783	\N
22	ARO	1	ffffff	211783	\N
94	PIÑON TENSOR GUIA	1	ffffff	211783	\N
95	POLINES	1	ffffff	211783	\N
96	COMANDO	1	ffffff	211783	\N
97	VOLANTE	1	ffffff	211783	\N
98	TRAPECIO	1	ffffff	211783	\N
99	MEDIDOR DE ACEITE	1	ffffff	211783	\N
100	LEVAS	1	ffffff	211783	\N
\.


--
-- TOC entry 4044 (class 0 OID 192027)
-- Dependencies: 229
-- Data for Name: marcas; Type: TABLE DATA; Schema: almacen; Owner: phuyu15
--

COPY almacen.marcas (codmarca, descripcion, estado, abreviatura) FROM stdin;
0	SIN MARCA	1	\N
1	DURO	1	\N
2	MICHELLIN	1	\N
3	CILUBE	1	\N
4	SFX	1	\N
5	RIFFEL	1	\N
6	COPILAR	1	\N
7	NGK	1	\N
8	SFX GOLD	1	\N
9	NACHI	1	\N
10	SCP	1	\N
11	KRAIN	1	\N
12	CST	1	\N
13	KOCT	1	\N
14	BJR	1	\N
15	KIGCOL	1	\N
16	WY	1	\N
17	RALCO	1	\N
18	HONGJU	1	\N
19	PREMIUM	1	\N
20	CREVON	1	\N
21	YUANXING	1	\N
22	WHB	1	\N
23	D TIEX	1	\N
24	ZHENGHE	1	\N
25	KINGLON	1	\N
26	TECNI	1	\N
27	ZS//	1	\N
28	OSAKA	1	\N
29	TP	1	\N
30	AMERICAN	1	\N
31	PASOIL	1	\N
32	HONDA	1	\N
33	ABRO	1	\N
34	VALVOLINE	1	\N
35	VISTONY	1	\N
36	MOBIL	1	\N
37	MOTUL	1	\N
38	SUMOTO	1	\N
39	GDM	1	\N
40	REPSOL	1	\N
41	CHENG SHIN	1	\N
42	WB	1	\N
43	MCC (DORADO)	1	\N
44	TSK	1	\N
45	BS	1	\N
46	ZERO	1	\N
47	CAPSA	1	\N
48	RAYDER	1	\N
49	GOSTONE	1	\N
50	YAMALUBE	1	\N
51	STANLEY	1	\N
52	SHELL	1	\N
53	RODATECH	1	\N
54	CAILI	1	\N
55	ROVIL	1	\N
324	pawer flow	1	\N
\.


--
-- TOC entry 4046 (class 0 OID 192033)
-- Dependencies: 231
-- Data for Name: modalidadtraslado; Type: TABLE DATA; Schema: almacen; Owner: phuyu15
--

COPY almacen.modalidadtraslado (codmodalidadtraslado, modalidadtraslado, oficial, estado) FROM stdin;
\.


--
-- TOC entry 4048 (class 0 OID 192038)
-- Dependencies: 233
-- Data for Name: motivotraslado; Type: TABLE DATA; Schema: almacen; Owner: phuyu15
--

COPY almacen.motivotraslado (codmotivotraslado, descripcion, oficial, tipo, estado) FROM stdin;
1	VENTA	01	\N	1
2	COMPRA	02	\N	1
4	TRASLADO ENTRE ESTABLECIMIENTOS DE UNA MISMA EMPRESA	04	\N	1
8	IMPORTACION	08	\N	1
9	EXPORTACION	09	\N	1
3	DEVOLUCION	13	\N	1
14	OTROS MOTIVOS	13	\N	1
5	TRASLADO DE BIENES PARA PRODUCCION	05	\N	1
6	TRASLADO DE BIENES PARA MANIPULACION	06	\N	1
7	RECOJO DE BIENES	07	\N	1
10	VENTA A DESTINATARIO NO INSCRITO EN EL REGISTRO, POR ENCONTRARSE COMPRENDIDA EN LAS EXCEPCIONES QUE SEÑALA EL ARTICULO 16° DEL DECRETO O POR SER USUARIO DOMESTICO	10	\N	1
11	VENTA CON ENTREGA A TERCEROS	11	\N	1
12	PRESTACION DE SERVICIOS	12	\N	1
13	NUEVA EMISION POR CAMBIO DE DESTINATARIO	13	\N	1
\.


--
-- TOC entry 4050 (class 0 OID 192043)
-- Dependencies: 235
-- Data for Name: movimientotipos; Type: TABLE DATA; Schema: almacen; Owner: phuyu15
--

COPY almacen.movimientotipos (codmovimientotipo, descripcion, tipo, oficial, origen, estado) FROM stdin;
1	SALDO INICIAL	1	16	0	1
2	INGRESO X COMPRA	1	2	2	1
3	INGRESO X AJUSTES	1	2	3	1
4	INGRESO X FALTANTES	1	3	3	1
5	INGRESO X MIGRACION	1	5	3	1
6	INGRESO X CONSIGNACION RECIBIDA	1	3	3	1
7	INGRESO X PRESTAMOS RECIBIDOS	1	7	3	1
9	INGRESO X INVENTARIO	1	9	0	1
8	INGRESO X NOTA DE CREDITO VENTA	1	6	2	1
10	INGRESO X PRODUCCION	1	10	3	1
11	INGRESO X DEV PRESTAMOS OTORGADOS	1	11	3	1
12	INGRESO X TRANSFERENCIA ALMACEN	1	11	3	1
32	SALIDA X SINIESTRO ASALTO ROBO	2	13	3	1
31	SALIDA X DEV DE COMPRA MERCADERIA	2	31	3	1
13	INGRESO X DEV DE VENTA MERCADERIA	1	12	3	1
14	INGRESO X STOCK PARA FACTURAR	1	15	3	1
15	INGRESO X GARANTIA PROVEEDOR	1	15	3	1
16	INGRESO X RECLAMO GARANTIA CLIENTE	1	1	3	1
17	INGRESO X AJUSTE INVENTARIO FIN DE AÑO	1	18	3	1
18	INGRESO X RECUPERACION DE MERCADERIA X FALTA DE PAGO	1	19	3	1
19	INGRESO X DEVOLUCION DE ENVASES	1	20	3	1
20	SALIDA X VENTA	2	1	2	1
21	SALIDA X AJUSTES	2	2	3	1
22	SALIDA X SOBRANTES	2	23	3	1
33	SALIDA X CONSUMO INTERNO	2	33	3	1
23	SALIDA X OTROS MOVIMIENTOS	2	4	3	1
34	SALIDA X RECLAMO GARANTIA PROVEEDOR	2	15	3	1
24	SALIDA X CONSIGNACION ENTREGADA	2	4	3	1
35	SALIDA X CAMBIO PARTE GARANTIA CLIENTE	2	16	3	1
36	SALIDA X AJUSTE DE INVENTARIO FIN DE AÑO	2	17	0	1
37	SALIDA X DEVOLUCION DE MERCADERIA X FALTA DE PAGO	2	18	3	1
38	SALIDA X CONTENIDO DE ENVASES	2	19	3	1
39	SALIDA X EVAPORACION	2	20	3	1
25	SALIDA X PRESTAMOS OTORGADOS	2	6	3	1
26	SALIDA X NOTA DE CREDITO COMPRA	2	5	2	1
27	SALIDA X DETERIORO	2	15	3	1
28	SALIDA X PRODUCCION	2	10	3	1
29	SALIDA X DEV PRESTAMOS RECIBIDOS	2	10	3	1
30	SALIDA X TRANSFERENCIA DE ALMACEN	2	11	3	1
\.


--
-- TOC entry 4052 (class 0 OID 192050)
-- Dependencies: 237
-- Data for Name: presentacion; Type: TABLE DATA; Schema: almacen; Owner: phuyu15
--

COPY almacen.presentacion (codpresentacion, descripcion, oficial, estado) FROM stdin;
0	NINGUNA	\N	1
2	PAQUETE	\N	1
3	BOLSA	\N	1
5	BLISTER	\N	1
6	TABLETA	\N	1
7	COJIN	\N	1
1	FRASCO	\N	1
4	CAJA	\N	1
8	ROLLO	\N	1
9	KIT	\N	1
10	TABLON	\N	1
11	UNIDAD	\N	1
12	SOBRE	\N	1
13	CAPSULA	\N	1
14	CREMA	\N	1
15	UNITOMA	\N	1
18	POTE	\N	1
20	GOTAS	\N	1
19	OVULO	\N	0
17	JARABE	\N	0
16	AMPOLLA	\N	0
21	GALON	\N	1
22	NINGUNO	\N	1
\.


--
-- TOC entry 4054 (class 0 OID 192056)
-- Dependencies: 239
-- Data for Name: principioactivo; Type: TABLE DATA; Schema: almacen; Owner: phuyu15
--

COPY almacen.principioactivo (codprincipioactivo, codfamilia, codlinea, codempresa, codigo, descripcion, estado) FROM stdin;
0	0	0	1		SIN PRINCIPIO ACTIVO	1
\.


--
-- TOC entry 4056 (class 0 OID 192065)
-- Dependencies: 241
-- Data for Name: productos; Type: TABLE DATA; Schema: almacen; Owner: phuyu15
--

COPY almacen.productos (codproducto, codfamilia, codlinea, codmarca, codempresa, codigo, descripcion, afectoicbper, controlstock, afectoigvcompra, afectoigvventa, foto, estado, calcular, paraventa, codatencion, caracteristicas, codoficial, sexo, codmodelo, codcolor, codtalla, concaducidad, conrecetamedica, codpresentacion, codprincipioactivo, indicaciones, composicion, viaadministracion, advertencias, precauciones, contraindicaciones, almacenamiento) FROM stdin;
1	337	2	33	1	0001	ejemplo	0	1	0	0	default.png	1	0	1	0	s	\N	0	0	\N	0	0	0	21	0							
2	0	0	0	1	0002	ejemplo 02	0	1	0	0	default.png	1	0	1	0		\N	0	0	\N	0	0	0	11	0							
3	337	2	37	1	0003	Motul 5100	0	1	0	0	default.png	1	0	1	0		\N	0	0	\N	0	0	0	1	0							
4	0	0	0	1	0004	mantenimiento	0	0	0	0	default.png	1	0	1	0		\N	0	0	\N	0	0	0	11	0							
5	337	2	37	1	0005	Motul 3000 	0	1	0	0	default.png	1	0	1	0		\N	0	0	\N	0	0	0	1	0							
6	337	2	324	1	0006	Pawer Flow	0	1	0	0	default.png	1	0	1	0		\N	0	0	\N	0	0	0	1	0							
23	346	17	14	1	00023	zapatas 	0	1	0	0	default.png	1	0	1	0		\N	0	0	\N	0	0	0	11	0							
7	337	2	14	1	0007	ACEITE VISTONY	0	1	0	0	default.png	1	0	1	0		\N	0	0	\N	0	0	0	1	0							
8	340	8	1	1	0008	camara 300x18 duro	0	1	0	0	default.png	1	0	1	0		\N	0	0	\N	0	0	0	3	0							
9	341	0	33	1	0009	cadena de arrastre	0	1	0	0	default.png	1	0	1	0		\N	0	0	\N	0	0	0	5	0							
10	342	0	13	1	00010	catalina numero 37	0	1	0	0	default.png	1	0	1	0		\N	0	0	\N	0	0	0	3	0							
11	342	0	18	1	00011	catalina numero 42	0	1	0	0	default.png	1	0	1	0		\N	0	0	\N	0	0	0	11	0							
12	343	0	33	1	00012	catalina 45	0	1	0	0	default.png	1	0	1	0		\N	0	0	\N	0	0	0	11	0							
13	75	0	33	1	00013	catalina numerto 36	0	1	0	0	default.png	1	0	1	0		\N	0	0	\N	0	0	0	0	0							
14	345	0	0	1	00014	carburador de motor estacionario	0	1	0	0	default.png	1	0	1	0		\N	0	0	\N	0	0	0	0	0							
15	0	0	27	1	00015	cargador y adaptacion	0	1	0	0	default.png	1	0	1	0		\N	0	0	\N	0	0	0	11	0							
16	337	2	27	1	00016	hidrolina	0	1	0	0	default.png	1	0	1	0		\N	0	0	\N	0	0	0	11	0							
17	344	0	0	1	00017	mantenimiento de moto	0	1	0	0	default.png	1	0	1	0		\N	0	0	\N	0	0	0	11	0							
18	7	0	7	1	00018	bujia	0	1	0	0	default.png	1	0	1	0		\N	0	0	\N	0	0	0	11	0							
19	343	0	0	1	00019	chupon	0	1	0	0	default.png	1	0	1	0		\N	0	0	\N	0	0	0	11	0							
20	343	0	14	1	00020	batería 12n7	0	1	0	0	default.png	1	0	1	0		\N	0	0	\N	0	0	0	11	0							
21	337	2	27	1	00021	aceite multigrado 25w60	0	1	0	0	default.png	1	0	1	0		\N	0	0	\N	0	0	0	11	0							
22	337	2	27	1	00022	reten de tapa de balancines 	0	1	0	0	default.png	1	0	1	0		\N	0	0	\N	0	0	0	11	0							
24	0	0	27	1	00024	kit de sistema de arrastre	0	1	0	0	default.png	1	0	1	0		\N	0	0	\N	0	0	0	11	0							
25	346	17	27	1	00025	aceite pasoil sintetico	0	1	0	0	default.png	1	0	1	0		\N	0	0	\N	0	0	0	11	0							
26	337	2	33	1	00026	palanca de cambios	0	1	0	0	default.png	1	0	1	0		\N	0	0	\N	0	0	0	11	0							
27	337	2	33	1	00027	llanta 300x18 pantanera	0	1	0	0	default.png	1	0	1	0		\N	0	0	\N	0	0	0	11	0							
28	337	2	33	1	00028	cable de embrague	0	1	0	0	default.png	1	0	1	0		\N	0	0	\N	0	0	0	11	0							
29	337	2	33	1	00029	mano de obra general	0	0	0	0	default.png	1	0	1	0		\N	0	0	\N	0	0	0	11	0							
30	337	2	33	1	00030	camara de furgon 500x12	0	1	0	0	default.png	1	0	1	0		\N	0	0	\N	0	0	0	11	0							
31	337	2	33	1	00031	kit de discos de embrague	0	1	0	0	default.png	1	0	1	0		\N	0	0	\N	0	0	0	11	0							
32	337	2	33	1	00032	mano de obra por servicio técnico de motor	0	0	0	0	default.png	1	0	1	0		\N	0	0	\N	0	0	0	11	0							
33	337	2	33	1	00033	rodaje japones para caja de cambios	0	1	0	0	default.png	1	0	1	0		\N	0	0	\N	0	0	0	11	0							
34	337	2	33	1	00034	kit de empaques 	0	1	0	0	default.png	1	0	1	0		\N	0	0	\N	0	0	0	11	0							
35	337	2	33	1	00035	kit de retenes 	0	1	0	0	default.png	1	0	1	0		\N	0	0	\N	0	0	0	11	0							
36	337	2	33	1	00036	servicio de torno	0	0	0	0	default.png	1	0	1	0		\N	0	0	\N	0	0	0	11	0							
37	337	2	33	1	00037	kit de árbol de levas	0	1	0	0	default.png	1	0	1	0		\N	0	0	\N	0	0	0	11	0							
38	337	2	33	1	00038	mantenimiento furgón	0	1	0	0	default.png	1	0	1	0		\N	0	0	\N	0	0	0	11	0							
39	337	2	33	1	00039	cable de freno	0	1	0	0	default.png	1	0	1	0		\N	0	0	\N	0	0	0	11	0							
40	337	2	33	1	00040	cable de celular 	0	1	0	0	default.png	1	0	1	0		\N	0	0	\N	0	0	0	11	0							
41	337	2	33	1	00041	bebidas gasificadas	0	1	0	0	default.png	1	0	1	0		\N	0	0	\N	0	0	0	11	0							
42	337	2	33	1	00042	 piñón 	0	1	0	0	default.png	1	0	1	0		\N	0	0	\N	0	0	0	11	0							
\.


--
-- TOC entry 4058 (class 0 OID 192093)
-- Dependencies: 243
-- Data for Name: productoubicacion; Type: TABLE DATA; Schema: almacen; Owner: phuyu15
--

COPY almacen.productoubicacion (codalmacen, codproducto, codunidad, codsucursal, stockactual, stockactualreal, preciostockvalorizado, ventarecogo, comprarecogo, stockminimo, stockmaximo, estado, stockactualconvertido, factor, preciocompra, pventapublico, pventamin, pventacredito, pventaxmayor, pventaadicional, preciocosto, gastos, codigobarra) FROM stdin;
1	1	68	1	0.0000	0.0000	0.000000	0.0000	0.0000	0.0000	0.0000	1	0.0000	1.000000	3.0000	6.0000	0.0000	0.0000	0.0000	0.0000	3.0000	0.0000	
1	2	68	1	-1.0000	0.0000	0.000000	0.0000	0.0000	0.0000	0.0000	1	-1.0000	1.000000	4.0000	5.0000	4.5000	6.0000	4.5000	0.0000	4.0000	0.0000	
1	20	68	1	-1.0000	0.0000	0.000000	0.0000	0.0000	0.0000	0.0000	1	-1.0000	1.000000	50.0000	75.0000	74.0000	0.0000	0.0000	0.0000	50.0000	0.0000	
1	24	68	1	-3.0000	0.0000	0.000000	0.0000	0.0000	0.0000	0.0000	1	-3.0000	1.000000	30.0000	50.0000	50.0000	0.0000	0.0000	0.0000	30.0000	0.0000	
1	22	68	1	-1.0000	0.0000	0.000000	0.0000	0.0000	0.0000	0.0000	1	-1.0000	1.000000	3.0000	5.0000	4.0000	0.0000	0.0000	0.0000	3.0000	0.0000	
1	37	68	1	-1.0000	0.0000	0.000000	0.0000	0.0000	0.0000	0.0000	1	-1.0000	1.000000	25.0000	39.0000	39.0000	0.0000	0.0000	0.0000	25.0000	0.0000	
1	39	68	1	-1.0000	0.0000	0.000000	0.0000	0.0000	0.0000	0.0000	1	-1.0000	1.000000	15.0000	15.0000	15.0000	0.0000	0.0000	0.0000	15.0000	0.0000	
1	29	68	1	-4.0000	0.0000	0.000000	0.0000	0.0000	0.0000	0.0000	1	-4.0000	1.000000	25.0000	25.0000	25.0000	0.0000	0.0000	0.0000	25.0000	0.0000	
1	36	68	1	-1.0000	0.0000	0.000000	0.0000	0.0000	0.0000	0.0000	1	-1.0000	1.000000	60.0000	60.0000	60.0000	0.0000	0.0000	0.0000	60.0000	0.0000	
1	5	68	1	-1.0000	0.0000	0.000000	0.0000	0.0000	0.0000	0.0000	1	-1.0000	1.000000	23.0000	27.0000	26.0000	0.0000	0.0000	0.0000	23.0000	0.0000	
1	6	68	1	0.0000	0.0000	0.000000	0.0000	0.0000	0.0000	0.0000	1	0.0000	1.000000	8.0000	16.0000	15.0000	0.0000	0.0000	0.0000	8.0000	0.0000	
1	25	68	1	-1.0000	0.0000	0.000000	0.0000	0.0000	0.0000	0.0000	1	-1.0000	1.000000	13.0000	25.0000	24.0000	0.0000	0.0000	0.0000	13.0000	0.0000	
1	26	68	1	-1.0000	0.0000	0.000000	0.0000	0.0000	0.0000	0.0000	1	-1.0000	1.000000	6.0000	12.0000	11.0000	0.0000	0.0000	0.0000	6.0000	0.0000	
1	35	68	1	-1.0000	0.0000	0.000000	0.0000	0.0000	0.0000	0.0000	1	-1.0000	1.000000	13.0000	15.0000	15.0000	0.0000	0.0000	0.0000	13.0000	0.0000	
1	40	68	1	-1.0000	0.0000	0.000000	0.0000	0.0000	0.0000	0.0000	1	-1.0000	1.000000	15.0000	15.0000	15.0000	0.0000	0.0000	0.0000	15.0000	0.0000	
1	8	68	1	-1.0000	0.0000	0.000000	0.0000	0.0000	0.0000	0.0000	1	-1.0000	1.000000	14.0000	20.0000	19.0000	0.0000	0.0000	0.0000	14.0000	0.0000	
1	9	68	1	0.0000	0.0000	0.000000	0.0000	0.0000	0.0000	0.0000	1	0.0000	1.000000	15.0000	23.0000	22.0000	0.0000	0.0000	0.0000	15.0000	0.0000	
1	10	68	1	0.0000	0.0000	0.000000	0.0000	0.0000	0.0000	0.0000	1	0.0000	1.000000	9.0000	11.0000	10.0000	0.0000	0.0000	0.0000	9.0000	0.0000	
1	11	68	1	0.0000	0.0000	0.000000	0.0000	0.0000	0.0000	0.0000	1	0.0000	1.000000	10.0000	13.0000	12.0000	0.0000	0.0000	0.0000	10.0000	0.0000	
1	12	68	1	0.0000	0.0000	0.000000	0.0000	0.0000	0.0000	0.0000	1	0.0000	1.000000	11.0000	14.0000	13.0000	0.0000	0.0000	0.0000	11.0000	0.0000	
1	13	68	1	0.0000	0.0000	0.000000	0.0000	0.0000	0.0000	0.0000	1	0.0000	1.000000	7.0000	13.0000	12.0000	0.0000	0.0000	0.0000	7.0000	0.0000	
1	18	68	1	0.0000	0.0000	0.000000	0.0000	0.0000	0.0000	0.0000	1	0.0000	1.000000	6.0000	7.0000	7.0000	0.0000	0.0000	0.0000	6.0000	0.0000	
1	27	68	1	-1.0000	0.0000	0.000000	0.0000	0.0000	0.0000	0.0000	1	-1.0000	1.000000	55.0000	85.0000	80.0000	0.0000	0.0000	0.0000	55.0000	0.0000	
1	3	68	1	-3.0000	0.0000	0.000000	0.0000	0.0000	0.0000	0.0000	1	-3.0000	1.000000	27.0000	35.0000	34.0000	0.0000	0.0000	0.0000	27.0000	0.0000	
1	34	68	1	-1.0000	0.0000	0.000000	0.0000	0.0000	0.0000	0.0000	1	-1.0000	1.000000	15.0000	16.0000	16.0000	0.0000	0.0000	0.0000	15.0000	0.0000	
1	15	68	1	-1.0000	0.0000	0.000000	0.0000	0.0000	0.0000	0.0000	1	-1.0000	1.000000	10.0000	75.0000	70.0000	0.0000	0.0000	0.0000	10.0000	0.0000	
1	28	68	1	-1.0000	0.0000	0.000000	0.0000	0.0000	0.0000	0.0000	1	-1.0000	1.000000	1.0000	2.0000	2.0000	0.0000	0.0000	0.0000	1.0000	0.0000	
1	16	8	1	-1.0000	0.0000	0.000000	0.0000	0.0000	0.0000	0.0000	1	-1.0000	1.000000	5.0000	12.0000	10.0000	0.0000	0.0000	0.0000	5.0000	0.0000	
1	17	68	1	-1.0000	0.0000	0.000000	0.0000	0.0000	0.0000	0.0000	1	-1.0000	1.000000	25.0000	25.0000	25.0000	0.0000	0.0000	0.0000	25.0000	0.0000	
1	14	8	1	-1.0000	0.0000	0.000000	0.0000	0.0000	0.0000	0.0000	1	-1.0000	1.000000	45.0000	70.0000	69.0000	0.0000	0.0000	0.0000	45.0000	0.0000	
1	33	68	1	-1.0000	0.0000	0.000000	0.0000	0.0000	0.0000	0.0000	1	-1.0000	1.000000	20.0000	25.0000	24.0000	0.0000	0.0000	0.0000	20.0000	0.0000	
1	19	8	1	-1.0000	0.0000	0.000000	0.0000	0.0000	0.0000	0.0000	1	-1.0000	1.000000	7.0000	10.0000	10.0000	0.0000	0.0000	0.0000	7.0000	0.0000	
1	4	68	1	-4.0000	0.0000	0.000000	0.0000	0.0000	0.0000	0.0000	1	-4.0000	1.000000	25.0000	26.0000	25.0000	0.0000	0.0000	0.0000	25.0000	0.0000	
1	41	68	1	-1.0000	0.0000	0.000000	0.0000	0.0000	0.0000	0.0000	1	-1.0000	1.000000	10.0000	10.0000	10.0000	0.0000	0.0000	0.0000	10.0000	0.0000	
1	32	68	1	-1.0000	0.0000	0.000000	0.0000	0.0000	0.0000	0.0000	1	-1.0000	1.000000	120.0000	120.0000	120.0000	0.0000	0.0000	0.0000	120.0000	0.0000	
1	31	68	1	-1.0000	0.0000	0.000000	0.0000	0.0000	0.0000	0.0000	1	-1.0000	1.000000	20.0000	25.0000	25.0000	0.0000	0.0000	0.0000	20.0000	0.0000	
1	7	68	1	-9.0000	0.0000	0.000000	0.0000	0.0000	0.0000	0.0000	1	-9.0000	1.000000	13.0000	20.0000	19.0000	0.0000	0.0000	0.0000	13.0000	0.0000	
1	30	68	1	-1.0000	0.0000	0.000000	0.0000	0.0000	0.0000	0.0000	1	-1.0000	1.000000	15.0000	20.0000	20.0000	0.0000	0.0000	0.0000	15.0000	0.0000	
1	38	68	1	-1.0000	0.0000	0.000000	0.0000	0.0000	0.0000	0.0000	1	-1.0000	1.000000	25.0000	25.0000	25.0000	0.0000	0.0000	0.0000	25.0000	0.0000	
1	23	68	1	-2.0000	0.0000	0.000000	0.0000	0.0000	0.0000	0.0000	1	-2.0000	1.000000	6.0000	12.0000	10.0000	0.0000	0.0000	0.0000	6.0000	0.0000	
1	21	68	1	-6.0000	0.0000	0.000000	0.0000	0.0000	0.0000	0.0000	1	-6.0000	1.000000	11.0000	20.0000	19.0000	0.0000	0.0000	0.0000	11.0000	0.0000	
1	42	68	1	0.0000	0.0000	0.000000	0.0000	0.0000	0.0000	0.0000	1	0.0000	1.000000	3.0000	5.0000	5.0000	0.0000	0.0000	0.0000	3.0000	0.0000	
\.


--
-- TOC entry 4059 (class 0 OID 192114)
-- Dependencies: 244
-- Data for Name: productounidades; Type: TABLE DATA; Schema: almacen; Owner: phuyu15
--

COPY almacen.productounidades (codproducto, codunidad, codsucursal, factor, preciocompra, pventapublico, pventamin, pventacredito, pventaxmayor, pventaadicional, preciocosto, gastos, codigobarra, estado, unidad) FROM stdin;
1	68	1	1.000000	3.0000	6.0000	0.0000	0.0000	0.0000	0.0000	3.0000	0.0000		1	\N
2	68	1	1.000000	4.0000	5.0000	4.5000	6.0000	4.5000	0.0000	4.0000	0.0000		1	\N
3	68	1	1.000000	27.0000	35.0000	34.0000	0.0000	0.0000	0.0000	27.0000	0.0000		1	\N
4	68	1	1.000000	25.0000	26.0000	25.0000	0.0000	0.0000	0.0000	25.0000	0.0000		1	\N
5	68	1	1.000000	23.0000	27.0000	26.0000	0.0000	0.0000	0.0000	23.0000	0.0000		1	\N
6	68	1	1.000000	8.0000	16.0000	15.0000	0.0000	0.0000	0.0000	8.0000	0.0000		1	\N
7	68	1	1.000000	13.0000	20.0000	19.0000	0.0000	0.0000	0.0000	13.0000	0.0000		1	\N
8	68	1	1.000000	14.0000	20.0000	19.0000	0.0000	0.0000	0.0000	14.0000	0.0000		1	\N
9	68	1	1.000000	15.0000	23.0000	22.0000	0.0000	0.0000	0.0000	15.0000	0.0000		1	\N
10	68	1	1.000000	9.0000	11.0000	10.0000	0.0000	0.0000	0.0000	9.0000	0.0000		1	\N
11	68	1	1.000000	10.0000	13.0000	12.0000	0.0000	0.0000	0.0000	10.0000	0.0000		1	\N
12	68	1	1.000000	11.0000	14.0000	13.0000	0.0000	0.0000	0.0000	11.0000	0.0000		1	\N
13	68	1	1.000000	7.0000	13.0000	12.0000	0.0000	0.0000	0.0000	7.0000	0.0000		1	\N
14	8	1	1.000000	45.0000	70.0000	69.0000	0.0000	0.0000	0.0000	45.0000	0.0000		1	\N
15	68	1	1.000000	10.0000	75.0000	70.0000	0.0000	0.0000	0.0000	10.0000	0.0000		1	\N
16	8	1	1.000000	5.0000	12.0000	10.0000	0.0000	0.0000	0.0000	5.0000	0.0000		1	\N
17	68	1	1.000000	25.0000	25.0000	25.0000	0.0000	0.0000	0.0000	25.0000	0.0000		1	\N
18	68	1	1.000000	6.0000	7.0000	7.0000	0.0000	0.0000	0.0000	6.0000	0.0000		1	\N
19	8	1	1.000000	7.0000	10.0000	10.0000	0.0000	0.0000	0.0000	7.0000	0.0000		1	\N
20	68	1	1.000000	50.0000	75.0000	74.0000	0.0000	0.0000	0.0000	50.0000	0.0000		1	\N
21	68	1	1.000000	11.0000	20.0000	19.0000	0.0000	0.0000	0.0000	11.0000	0.0000		1	\N
22	68	1	1.000000	3.0000	5.0000	4.0000	0.0000	0.0000	0.0000	3.0000	0.0000		1	\N
23	68	1	1.000000	6.0000	12.0000	10.0000	0.0000	0.0000	0.0000	6.0000	0.0000		1	\N
24	68	1	1.000000	30.0000	50.0000	50.0000	0.0000	0.0000	0.0000	30.0000	0.0000		1	\N
25	68	1	1.000000	13.0000	25.0000	24.0000	0.0000	0.0000	0.0000	13.0000	0.0000		1	\N
26	68	1	1.000000	6.0000	12.0000	11.0000	0.0000	0.0000	0.0000	6.0000	0.0000		1	\N
27	68	1	1.000000	55.0000	85.0000	80.0000	0.0000	0.0000	0.0000	55.0000	0.0000		1	\N
28	68	1	1.000000	1.0000	2.0000	2.0000	0.0000	0.0000	0.0000	1.0000	0.0000		1	\N
29	68	1	1.000000	25.0000	25.0000	25.0000	0.0000	0.0000	0.0000	25.0000	0.0000		1	\N
30	68	1	1.000000	15.0000	20.0000	20.0000	0.0000	0.0000	0.0000	15.0000	0.0000		1	\N
31	68	1	1.000000	20.0000	25.0000	25.0000	0.0000	0.0000	0.0000	20.0000	0.0000		1	\N
32	68	1	1.000000	120.0000	120.0000	120.0000	0.0000	0.0000	0.0000	120.0000	0.0000		1	\N
33	68	1	1.000000	20.0000	25.0000	24.0000	0.0000	0.0000	0.0000	20.0000	0.0000		1	\N
34	68	1	1.000000	15.0000	16.0000	16.0000	0.0000	0.0000	0.0000	15.0000	0.0000		1	\N
35	68	1	1.000000	13.0000	15.0000	15.0000	0.0000	0.0000	0.0000	13.0000	0.0000		1	\N
36	68	1	1.000000	60.0000	60.0000	60.0000	0.0000	0.0000	0.0000	60.0000	0.0000		1	\N
37	68	1	1.000000	25.0000	39.0000	39.0000	0.0000	0.0000	0.0000	25.0000	0.0000		1	\N
38	68	1	1.000000	25.0000	25.0000	25.0000	0.0000	0.0000	0.0000	25.0000	0.0000		1	\N
39	68	1	1.000000	15.0000	15.0000	15.0000	0.0000	0.0000	0.0000	15.0000	0.0000		1	\N
40	68	1	1.000000	15.0000	15.0000	15.0000	0.0000	0.0000	0.0000	15.0000	0.0000		1	\N
41	68	1	1.000000	10.0000	10.0000	10.0000	0.0000	0.0000	0.0000	10.0000	0.0000		1	\N
42	68	1	1.000000	3.0000	5.0000	5.0000	0.0000	0.0000	0.0000	3.0000	0.0000		1	\N
\.


--
-- TOC entry 4060 (class 0 OID 192128)
-- Dependencies: 245
-- Data for Name: unidades; Type: TABLE DATA; Schema: almacen; Owner: phuyu15
--

COPY almacen.unidades (codunidad, descripcion, oficial, estado) FROM stdin;
1	UNIDAD (BIENES)	NIU	1
2	ANULADO	ANU	0
4	BALDE	BJ	1
6	BOLSA	BG	1
7	BOTELLAS	BO	1
13	CIENTO DE UNIDADES	CEN	1
14	CILINDRO	CY	1
16	DOCENA	DZN	1
18	FARDO	BE	1
23	JUEGO	SET	1
24	KILOGRAMO	KGM	1
27	KIT	KT	1
29	LITRO	LTR	1
32	METRO	MTR	1
33	METRO CUADRADO	MTK	1
34	METRO CUBICO	MTQ	1
39	MILLARES	MLL	1
42	PALETAS	PF	1
43	PAQUETE	PK	1
44	PAR	PR	1
45	PIES	FOT	1
48	PIEZAS	C62	1
52	PULGADAS	INH	1
56	TONELADAS	TNE	1
57	TUBOS	TU	1
58	UNIDAD (SERVICIOS)	ZZ	1
60	YARDA CUADRADA	YDK	0
59	YARDA	YRD	0
55	TONELADA LARGA	LTN	0
54	TONELADA CORTA	STN	0
53	TAMBOR	DR	0
51	RESMA	RM	0
50	PLIEGO	ST	0
49	PLACAS	PG	0
41	ONZAS	ONZ	0
40	MILLON DE UNIDADES	UM	0
38	MILIMETRO CUBICO	MMQ	0
37	MILIMETRO CUADRADO	MMK	0
36	MILIMETRO	MLT	0
35	MILIGRAMOS	MGM	0
31	MEGAWATT HORA	MWH	0
30	LIBRAS	LBR	0
26	KILOVATIO HORA	KWH	0
25	KILOMETRO	KTM	0
28	LATAS	CA	0
22	HOJA	LEF	0
20	GRUESA	GRO	0
19	GRAMO	GRM	0
17	DOCENA POR 10**6	DZP	0
12	CENTIMETRO LINEAL	CMT	0
11	CENTIMETRO CUBICO	CMQ	0
10	CENTIMETRO CUADRADO	CMK	0
9	CARTONES	CT	0
5	BARRILES	BLL	0
3	BOBINAS	4A	0
15	CONOS	CJ	0
21	HECTOLITRO	HLT	0
47	PIES CUBICOS	FTQ	0
46	PIES CUADRADOS	FTK	0
61	GALON INGLES	GLI	1
62	US GALON	GLL	1
63	FRASCO	NIU	1
64	TABLETA	NIU	1
65	CAPSULA	NIU	1
66	PACK	NIU	1
67	SOBRE	NIU	1
68	UNIDAD	NIU	1
69	GOTAS	NIU	1
70	TIRAS	NIU	1
71	CASSETTE	NIU	1
72	TUBO	NIU	1
8	UNIDAD	BX	1
73	CAJA	NIU	1
\.


--
-- TOC entry 4062 (class 0 OID 192139)
-- Dependencies: 248
-- Data for Name: vehiculos; Type: TABLE DATA; Schema: almacen; Owner: phuyu15
--

COPY almacen.vehiculos (codvehiculo, nroplaca, codvehiculocategoria, codvehiculomarca, aniofabricacion, codvehiculomodelo, nrocertinscripcion, configuracionvehicular, color, nroserie, nromotor, codpersona, codusuario, descripcion, caracteristicas, codconductor, conductor, licenciadeconducir, constancia, estado) FROM stdin;
\.


--
-- TOC entry 4064 (class 0 OID 192148)
-- Dependencies: 250
-- Data for Name: vehiculoscategorias; Type: TABLE DATA; Schema: almacen; Owner: phuyu15
--

COPY almacen.vehiculoscategorias (codvehiculocategoria, descripcion, estado) FROM stdin;
\.


--
-- TOC entry 4066 (class 0 OID 192154)
-- Dependencies: 252
-- Data for Name: vehiculosmarcas; Type: TABLE DATA; Schema: almacen; Owner: phuyu15
--

COPY almacen.vehiculosmarcas (codvehiculomarca, descripcion, estado) FROM stdin;
\.


--
-- TOC entry 4068 (class 0 OID 192160)
-- Dependencies: 254
-- Data for Name: vehiculosmodelos; Type: TABLE DATA; Schema: almacen; Owner: phuyu15
--

COPY almacen.vehiculosmodelos (codvehiculomodelo, codvehiculomarca, descripcion, estado) FROM stdin;
\.


--
-- TOC entry 4070 (class 0 OID 192166)
-- Dependencies: 256
-- Data for Name: bancos; Type: TABLE DATA; Schema: caja; Owner: phuyu15
--

COPY caja.bancos (codbanco, descripcion, abreviatura, oficial, tipobanco, estado) FROM stdin;
\.


--
-- TOC entry 4072 (class 0 OID 192173)
-- Dependencies: 258
-- Data for Name: cajas; Type: TABLE DATA; Schema: caja; Owner: phuyu15
--

COPY caja.cajas (codcaja, codsucursal, descripcion, direccion, telefonos, estado, saldarautomaticamente) FROM stdin;
1	1	JUAN GUERRA	Jr.Tahuantinsuyo N844	972895288	1	0
\.


--
-- TOC entry 4074 (class 0 OID 192180)
-- Dependencies: 260
-- Data for Name: centrocostos; Type: TABLE DATA; Schema: caja; Owner: phuyu15
--

COPY caja.centrocostos (codcentrocosto, descripcion, centrocosto, ctacontableabono, ctacontablecargo, ctacontabledebe, ctacontablehaber, estado) FROM stdin;
\.


--
-- TOC entry 4076 (class 0 OID 192186)
-- Dependencies: 262
-- Data for Name: comprobantes; Type: TABLE DATA; Schema: caja; Owner: phuyu15
--

COPY caja.comprobantes (codcomprobantetipo, seriecomprobante, nrocorrelativo, codsucursal, codcaja, codalmacen, nroinicial, nroitems, codcomprobantetipo_ref, seriecomprobante_ref, impresion, formato, orientacion, impresora, estado) FROM stdin;
16	GR01	0	1	0	0	1	0	0		0	a4	p		1
2	RE01	0	1	1	0	1	0	0		0	a4	p		1
3	NE01	0	1	0	1	1	0	0		0	a4	p		1
9	PF01	0	1	0	0	1	0	0		0	a4	p		1
5	NV01	10	1	0	0	1	0	0		0	a4	p		1
10	F001	11	1	0	0	1	0	0		0	ticket	p		1
4	NS01	22	1	0	1	1	0	0		0	a4	p		1
1	RI01	22	1	1	0	1	0	0		0	a4	p		1
12	B001	1	1	0	0	1	0	0		0	a4	p		1
\.


--
-- TOC entry 4077 (class 0 OID 192198)
-- Dependencies: 263
-- Data for Name: comprobantetipos; Type: TABLE DATA; Schema: caja; Owner: phuyu15
--

COPY caja.comprobantetipos (codcomprobantetipo, descripcion, abreviatura, oficial, origen, control, estado) FROM stdin;
0	SIN COMPROBANTE	SIN	00	1	0	0
1	RECIBO INGRESO	RIC	00	1	0	1
2	RECIBO EGRESO	REC	00	1	0	1
3	NOTA ENTRADA ALMACEN	NEA	00	1	0	1
4	NOTA SALIDA ALMACEN	NSA	00	1	0	1
5	NOTA DE VENTA	NVE	00	1	0	1
6	HOJA DE INGRESO	HJI	00	1	0	1
10	FACTURA ELECTRONICA	FAC	01	1	1	1
11	RECIBO POR HONORARIOS	RXH	02	1	0	1
12	BOLETA DE VENTA ELECTRONICA	BOL	03	1	1	1
13	LIQUIDACION DE COMPRA	LIQ	04	1	0	1
14	NOTA DE CREDITO	NDC	07	1	1	1
15	NOTA DE DEBITO	NDD	08	1	1	1
16	GUIA DE REMISION - REMITENTE	GRR	09	1	0	1
17	TICKET DE MAQUINA REGISTRADORA	TMQ	12	1	0	1
18	DOCUMENTO EMITIDO POR BANCOS - II.FF	DEB	13	1	0	1
19	RECIBO X SERVICIOS PUBLICOS (AGUA - LUZ -  ETC)	RXS	14	1	0	1
20	BOLETO DE EMPRESAS DE TRANSPORTE PUBLICO	BET	15	1	0	1
21	BOLETO DE VIAJE EMITIDO POR TRANSPORTE INTERPROVINICIAL	BVE	16	1	0	1
22	COMPROBANTE DE RETENCION	RET	20	1	0	1
23	GUIA DE REMISION - TRANSPORTISTA	GRT	31	1	0	1
24	OTROS CONSOLIDADO DE BOLETAS	OTR	99	1	0	1
25	FACTURA	FAC	01	1	0	1
8	NOTA DE PEDIDO	NPE	00	1	0	1
9	PROFORMA	PRO	00	1	0	1
\.


--
-- TOC entry 4079 (class 0 OID 192206)
-- Dependencies: 265
-- Data for Name: conceptos; Type: TABLE DATA; Schema: caja; Owner: phuyu15
--

COPY caja.conceptos (codconcepto, descripcion, abreviatura, tipo, estado) FROM stdin;
1	SALDO INICIAL	\N	1	1
2	INGRESO X AJUSTE DE CAJA	\N	1	1
3	EGRESO X AJUSTE DE CAJA	\N	2	1
4	AUM LIQUIDEZ CAJ EFEC	\N	1	1
5	INGRESOS VARIOS	\N	1	1
6	GASTOS VARIOS	\N	2	1
9	ENTREGA EN EFECTIVO A CAJA CENTRAL	\N	2	1
10	CHEQUES COBRADOS	\N	1	1
11	CHEQUES GIRADOS	\N	2	1
12	COMPRAS AL CONTADO	\N	2	1
13	VENTAS AL CONTADO	\N	1	1
14	COMPRAS AL CREDITO	\N	2	1
15	VENTAS AL CREDITO	\N	1	1
16	PAGO DE INICIAL	\N	2	1
17	PAGO DE CUOTAS	\N	2	1
18	COBRANZA DE INICIAL	\N	1	1
19	COBRANZA DE CUOTAS	\N	1	1
20	ADELANTOS RECIBIDOS	\N	2	1
21	ADELANTOS ENTREGADOS	\N	1	1
22	SALDO FINAL CAJA EFECTIVO	\N	1	1
23	AUM LIQUIDEZ CAJA CENTRAL	\N	1	1
24	EGRESO CAJA CENTRAL	\N	2	1
25	TRANSFERENCIA CAJA CENTRAL - CAJA CHICA	\N	2	1
26	TRANSFERENCIA CAJA CHICA - CAJA CENTRAL	\N	1	1
27	OTROS CREDITOS OTORGADOS	\N	1	1
28	OTROS CREDITOS RECIBIDOS	\N	2	1
29	ING X AJUSTE CAJA CENTRAL	\N	1	1
30	EGRESO X AJUSTE CAJA CENTRAL	\N	2	1
31	PAGO PLANILLA	\N	2	1
32	GARANTIA DE ENVASES	\N	2	1
33	DEVOLUCIÓN DE GARANTIA DE ENVASES	\N	1	1
34	ANULADO	\N	1	1
7	CREDITOS OTORGADOS	\N	1	1
8	CREDITOS RECIBIDOS	\N	2	1
\.


--
-- TOC entry 4081 (class 0 OID 192212)
-- Dependencies: 267
-- Data for Name: controldiario; Type: TABLE DATA; Schema: caja; Owner: phuyu15
--

COPY caja.controldiario (codcontroldiario, codcaja, codusuario, codusuariocierre, codsucursal, fechaapertura, fechacierre, saldoinicialcaja, saldofinalcaja, totalingresoscaja, totalegresoscaja, ajustecaja, saldoinicialbanco, saldofinalbanco, totalingresosbanco, totalegresosbanco, ajustebanco, codigodiario, cerrado, estado) FROM stdin;
6	1	52	52	1	2023-03-29	2023-03-29	0.0000	106.0000	106.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	29032023	0	1
7	1	52	\N	1	2023-03-30	\N	106.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	0.0000	30032023	1	1
\.


--
-- TOC entry 4083 (class 0 OID 192230)
-- Dependencies: 269
-- Data for Name: ctasctes; Type: TABLE DATA; Schema: caja; Owner: phuyu15
--

COPY caja.ctasctes (codctacte, codbanco, codmoneda, codpersona, nroctacte, descripcion, estado) FROM stdin;
\.


--
-- TOC entry 4085 (class 0 OID 192236)
-- Dependencies: 271
-- Data for Name: monedas; Type: TABLE DATA; Schema: caja; Owner: phuyu15
--

COPY caja.monedas (codmoneda, descripcion, simbolo, oficial, tipo, estado) FROM stdin;
2	DOLAR	$	USD	1	1
1	SOLES	S/	PEM	1	1
3	EURO	€	EUR	1	1
\.


--
-- TOC entry 4087 (class 0 OID 192243)
-- Dependencies: 273
-- Data for Name: movimientos; Type: TABLE DATA; Schema: caja; Owner: phuyu15
--

COPY caja.movimientos (codmovimiento, codcontroldiario, codcaja, codconcepto, codpersona, codusuario, tipomovimiento, codcomprobantetipo, seriecomprobante, nrocomprobante, codkardex, fechamovimiento, codcomprobantetipo_ref, seriecomprobante_ref, nrocomprobante_ref, importe, referencia, condicionpago, estado, codcaja_ref, transferido, codempleado) FROM stdin;
4	6	1	13	2	52	1	1	RI01	00000004	4	2023-03-29	5	NV01	00000004	30.0000	INGRESO POR VENTA	1	1	\N	0	\N
5	6	1	13	2	52	1	1	RI01	00000005	5	2023-03-29	5	NV01	00000005	26.0000	INGRESO POR VENTA	1	1	\N	0	\N
6	6	1	13	2	52	1	1	RI01	00000006	6	2023-03-29	5	NV01	00000006	30.0000	INGRESO POR VENTA	1	1	\N	0	\N
7	6	1	13	2	52	1	1	RI01	00000007	7	2023-03-29	5	NV01	00000007	20.0000	INGRESO POR VENTA	1	1	\N	0	\N
8	7	1	13	6980	52	1	1	RI01	00000008	8	2023-03-30	10	F001	00000001	19.0000	INGRESO POR VENTA	1	1	\N	0	\N
9	7	1	13	2	52	1	1	RI01	00000009	9	2023-04-01	12	B001	00000001	35.0000	INGRESO POR VENTA	1	1	\N	0	\N
10	7	1	13	6981	52	1	1	RI01	00000010	10	2023-04-01	10	F001	00000002	525.0000	INGRESO POR VENTA	1	1	\N	0	\N
11	7	1	13	6982	52	1	1	RI01	00000011	11	2023-04-05	5	NV01	00000008	32.0000	INGRESO POR VENTA	1	1	\N	0	\N
12	7	1	13	6982	52	1	1	RI01	00000012	12	2023-04-05	10	F001	00000003	32.0000	INGRESO POR VENTA	1	1	\N	0	\N
13	7	1	13	6981	52	1	1	RI01	00000013	13	2023-04-05	10	F001	00000004	293.0000	INGRESO POR VENTA	1	1	\N	0	\N
14	7	1	13	6983	52	1	1	RI01	00000014	14	2023-04-11	10	F001	00000005	25.0000	INGRESO POR VENTA	1	1	\N	0	\N
15	7	1	13	6984	52	1	1	RI01	00000015	15	2023-04-11	5	NV01	00000009	80.0000	INGRESO POR VENTA	1	1	\N	0	\N
16	7	1	13	6984	52	1	1	RI01	00000016	16	2023-04-11	10	F001	00000006	80.0000	INGRESO POR VENTA	1	1	\N	0	\N
17	7	1	13	6985	52	1	1	RI01	00000017	17	2023-04-12	10	F001	00000007	25.0000	INGRESO POR VENTA	1	1	\N	0	\N
18	7	1	13	6986	52	1	1	RI01	00000018	18	2023-04-15	10	F001	00000008	300.0000	INGRESO POR VENTA	1	1	\N	0	\N
19	7	1	13	6987	52	1	1	RI01	00000019	19	2023-04-17	10	F001	00000009	113.0000	INGRESO POR VENTA	1	1	\N	0	\N
20	7	1	13	6987	52	1	1	RI01	00000020	20	2023-04-17	10	F001	00000010	25.0000	INGRESO POR VENTA	1	1	\N	0	\N
21	7	1	13	6988	52	1	1	RI01	00000021	21	2023-05-05	5	NV01	00000010	87.0000	INGRESO POR VENTA	1	1	\N	0	\N
22	7	1	13	6988	52	1	1	RI01	00000022	22	2023-05-05	10	F001	00000011	87.0000	INGRESO POR VENTA	1	1	\N	0	\N
\.


--
-- TOC entry 4089 (class 0 OID 192254)
-- Dependencies: 275
-- Data for Name: movimientosdetalle; Type: TABLE DATA; Schema: caja; Owner: phuyu15
--

COPY caja.movimientosdetalle (codmovimiento, codtipopago, codcontroldiario, codcaja, codmoneda, tipocambio, codctacte, fechadocbanco, nrodocbanco, urldocbanco, importe, importeentregado, vuelto, estado) FROM stdin;
4	1	6	1	1	1.0000	\N	2023-03-29	\N	\N	30.0000	30.0000	0.0000	1
5	1	6	1	1	1.0000	\N	2023-03-29	\N	\N	26.0000	26.0000	0.0000	1
6	1	6	1	1	1.0000	\N	2023-03-29	\N	\N	30.0000	100.0000	70.0000	1
7	1	6	1	1	1.0000	\N	2023-03-29	\N	\N	20.0000	20.0000	0.0000	1
8	1	7	1	1	1.0000	\N	2023-03-30	\N	\N	19.0000	19.0000	0.0000	1
9	1	7	1	1	1.0000	\N	2023-04-01	\N	\N	35.0000	35.0000	0.0000	1
10	1	7	1	1	1.0000	\N	2023-04-01	\N	\N	525.0000	525.0000	0.0000	1
11	1	7	1	1	1.0000	\N	2023-04-05	\N	\N	32.0000	32.0000	0.0000	1
12	1	7	1	1	1.0000	\N	2023-04-05	\N	\N	32.0000	32.0000	0.0000	1
13	1	7	1	1	1.0000	\N	2023-04-05	\N	\N	293.0000	293.0000	0.0000	1
14	1	7	1	1	1.0000	\N	2023-04-11	\N	\N	25.0000	25.0000	0.0000	1
15	1	7	1	1	1.0000	\N	2023-04-11	\N	\N	80.0000	80.0000	0.0000	1
16	1	7	1	1	1.0000	\N	2023-04-11	\N	\N	80.0000	80.0000	0.0000	1
17	1	7	1	1	1.0000	\N	2023-04-12	\N	\N	25.0000	25.0000	0.0000	1
18	1	7	1	1	1.0000	\N	2023-04-15	\N	\N	300.0000	300.0000	0.0000	1
19	1	7	1	1	1.0000	\N	2023-04-17	\N	\N	113.0000	113.0000	0.0000	1
20	1	7	1	1	1.0000	\N	2023-04-17	\N	\N	25.0000	25.0000	0.0000	1
21	1	7	1	1	1.0000	\N	2023-05-05	\N	\N	87.0000	87.0000	0.0000	1
22	1	7	1	1	1.0000	\N	2023-05-05	\N	\N	87.0000	87.0000	0.0000	1
\.


--
-- TOC entry 4090 (class 0 OID 192263)
-- Dependencies: 276
-- Data for Name: tipocambios; Type: TABLE DATA; Schema: caja; Owner: phuyu15
--

COPY caja.tipocambios (codtipocambio, codmoneda, compra, venta, fecha, estado) FROM stdin;
\.


--
-- TOC entry 4092 (class 0 OID 192270)
-- Dependencies: 278
-- Data for Name: tipopagos; Type: TABLE DATA; Schema: caja; Owner: phuyu15
--

COPY caja.tipopagos (codtipopago, descripcion, ingreso, egreso, abono, cargo, estado) FROM stdin;
1	EFECTIVO	1	1	0	0	1
2	CHEQUE	1	0	0	1	1
3	DEPÓSITO	0	1	1	1	1
4	RETIRO	0	0	0	0	1
5	TRANSFERENCIA	0	0	1	1	1
6	MASTERCARD	1	0	0	0	1
7	VISA	1	0	0	0	1
8	VALE	0	0	0	0	1
\.


--
-- TOC entry 4094 (class 0 OID 192276)
-- Dependencies: 280
-- Data for Name: creditoconceptos; Type: TABLE DATA; Schema: kardex; Owner: phuyu15
--

COPY kardex.creditoconceptos (codcreditoconcepto, descripcion, tipo, estado) FROM stdin;
1	CREDITOS OTORGADOS	1	1
2	CREDITOS RECIBIDOS	2	1
3	CREDITOS OTORGADOS X VENTAS	1	1
4	CCREDITOS RECIBIDOS X COMPRAS	2	1
\.


--
-- TOC entry 4096 (class 0 OID 192282)
-- Dependencies: 282
-- Data for Name: creditos; Type: TABLE DATA; Schema: kardex; Owner: phuyu15
--

COPY kardex.creditos (codcredito, codsucursal, codcaja, codcreditoconcepto, codpersona, codmovimiento, codusuario, codempleado, codmoneda, tipocambio, codkardex, tipo, fechacredito, fechainicio, fechavencimiento, fecha, hora, nrodias, nrocuotas, importe, tasainteres, tasainteresmora, interes, saldo, saldomora, total, tipocuota, estado, referencia) FROM stdin;
\.


--
-- TOC entry 4098 (class 0 OID 192305)
-- Dependencies: 284
-- Data for Name: creditosanulados; Type: TABLE DATA; Schema: kardex; Owner: phuyu15
--

COPY kardex.creditosanulados (codcredito, codsucursal, fechaanulacion, codusuario, fecha, hora, observaciones) FROM stdin;
\.


--
-- TOC entry 4099 (class 0 OID 192310)
-- Dependencies: 285
-- Data for Name: cuotas; Type: TABLE DATA; Schema: kardex; Owner: phuyu15
--

COPY kardex.cuotas (codcredito, nrocuota, codsucursal, fechavence, fechapago, fecha, importe, saldo, saldomora, interesmora, interes, total, estado) FROM stdin;
\.


--
-- TOC entry 4100 (class 0 OID 192323)
-- Dependencies: 286
-- Data for Name: cuotaspagos; Type: TABLE DATA; Schema: kardex; Owner: phuyu15
--

COPY kardex.cuotaspagos (codcredito, nrocuota, codsucursal, codmovimiento, codusuario, importe, saldocuota, fecha, hora, estado) FROM stdin;
\.


--
-- TOC entry 4101 (class 0 OID 192331)
-- Dependencies: 287
-- Data for Name: kardex; Type: TABLE DATA; Schema: kardex; Owner: phuyu15
--

COPY kardex.kardex (codkardex, codkardex_ref, codsucursal, codalmacen, codalmacen_ref, codpersona, codusuario, codmovimientotipo, condicionpago, codcredito, codmoneda, tipocambio, codmotivonota, fecha, hora, fechakardex, codcomprobantetipo, seriecomprobante, nrocomprobante, codcomprobantetipo_ref, seriecomprobante_ref, nrocomprobante_ref, valorventa, porcdescuento, descglobal, porcigv, igv, importe, retirar, flete, estiba, gastos, descripcion, transferido, afectacaja, cliente, direccion, estado, nroplaca, codempleado, fechacomprobante, descuentos, codcentrocosto, icbper, isc, porcicbper, codguiar) FROM stdin;
15	\N	1	1	\N	6984	52	20	1	0	1	0.0000	0	2023-04-11	14:11:58	2023-04-11	5	NV01	00000009	0	\N	\N	80.0000	0.0000	0.0000	18.0000	0.0000	80.0000	1	0.0000	0.0000	0.0000	REGISTRO POR VENTA	0	1	CONSTRUCTORA INMOBILIARIA RIO HUALLAGA  S.A.C	sn	1		0	2023-04-11	0.0000	0	0.000000	0.0000	0.4000	\N
16	\N	1	1	\N	6984	52	20	1	0	1	0.0000	0	2023-04-11	14:13:58	2023-04-11	10	F001	00000006	0	\N	\N	80.0000	0.0000	0.0000	18.0000	0.0000	80.0000	1	0.0000	0.0000	0.0000	REGISTRO POR VENTA	0	1	CONSTRUCTORA INMOBILIARIA RIO HUALLAGA  S.A.C	AV. CIRCUNVALACION NRO 2283 	1		0	2023-04-11	0.0000	0	0.000000	0.0000	0.4000	\N
4	\N	1	1	\N	2	52	20	1	0	1	0.0000	0	2023-03-29	21:50:53	2023-03-29	5	NV01	00000004	0	\N	\N	30.0000	0.0000	0.0000	18.0000	0.0000	30.0000	1	0.0000	0.0000	0.0000	REGISTRO POR VENTA	0	1	CLIENTES VARIOS	-	1		0	2023-03-29	0.0000	0	0.000000	0.0000	0.4000	\N
5	\N	1	1	\N	2	52	20	1	0	1	0.0000	0	2023-03-29	21:51:45	2023-03-29	5	NV01	00000005	0	\N	\N	26.0000	0.0000	0.0000	18.0000	0.0000	26.0000	1	0.0000	0.0000	0.0000	REGISTRO POR VENTA	0	1	CLIENTES VARIOS	-	1		0	2023-03-29	0.0000	0	0.000000	0.0000	0.4000	\N
6	\N	1	1	\N	2	52	20	1	0	1	0.0000	0	2023-03-29	21:57:47	2023-03-29	5	NV01	00000006	0	\N	\N	30.0000	0.0000	0.0000	18.0000	0.0000	30.0000	1	0.0000	0.0000	0.0000	REGISTRO POR VENTA	0	1	CLIENTES VARIOS	-	1		0	2023-03-29	0.0000	0	0.000000	0.0000	0.4000	\N
7	\N	1	1	\N	2	52	20	1	0	1	0.0000	0	2023-03-29	22:09:52	2023-03-29	5	NV01	00000007	0	\N	\N	20.0000	0.0000	0.0000	18.0000	0.0000	20.0000	1	0.0000	0.0000	0.0000	REGISTRO POR VENTA	0	1	CLIENTES VARIOS	-	1		0	2023-03-29	0.0000	0	0.000000	0.0000	0.4000	\N
8	\N	1	1	\N	6980	52	20	1	0	1	0.0000	0	2023-03-30	11:35:56	2023-03-30	10	F001	00000001	0	\N	\N	19.0000	0.0000	0.0000	18.0000	0.0000	19.0000	1	0.0000	0.0000	0.0000	REGISTRO POR VENTA	0	1	INSTITUTO PARA EL DESARROLLO Y LA PAZ AMAZONICA	JR. PROGRESO NRO 767 URB. 9 DE ABRIL 	1		0	2023-03-30	0.0000	0	0.000000	0.0000	0.4000	\N
9	\N	1	1	\N	2	52	20	1	0	1	0.0000	0	2023-04-01	10:50:06	2023-04-01	12	B001	00000001	0	\N	\N	35.0000	0.0000	0.0000	18.0000	0.0000	35.0000	1	0.0000	0.0000	0.0000	REGISTRO POR VENTA	0	1	alex	-	1		0	2023-04-01	0.0000	0	0.000000	0.0000	0.4000	\N
10	\N	1	1	\N	6981	52	20	1	0	1	0.0000	0	2023-04-01	10:59:42	2023-04-01	10	F001	00000002	0	\N	\N	525.0000	0.0000	0.0000	18.0000	0.0000	525.0000	1	0.0000	0.0000	0.0000	REGISTRO POR VENTA	0	1	AGROINDUSTRIAS EL MAIZAL DE SAN JOSE S.A.C	JR. LOS LIRIOS NRO 279 	1		0	2023-04-01	0.0000	0	0.000000	0.0000	0.4000	\N
11	\N	1	1	\N	6982	52	20	1	0	1	0.0000	0	2023-04-05	15:30:25	2023-04-05	5	NV01	00000008	0	\N	\N	32.0000	0.0000	0.0000	18.0000	0.0000	32.0000	1	0.0000	0.0000	0.0000	REGISTRO POR VENTA	0	1	PAREDES ALVARADO LUIS ALBERTO	s/n	1		0	2023-04-05	0.0000	0	0.000000	0.0000	0.4000	\N
12	\N	1	1	\N	6982	52	20	1	0	1	0.0000	0	2023-04-05	15:48:54	2023-04-05	10	F001	00000003	0	\N	\N	32.0000	0.0000	0.0000	18.0000	0.0000	32.0000	1	0.0000	0.0000	0.0000	REGISTRO POR VENTA	0	1	PAREDES ALVARADO LUIS ALBERTO	sn	1		0	2023-04-05	0.0000	0	0.000000	0.0000	0.4000	\N
13	\N	1	1	\N	6981	52	20	1	0	1	0.0000	0	2023-04-05	15:55:35	2023-04-05	10	F001	00000004	0	\N	\N	293.0000	0.0000	0.0000	18.0000	0.0000	293.0000	1	0.0000	0.0000	0.0000	REGISTRO POR VENTA	0	1	AGROINDUSTRIAS EL MAIZAL DE SAN JOSE S.A.C	JR. LOS LIRIOS NRO 279 	1		0	2023-04-05	0.0000	0	0.000000	0.0000	0.4000	\N
14	\N	1	1	\N	6983	52	20	1	0	1	0.0000	0	2023-04-11	14:10:04	2023-04-11	10	F001	00000005	0	\N	\N	25.0000	0.0000	0.0000	18.0000	0.0000	25.0000	1	0.0000	0.0000	0.0000	REGISTRO POR VENTA	0	1	FUNDACION PARA EL DESARROLLO AGRARIO	sn	1		0	2023-04-11	0.0000	0	0.000000	0.0000	0.4000	\N
17	\N	1	1	\N	6985	52	20	1	0	1	0.0000	0	2023-04-12	09:30:21	2023-04-12	10	F001	00000007	0	\N	\N	25.0000	0.0000	0.0000	18.0000	0.0000	25.0000	1	0.0000	0.0000	0.0000	REGISTRO POR VENTA	0	1	ESTACION EXPERIMENTAL AGRARIA EL PORVENIR - SAN MARTIN	CAR. MARGINAL SUR NRO S/N 	1		0	2023-04-12	0.0000	0	0.000000	0.0000	0.4000	\N
18	\N	1	1	\N	6986	52	20	1	0	1	0.0000	0	2023-04-15	20:55:20	2023-04-15	10	F001	00000008	0	\N	\N	300.0000	0.0000	0.0000	18.0000	0.0000	300.0000	1	0.0000	0.0000	0.0000	REGISTRO POR VENTA	0	1	PALOMINO TARQUI JESSICA MAGDALENA	-Jr. Alfonso Ugarte 1831	1		0	2023-04-15	0.0000	0	0.000000	0.0000	0.4000	\N
19	\N	1	1	\N	6987	52	20	1	0	1	0.0000	0	2023-04-17	15:01:43	2023-04-17	10	F001	00000009	0	\N	\N	113.0000	0.0000	0.0000	18.0000	0.0000	113.0000	1	0.0000	0.0000	0.0000	REGISTRO POR VENTA	0	1	B Y J SERVICIOS Y CONSTRUCCIONES S.A.C.	Jr. Camila morey   numero 118	1		0	2023-04-17	0.0000	0	0.000000	0.0000	0.4000	\N
20	\N	1	1	\N	6987	52	20	1	0	1	0.0000	0	2023-04-17	15:03:29	2023-04-17	10	F001	00000010	0	\N	\N	25.0000	0.0000	0.0000	18.0000	0.0000	25.0000	1	0.0000	0.0000	0.0000	REGISTRO POR VENTA	0	1	B Y J SERVICIOS Y CONSTRUCCIONES S.A.C.	JR. CAMILA MOREY NRO 118 PARTIDO ALTO 	1		0	2023-04-17	0.0000	0	0.000000	0.0000	0.4000	\N
21	\N	1	1	\N	6988	52	20	1	0	1	0.0000	0	2023-05-05	20:09:36	2023-05-05	5	NV01	00000010	0	\N	\N	87.0000	0.0000	0.0000	18.0000	0.0000	87.0000	1	0.0000	0.0000	0.0000	REGISTRO POR VENTA	0	1	ROSALES MENDEZ HENRY BENJAMIN	jr los próceres  922 JG	1		0	2023-05-05	0.0000	0	0.000000	0.0000	0.4000	\N
22	\N	1	1	\N	6988	52	20	1	0	1	0.0000	0	2023-05-05	20:10:55	2023-05-05	10	F001	00000011	0	\N	\N	87.0000	0.0000	0.0000	18.0000	0.0000	87.0000	1	0.0000	0.0000	0.0000	REGISTRO POR VENTA	0	1	ROSALES MENDEZ HENRY BENJAMIN	-	1		0	2023-05-05	0.0000	0	0.000000	0.0000	0.4000	\N
\.


--
-- TOC entry 4103 (class 0 OID 192369)
-- Dependencies: 289
-- Data for Name: kardexalmacen; Type: TABLE DATA; Schema: kardex; Owner: phuyu15
--

COPY kardex.kardexalmacen (codkardexalmacen, codsucursal, codalmacen, codalmacen_ref, codkardex, codusuario, codmovimientotipo, fechakardex, movimiento, codcomprobantetipo, seriecomprobante, nrocomprobante, estado) FROM stdin;
4	1	1	\N	4	52	20	2023-03-29	1	4	NS01	00000004	1
5	1	1	\N	5	52	20	2023-03-29	1	4	NS01	00000005	1
6	1	1	\N	6	52	20	2023-03-29	1	4	NS01	00000006	1
7	1	1	\N	7	52	20	2023-03-29	1	4	NS01	00000007	1
8	1	1	\N	8	52	20	2023-03-30	1	4	NS01	00000008	1
9	1	1	\N	9	52	20	2023-04-01	1	4	NS01	00000009	1
10	1	1	\N	10	52	20	2023-04-01	1	4	NS01	00000010	1
11	1	1	\N	11	52	20	2023-04-05	1	4	NS01	00000011	1
12	1	1	\N	12	52	20	2023-04-05	1	4	NS01	00000012	1
13	1	1	\N	13	52	20	2023-04-05	1	4	NS01	00000013	1
14	1	1	\N	14	52	20	2023-04-11	1	4	NS01	00000014	1
15	1	1	\N	15	52	20	2023-04-11	1	4	NS01	00000015	1
16	1	1	\N	16	52	20	2023-04-11	1	4	NS01	00000016	1
17	1	1	\N	17	52	20	2023-04-12	1	4	NS01	00000017	1
18	1	1	\N	18	52	20	2023-04-15	1	4	NS01	00000018	1
19	1	1	\N	19	52	20	2023-04-17	1	4	NS01	00000019	1
20	1	1	\N	20	52	20	2023-04-17	1	4	NS01	00000020	1
21	1	1	\N	21	52	20	2023-05-05	1	4	NS01	00000021	1
22	1	1	\N	22	52	20	2023-05-05	1	4	NS01	00000022	1
\.


--
-- TOC entry 4105 (class 0 OID 192376)
-- Dependencies: 291
-- Data for Name: kardexalmacenanulado; Type: TABLE DATA; Schema: kardex; Owner: phuyu15
--

COPY kardex.kardexalmacenanulado (codkardexalmacen, codsucursal, codusuario, fechaanulacion, hora, observaciones) FROM stdin;
\.


--
-- TOC entry 4106 (class 0 OID 192380)
-- Dependencies: 292
-- Data for Name: kardexalmacendetalle; Type: TABLE DATA; Schema: kardex; Owner: phuyu15
--

COPY kardex.kardexalmacendetalle (codkardexalmacen, codproducto, codunidad, codalmacen, item, codsucursal, cantidad, estado) FROM stdin;
4	4	68	1	1	1	1.0000	1
5	4	68	1	1	1	1.0000	1
6	5	68	1	1	1	1.0000	1
7	7	68	1	1	1	1.0000	1
8	8	68	1	1	1	1.0000	1
9	3	68	1	1	1	1.0000	1
10	15	68	1	1	1	1.0000	1
10	16	8	1	2	1	1.0000	1
10	17	68	1	3	1	1.0000	1
10	14	8	1	4	1	1.0000	1
10	19	8	1	5	1	1.0000	1
10	4	68	1	6	1	1.0000	1
11	21	68	1	1	1	1.0000	1
12	21	68	1	1	1	1.0000	1
13	20	68	1	1	1	1.0000	1
13	22	68	1	2	1	1.0000	1
13	23	68	1	3	1	1.0000	1
13	24	68	1	4	1	1.0000	1
13	25	68	1	5	1	1.0000	1
13	26	68	1	6	1	1.0000	1
13	27	68	1	7	1	1.0000	1
13	28	68	1	8	1	1.0000	1
13	29	68	1	9	1	1.0000	1
14	21	68	1	1	1	1.0000	1
15	7	68	1	1	1	4.0000	1
16	7	68	1	1	1	4.0000	1
17	30	68	1	1	1	1.0000	1
18	37	68	1	1	1	1.0000	1
18	36	68	1	2	1	1.0000	1
18	35	68	1	3	1	1.0000	1
18	34	68	1	4	1	1.0000	1
18	33	68	1	5	1	1.0000	1
18	32	68	1	6	1	1.0000	1
18	31	68	1	7	1	1.0000	1
19	38	68	1	1	1	1.0000	1
19	21	68	1	2	1	2.0000	1
19	23	68	1	3	1	1.0000	1
19	29	68	1	4	1	1.0000	1
19	39	68	1	5	1	1.0000	1
19	40	68	1	6	1	1.0000	1
19	41	68	1	7	1	1.0000	1
20	21	68	1	1	1	1.0000	1
21	24	68	1	1	1	1.0000	1
21	29	68	1	2	1	1.0000	1
22	24	68	1	1	1	1.0000	1
22	29	68	1	2	1	1.0000	1
\.


--
-- TOC entry 4107 (class 0 OID 192385)
-- Dependencies: 293
-- Data for Name: kardexanulados; Type: TABLE DATA; Schema: kardex; Owner: phuyu15
--

COPY kardex.kardexanulados (codkardex, codsucursal, codusuario, fechaanulacion, fecha, hora, observaciones) FROM stdin;
\.


--
-- TOC entry 4108 (class 0 OID 192390)
-- Dependencies: 294
-- Data for Name: kardexdetalle; Type: TABLE DATA; Schema: kardex; Owner: phuyu15
--

COPY kardex.kardexdetalle (codkardex, codproducto, codunidad, item, cantidad, preciounitario, porcdescuento, descuento, subtotal, preciosinigv, preciorefunitario, igv, codafectacionigv, recoger, recogido, valorventa, descripcion, estado, preciobruto, conicbper, icbper, cantidadguia, flete, estiba, gastos, preciocompra, preciocosto, registrosanitario, fecharegistrosanitario, fechavencimiento, fechaproduccion, loteproduccion, stockkardex, codkardexdestino, stockkardexconvertido, itemdestino) FROM stdin;
4	4	68	1	1.0000	30.000000	0.00	0.00	30.0000	30.000000	26.000000	0.0000	20	1	0.0000	30.0000		1	30.000000	0	0.000000	0.0000	0.0000	0.0000	0.0000	25.000000	25.000000		\N	\N	\N		0.0000	0	0.0000	0
5	4	68	1	1.0000	26.000000	0.00	0.00	26.0000	26.000000	26.000000	0.0000	20	1	0.0000	26.0000		1	26.000000	0	0.000000	0.0000	0.0000	0.0000	0.0000	25.000000	25.000000		\N	\N	\N		0.0000	0	0.0000	0
6	5	68	1	1.0000	30.000000	0.00	0.00	30.0000	30.000000	27.000000	0.0000	20	1	0.0000	30.0000		1	30.000000	0	0.000000	0.0000	0.0000	0.0000	0.0000	23.000000	23.000000		\N	\N	\N		0.0000	0	0.0000	0
7	7	68	1	1.0000	20.000000	0.00	0.00	20.0000	20.000000	20.000000	0.0000	20	1	0.0000	20.0000	aceite vistony	1	20.000000	0	0.000000	0.0000	0.0000	0.0000	0.0000	13.000000	13.000000		\N	\N	\N		0.0000	0	0.0000	0
8	8	68	1	1.0000	19.000000	0.00	0.00	19.0000	19.000000	20.000000	0.0000	20	1	0.0000	19.0000		1	19.000000	0	0.000000	0.0000	0.0000	0.0000	0.0000	14.000000	14.000000		\N	\N	\N		0.0000	0	0.0000	0
9	3	68	1	1.0000	35.000000	0.00	0.00	35.0000	35.000000	35.000000	0.0000	20	1	0.0000	35.0000		1	35.000000	0	0.000000	0.0000	0.0000	0.0000	0.0000	27.000000	27.000000		\N	\N	\N		0.0000	0	0.0000	0
10	15	68	1	1.0000	75.000000	0.00	0.00	75.0000	75.000000	75.000000	0.0000	20	1	0.0000	75.0000		1	75.000000	0	0.000000	0.0000	0.0000	0.0000	0.0000	10.000000	10.000000		\N	\N	\N		0.0000	0	0.0000	0
10	16	8	2	1.0000	235.000000	0.00	0.00	235.0000	235.000000	12.000000	0.0000	20	1	0.0000	235.0000		1	235.000000	0	0.000000	0.0000	0.0000	0.0000	0.0000	5.000000	5.000000		\N	\N	\N		0.0000	0	0.0000	0
10	17	68	3	1.0000	105.000000	0.00	0.00	105.0000	105.000000	25.000000	0.0000	20	1	0.0000	105.0000		1	105.000000	0	0.000000	0.0000	0.0000	0.0000	0.0000	25.000000	25.000000		\N	\N	\N		0.0000	0	0.0000	0
10	14	8	4	1.0000	70.000000	0.00	0.00	70.0000	70.000000	70.000000	0.0000	20	1	0.0000	70.0000		1	70.000000	0	0.000000	0.0000	0.0000	0.0000	0.0000	45.000000	45.000000		\N	\N	\N		0.0000	0	0.0000	0
10	19	8	5	1.0000	10.000000	0.00	0.00	10.0000	10.000000	10.000000	0.0000	20	1	0.0000	10.0000		1	10.000000	0	0.000000	0.0000	0.0000	0.0000	0.0000	7.000000	7.000000		\N	\N	\N		0.0000	0	0.0000	0
10	4	68	6	1.0000	30.000000	0.00	0.00	30.0000	30.000000	26.000000	0.0000	20	1	0.0000	30.0000		1	30.000000	0	0.000000	0.0000	0.0000	0.0000	0.0000	25.000000	25.000000		\N	\N	\N		0.0000	0	0.0000	0
11	21	68	1	1.0000	32.000000	0.00	0.00	32.0000	32.000000	20.000000	0.0000	20	1	0.0000	32.0000		1	32.000000	0	0.000000	0.0000	0.0000	0.0000	0.0000	11.000000	11.000000		\N	\N	\N		0.0000	0	0.0000	0
12	21	68	1	1.0000	32.000000	0.00	0.00	32.0000	32.000000	20.000000	0.0000	20	1	0.0000	32.0000		1	32.000000	0	0.000000	0.0000	0.0000	0.0000	0.0000	11.000000	11.000000		\N	\N	\N		0.0000	0	0.0000	0
13	20	68	1	1.0000	75.000000	0.00	0.00	75.0000	75.000000	75.000000	0.0000	20	1	0.0000	75.0000		1	75.000000	0	0.000000	0.0000	0.0000	0.0000	0.0000	50.000000	50.000000		\N	\N	\N		0.0000	0	0.0000	0
13	22	68	2	1.0000	8.000000	0.00	0.00	8.0000	8.000000	5.000000	0.0000	20	1	0.0000	8.0000		1	8.000000	0	0.000000	0.0000	0.0000	0.0000	0.0000	3.000000	3.000000		\N	\N	\N		0.0000	0	0.0000	0
13	23	68	3	1.0000	15.000000	0.00	0.00	15.0000	15.000000	12.000000	0.0000	20	1	0.0000	15.0000		1	15.000000	0	0.000000	0.0000	0.0000	0.0000	0.0000	6.000000	6.000000		\N	\N	\N		0.0000	0	0.0000	0
13	24	68	4	1.0000	59.000000	0.00	0.00	59.0000	59.000000	50.000000	0.0000	20	1	0.0000	59.0000		1	59.000000	0	0.000000	0.0000	0.0000	0.0000	0.0000	30.000000	30.000000		\N	\N	\N		0.0000	0	0.0000	0
13	25	68	5	1.0000	25.000000	0.00	0.00	25.0000	25.000000	25.000000	0.0000	20	1	0.0000	25.0000		1	25.000000	0	0.000000	0.0000	0.0000	0.0000	0.0000	13.000000	13.000000		\N	\N	\N		0.0000	0	0.0000	0
13	26	68	6	1.0000	15.000000	0.00	0.00	15.0000	15.000000	12.000000	0.0000	20	1	0.0000	15.0000		1	15.000000	0	0.000000	0.0000	0.0000	0.0000	0.0000	6.000000	6.000000		\N	\N	\N		0.0000	0	0.0000	0
13	27	68	7	1.0000	79.000000	0.00	0.00	79.0000	79.000000	85.000000	0.0000	20	1	0.0000	79.0000		1	79.000000	0	0.000000	0.0000	0.0000	0.0000	0.0000	55.000000	55.000000		\N	\N	\N		0.0000	0	0.0000	0
13	28	68	8	1.0000	2.000000	0.00	0.00	2.0000	2.000000	2.000000	0.0000	20	1	0.0000	2.0000		1	2.000000	0	0.000000	0.0000	0.0000	0.0000	0.0000	1.000000	1.000000		\N	\N	\N		0.0000	0	0.0000	0
13	29	68	9	1.0000	15.000000	0.00	0.00	15.0000	15.000000	25.000000	0.0000	20	1	0.0000	15.0000		1	15.000000	0	0.000000	0.0000	0.0000	0.0000	0.0000	25.000000	25.000000		\N	\N	\N		0.0000	0	0.0000	0
14	21	68	1	1.0000	25.000000	0.00	0.00	25.0000	25.000000	20.000000	0.0000	20	1	0.0000	25.0000		1	25.000000	0	0.000000	0.0000	0.0000	0.0000	0.0000	11.000000	11.000000		\N	\N	\N		0.0000	0	0.0000	0
15	7	68	1	4.0000	20.000000	0.00	0.00	80.0000	20.000000	20.000000	0.0000	20	1	0.0000	80.0000		1	20.000000	0	0.000000	0.0000	0.0000	0.0000	0.0000	13.000000	13.000000		\N	\N	\N		0.0000	0	0.0000	0
16	7	68	1	4.0000	20.000000	0.00	0.00	80.0000	20.000000	20.000000	0.0000	20	1	0.0000	80.0000		1	20.000000	0	0.000000	0.0000	0.0000	0.0000	0.0000	13.000000	13.000000		\N	\N	\N		0.0000	0	0.0000	0
17	30	68	1	1.0000	25.000000	0.00	0.00	25.0000	25.000000	20.000000	0.0000	20	1	0.0000	25.0000		1	25.000000	0	0.000000	0.0000	0.0000	0.0000	0.0000	15.000000	15.000000		\N	\N	\N		0.0000	0	0.0000	0
18	37	68	1	1.0000	39.000000	0.00	0.00	39.0000	39.000000	39.000000	0.0000	20	1	0.0000	39.0000		1	39.000000	0	0.000000	0.0000	0.0000	0.0000	0.0000	25.000000	25.000000		\N	\N	\N		0.0000	0	0.0000	0
18	36	68	2	1.0000	60.000000	0.00	0.00	60.0000	60.000000	60.000000	0.0000	20	1	0.0000	60.0000		1	60.000000	0	0.000000	0.0000	0.0000	0.0000	0.0000	60.000000	60.000000		\N	\N	\N		0.0000	0	0.0000	0
18	35	68	3	1.0000	15.000000	0.00	0.00	15.0000	15.000000	15.000000	0.0000	20	1	0.0000	15.0000		1	15.000000	0	0.000000	0.0000	0.0000	0.0000	0.0000	13.000000	13.000000		\N	\N	\N		0.0000	0	0.0000	0
18	34	68	4	1.0000	16.000000	0.00	0.00	16.0000	16.000000	16.000000	0.0000	20	1	0.0000	16.0000		1	16.000000	0	0.000000	0.0000	0.0000	0.0000	0.0000	15.000000	15.000000		\N	\N	\N		0.0000	0	0.0000	0
18	33	68	5	1.0000	25.000000	0.00	0.00	25.0000	25.000000	25.000000	0.0000	20	1	0.0000	25.0000		1	25.000000	0	0.000000	0.0000	0.0000	0.0000	0.0000	20.000000	20.000000		\N	\N	\N		0.0000	0	0.0000	0
18	32	68	6	1.0000	120.000000	0.00	0.00	120.0000	120.000000	120.000000	0.0000	20	1	0.0000	120.0000		1	120.000000	0	0.000000	0.0000	0.0000	0.0000	0.0000	120.000000	120.000000		\N	\N	\N		0.0000	0	0.0000	0
18	31	68	7	1.0000	25.000000	0.00	0.00	25.0000	25.000000	25.000000	0.0000	20	1	0.0000	25.0000		1	25.000000	0	0.000000	0.0000	0.0000	0.0000	0.0000	20.000000	20.000000		\N	\N	\N		0.0000	0	0.0000	0
19	38	68	1	1.0000	25.000000	0.00	0.00	25.0000	25.000000	25.000000	0.0000	20	1	0.0000	25.0000		1	25.000000	0	0.000000	0.0000	0.0000	0.0000	0.0000	25.000000	25.000000		\N	\N	\N		0.0000	0	0.0000	0
19	21	68	2	2.0000	20.000000	0.00	0.00	40.0000	20.000000	20.000000	0.0000	20	1	0.0000	40.0000		1	20.000000	0	0.000000	0.0000	0.0000	0.0000	0.0000	11.000000	11.000000		\N	\N	\N		0.0000	0	0.0000	0
19	23	68	3	1.0000	15.000000	0.00	0.00	15.0000	15.000000	12.000000	0.0000	20	1	0.0000	15.0000		1	15.000000	0	0.000000	0.0000	0.0000	0.0000	0.0000	6.000000	6.000000		\N	\N	\N		0.0000	0	0.0000	0
19	29	68	4	1.0000	5.000000	0.00	0.00	5.0000	5.000000	25.000000	0.0000	20	1	0.0000	5.0000		1	5.000000	0	0.000000	0.0000	0.0000	0.0000	0.0000	25.000000	25.000000		\N	\N	\N		0.0000	0	0.0000	0
19	39	68	5	1.0000	10.000000	0.00	0.00	10.0000	10.000000	15.000000	0.0000	20	1	0.0000	10.0000		1	10.000000	0	0.000000	0.0000	0.0000	0.0000	0.0000	15.000000	15.000000		\N	\N	\N		0.0000	0	0.0000	0
19	40	68	6	1.0000	15.000000	0.00	0.00	15.0000	15.000000	15.000000	0.0000	20	1	0.0000	15.0000		1	15.000000	0	0.000000	0.0000	0.0000	0.0000	0.0000	15.000000	15.000000		\N	\N	\N		0.0000	0	0.0000	0
19	41	68	7	1.0000	3.000000	0.00	0.00	3.0000	3.000000	10.000000	0.0000	20	1	0.0000	3.0000		1	3.000000	0	0.000000	0.0000	0.0000	0.0000	0.0000	10.000000	10.000000		\N	\N	\N		0.0000	0	0.0000	0
20	21	68	1	1.0000	25.000000	0.00	0.00	25.0000	25.000000	20.000000	0.0000	20	1	0.0000	25.0000		1	25.000000	0	0.000000	0.0000	0.0000	0.0000	0.0000	11.000000	11.000000		\N	\N	\N		0.0000	0	0.0000	0
21	24	68	1	1.0000	80.000000	0.00	0.00	80.0000	80.000000	50.000000	0.0000	20	1	0.0000	80.0000		1	80.000000	0	0.000000	0.0000	0.0000	0.0000	0.0000	30.000000	30.000000		\N	\N	\N		0.0000	0	0.0000	0
21	29	68	2	1.0000	7.000000	0.00	0.00	7.0000	7.000000	25.000000	0.0000	20	1	0.0000	7.0000		1	7.000000	0	0.000000	0.0000	0.0000	0.0000	0.0000	25.000000	25.000000		\N	\N	\N		0.0000	0	0.0000	0
22	24	68	1	1.0000	80.000000	0.00	0.00	80.0000	80.000000	50.000000	0.0000	20	1	0.0000	80.0000		1	80.000000	0	0.000000	0.0000	0.0000	0.0000	0.0000	30.000000	30.000000		\N	\N	\N		0.0000	0	0.0000	0
22	29	68	2	1.0000	7.000000	0.00	0.00	7.0000	7.000000	25.000000	0.0000	20	1	0.0000	7.0000		1	7.000000	0	0.000000	0.0000	0.0000	0.0000	0.0000	25.000000	25.000000		\N	\N	\N		0.0000	0	0.0000	0
\.


--
-- TOC entry 4109 (class 0 OID 192421)
-- Dependencies: 295
-- Data for Name: kardexpedido; Type: TABLE DATA; Schema: kardex; Owner: phuyu15
--

COPY kardex.kardexpedido (codpedido, codproducto, itempedido, codkardex, itemkardex, codunidad) FROM stdin;
\.


--
-- TOC entry 4110 (class 0 OID 192425)
-- Dependencies: 296
-- Data for Name: kardexproforma; Type: TABLE DATA; Schema: kardex; Owner: phuyu15
--

COPY kardex.kardexproforma (codproforma, codproducto, itemproforma, codkardex, itemkardex, codunidad) FROM stdin;
\.


--
-- TOC entry 4111 (class 0 OID 192429)
-- Dependencies: 297
-- Data for Name: motivonotas; Type: TABLE DATA; Schema: kardex; Owner: phuyu15
--

COPY kardex.motivonotas (codmotivonota, descripcion, oficial, tipo, estado) FROM stdin;
1	ANULACION DE LA OPERACION	01	7	1
2	ANULACION POR ERROR EN EL RUC	02	7	1
3	CORRECION POR ERROR EN LA DESCRIPCION	03	7	1
4	DESCUENTO GLOBAL	04	7	1
5	DESCUENTO POR ITEM	05	7	1
6	DEVOLUCION TOTAL	07	7	1
7	DEVOLUCION POR ITEM	07	7	1
8	BONIFICACION	08	7	1
9	DISMINUCION EN EL VALOR	09	7	1
10	OTROS CONCEPTOS	10	7	1
11	INTERESES POR MORA	01	8	1
12	AUMENTO EN EL VALOR	02	8	1
13	PENALIDADES / OTROS CONCEPTOS	03	8	1
0	SIN NOTAS ELECTRONICAS	00	0	1
\.


--
-- TOC entry 4113 (class 0 OID 192435)
-- Dependencies: 299
-- Data for Name: pedidos; Type: TABLE DATA; Schema: kardex; Owner: phuyu15
--

COPY kardex.pedidos (codpedido, codkardex, codsucursal, codalmacen, codpersona, codusuario, fecha, hora, fechapedido, porcdescuento, porcigv, igv, importe, descripcion, cliente, direccion, codempleado, estado, valorventa, descglobal, descuentos, tipopedido, afectastock, afectacaja, condicionpago, codcomprobantetiporeferencia, seriecomprobantereferencia, nrocomprobantereferencia, codcomprobantetipo, seriecomprobante, nrocomprobante, estadoproceso) FROM stdin;
\.


--
-- TOC entry 4115 (class 0 OID 192458)
-- Dependencies: 301
-- Data for Name: pedidosdetalle; Type: TABLE DATA; Schema: kardex; Owner: phuyu15
--

COPY kardex.pedidosdetalle (codpedido, codproducto, codunidad, item, cantidad, preciounitario, porcdescuento, descuento, subtotal, preciorefunitario, igv, codafectacionigv, descripcion, estado, preciobruto, preciosinigv, valorventa, fecha, hora, atencion, cantidaddespachada, cantidadcomprobante, conicbper, icbper) FROM stdin;
\.


--
-- TOC entry 4116 (class 0 OID 192483)
-- Dependencies: 302
-- Data for Name: proformas; Type: TABLE DATA; Schema: kardex; Owner: phuyu15
--

COPY kardex.proformas (codproforma, codkardex, codsucursal, codalmacen, codpersona, codusuario, fecha, hora, fechaproforma, porcdescuento, porcigv, igv, importe, descripcion, razonsocial, direccion, codempleado, estado, codcomprobante, valorventa, descglobal, descuentos, tipoproforma, afectastock, afectacaja, codcomprobantetipo, seriecomprobante, nrocomprobante, condicionpago, estadoproceso) FROM stdin;
\.


--
-- TOC entry 4118 (class 0 OID 192506)
-- Dependencies: 304
-- Data for Name: proformasdetalle; Type: TABLE DATA; Schema: kardex; Owner: phuyu15
--

COPY kardex.proformasdetalle (codproforma, codproducto, codunidad, item, cantidad, preciounitario, porcdescuento, descuento, subtotal, preciorefunitario, igv, codafectacionigv, descripcion, estado, preciobruto, preciosinigv, valorventa, fecha, hora, atencion, cantidaddespachada, cantidadcomprobante, conicbper, icbper) FROM stdin;
\.


--
-- TOC entry 4121 (class 0 OID 192570)
-- Dependencies: 312
-- Data for Name: areas; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.areas (codarea, descripcion, estado) FROM stdin;
1	RECURSOS HUMANOS	1
2	VENTAS	1
\.


--
-- TOC entry 4123 (class 0 OID 192576)
-- Dependencies: 314
-- Data for Name: asistencias; Type: TABLE DATA; Schema: public; Owner: phuyu15
--

COPY public.asistencias (codempleado, fecha, turno, tipo, observacion, hora, codasistencia, estado) FROM stdin;
\.


--
-- TOC entry 4124 (class 0 OID 192582)
-- Dependencies: 315
-- Data for Name: cargos; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.cargos (codcargo, descripcion, estado) FROM stdin;
2	ADMINISTRADOR	1
1	GERENTE GENERAL	1
3	CAJERO	1
4	VENDEDOR	1
5	ALMACENERO	1
\.


--
-- TOC entry 4119 (class 0 OID 192546)
-- Dependencies: 308
-- Data for Name: documentotipos; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.documentotipos (coddocumentotipo, descripcion, oficial, estado) FROM stdin;
2	DNI	1	1
3	CARNET DE EXTRANJERIA	4	1
4	RUC	6	1
5	PASAPORTE	7	1
1	SIN DOCUMENTO	0	1
\.


--
-- TOC entry 4127 (class 0 OID 192590)
-- Dependencies: 318
-- Data for Name: empleados; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.empleados (codpersona, codarea, codcargo, codsucursal, tipoempleado, sueldotipo, sueldo, estado, sueldohora) FROM stdin;
0	2	4	1	1	1	0.00	1	\N
6978	1	2	1	1	1	0.00	1	\N
\.


--
-- TOC entry 4128 (class 0 OID 192598)
-- Dependencies: 319
-- Data for Name: empresas; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.empresas (codempresa, codpersona, igvsunat, icbpersunat, iscsunat, extrasunat, facturacion, slogan, rubro, copiaseguridad, logoauspiciador, claveseguridad, itemrepetircomprobante, ubigeo, departamento, provincia, distrito, publicidad, agradecimiento, controlstocktipo, linkdescargacomprobantes) FROM stdin;
1	1	18.00	0.40	1.00	0.00	1	\N	2	\N	\N	7391	1	220908	SAN MARTIN	SAN MARTIN	SAN MARTIN	\N	\N	2	https://ww1.sunat.gob.pe/ol-ti-itconsvalicpe/ConsValiCpe.htm
\.


--
-- TOC entry 4120 (class 0 OID 192550)
-- Dependencies: 309
-- Data for Name: personas; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.personas (codpersona, codubigeo, coddocumentotipo, tipopersona, documento, razonsocial, nombrecomercial, direccion, telefono, fechanacimiento, email, sexo, foto, estado, codsucursal) FROM stdin;
1	1740	4	2	10701840017	LOPEZ DE LA CRUZ, JAIDER	TOCHO	--		\N		M	default.png	1	1
2	0	1	1	00000000	VARIOS VENTAS VARIOS	VARIOS	SIN DIRECCION	00000000	\N	\N	1	default.png	1	1
0	1740	2	1	-	USUARIO SOPORTE	SUPER ADMIN	TARAPOTO	930576964	\N		M	default.png	1	\N
6978	0	2	1	70184001	LOPEZ DE LA CRUZ JAIDER	\N	-		\N		M	default.png	1	\N
6979	0	4	1	10703237016	CRUZ VILCHEZ ALFREDO DEYVI	-	-		\N		\N	default.png	1	\N
6980	0	4	1	20224209763	INSTITUTO PARA EL DESARROLLO Y LA PAZ AMAZONICA	-	JR. PROGRESO NRO 767 URB. 9 DE ABRIL 		\N		\N	default.png	1	\N
6981	0	4	1	20609991683	AGROINDUSTRIAS EL MAIZAL DE SAN JOSE S.A.C	-	JR. LOS LIRIOS NRO 279 	927843567	\N		\N	default.png	1	\N
6982	0	4	1	10457554139	PAREDES ALVARADO LUIS ALBERTO		-		\N		\N	default.png	1	\N
6983	0	4	1	20101259014	FUNDACION PARA EL DESARROLLO AGRARIO	-	JR. CAMILO CARRILLO NRO 325 		\N		\N	default.png	1	\N
6984	0	4	1	20450278051	CONSTRUCTORA INMOBILIARIA RIO HUALLAGA  S.A.C	-	AV. CIRCUNVALACION NRO 2283 		\N		\N	default.png	1	\N
6985	0	4	1	20542249669	ESTACION EXPERIMENTAL AGRARIA EL PORVENIR - SAN MARTIN	-	CAR. MARGINAL SUR NRO S/N 		\N		\N	default.png	1	\N
6986	0	4	1	10410194151	PALOMINO TARQUI JESSICA MAGDALENA	-	-		\N		\N	default.png	1	\N
6987	0	4	1	20609934981	B Y J SERVICIOS Y CONSTRUCCIONES S.A.C.	-	JR. CAMILA MOREY NRO 118 PARTIDO ALTO 		\N		\N	default.png	1	\N
6988	0	4	1	10401429412	ROSALES MENDEZ HENRY BENJAMIN	-	-		\N		\N	default.png	1	\N
\.


--
-- TOC entry 4131 (class 0 OID 192617)
-- Dependencies: 322
-- Data for Name: rubros; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.rubros (codrubro, descripcion, estado, concaducidad, controlstock) FROM stdin;
1	FERRETERIA	1	0	1
2	RESTAURANTE	1	1	1
3	CEBICHERIA	1	1	1
4	TIENDA COMERCIAL	1	0	1
5	RESTOBAR	1	0	1
6	LICORERIA	1	0	1
\.


--
-- TOC entry 4133 (class 0 OID 192625)
-- Dependencies: 324
-- Data for Name: socios; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.socios (codpersona, codsociotipo, usuario, clave, estado, codpatrocinador, licenciadeconducir, conductor) FROM stdin;
0	3	70323701	70323701	1	0	\N	0
2	1	00000000	00000000	1	0	\N	0
1	2	10765382331	10765382331	1	0	\N	0
6979	1	10703237016	10703237016	1	0	\N	0
6980	1	20224209763	20224209763	1	0	\N	0
6981	1	20609991683	20609991683	1	0	\N	0
6982	1	10457554139	10457554139	1	0	\N	0
6983	1	20101259014	20101259014	1	0	\N	0
6984	1	20450278051	20450278051	1	0	\N	0
6985	1	20542249669	20542249669	1	0	\N	0
6986	1	10410194151	10410194151	1	0	\N	0
6987	1	20609934981	20609934981	1	0	\N	0
6988	1	10401429412	10401429412	1	0	\N	0
\.


--
-- TOC entry 4134 (class 0 OID 192631)
-- Dependencies: 325
-- Data for Name: sociotipos; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.sociotipos (codsociotipo, descripcion, estado) FROM stdin;
1	CLIENTES	1
2	PROVEEDORES	1
3	CLIENTE / PROVEEDOR	1
\.


--
-- TOC entry 4136 (class 0 OID 192637)
-- Dependencies: 327
-- Data for Name: sucursales; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.sucursales (codsucursal, codempresa, descripcion, direccion, telefonos, codcomprobantetipo, seriecomprobante, estado, principal, codubigeo, envioautomaticofe, envioautomaticobve, envioautomaticogre, coddespachotipo) FROM stdin;
1	1	JUAN GUERRA	---	938 262 304	5	NV01	1	1	1747	0	0	0	1                   
\.


--
-- TOC entry 4138 (class 0 OID 192648)
-- Dependencies: 329
-- Data for Name: ubigeo; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.ubigeo (codubigeo, ubidepartamento, ubiprovincia, ubidistrito, departamento, provincia, distrito) FROM stdin;
1	01	01	01	AMAZONAS	CHACHAPOYAS	CHACHAPOYAS
2	01	01	02	AMAZONAS	CHACHAPOYAS	ASUNCION
3	01	01	03	AMAZONAS	CHACHAPOYAS	BALSAS
4	01	01	04	AMAZONAS	CHACHAPOYAS	CHETO
5	01	01	05	AMAZONAS	CHACHAPOYAS	CHILIQUIN
6	01	01	06	AMAZONAS	CHACHAPOYAS	CHUQUIBAMBA
7	01	01	07	AMAZONAS	CHACHAPOYAS	GRANADA
8	01	01	08	AMAZONAS	CHACHAPOYAS	HUANCAS
9	01	01	09	AMAZONAS	CHACHAPOYAS	LA JALCA
10	01	01	10	AMAZONAS	CHACHAPOYAS	LEIMEBAMBA
11	01	01	11	AMAZONAS	CHACHAPOYAS	LEVANTO
12	01	01	12	AMAZONAS	CHACHAPOYAS	MAGDALENA
13	01	01	13	AMAZONAS	CHACHAPOYAS	MARISCAL CASTILLA
14	01	01	14	AMAZONAS	CHACHAPOYAS	MOLINOPAMPA
15	01	01	15	AMAZONAS	CHACHAPOYAS	MONTEVIDEO
16	01	01	16	AMAZONAS	CHACHAPOYAS	OLLEROS
17	01	01	17	AMAZONAS	CHACHAPOYAS	QUINJALCA
18	01	01	18	AMAZONAS	CHACHAPOYAS	SAN FRANCISCO DE DAGUAS
19	01	01	19	AMAZONAS	CHACHAPOYAS	SAN ISIDRO DE MAINO
20	01	01	20	AMAZONAS	CHACHAPOYAS	SOLOCO
21	01	01	21	AMAZONAS	CHACHAPOYAS	SONCHE
22	01	02	01	AMAZONAS	BAGUA	LA PECA
23	01	02	02	AMAZONAS	BAGUA	ARAMANGO
24	01	02	03	AMAZONAS	BAGUA	COPALLIN
25	01	02	04	AMAZONAS	BAGUA	EL PARCO
26	01	02	05	AMAZONAS	BAGUA	BAGUA
27	01	02	06	AMAZONAS	BAGUA	IMAZA
28	01	03	01	AMAZONAS	BONGARA	JUMBILLA
29	01	03	02	AMAZONAS	BONGARA	COROSHA
30	01	03	03	AMAZONAS	BONGARA	CUISPES
31	01	03	04	AMAZONAS	BONGARA	CHISQUILLA
32	01	03	05	AMAZONAS	BONGARA	CHURUJA
33	01	03	06	AMAZONAS	BONGARA	FLORIDA
34	01	03	07	AMAZONAS	BONGARA	RECTA
35	01	03	08	AMAZONAS	BONGARA	SAN CARLOS
36	01	03	09	AMAZONAS	BONGARA	SHIPASBAMBA
37	01	03	10	AMAZONAS	BONGARA	VALERA
38	01	03	11	AMAZONAS	BONGARA	YAMBRASBAMBA
39	01	03	12	AMAZONAS	BONGARA	JAZAN
40	01	04	01	AMAZONAS	LUYA	LAMUD
41	01	04	02	AMAZONAS	LUYA	CAMPORREDONDO
42	01	04	03	AMAZONAS	LUYA	COCABAMBA
43	01	04	04	AMAZONAS	LUYA	COLCAMAR
44	01	04	05	AMAZONAS	LUYA	CONILA
45	01	04	06	AMAZONAS	LUYA	INGUILPATA
46	01	04	07	AMAZONAS	LUYA	LONGUITA
47	01	04	08	AMAZONAS	LUYA	LONYA CHICO
48	01	04	09	AMAZONAS	LUYA	LUYA
49	01	04	10	AMAZONAS	LUYA	LUYA VIEJO
50	01	04	11	AMAZONAS	LUYA	MARIA
51	01	04	12	AMAZONAS	LUYA	OCALLI
52	01	04	13	AMAZONAS	LUYA	OCUMAL
53	01	04	14	AMAZONAS	LUYA	PISUQUIA
54	01	04	15	AMAZONAS	LUYA	SAN CRISTOBAL
55	01	04	16	AMAZONAS	LUYA	SAN FRANCISCO DE YESO
56	01	04	17	AMAZONAS	LUYA	SAN JERONIMO
57	01	04	18	AMAZONAS	LUYA	SAN JUAN DE LOPECANCHA
58	01	04	19	AMAZONAS	LUYA	SANTA CATALINA
59	01	04	20	AMAZONAS	LUYA	SANTO TOMAS
60	01	04	21	AMAZONAS	LUYA	TINGO
61	01	04	22	AMAZONAS	LUYA	TRITA
62	01	04	23	AMAZONAS	LUYA	PROVIDENCIA
63	01	05	01	AMAZONAS	RODRIGUEZ DE MENDOZA	SAN NICOLAS
64	01	05	02	AMAZONAS	RODRIGUEZ DE MENDOZA	COCHAMAL
65	01	05	03	AMAZONAS	RODRIGUEZ DE MENDOZA	CHIRIMOTO
66	01	05	04	AMAZONAS	RODRIGUEZ DE MENDOZA	HUAMBO
67	01	05	05	AMAZONAS	RODRIGUEZ DE MENDOZA	LIMABAMBA
68	01	05	06	AMAZONAS	RODRIGUEZ DE MENDOZA	LONGAR
69	01	05	07	AMAZONAS	RODRIGUEZ DE MENDOZA	MILPUCC
70	01	05	08	AMAZONAS	RODRIGUEZ DE MENDOZA	MARISCAL BENAVIDES
71	01	05	09	AMAZONAS	RODRIGUEZ DE MENDOZA	OMIA
72	01	05	10	AMAZONAS	RODRIGUEZ DE MENDOZA	SANTA ROSA
73	01	05	11	AMAZONAS	RODRIGUEZ DE MENDOZA	TOTORA
74	01	05	12	AMAZONAS	RODRIGUEZ DE MENDOZA	VISTA ALEGRE
75	01	06	01	AMAZONAS	CONDORCANQUI	NIEVA
76	01	06	02	AMAZONAS	CONDORCANQUI	RIO SANTIAGO
77	01	06	03	AMAZONAS	CONDORCANQUI	EL CENEPA
78	01	07	01	AMAZONAS	UTCUBAMBA	BAGUA GRANDE
79	01	07	02	AMAZONAS	UTCUBAMBA	CAJARURO
80	01	07	03	AMAZONAS	UTCUBAMBA	CUMBA
81	01	07	04	AMAZONAS	UTCUBAMBA	EL MILAGRO
82	01	07	05	AMAZONAS	UTCUBAMBA	JAMALCA
83	01	07	06	AMAZONAS	UTCUBAMBA	LONYA GRANDE
84	01	07	07	AMAZONAS	UTCUBAMBA	YAMON
85	02	01	01	ANCASH	HUARAZ	HUARAZ
86	02	01	02	ANCASH	HUARAZ	INDEPENDENCIA
87	02	01	03	ANCASH	HUARAZ	COCHABAMBA
88	02	01	04	ANCASH	HUARAZ	COLCABAMBA
89	02	01	05	ANCASH	HUARAZ	HUANCHAY
90	02	01	06	ANCASH	HUARAZ	JANGAS
91	02	01	07	ANCASH	HUARAZ	LA LIBERTAD
92	02	01	08	ANCASH	HUARAZ	OLLEROS
93	02	01	09	ANCASH	HUARAZ	PAMPAS GRANDE
94	02	01	10	ANCASH	HUARAZ	PARIACOTO
95	02	01	11	ANCASH	HUARAZ	PIRA
96	02	01	12	ANCASH	HUARAZ	TARICA
97	02	02	01	ANCASH	AIJA	AIJA
98	02	02	03	ANCASH	AIJA	CORIS
99	02	02	05	ANCASH	AIJA	HUACLLAN
100	02	02	06	ANCASH	AIJA	LA MERCED
101	02	02	08	ANCASH	AIJA	SUCCHA
102	02	03	01	ANCASH	BOLOGNESI	CHIQUIAN
103	02	03	02	ANCASH	BOLOGNESI	ABELARDO PARDO LEZAMETA
104	02	03	04	ANCASH	BOLOGNESI	AQUIA
105	02	03	05	ANCASH	BOLOGNESI	CAJACAY
106	02	03	10	ANCASH	BOLOGNESI	HUAYLLACAYAN
107	02	03	11	ANCASH	BOLOGNESI	HUASTA
108	02	03	13	ANCASH	BOLOGNESI	MANGAS
109	02	03	15	ANCASH	BOLOGNESI	PACLLON
110	02	03	17	ANCASH	BOLOGNESI	SAN MIGUEL DE CORPANQUI
111	02	03	20	ANCASH	BOLOGNESI	TICLLOS
112	02	03	21	ANCASH	BOLOGNESI	ANTONIO RAIMONDI
113	02	03	22	ANCASH	BOLOGNESI	CANIS
114	02	03	23	ANCASH	BOLOGNESI	COLQUIOC
115	02	03	24	ANCASH	BOLOGNESI	LA PRIMAVERA
116	02	03	25	ANCASH	BOLOGNESI	HUALLANCA
117	02	04	01	ANCASH	CARHUAZ	CARHUAZ
118	02	04	02	ANCASH	CARHUAZ	ACOPAMPA
119	02	04	03	ANCASH	CARHUAZ	AMASHCA
120	02	04	04	ANCASH	CARHUAZ	ANTA
121	02	04	05	ANCASH	CARHUAZ	ATAQUERO
122	02	04	06	ANCASH	CARHUAZ	MARCARA
123	02	04	07	ANCASH	CARHUAZ	PARIAHUANCA
124	02	04	08	ANCASH	CARHUAZ	SAN MIGUEL DE ACO
125	02	04	09	ANCASH	CARHUAZ	SHILLA
126	02	04	10	ANCASH	CARHUAZ	TINCO
127	02	04	11	ANCASH	CARHUAZ	YUNGAR
128	02	05	01	ANCASH	CASMA	CASMA
129	02	05	02	ANCASH	CASMA	BUENA VISTA ALTA
130	02	05	03	ANCASH	CASMA	COMANDANTE NOEL
131	02	05	05	ANCASH	CASMA	YAUTAN
132	02	06	01	ANCASH	CORONGO	CORONGO
133	02	06	02	ANCASH	CORONGO	ACO
134	02	06	03	ANCASH	CORONGO	BAMBAS
135	02	06	04	ANCASH	CORONGO	CUSCA
136	02	06	05	ANCASH	CORONGO	LA PAMPA
137	02	06	06	ANCASH	CORONGO	YANAC
138	02	06	07	ANCASH	CORONGO	YUPAN
139	02	07	01	ANCASH	HUAYLAS	CARAZ
140	02	07	02	ANCASH	HUAYLAS	HUALLANCA
141	02	07	03	ANCASH	HUAYLAS	HUATA
142	02	07	04	ANCASH	HUAYLAS	HUAYLAS
143	02	07	05	ANCASH	HUAYLAS	MATO
144	02	07	06	ANCASH	HUAYLAS	PAMPAROMAS
145	02	07	07	ANCASH	HUAYLAS	PUEBLO LIBRE
146	02	07	08	ANCASH	HUAYLAS	SANTA CRUZ
147	02	07	09	ANCASH	HUAYLAS	YURACMARCA
148	02	07	10	ANCASH	HUAYLAS	SANTO TORIBIO
149	02	08	01	ANCASH	HUARI	HUARI
150	02	08	02	ANCASH	HUARI	CAJAY
151	02	08	03	ANCASH	HUARI	CHAVIN DE HUANTAR
152	02	08	04	ANCASH	HUARI	HUACACHI
153	02	08	05	ANCASH	HUARI	HUACHIS
154	02	08	06	ANCASH	HUARI	HUACCHIS
155	02	08	07	ANCASH	HUARI	HUANTAR
156	02	08	08	ANCASH	HUARI	MASIN
157	02	08	09	ANCASH	HUARI	PAUCAS
158	02	08	10	ANCASH	HUARI	PONTO
159	02	08	11	ANCASH	HUARI	RAHUAPAMPA
160	02	08	12	ANCASH	HUARI	RAPAYAN
161	02	08	13	ANCASH	HUARI	SAN MARCOS
162	02	08	14	ANCASH	HUARI	SAN PEDRO DE CHANA
163	02	08	15	ANCASH	HUARI	UCO
164	02	08	16	ANCASH	HUARI	ANRA
165	02	09	01	ANCASH	MARISCAL LUZURIAGA	PISCOBAMBA
166	02	09	02	ANCASH	MARISCAL LUZURIAGA	CASCA
167	02	09	03	ANCASH	MARISCAL LUZURIAGA	LUCMA
168	02	09	04	ANCASH	MARISCAL LUZURIAGA	FIDEL OLIVAS ESCUDERO
169	02	09	05	ANCASH	MARISCAL LUZURIAGA	LLAMA
170	02	09	06	ANCASH	MARISCAL LUZURIAGA	LLUMPA
171	02	09	07	ANCASH	MARISCAL LUZURIAGA	MUSGA
172	02	09	08	ANCASH	MARISCAL LUZURIAGA	ELEAZAR GUZMAN BARRON
173	02	10	01	ANCASH	PALLASCA	CABANA
174	02	10	02	ANCASH	PALLASCA	BOLOGNESI
175	02	10	03	ANCASH	PALLASCA	CONCHUCOS
176	02	10	04	ANCASH	PALLASCA	HUACASCHUQUE
177	02	10	05	ANCASH	PALLASCA	HUANDOVAL
178	02	10	06	ANCASH	PALLASCA	LACABAMBA
179	02	10	07	ANCASH	PALLASCA	LLAPO
180	02	10	08	ANCASH	PALLASCA	PALLASCA
181	02	10	09	ANCASH	PALLASCA	PAMPAS
182	02	10	10	ANCASH	PALLASCA	SANTA ROSA
183	02	10	11	ANCASH	PALLASCA	TAUCA
184	02	11	01	ANCASH	POMABAMBA	POMABAMBA
185	02	11	02	ANCASH	POMABAMBA	HUAYLLAN
186	02	11	03	ANCASH	POMABAMBA	PAROBAMBA
187	02	11	04	ANCASH	POMABAMBA	QUINUABAMBA
188	02	12	01	ANCASH	RECUAY	RECUAY
189	02	12	02	ANCASH	RECUAY	COTAPARACO
190	02	12	03	ANCASH	RECUAY	HUAYLLAPAMPA
191	02	12	04	ANCASH	RECUAY	MARCA
192	02	12	05	ANCASH	RECUAY	PAMPAS CHICO
193	02	12	06	ANCASH	RECUAY	PARARIN
194	02	12	07	ANCASH	RECUAY	TAPACOCHA
195	02	12	08	ANCASH	RECUAY	TICAPAMPA
196	02	12	09	ANCASH	RECUAY	LLACLLIN
197	02	12	10	ANCASH	RECUAY	CATAC
198	02	13	01	ANCASH	SANTA	CHIMBOTE
199	02	13	02	ANCASH	SANTA	CACERES DEL PERU
200	02	13	03	ANCASH	SANTA	MACATE
201	02	13	04	ANCASH	SANTA	MORO
202	02	13	05	ANCASH	SANTA	NEPEÑA
203	02	13	06	ANCASH	SANTA	SAMANCO
204	02	13	07	ANCASH	SANTA	SANTA
205	02	13	08	ANCASH	SANTA	COISHCO
206	02	13	09	ANCASH	SANTA	NUEVO CHIMBOTE
207	02	14	01	ANCASH	SIHUAS	SIHUAS
208	02	14	02	ANCASH	SIHUAS	ALFONSO UGARTE
209	02	14	03	ANCASH	SIHUAS	CHINGALPO
210	02	14	04	ANCASH	SIHUAS	HUAYLLABAMBA
211	02	14	05	ANCASH	SIHUAS	QUICHES
212	02	14	06	ANCASH	SIHUAS	SICSIBAMBA
213	02	14	07	ANCASH	SIHUAS	ACOBAMBA
214	02	14	08	ANCASH	SIHUAS	CASHAPAMPA
215	02	14	09	ANCASH	SIHUAS	RAGASH
216	02	14	10	ANCASH	SIHUAS	SAN JUAN
217	02	15	01	ANCASH	YUNGAY	YUNGAY
218	02	15	02	ANCASH	YUNGAY	CASCAPARA
219	02	15	03	ANCASH	YUNGAY	MANCOS
220	02	15	04	ANCASH	YUNGAY	MATACOTO
221	02	15	05	ANCASH	YUNGAY	QUILLO
222	02	15	06	ANCASH	YUNGAY	RANRAHIRCA
223	02	15	07	ANCASH	YUNGAY	SHUPLUY
224	02	15	08	ANCASH	YUNGAY	YANAMA
225	02	16	01	ANCASH	ANTONIO RAIMONDI	LLAMELLIN
226	02	16	02	ANCASH	ANTONIO RAIMONDI	ACZO
227	02	16	03	ANCASH	ANTONIO RAIMONDI	CHACCHO
228	02	16	04	ANCASH	ANTONIO RAIMONDI	CHINGAS
229	02	16	05	ANCASH	ANTONIO RAIMONDI	MIRGAS
230	02	16	06	ANCASH	ANTONIO RAIMONDI	SAN JUAN DE RONTOY
231	02	17	01	ANCASH	CARLOS FERMIN FITZCARRALD	SAN LUIS
232	02	17	02	ANCASH	CARLOS FERMIN FITZCARRALD	YAUYA
233	02	17	03	ANCASH	CARLOS FERMIN FITZCARRALD	SAN NICOLAS
234	02	18	01	ANCASH	ASUNCION	CHACAS
235	02	18	02	ANCASH	ASUNCION	ACOCHACA
236	02	19	01	ANCASH	HUARMEY	HUARMEY
237	02	19	02	ANCASH	HUARMEY	COCHAPETI
238	02	19	03	ANCASH	HUARMEY	HUAYAN
239	02	19	04	ANCASH	HUARMEY	MALVAS
240	02	19	05	ANCASH	HUARMEY	CULEBRAS
241	02	20	01	ANCASH	OCROS	ACAS
242	02	20	02	ANCASH	OCROS	CAJAMARQUILLA
243	02	20	03	ANCASH	OCROS	CARHUAPAMPA
244	02	20	04	ANCASH	OCROS	COCHAS
245	02	20	05	ANCASH	OCROS	CONGAS
246	02	20	06	ANCASH	OCROS	LLIPA
247	02	20	07	ANCASH	OCROS	OCROS
248	02	20	08	ANCASH	OCROS	SAN CRISTOBAL DE RAJAN
249	02	20	09	ANCASH	OCROS	SAN PEDRO
250	02	20	10	ANCASH	OCROS	SANTIAGO DE CHILCAS
251	03	01	01	APURIMAC	ABANCAY	ABANCAY
252	03	01	02	APURIMAC	ABANCAY	CIRCA
253	03	01	03	APURIMAC	ABANCAY	CURAHUASI
254	03	01	04	APURIMAC	ABANCAY	CHACOCHE
255	03	01	05	APURIMAC	ABANCAY	HUANIPACA
256	03	01	06	APURIMAC	ABANCAY	LAMBRAMA
257	03	01	07	APURIMAC	ABANCAY	PICHIRHUA
258	03	01	08	APURIMAC	ABANCAY	SAN PEDRO DE CACHORA
259	03	01	09	APURIMAC	ABANCAY	TAMBURCO
260	03	02	01	APURIMAC	AYMARAES	CHALHUANCA
261	03	02	02	APURIMAC	AYMARAES	CAPAYA
262	03	02	03	APURIMAC	AYMARAES	CARAYBAMBA
263	03	02	04	APURIMAC	AYMARAES	COLCABAMBA
264	03	02	05	APURIMAC	AYMARAES	COTARUSE
265	03	02	06	APURIMAC	AYMARAES	CHAPIMARCA
266	03	02	07	APURIMAC	AYMARAES	HUAYLLO
267	03	02	08	APURIMAC	AYMARAES	LUCRE
268	03	02	09	APURIMAC	AYMARAES	POCOHUANCA
269	03	02	10	APURIMAC	AYMARAES	SAÑAYCA
270	03	02	11	APURIMAC	AYMARAES	SORAYA
271	03	02	12	APURIMAC	AYMARAES	TAPAIRIHUA
272	03	02	13	APURIMAC	AYMARAES	TINTAY
273	03	02	14	APURIMAC	AYMARAES	TORAYA
274	03	02	15	APURIMAC	AYMARAES	YANACA
275	03	02	16	APURIMAC	AYMARAES	SAN JUAN DE CHACÑA
276	03	02	17	APURIMAC	AYMARAES	JUSTO APU SAHUARAURA
277	03	03	01	APURIMAC	ANDAHUAYLAS	ANDAHUAYLAS
278	03	03	02	APURIMAC	ANDAHUAYLAS	ANDARAPA
279	03	03	03	APURIMAC	ANDAHUAYLAS	CHIARA
280	03	03	04	APURIMAC	ANDAHUAYLAS	HUANCARAMA
281	03	03	05	APURIMAC	ANDAHUAYLAS	HUANCARAY
282	03	03	06	APURIMAC	ANDAHUAYLAS	KISHUARA
283	03	03	07	APURIMAC	ANDAHUAYLAS	PACOBAMBA
284	03	03	08	APURIMAC	ANDAHUAYLAS	PAMPACHIRI
285	03	03	09	APURIMAC	ANDAHUAYLAS	SAN ANTONIO DE CACHI
286	03	03	10	APURIMAC	ANDAHUAYLAS	SAN JERONIMO
287	03	03	11	APURIMAC	ANDAHUAYLAS	TALAVERA
288	03	03	12	APURIMAC	ANDAHUAYLAS	TURPO
289	03	03	13	APURIMAC	ANDAHUAYLAS	PACUCHA
290	03	03	14	APURIMAC	ANDAHUAYLAS	POMACOCHA
291	03	03	15	APURIMAC	ANDAHUAYLAS	SANTA MARIA DE CHICMO
292	03	03	16	APURIMAC	ANDAHUAYLAS	TUMAY HUARACA
293	03	03	17	APURIMAC	ANDAHUAYLAS	HUAYANA
294	03	03	18	APURIMAC	ANDAHUAYLAS	SAN MIGUEL DE CHACCRAMPA
295	03	03	19	APURIMAC	ANDAHUAYLAS	KAQUIABAMBA
296	03	04	01	APURIMAC	ANTABAMBA	ANTABAMBA
297	03	04	02	APURIMAC	ANTABAMBA	EL ORO
298	03	04	03	APURIMAC	ANTABAMBA	HUAQUIRCA
299	03	04	04	APURIMAC	ANTABAMBA	JUAN ESPINOZA MEDRANO
300	03	04	05	APURIMAC	ANTABAMBA	OROPESA
301	03	04	06	APURIMAC	ANTABAMBA	PACHACONAS
302	03	04	07	APURIMAC	ANTABAMBA	SABAINO
303	03	05	01	APURIMAC	COTABAMBAS	TAMBOBAMBA
304	03	05	02	APURIMAC	COTABAMBAS	COYLLURQUI
305	03	05	03	APURIMAC	COTABAMBAS	COTABAMBAS
306	03	05	04	APURIMAC	COTABAMBAS	HAQUIRA
307	03	05	05	APURIMAC	COTABAMBAS	MARA
308	03	05	06	APURIMAC	COTABAMBAS	CHALLHUAHUACHO
309	03	06	01	APURIMAC	GRAU	CHUQUIBAMBILLA
310	03	06	02	APURIMAC	GRAU	CURPAHUASI
311	03	06	03	APURIMAC	GRAU	HUAILLATI
312	03	06	04	APURIMAC	GRAU	MAMARA
313	03	06	05	APURIMAC	GRAU	MARISCAL GAMARRA
314	03	06	06	APURIMAC	GRAU	MICAELA BASTIDAS
315	03	06	07	APURIMAC	GRAU	PROGRESO
316	03	06	08	APURIMAC	GRAU	PATAYPAMPA
317	03	06	09	APURIMAC	GRAU	SAN ANTONIO
318	03	06	10	APURIMAC	GRAU	TURPAY
319	03	06	11	APURIMAC	GRAU	VILCABAMBA
320	03	06	12	APURIMAC	GRAU	VIRUNDO
321	03	06	13	APURIMAC	GRAU	SANTA ROSA
322	03	06	14	APURIMAC	GRAU	CURASCO
323	03	07	01	APURIMAC	CHINCHEROS	CHINCHEROS
324	03	07	02	APURIMAC	CHINCHEROS	ONGOY
325	03	07	03	APURIMAC	CHINCHEROS	OCOBAMBA
326	03	07	04	APURIMAC	CHINCHEROS	COCHARCAS
327	03	07	05	APURIMAC	CHINCHEROS	ANCO HUALLO
328	03	07	06	APURIMAC	CHINCHEROS	HUACCANA
329	03	07	07	APURIMAC	CHINCHEROS	URANMARCA
330	03	07	08	APURIMAC	CHINCHEROS	RANRACANCHA
331	04	01	01	AREQUIPA	AREQUIPA	AREQUIPA
332	04	01	02	AREQUIPA	AREQUIPA	CAYMA
333	04	01	03	AREQUIPA	AREQUIPA	CERRO COLORADO
334	04	01	04	AREQUIPA	AREQUIPA	CHARACATO
335	04	01	05	AREQUIPA	AREQUIPA	CHIGUATA
336	04	01	06	AREQUIPA	AREQUIPA	LA JOYA
337	04	01	07	AREQUIPA	AREQUIPA	MIRAFLORES
338	04	01	08	AREQUIPA	AREQUIPA	MOLLEBAYA
339	04	01	09	AREQUIPA	AREQUIPA	PAUCARPATA
340	04	01	10	AREQUIPA	AREQUIPA	POCSI
341	04	01	11	AREQUIPA	AREQUIPA	POLOBAYA
342	04	01	12	AREQUIPA	AREQUIPA	QUEQUEÑA
343	04	01	13	AREQUIPA	AREQUIPA	SABANDIA
344	04	01	14	AREQUIPA	AREQUIPA	SACHACA
345	04	01	15	AREQUIPA	AREQUIPA	SAN JUAN DE SIGUAS
346	04	01	16	AREQUIPA	AREQUIPA	SAN JUAN DE TARUCANI
347	04	01	17	AREQUIPA	AREQUIPA	SANTA ISABEL DE SIGUAS
348	04	01	18	AREQUIPA	AREQUIPA	SANTA RITA DE SIHUAS
349	04	01	19	AREQUIPA	AREQUIPA	SOCABAYA
350	04	01	20	AREQUIPA	AREQUIPA	TIABAYA
351	04	01	21	AREQUIPA	AREQUIPA	UCHUMAYO
352	04	01	22	AREQUIPA	AREQUIPA	VITOR
353	04	01	23	AREQUIPA	AREQUIPA	YANAHUARA
354	04	01	24	AREQUIPA	AREQUIPA	YARABAMBA
355	04	01	25	AREQUIPA	AREQUIPA	YURA
356	04	01	26	AREQUIPA	AREQUIPA	MARIANO MELGAR
357	04	01	27	AREQUIPA	AREQUIPA	JACOBO HUNTER
358	04	01	28	AREQUIPA	AREQUIPA	ALTO SELVA ALEGRE
359	04	01	29	AREQUIPA	AREQUIPA	JOSE LUIS BUSTAMANTE Y RIVERO
360	04	02	01	AREQUIPA	CAYLLOMA	CHIVAY
361	04	02	02	AREQUIPA	CAYLLOMA	ACHOMA
362	04	02	03	AREQUIPA	CAYLLOMA	CABANACONDE
363	04	02	04	AREQUIPA	CAYLLOMA	CAYLLOMA
364	04	02	05	AREQUIPA	CAYLLOMA	CALLALLI
365	04	02	06	AREQUIPA	CAYLLOMA	COPORAQUE
366	04	02	07	AREQUIPA	CAYLLOMA	HUAMBO
367	04	02	08	AREQUIPA	CAYLLOMA	HUANCA
368	04	02	09	AREQUIPA	CAYLLOMA	ICHUPAMPA
369	04	02	10	AREQUIPA	CAYLLOMA	LARI
370	04	02	11	AREQUIPA	CAYLLOMA	LLUTA
371	04	02	12	AREQUIPA	CAYLLOMA	MACA
372	04	02	13	AREQUIPA	CAYLLOMA	MADRIGAL
373	04	02	14	AREQUIPA	CAYLLOMA	SAN ANTONIO DE CHUCA
374	04	02	15	AREQUIPA	CAYLLOMA	SIBAYO
375	04	02	16	AREQUIPA	CAYLLOMA	TAPAY
376	04	02	17	AREQUIPA	CAYLLOMA	TISCO
377	04	02	18	AREQUIPA	CAYLLOMA	TUTI
378	04	02	19	AREQUIPA	CAYLLOMA	YANQUE
379	04	02	20	AREQUIPA	CAYLLOMA	MAJES
380	04	03	01	AREQUIPA	CAMANA	CAMANA
381	04	03	02	AREQUIPA	CAMANA	JOSE MARIA QUIMPER
382	04	03	03	AREQUIPA	CAMANA	MARIANO NICOLAS VALCARCEL
383	04	03	04	AREQUIPA	CAMANA	MARISCAL CACERES
384	04	03	05	AREQUIPA	CAMANA	NICOLAS DE PIEROLA
385	04	03	06	AREQUIPA	CAMANA	OCOÑA
386	04	03	07	AREQUIPA	CAMANA	QUILCA
387	04	03	08	AREQUIPA	CAMANA	SAMUEL PASTOR
388	04	04	01	AREQUIPA	CARAVELI	CARAVELI
389	04	04	02	AREQUIPA	CARAVELI	ACARI
390	04	04	03	AREQUIPA	CARAVELI	ATICO
391	04	04	04	AREQUIPA	CARAVELI	ATIQUIPA
392	04	04	05	AREQUIPA	CARAVELI	BELLA UNION
393	04	04	06	AREQUIPA	CARAVELI	CAHUACHO
394	04	04	07	AREQUIPA	CARAVELI	CHALA
395	04	04	08	AREQUIPA	CARAVELI	CHAPARRA
396	04	04	09	AREQUIPA	CARAVELI	HUANUHUANU
397	04	04	10	AREQUIPA	CARAVELI	JAQUI
398	04	04	11	AREQUIPA	CARAVELI	LOMAS
399	04	04	12	AREQUIPA	CARAVELI	QUICACHA
400	04	04	13	AREQUIPA	CARAVELI	YAUCA
401	04	05	01	AREQUIPA	CASTILLA	APLAO
402	04	05	02	AREQUIPA	CASTILLA	ANDAGUA
403	04	05	03	AREQUIPA	CASTILLA	AYO
404	04	05	04	AREQUIPA	CASTILLA	CHACHAS
405	04	05	05	AREQUIPA	CASTILLA	CHILCAYMARCA
406	04	05	06	AREQUIPA	CASTILLA	CHOCO
407	04	05	07	AREQUIPA	CASTILLA	HUANCARQUI
408	04	05	08	AREQUIPA	CASTILLA	MACHAGUAY
409	04	05	09	AREQUIPA	CASTILLA	ORCOPAMPA
410	04	05	10	AREQUIPA	CASTILLA	PAMPACOLCA
411	04	05	11	AREQUIPA	CASTILLA	TIPAN
412	04	05	12	AREQUIPA	CASTILLA	URACA
413	04	05	13	AREQUIPA	CASTILLA	UÑON
414	04	05	14	AREQUIPA	CASTILLA	VIRACO
415	04	06	01	AREQUIPA	CONDESUYOS	CHUQUIBAMBA
416	04	06	02	AREQUIPA	CONDESUYOS	ANDARAY
417	04	06	03	AREQUIPA	CONDESUYOS	CAYARANI
418	04	06	04	AREQUIPA	CONDESUYOS	CHICHAS
419	04	06	05	AREQUIPA	CONDESUYOS	IRAY
420	04	06	06	AREQUIPA	CONDESUYOS	SALAMANCA
421	04	06	07	AREQUIPA	CONDESUYOS	YANAQUIHUA
422	04	06	08	AREQUIPA	CONDESUYOS	RIO GRANDE
423	04	07	01	AREQUIPA	ISLAY	MOLLENDO
424	04	07	02	AREQUIPA	ISLAY	COCACHACRA
425	04	07	03	AREQUIPA	ISLAY	DEAN VALDIVIA
426	04	07	04	AREQUIPA	ISLAY	ISLAY
427	04	07	05	AREQUIPA	ISLAY	MEJIA
428	04	07	06	AREQUIPA	ISLAY	PUNTA DE BOMBON
429	04	08	01	AREQUIPA	LA UNION	COTAHUASI
430	04	08	02	AREQUIPA	LA UNION	ALCA
431	04	08	03	AREQUIPA	LA UNION	CHARCANA
432	04	08	04	AREQUIPA	LA UNION	HUAYNACOTAS
433	04	08	05	AREQUIPA	LA UNION	PAMPAMARCA
434	04	08	06	AREQUIPA	LA UNION	PUYCA
435	04	08	07	AREQUIPA	LA UNION	QUECHUALLA
436	04	08	08	AREQUIPA	LA UNION	SAYLA
437	04	08	09	AREQUIPA	LA UNION	TAURIA
438	04	08	10	AREQUIPA	LA UNION	TOMEPAMPA
439	04	08	11	AREQUIPA	LA UNION	TORO
440	05	01	01	AYACUCHO	HUAMANGA	AYACUCHO
441	05	01	02	AYACUCHO	HUAMANGA	ACOS VINCHOS
442	05	01	03	AYACUCHO	HUAMANGA	CARMEN ALTO
443	05	01	04	AYACUCHO	HUAMANGA	CHIARA
444	05	01	05	AYACUCHO	HUAMANGA	QUINUA
445	05	01	06	AYACUCHO	HUAMANGA	SAN JOSE DE TICLLAS
446	05	01	07	AYACUCHO	HUAMANGA	SAN JUAN BAUTISTA
447	05	01	08	AYACUCHO	HUAMANGA	SANTIAGO DE PISCHA
448	05	01	09	AYACUCHO	HUAMANGA	VINCHOS
449	05	01	10	AYACUCHO	HUAMANGA	TAMBILLO
450	05	01	11	AYACUCHO	HUAMANGA	ACOCRO
451	05	01	12	AYACUCHO	HUAMANGA	SOCOS
452	05	01	13	AYACUCHO	HUAMANGA	OCROS
453	05	01	14	AYACUCHO	HUAMANGA	PACAYCASA
454	05	01	15	AYACUCHO	HUAMANGA	JESUS NAZARENO
455	05	02	01	AYACUCHO	CANGALLO	CANGALLO
456	05	02	04	AYACUCHO	CANGALLO	CHUSCHI
457	05	02	06	AYACUCHO	CANGALLO	LOS MOROCHUCOS
458	05	02	07	AYACUCHO	CANGALLO	PARAS
459	05	02	08	AYACUCHO	CANGALLO	TOTOS
460	05	02	11	AYACUCHO	CANGALLO	MARIA PARADO DE BELLIDO
461	05	03	01	AYACUCHO	HUANTA	HUANTA
462	05	03	02	AYACUCHO	HUANTA	AYAHUANCO
463	05	03	03	AYACUCHO	HUANTA	HUAMANGUILLA
464	05	03	04	AYACUCHO	HUANTA	IGUAIN
465	05	03	05	AYACUCHO	HUANTA	LURICOCHA
466	05	03	07	AYACUCHO	HUANTA	SANTILLANA
467	05	03	08	AYACUCHO	HUANTA	SIVIA
468	05	03	09	AYACUCHO	HUANTA	LLOCHEGUA
469	05	04	01	AYACUCHO	LA MAR	SAN MIGUEL
470	05	04	02	AYACUCHO	LA MAR	ANCO
471	05	04	03	AYACUCHO	LA MAR	AYNA
472	05	04	04	AYACUCHO	LA MAR	CHILCAS
473	05	04	05	AYACUCHO	LA MAR	CHUNGUI
474	05	04	06	AYACUCHO	LA MAR	TAMBO
475	05	04	07	AYACUCHO	LA MAR	LUIS CARRANZA
476	05	04	08	AYACUCHO	LA MAR	SANTA ROSA
477	05	04	09	AYACUCHO	LA MAR	SAMUGARI
478	05	05	01	AYACUCHO	LUCANAS	PUQUIO
479	05	05	02	AYACUCHO	LUCANAS	AUCARA
480	05	05	03	AYACUCHO	LUCANAS	CABANA
481	05	05	04	AYACUCHO	LUCANAS	CARMEN SALCEDO
482	05	05	06	AYACUCHO	LUCANAS	CHAVIÑA
483	05	05	08	AYACUCHO	LUCANAS	CHIPAO
484	05	05	10	AYACUCHO	LUCANAS	HUAC-HUAS
485	05	05	11	AYACUCHO	LUCANAS	LARAMATE
486	05	05	12	AYACUCHO	LUCANAS	LEONCIO PRADO
487	05	05	13	AYACUCHO	LUCANAS	LUCANAS
488	05	05	14	AYACUCHO	LUCANAS	LLAUTA
489	05	05	16	AYACUCHO	LUCANAS	OCAÑA
490	05	05	17	AYACUCHO	LUCANAS	OTOCA
491	05	05	20	AYACUCHO	LUCANAS	SANCOS
492	05	05	21	AYACUCHO	LUCANAS	SAN JUAN
493	05	05	22	AYACUCHO	LUCANAS	SAN PEDRO
494	05	05	24	AYACUCHO	LUCANAS	SANTA ANA DE HUAYCAHUACHO
495	05	05	25	AYACUCHO	LUCANAS	SANTA LUCIA
496	05	05	29	AYACUCHO	LUCANAS	SAISA
497	05	05	31	AYACUCHO	LUCANAS	SAN PEDRO DE PALCO
498	05	05	32	AYACUCHO	LUCANAS	SAN CRISTOBAL
499	05	06	01	AYACUCHO	PARINACOCHAS	CORACORA
500	05	06	04	AYACUCHO	PARINACOCHAS	CORONEL CASTAÑEDA
501	05	06	05	AYACUCHO	PARINACOCHAS	CHUMPI
502	05	06	08	AYACUCHO	PARINACOCHAS	PACAPAUSA
503	05	06	11	AYACUCHO	PARINACOCHAS	PULLO
504	05	06	12	AYACUCHO	PARINACOCHAS	PUYUSCA
505	05	06	15	AYACUCHO	PARINACOCHAS	SAN FRANCISCO DE RAVACAYCO
506	05	06	16	AYACUCHO	PARINACOCHAS	UPAHUACHO
507	05	07	01	AYACUCHO	VICTOR FAJARDO	HUANCAPI
508	05	07	02	AYACUCHO	VICTOR FAJARDO	ALCAMENCA
509	05	07	03	AYACUCHO	VICTOR FAJARDO	APONGO
510	05	07	04	AYACUCHO	VICTOR FAJARDO	CANARIA
511	05	07	06	AYACUCHO	VICTOR FAJARDO	CAYARA
512	05	07	07	AYACUCHO	VICTOR FAJARDO	COLCA
513	05	07	08	AYACUCHO	VICTOR FAJARDO	HUALLA
514	05	07	09	AYACUCHO	VICTOR FAJARDO	HUAMANQUIQUIA
515	05	07	10	AYACUCHO	VICTOR FAJARDO	HUANCARAYLLA
516	05	07	13	AYACUCHO	VICTOR FAJARDO	SARHUA
517	05	07	14	AYACUCHO	VICTOR FAJARDO	VILCANCHOS
518	05	07	15	AYACUCHO	VICTOR FAJARDO	ASQUIPATA
519	05	08	01	AYACUCHO	HUANCA SANCOS	SANCOS
520	05	08	02	AYACUCHO	HUANCA SANCOS	SACSAMARCA
521	05	08	03	AYACUCHO	HUANCA SANCOS	SANTIAGO DE LUCANAMARCA
522	05	08	04	AYACUCHO	HUANCA SANCOS	CARAPO
523	05	09	01	AYACUCHO	VILCAS HUAMAN	VILCAS HUAMAN
524	05	09	02	AYACUCHO	VILCAS HUAMAN	VISCHONGO
525	05	09	03	AYACUCHO	VILCAS HUAMAN	ACCOMARCA
526	05	09	04	AYACUCHO	VILCAS HUAMAN	CARHUANCA
527	05	09	05	AYACUCHO	VILCAS HUAMAN	CONCEPCION
528	05	09	06	AYACUCHO	VILCAS HUAMAN	HUAMBALPA
529	05	09	07	AYACUCHO	VILCAS HUAMAN	SAURAMA
530	05	09	08	AYACUCHO	VILCAS HUAMAN	INDEPENDENCIA
531	05	10	01	AYACUCHO	PAUCAR DEL SARA SARA	PAUSA
532	05	10	02	AYACUCHO	PAUCAR DEL SARA SARA	COLTA
533	05	10	03	AYACUCHO	PAUCAR DEL SARA SARA	CORCULLA
534	05	10	04	AYACUCHO	PAUCAR DEL SARA SARA	LAMPA
535	05	10	05	AYACUCHO	PAUCAR DEL SARA SARA	MARCABAMBA
536	05	10	06	AYACUCHO	PAUCAR DEL SARA SARA	OYOLO
537	05	10	07	AYACUCHO	PAUCAR DEL SARA SARA	PARARCA
538	05	10	08	AYACUCHO	PAUCAR DEL SARA SARA	SAN JAVIER DE ALPABAMBA
539	05	10	09	AYACUCHO	PAUCAR DEL SARA SARA	SAN JOSE DE USHUA
540	05	10	10	AYACUCHO	PAUCAR DEL SARA SARA	SARA SARA
541	05	11	01	AYACUCHO	SUCRE	QUEROBAMBA
542	05	11	02	AYACUCHO	SUCRE	BELEN
543	05	11	03	AYACUCHO	SUCRE	CHALCOS
544	05	11	04	AYACUCHO	SUCRE	SAN SALVADOR DE QUIJE
545	05	11	05	AYACUCHO	SUCRE	PAICO
546	05	11	06	AYACUCHO	SUCRE	SANTIAGO DE PAUCARAY
547	05	11	07	AYACUCHO	SUCRE	SAN PEDRO DE LARCAY
548	05	11	08	AYACUCHO	SUCRE	SORAS
549	05	11	09	AYACUCHO	SUCRE	HUACAÑA
550	05	11	10	AYACUCHO	SUCRE	CHILCAYOC
551	05	11	11	AYACUCHO	SUCRE	MORCOLLA
552	06	01	01	CAJAMARCA	CAJAMARCA	CAJAMARCA
553	06	01	02	CAJAMARCA	CAJAMARCA	ASUNCION
554	06	01	03	CAJAMARCA	CAJAMARCA	COSPAN
555	06	01	04	CAJAMARCA	CAJAMARCA	CHETILLA
556	06	01	05	CAJAMARCA	CAJAMARCA	ENCAÑADA
557	06	01	06	CAJAMARCA	CAJAMARCA	JESUS
558	06	01	07	CAJAMARCA	CAJAMARCA	LOS BAÑOS DEL INCA
559	06	01	08	CAJAMARCA	CAJAMARCA	LLACANORA
560	06	01	09	CAJAMARCA	CAJAMARCA	MAGDALENA
561	06	01	10	CAJAMARCA	CAJAMARCA	MATARA
562	06	01	11	CAJAMARCA	CAJAMARCA	NAMORA
563	06	01	12	CAJAMARCA	CAJAMARCA	SAN JUAN
564	06	02	01	CAJAMARCA	CAJABAMBA	CAJABAMBA
565	06	02	02	CAJAMARCA	CAJABAMBA	CACHACHI
566	06	02	03	CAJAMARCA	CAJABAMBA	CONDEBAMBA
567	06	02	05	CAJAMARCA	CAJABAMBA	SITACOCHA
568	06	03	01	CAJAMARCA	CELENDIN	CELENDIN
569	06	03	02	CAJAMARCA	CELENDIN	CORTEGANA
570	06	03	03	CAJAMARCA	CELENDIN	CHUMUCH
571	06	03	04	CAJAMARCA	CELENDIN	HUASMIN
572	06	03	05	CAJAMARCA	CELENDIN	JORGE CHAVEZ
573	06	03	06	CAJAMARCA	CELENDIN	JOSE GALVEZ
574	06	03	07	CAJAMARCA	CELENDIN	MIGUEL IGLESIAS
575	06	03	08	CAJAMARCA	CELENDIN	OXAMARCA
576	06	03	09	CAJAMARCA	CELENDIN	SOROCHUCO
577	06	03	10	CAJAMARCA	CELENDIN	SUCRE
578	06	03	11	CAJAMARCA	CELENDIN	UTCO
579	06	03	12	CAJAMARCA	CELENDIN	LA LIBERTAD DE PALLAN
580	06	04	01	CAJAMARCA	CONTUMAZA	CONTUMAZA
581	06	04	03	CAJAMARCA	CONTUMAZA	CHILETE
582	06	04	04	CAJAMARCA	CONTUMAZA	GUZMANGO
583	06	04	05	CAJAMARCA	CONTUMAZA	SAN BENITO
584	06	04	06	CAJAMARCA	CONTUMAZA	CUPISNIQUE
585	06	04	07	CAJAMARCA	CONTUMAZA	TANTARICA
586	06	04	08	CAJAMARCA	CONTUMAZA	YONAN
587	06	04	09	CAJAMARCA	CONTUMAZA	SANTA CRUZ DE TOLEDO
588	06	05	01	CAJAMARCA	CUTERVO	CUTERVO
589	06	05	02	CAJAMARCA	CUTERVO	CALLAYUC
590	06	05	03	CAJAMARCA	CUTERVO	CUJILLO
591	06	05	04	CAJAMARCA	CUTERVO	CHOROS
592	06	05	05	CAJAMARCA	CUTERVO	LA RAMADA
593	06	05	06	CAJAMARCA	CUTERVO	PIMPINGOS
594	06	05	07	CAJAMARCA	CUTERVO	QUEROCOTILLO
595	06	05	08	CAJAMARCA	CUTERVO	SAN ANDRES DE CUTERVO
596	06	05	09	CAJAMARCA	CUTERVO	SAN JUAN DE CUTERVO
597	06	05	10	CAJAMARCA	CUTERVO	SAN LUIS DE LUCMA
598	06	05	11	CAJAMARCA	CUTERVO	SANTA CRUZ
599	06	05	12	CAJAMARCA	CUTERVO	SANTO DOMINGO DE LA CAPILLA
600	06	05	13	CAJAMARCA	CUTERVO	SANTO TOMAS
601	06	05	14	CAJAMARCA	CUTERVO	SOCOTA
602	06	05	15	CAJAMARCA	CUTERVO	TORIBIO CASANOVA
603	06	06	01	CAJAMARCA	CHOTA	CHOTA
604	06	06	02	CAJAMARCA	CHOTA	ANGUIA
605	06	06	03	CAJAMARCA	CHOTA	COCHABAMBA
606	06	06	04	CAJAMARCA	CHOTA	CONCHAN
607	06	06	05	CAJAMARCA	CHOTA	CHADIN
608	06	06	06	CAJAMARCA	CHOTA	CHIGUIRIP
609	06	06	07	CAJAMARCA	CHOTA	CHIMBAN
610	06	06	08	CAJAMARCA	CHOTA	HUAMBOS
611	06	06	09	CAJAMARCA	CHOTA	LAJAS
612	06	06	10	CAJAMARCA	CHOTA	LLAMA
613	06	06	11	CAJAMARCA	CHOTA	MIRACOSTA
614	06	06	12	CAJAMARCA	CHOTA	PACCHA
615	06	06	13	CAJAMARCA	CHOTA	PION
616	06	06	14	CAJAMARCA	CHOTA	QUEROCOTO
617	06	06	15	CAJAMARCA	CHOTA	TACABAMBA
618	06	06	16	CAJAMARCA	CHOTA	TOCMOCHE
619	06	06	17	CAJAMARCA	CHOTA	SAN JUAN DE LICUPIS
620	06	06	18	CAJAMARCA	CHOTA	CHOROPAMPA
621	06	06	19	CAJAMARCA	CHOTA	CHALAMARCA
622	06	07	01	CAJAMARCA	HUALGAYOC	BAMBAMARCA
623	06	07	02	CAJAMARCA	HUALGAYOC	CHUGUR
624	06	07	03	CAJAMARCA	HUALGAYOC	HUALGAYOC
625	06	08	01	CAJAMARCA	JAEN	JAEN
626	06	08	02	CAJAMARCA	JAEN	BELLAVISTA
627	06	08	03	CAJAMARCA	JAEN	COLASAY
628	06	08	04	CAJAMARCA	JAEN	CHONTALI
629	06	08	05	CAJAMARCA	JAEN	POMAHUACA
630	06	08	06	CAJAMARCA	JAEN	PUCARA
631	06	08	07	CAJAMARCA	JAEN	SALLIQUE
632	06	08	08	CAJAMARCA	JAEN	SAN FELIPE
633	06	08	09	CAJAMARCA	JAEN	SAN JOSE DEL ALTO
634	06	08	10	CAJAMARCA	JAEN	SANTA ROSA
635	06	08	11	CAJAMARCA	JAEN	LAS PIRIAS
636	06	08	12	CAJAMARCA	JAEN	HUABAL
637	06	09	01	CAJAMARCA	SANTA CRUZ	SANTA CRUZ
638	06	09	02	CAJAMARCA	SANTA CRUZ	CATACHE
639	06	09	03	CAJAMARCA	SANTA CRUZ	CHANCAYBAÑOS
640	06	09	04	CAJAMARCA	SANTA CRUZ	LA ESPERANZA
641	06	09	05	CAJAMARCA	SANTA CRUZ	NINABAMBA
642	06	09	06	CAJAMARCA	SANTA CRUZ	PULAN
643	06	09	07	CAJAMARCA	SANTA CRUZ	SEXI
644	06	09	08	CAJAMARCA	SANTA CRUZ	UTICYACU
645	06	09	09	CAJAMARCA	SANTA CRUZ	YAUYUCAN
646	06	09	10	CAJAMARCA	SANTA CRUZ	ANDABAMBA
647	06	09	11	CAJAMARCA	SANTA CRUZ	SAUCEPAMPA
648	06	10	01	CAJAMARCA	SAN MIGUEL	SAN MIGUEL
649	06	10	02	CAJAMARCA	SAN MIGUEL	CALQUIS
650	06	10	03	CAJAMARCA	SAN MIGUEL	LA FLORIDA
651	06	10	04	CAJAMARCA	SAN MIGUEL	LLAPA
652	06	10	05	CAJAMARCA	SAN MIGUEL	NANCHOC
653	06	10	06	CAJAMARCA	SAN MIGUEL	NIEPOS
654	06	10	07	CAJAMARCA	SAN MIGUEL	SAN GREGORIO
655	06	10	08	CAJAMARCA	SAN MIGUEL	SAN SILVESTRE DE COCHAN
656	06	10	09	CAJAMARCA	SAN MIGUEL	EL PRADO
657	06	10	10	CAJAMARCA	SAN MIGUEL	UNION AGUA BLANCA
658	06	10	11	CAJAMARCA	SAN MIGUEL	TONGOD
659	06	10	12	CAJAMARCA	SAN MIGUEL	CATILLUC
660	06	10	13	CAJAMARCA	SAN MIGUEL	BOLIVAR
661	06	11	01	CAJAMARCA	SAN IGNACIO	SAN IGNACIO
662	06	11	02	CAJAMARCA	SAN IGNACIO	CHIRINOS
663	06	11	03	CAJAMARCA	SAN IGNACIO	HUARANGO
664	06	11	04	CAJAMARCA	SAN IGNACIO	NAMBALLE
665	06	11	05	CAJAMARCA	SAN IGNACIO	LA COIPA
666	06	11	06	CAJAMARCA	SAN IGNACIO	SAN JOSE DE LOURDES
667	06	11	07	CAJAMARCA	SAN IGNACIO	TABACONAS
668	06	12	01	CAJAMARCA	SAN MARCOS	PEDRO GALVEZ
669	06	12	02	CAJAMARCA	SAN MARCOS	ICHOCAN
670	06	12	03	CAJAMARCA	SAN MARCOS	GREGORIO PITA
671	06	12	04	CAJAMARCA	SAN MARCOS	JOSE MANUEL QUIROZ
672	06	12	05	CAJAMARCA	SAN MARCOS	EDUARDO VILLANUEVA
673	06	12	06	CAJAMARCA	SAN MARCOS	JOSE SABOGAL
674	06	12	07	CAJAMARCA	SAN MARCOS	CHANCAY
675	06	13	01	CAJAMARCA	SAN PABLO	SAN PABLO
676	06	13	02	CAJAMARCA	SAN PABLO	SAN BERNARDINO
677	06	13	03	CAJAMARCA	SAN PABLO	SAN LUIS
678	06	13	04	CAJAMARCA	SAN PABLO	TUMBADEN
679	07	01	01	CUSCO	CUSCO	CUSCO
680	07	01	02	CUSCO	CUSCO	CCORCA
681	07	01	03	CUSCO	CUSCO	POROY
682	07	01	04	CUSCO	CUSCO	SAN JERONIMO
683	07	01	05	CUSCO	CUSCO	SAN SEBASTIAN
684	07	01	06	CUSCO	CUSCO	SANTIAGO
685	07	01	07	CUSCO	CUSCO	SAYLLA
686	07	01	08	CUSCO	CUSCO	WANCHAQ
687	07	02	01	CUSCO	ACOMAYO	ACOMAYO
688	07	02	02	CUSCO	ACOMAYO	ACOPIA
689	07	02	03	CUSCO	ACOMAYO	ACOS
690	07	02	04	CUSCO	ACOMAYO	POMACANCHI
691	07	02	05	CUSCO	ACOMAYO	RONDOCAN
692	07	02	06	CUSCO	ACOMAYO	SANGARARA
693	07	02	07	CUSCO	ACOMAYO	MOSOC LLACTA
694	07	03	01	CUSCO	ANTA	ANTA
695	07	03	02	CUSCO	ANTA	CHINCHAYPUJIO
696	07	03	03	CUSCO	ANTA	HUAROCONDO
697	07	03	04	CUSCO	ANTA	LIMATAMBO
698	07	03	05	CUSCO	ANTA	MOLLEPATA
699	07	03	06	CUSCO	ANTA	PUCYURA
700	07	03	07	CUSCO	ANTA	ZURITE
701	07	03	08	CUSCO	ANTA	CACHIMAYO
702	07	03	09	CUSCO	ANTA	ANCAHUASI
703	07	04	01	CUSCO	CALCA	CALCA
704	07	04	02	CUSCO	CALCA	COYA
705	07	04	03	CUSCO	CALCA	LAMAY
706	07	04	04	CUSCO	CALCA	LARES
707	07	04	05	CUSCO	CALCA	PISAC
708	07	04	06	CUSCO	CALCA	SAN SALVADOR
709	07	04	07	CUSCO	CALCA	TARAY
710	07	04	08	CUSCO	CALCA	YANATILE
711	07	05	01	CUSCO	CANAS	YANAOCA
712	07	05	02	CUSCO	CANAS	CHECCA
713	07	05	03	CUSCO	CANAS	KUNTURKANKI
714	07	05	04	CUSCO	CANAS	LANGUI
715	07	05	05	CUSCO	CANAS	LAYO
716	07	05	06	CUSCO	CANAS	PAMPAMARCA
717	07	05	07	CUSCO	CANAS	QUEHUE
718	07	05	08	CUSCO	CANAS	TUPAC AMARU
719	07	06	01	CUSCO	CANCHIS	SICUANI
720	07	06	02	CUSCO	CANCHIS	COMBAPATA
721	07	06	03	CUSCO	CANCHIS	CHECACUPE
722	07	06	04	CUSCO	CANCHIS	MARANGANI
723	07	06	05	CUSCO	CANCHIS	PITUMARCA
724	07	06	06	CUSCO	CANCHIS	SAN PABLO
725	07	06	07	CUSCO	CANCHIS	SAN PEDRO
726	07	06	08	CUSCO	CANCHIS	TINTA
727	07	07	01	CUSCO	CHUMBIVILCAS	SANTO TOMAS
728	07	07	02	CUSCO	CHUMBIVILCAS	CAPACMARCA
729	07	07	03	CUSCO	CHUMBIVILCAS	COLQUEMARCA
730	07	07	04	CUSCO	CHUMBIVILCAS	CHAMACA
731	07	07	05	CUSCO	CHUMBIVILCAS	LIVITACA
732	07	07	06	CUSCO	CHUMBIVILCAS	LLUSCO
733	07	07	07	CUSCO	CHUMBIVILCAS	QUIÑOTA
734	07	07	08	CUSCO	CHUMBIVILCAS	VELILLE
735	07	08	01	CUSCO	ESPINAR	ESPINAR
736	07	08	02	CUSCO	ESPINAR	CONDOROMA
737	07	08	03	CUSCO	ESPINAR	COPORAQUE
738	07	08	04	CUSCO	ESPINAR	OCORURO
739	07	08	05	CUSCO	ESPINAR	PALLPATA
740	07	08	06	CUSCO	ESPINAR	PICHIGUA
741	07	08	07	CUSCO	ESPINAR	SUYCKUTAMBO
742	07	08	08	CUSCO	ESPINAR	ALTO PICHIGUA
743	07	09	01	CUSCO	LA CONVENCION	SANTA ANA
744	07	09	02	CUSCO	LA CONVENCION	ECHARATE
745	07	09	03	CUSCO	LA CONVENCION	HUAYOPATA
746	07	09	04	CUSCO	LA CONVENCION	MARANURA
747	07	09	05	CUSCO	LA CONVENCION	OCOBAMBA
748	07	09	06	CUSCO	LA CONVENCION	SANTA TERESA
749	07	09	07	CUSCO	LA CONVENCION	VILCABAMBA
750	07	09	08	CUSCO	LA CONVENCION	QUELLOUNO
751	07	09	09	CUSCO	LA CONVENCION	KIMBIRI
752	07	09	10	CUSCO	LA CONVENCION	PICHARI
753	07	10	01	CUSCO	PARURO	PARURO
754	07	10	02	CUSCO	PARURO	ACCHA
755	07	10	03	CUSCO	PARURO	CCAPI
756	07	10	04	CUSCO	PARURO	COLCHA
757	07	10	05	CUSCO	PARURO	HUANOQUITE
758	07	10	06	CUSCO	PARURO	OMACHA
759	07	10	07	CUSCO	PARURO	YAURISQUE
760	07	10	08	CUSCO	PARURO	PACCARITAMBO
761	07	10	09	CUSCO	PARURO	PILLPINTO
762	07	11	01	CUSCO	PAUCARTAMBO	PAUCARTAMBO
763	07	11	02	CUSCO	PAUCARTAMBO	CAICAY
764	07	11	03	CUSCO	PAUCARTAMBO	COLQUEPATA
765	07	11	04	CUSCO	PAUCARTAMBO	CHALLABAMBA
766	07	11	05	CUSCO	PAUCARTAMBO	KOSÑIPATA
767	07	11	06	CUSCO	PAUCARTAMBO	HUANCARANI
768	07	12	01	CUSCO	QUISPICANCHI	URCOS
769	07	12	02	CUSCO	QUISPICANCHI	ANDAHUAYLILLAS
770	07	12	03	CUSCO	QUISPICANCHI	CAMANTI
771	07	12	04	CUSCO	QUISPICANCHI	CCARHUAYO
772	07	12	05	CUSCO	QUISPICANCHI	CCATCA
773	07	12	06	CUSCO	QUISPICANCHI	CUSIPATA
774	07	12	07	CUSCO	QUISPICANCHI	HUARO
775	07	12	08	CUSCO	QUISPICANCHI	LUCRE
776	07	12	09	CUSCO	QUISPICANCHI	MARCAPATA
777	07	12	10	CUSCO	QUISPICANCHI	OCONGATE
778	07	12	11	CUSCO	QUISPICANCHI	OROPESA
779	07	12	12	CUSCO	QUISPICANCHI	QUIQUIJANA
780	07	13	01	CUSCO	URUBAMBA	URUBAMBA
781	07	13	02	CUSCO	URUBAMBA	CHINCHERO
782	07	13	03	CUSCO	URUBAMBA	HUAYLLABAMBA
783	07	13	04	CUSCO	URUBAMBA	MACHUPICCHU
784	07	13	05	CUSCO	URUBAMBA	MARAS
785	07	13	06	CUSCO	URUBAMBA	OLLANTAYTAMBO
786	07	13	07	CUSCO	URUBAMBA	YUCAY
787	08	01	01	HUANCAVELICA	HUANCAVELICA	HUANCAVELICA
788	08	01	02	HUANCAVELICA	HUANCAVELICA	ACOBAMBILLA
789	08	01	03	HUANCAVELICA	HUANCAVELICA	ACORIA
790	08	01	04	HUANCAVELICA	HUANCAVELICA	CONAYCA
791	08	01	05	HUANCAVELICA	HUANCAVELICA	CUENCA
792	08	01	06	HUANCAVELICA	HUANCAVELICA	HUACHOCOLPA
793	08	01	08	HUANCAVELICA	HUANCAVELICA	HUAYLLAHUARA
794	08	01	09	HUANCAVELICA	HUANCAVELICA	IZCUCHACA
795	08	01	10	HUANCAVELICA	HUANCAVELICA	LARIA
796	08	01	11	HUANCAVELICA	HUANCAVELICA	MANTA
797	08	01	12	HUANCAVELICA	HUANCAVELICA	MARISCAL CACERES
798	08	01	13	HUANCAVELICA	HUANCAVELICA	MOYA'
799	08	01	14	HUANCAVELICA	HUANCAVELICA	NUEVO OCCORO
800	08	01	15	HUANCAVELICA	HUANCAVELICA	PALCA
801	08	01	16	HUANCAVELICA	HUANCAVELICA	PILCHACA
802	08	01	17	HUANCAVELICA	HUANCAVELICA	VILCA
803	08	01	18	HUANCAVELICA	HUANCAVELICA	YAULI
804	08	01	19	HUANCAVELICA	HUANCAVELICA	ASCENSION
805	08	01	20	HUANCAVELICA	HUANCAVELICA	HUANDO
806	08	02	01	HUANCAVELICA	ACOBAMBA	ACOBAMBA
807	08	02	02	HUANCAVELICA	ACOBAMBA	ANTA
808	08	02	03	HUANCAVELICA	ACOBAMBA	ANDABAMBA
809	08	02	04	HUANCAVELICA	ACOBAMBA	CAJA
810	08	02	05	HUANCAVELICA	ACOBAMBA	MARCAS
811	08	02	06	HUANCAVELICA	ACOBAMBA	PAUCARA
812	08	02	07	HUANCAVELICA	ACOBAMBA	POMACOCHA
813	08	02	08	HUANCAVELICA	ACOBAMBA	ROSARIO
814	08	03	01	HUANCAVELICA	ANGARAES	LIRCAY
815	08	03	02	HUANCAVELICA	ANGARAES	ANCHONGA
816	08	03	03	HUANCAVELICA	ANGARAES	CALLANMARCA
817	08	03	04	HUANCAVELICA	ANGARAES	CONGALLA
818	08	03	05	HUANCAVELICA	ANGARAES	CHINCHO
819	08	03	06	HUANCAVELICA	ANGARAES	HUALLAY-GRANDE
820	08	03	07	HUANCAVELICA	ANGARAES	HUANCA-HUANCA
821	08	03	08	HUANCAVELICA	ANGARAES	JULCAMARCA
822	08	03	09	HUANCAVELICA	ANGARAES	SAN ANTONIO DE ANTAPARCO
823	08	03	10	HUANCAVELICA	ANGARAES	SANTO TOMAS DE PATA
824	08	03	11	HUANCAVELICA	ANGARAES	SECCLLA
825	08	03	12	HUANCAVELICA	ANGARAES	CCOCHACCASA
826	08	04	01	HUANCAVELICA	CASTROVIRREYNA	CASTROVIRREYNA
827	08	04	02	HUANCAVELICA	CASTROVIRREYNA	ARMA
828	08	04	03	HUANCAVELICA	CASTROVIRREYNA	AURAHUA
829	08	04	05	HUANCAVELICA	CASTROVIRREYNA	CAPILLAS
830	08	04	06	HUANCAVELICA	CASTROVIRREYNA	COCAS
831	08	04	08	HUANCAVELICA	CASTROVIRREYNA	CHUPAMARCA
832	08	04	09	HUANCAVELICA	CASTROVIRREYNA	HUACHOS
833	08	04	10	HUANCAVELICA	CASTROVIRREYNA	HUAMATAMBO
834	08	04	14	HUANCAVELICA	CASTROVIRREYNA	MOLLEPAMPA
835	08	04	22	HUANCAVELICA	CASTROVIRREYNA	SAN JUAN
836	08	04	27	HUANCAVELICA	CASTROVIRREYNA	TANTARA
837	08	04	28	HUANCAVELICA	CASTROVIRREYNA	TICRAPO
838	08	04	29	HUANCAVELICA	CASTROVIRREYNA	SANTA ANA
839	08	05	01	HUANCAVELICA	TAYACAJA	PAMPAS
840	08	05	02	HUANCAVELICA	TAYACAJA	ACOSTAMBO
841	08	05	03	HUANCAVELICA	TAYACAJA	ACRAQUIA
842	08	05	04	HUANCAVELICA	TAYACAJA	AHUAYCHA
843	08	05	06	HUANCAVELICA	TAYACAJA	COLCABAMBA
844	08	05	09	HUANCAVELICA	TAYACAJA	DANIEL HERNANDEZ
845	08	05	11	HUANCAVELICA	TAYACAJA	HUACHOCOLPA
846	08	05	12	HUANCAVELICA	TAYACAJA	HUARIBAMBA
847	08	05	15	HUANCAVELICA	TAYACAJA	ÑAHUIMPUQUIO
848	08	05	17	HUANCAVELICA	TAYACAJA	PAZOS
849	08	05	18	HUANCAVELICA	TAYACAJA	QUISHUAR
850	08	05	19	HUANCAVELICA	TAYACAJA	SALCABAMBA
851	08	05	20	HUANCAVELICA	TAYACAJA	SAN MARCOS DE ROCCHAC
852	08	05	23	HUANCAVELICA	TAYACAJA	SURCUBAMBA
853	08	05	25	HUANCAVELICA	TAYACAJA	TINTAY PUNCU
854	08	05	26	HUANCAVELICA	TAYACAJA	SALCAHUASI
855	08	06	01	HUANCAVELICA	HUAYTARA	AYAVI
856	08	06	02	HUANCAVELICA	HUAYTARA	CORDOVA
857	08	06	03	HUANCAVELICA	HUAYTARA	HUAYACUNDO ARMA
858	08	06	04	HUANCAVELICA	HUAYTARA	HUAYTARA
859	08	06	05	HUANCAVELICA	HUAYTARA	LARAMARCA
860	08	06	06	HUANCAVELICA	HUAYTARA	OCOYO
861	08	06	07	HUANCAVELICA	HUAYTARA	PILPICHACA
862	08	06	08	HUANCAVELICA	HUAYTARA	QUERCO
863	08	06	09	HUANCAVELICA	HUAYTARA	QUITO ARMA
864	08	06	10	HUANCAVELICA	HUAYTARA	SAN ANTONIO DE CUSICANCHA
865	08	06	11	HUANCAVELICA	HUAYTARA	SAN FRANCISCO DE SANGAYAICO
866	08	06	12	HUANCAVELICA	HUAYTARA	SAN ISIDRO
867	08	06	13	HUANCAVELICA	HUAYTARA	SANTIAGO DE CHOCORVOS
868	08	06	14	HUANCAVELICA	HUAYTARA	SANTIAGO DE QUIRAHUARA
869	08	06	15	HUANCAVELICA	HUAYTARA	SANTO DOMINGO DE CAPILLAS
870	08	06	16	HUANCAVELICA	HUAYTARA	TAMBO
871	08	07	01	HUANCAVELICA	CHURCAMPA	CHURCAMPA
872	08	07	02	HUANCAVELICA	CHURCAMPA	ANCO
873	08	07	03	HUANCAVELICA	CHURCAMPA	CHINCHIHUASI
874	08	07	04	HUANCAVELICA	CHURCAMPA	EL CARMEN
875	08	07	05	HUANCAVELICA	CHURCAMPA	LA MERCED
876	08	07	06	HUANCAVELICA	CHURCAMPA	LOCROJA
877	08	07	07	HUANCAVELICA	CHURCAMPA	PAUCARBAMBA
878	08	07	08	HUANCAVELICA	CHURCAMPA	SAN MIGUEL DE MAYOCC
879	08	07	09	HUANCAVELICA	CHURCAMPA	SAN PEDRO DE CORIS
880	08	07	10	HUANCAVELICA	CHURCAMPA	PACHAMARCA
881	08	07	11	HUANCAVELICA	CHURCAMPA	COSME
882	09	01	01	HUANUCO	HUANUCO	HUANUCO
883	09	01	02	HUANUCO	HUANUCO	CHINCHAO
884	09	01	03	HUANUCO	HUANUCO	CHURUBAMBA
885	09	01	04	HUANUCO	HUANUCO	MARGOS
886	09	01	05	HUANUCO	HUANUCO	QUISQUI
887	09	01	06	HUANUCO	HUANUCO	SAN FRANCISCO DE CAYRAN
888	09	01	07	HUANUCO	HUANUCO	SAN PEDRO DE CHAULAN
889	09	01	08	HUANUCO	HUANUCO	SANTA MARIA DEL VALLE
890	09	01	09	HUANUCO	HUANUCO	YARUMAYO
891	09	01	10	HUANUCO	HUANUCO	AMARILIS
892	09	01	11	HUANUCO	HUANUCO	PILLCO MARCA
893	09	01	12	HUANUCO	HUANUCO	YACUS
894	09	02	01	HUANUCO	AMBO	AMBO
895	09	02	02	HUANUCO	AMBO	CAYNA
896	09	02	03	HUANUCO	AMBO	COLPAS
897	09	02	04	HUANUCO	AMBO	CONCHAMARCA
898	09	02	05	HUANUCO	AMBO	HUACAR
899	09	02	06	HUANUCO	AMBO	SAN FRANCISCO
900	09	02	07	HUANUCO	AMBO	SAN RAFAEL
901	09	02	08	HUANUCO	AMBO	TOMAY-KICHWA
902	09	03	01	HUANUCO	DOS DE MAYO	LA UNION
903	09	03	07	HUANUCO	DOS DE MAYO	CHUQUIS
904	09	03	12	HUANUCO	DOS DE MAYO	MARIAS
905	09	03	14	HUANUCO	DOS DE MAYO	PACHAS
906	09	03	16	HUANUCO	DOS DE MAYO	QUIVILLA
907	09	03	17	HUANUCO	DOS DE MAYO	RIPAN
908	09	03	21	HUANUCO	DOS DE MAYO	SHUNQUI
909	09	03	22	HUANUCO	DOS DE MAYO	SILLAPATA
910	09	03	23	HUANUCO	DOS DE MAYO	YANAS
911	09	04	01	HUANUCO	HUAMALIES	LLATA
912	09	04	02	HUANUCO	HUAMALIES	ARANCAY
913	09	04	03	HUANUCO	HUAMALIES	CHAVIN DE PARIARCA
914	09	04	04	HUANUCO	HUAMALIES	JACAS GRANDE
915	09	04	05	HUANUCO	HUAMALIES	JIRCAN
916	09	04	06	HUANUCO	HUAMALIES	MIRAFLORES
917	09	04	07	HUANUCO	HUAMALIES	MONZON
918	09	04	08	HUANUCO	HUAMALIES	PUNCHAO
919	09	04	09	HUANUCO	HUAMALIES	PUÑOS
920	09	04	10	HUANUCO	HUAMALIES	SINGA
921	09	04	11	HUANUCO	HUAMALIES	TANTAMAYO
922	09	05	01	HUANUCO	MARAÑON	HUACRACHUCO
923	09	05	02	HUANUCO	MARAÑON	CHOLON
924	09	05	05	HUANUCO	MARAÑON	SAN BUENAVENTURA
925	09	06	01	HUANUCO	LEONCIO PRADO	RUPA-RUPA
926	09	06	02	HUANUCO	LEONCIO PRADO	DANIEL ALOMIA ROBLES
927	09	06	03	HUANUCO	LEONCIO PRADO	HERMILIO VALDIZAN
928	09	06	04	HUANUCO	LEONCIO PRADO	LUYANDO
929	09	06	05	HUANUCO	LEONCIO PRADO	MARIANO DAMASO BERAUN
930	09	06	06	HUANUCO	LEONCIO PRADO	JOSE CRESPO Y CASTILLO
931	09	07	01	HUANUCO	PACHITEA	PANAO
932	09	07	02	HUANUCO	PACHITEA	CHAGLLA
933	09	07	04	HUANUCO	PACHITEA	MOLINO
934	09	07	06	HUANUCO	PACHITEA	UMARI
935	09	08	01	HUANUCO	PUERTO INCA	HONORIA
936	09	08	02	HUANUCO	PUERTO INCA	PUERTO INCA
937	09	08	03	HUANUCO	PUERTO INCA	CODO DEL POZUZO
938	09	08	04	HUANUCO	PUERTO INCA	TOURNAVISTA
939	09	08	05	HUANUCO	PUERTO INCA	YUYAPICHIS
940	09	09	01	HUANUCO	HUACAYBAMBA	HUACAYBAMBA
941	09	09	02	HUANUCO	HUACAYBAMBA	PINRA
942	09	09	03	HUANUCO	HUACAYBAMBA	CANCHABAMBA
943	09	09	04	HUANUCO	HUACAYBAMBA	COCHABAMBA
944	09	10	01	HUANUCO	LAURICOCHA	JESUS
945	09	10	02	HUANUCO	LAURICOCHA	BAÑOS
946	09	10	03	HUANUCO	LAURICOCHA	SAN FRANCISCO DE ASIS
947	09	10	04	HUANUCO	LAURICOCHA	QUEROPALCA
948	09	10	05	HUANUCO	LAURICOCHA	SAN MIGUEL DE CAURI
949	09	10	06	HUANUCO	LAURICOCHA	RONDOS
950	09	10	07	HUANUCO	LAURICOCHA	JIVIA
951	09	11	01	HUANUCO	YAROWILCA	CHAVINILLO
952	09	11	02	HUANUCO	YAROWILCA	APARICIO POMARES
953	09	11	03	HUANUCO	YAROWILCA	CAHUAC
954	09	11	04	HUANUCO	YAROWILCA	CHACABAMBA
955	09	11	05	HUANUCO	YAROWILCA	JACAS CHICO
956	09	11	06	HUANUCO	YAROWILCA	OBAS
957	09	11	07	HUANUCO	YAROWILCA	PAMPAMARCA
958	09	11	08	HUANUCO	YAROWILCA	CHORAS
959	10	01	01	ICA	ICA	ICA
960	10	01	02	ICA	ICA	LA TINGUIÑA
961	10	01	03	ICA	ICA	LOS AQUIJES
962	10	01	04	ICA	ICA	PARCONA
963	10	01	05	ICA	ICA	PUEBLO NUEVO
964	10	01	06	ICA	ICA	SALAS
965	10	01	07	ICA	ICA	SAN JOSE DE LOS MOLINOS
966	10	01	08	ICA	ICA	SAN JUAN BAUTISTA
967	10	01	09	ICA	ICA	SANTIAGO
968	10	01	10	ICA	ICA	SUBTANJALLA
969	10	01	11	ICA	ICA	YAUCA DEL ROSARIO
970	10	01	12	ICA	ICA	TATE
971	10	01	13	ICA	ICA	PACHACUTEC
972	10	01	14	ICA	ICA	OCUCAJE
973	10	02	01	ICA	CHINCHA	CHINCHA ALTA
974	10	02	02	ICA	CHINCHA	CHAVIN
975	10	02	03	ICA	CHINCHA	CHINCHA BAJA
976	10	02	04	ICA	CHINCHA	EL CARMEN
977	10	02	05	ICA	CHINCHA	GROCIO PRADO
978	10	02	06	ICA	CHINCHA	SAN PEDRO DE HUACARPANA
979	10	02	07	ICA	CHINCHA	SUNAMPE
980	10	02	08	ICA	CHINCHA	TAMBO DE MORA
981	10	02	09	ICA	CHINCHA	ALTO LARAN
982	10	02	10	ICA	CHINCHA	PUEBLO NUEVO
983	10	02	11	ICA	CHINCHA	SAN JUAN DE YANAC
984	10	03	01	ICA	NAZCA	NAZCA
985	10	03	02	ICA	NAZCA	CHANGUILLO
986	10	03	03	ICA	NAZCA	EL INGENIO
987	10	03	04	ICA	NAZCA	MARCONA
988	10	03	05	ICA	NAZCA	VISTA ALEGRE
989	10	04	01	ICA	PISCO	PISCO
990	10	04	02	ICA	PISCO	HUANCANO
991	10	04	03	ICA	PISCO	HUMAY
992	10	04	04	ICA	PISCO	INDEPENDENCIA
993	10	04	05	ICA	PISCO	PARACAS
994	10	04	06	ICA	PISCO	SAN ANDRES
995	10	04	07	ICA	PISCO	SAN CLEMENTE
996	10	04	08	ICA	PISCO	TUPAC AMARU INCA
997	10	05	01	ICA	PALPA	PALPA
998	10	05	02	ICA	PALPA	LLIPATA
999	10	05	03	ICA	PALPA	RIO GRANDE
1000	10	05	04	ICA	PALPA	SANTA CRUZ
1001	10	05	05	ICA	PALPA	TIBILLO
1002	11	01	01	JUNIN	HUANCAYO	HUANCAYO
1003	11	01	03	JUNIN	HUANCAYO	CARHUACALLANGA
1004	11	01	04	JUNIN	HUANCAYO	COLCA
1005	11	01	05	JUNIN	HUANCAYO	CULLHUAS
1006	11	01	06	JUNIN	HUANCAYO	CHACAPAMPA
1007	11	01	07	JUNIN	HUANCAYO	CHICCHE
1008	11	01	08	JUNIN	HUANCAYO	CHILCA
1009	11	01	09	JUNIN	HUANCAYO	CHONGOS ALTO
1010	11	01	12	JUNIN	HUANCAYO	CHUPURO
1011	11	01	13	JUNIN	HUANCAYO	EL TAMBO
1012	11	01	14	JUNIN	HUANCAYO	HUACRAPUQUIO
1013	11	01	16	JUNIN	HUANCAYO	HUALHUAS
1014	11	01	18	JUNIN	HUANCAYO	HUANCAN
1015	11	01	19	JUNIN	HUANCAYO	HUASICANCHA
1016	11	01	20	JUNIN	HUANCAYO	HUAYUCACHI
1017	11	01	21	JUNIN	HUANCAYO	INGENIO
1018	11	01	22	JUNIN	HUANCAYO	PARIAHUANCA
1019	11	01	23	JUNIN	HUANCAYO	PILCOMAYO
1020	11	01	24	JUNIN	HUANCAYO	PUCARA
1021	11	01	25	JUNIN	HUANCAYO	QUICHUAY
1022	11	01	26	JUNIN	HUANCAYO	QUILCAS
1023	11	01	27	JUNIN	HUANCAYO	SAN AGUSTIN
1024	11	01	28	JUNIN	HUANCAYO	SAN JERONIMO DE TUNAN
1025	11	01	31	JUNIN	HUANCAYO	SANTO DOMINGO DE ACOBAMBA
1026	11	01	32	JUNIN	HUANCAYO	SAÑO
1027	11	01	33	JUNIN	HUANCAYO	SAPALLANGA
1028	11	01	34	JUNIN	HUANCAYO	SICAYA
1029	11	01	36	JUNIN	HUANCAYO	VIQUES
1030	11	02	01	JUNIN	CONCEPCION	CONCEPCION
1031	11	02	02	JUNIN	CONCEPCION	ACO
1032	11	02	03	JUNIN	CONCEPCION	ANDAMARCA
1033	11	02	04	JUNIN	CONCEPCION	COMAS
1034	11	02	05	JUNIN	CONCEPCION	COCHAS
1035	11	02	06	JUNIN	CONCEPCION	CHAMBARA
1036	11	02	07	JUNIN	CONCEPCION	HEROINAS TOLEDO
1037	11	02	08	JUNIN	CONCEPCION	MANZANARES
1038	11	02	09	JUNIN	CONCEPCION	MARISCAL CASTILLA
1039	11	02	10	JUNIN	CONCEPCION	MATAHUASI
1040	11	02	11	JUNIN	CONCEPCION	MITO
1041	11	02	12	JUNIN	CONCEPCION	NUEVE DE JULIO
1042	11	02	13	JUNIN	CONCEPCION	ORCOTUNA
1043	11	02	14	JUNIN	CONCEPCION	SANTA ROSA DE OCOPA
1044	11	02	15	JUNIN	CONCEPCION	SAN JOSE DE QUERO
1045	11	03	01	JUNIN	JAUJA	JAUJA
1046	11	03	02	JUNIN	JAUJA	ACOLLA
1047	11	03	03	JUNIN	JAUJA	APATA
1048	11	03	04	JUNIN	JAUJA	ATAURA
1049	11	03	05	JUNIN	JAUJA	CANCHAYLLO
1050	11	03	06	JUNIN	JAUJA	EL MANTARO
1051	11	03	07	JUNIN	JAUJA	HUAMALI
1052	11	03	08	JUNIN	JAUJA	HUARIPAMPA
1053	11	03	09	JUNIN	JAUJA	HUERTAS
1054	11	03	10	JUNIN	JAUJA	JANJAILLO
1055	11	03	11	JUNIN	JAUJA	JULCAN
1056	11	03	12	JUNIN	JAUJA	LEONOR ORDOÑEZ
1057	11	03	13	JUNIN	JAUJA	LLOCLLAPAMPA
1058	11	03	14	JUNIN	JAUJA	MARCO
1059	11	03	15	JUNIN	JAUJA	MASMA
1060	11	03	16	JUNIN	JAUJA	MOLINOS
1061	11	03	17	JUNIN	JAUJA	MONOBAMBA
1062	11	03	18	JUNIN	JAUJA	MUQUI
1063	11	03	19	JUNIN	JAUJA	MUQUIYAUYO
1064	11	03	20	JUNIN	JAUJA	PACA
1065	11	03	21	JUNIN	JAUJA	PACCHA
1066	11	03	22	JUNIN	JAUJA	PANCAN
1067	11	03	23	JUNIN	JAUJA	PARCO
1068	11	03	24	JUNIN	JAUJA	POMACANCHA
1069	11	03	25	JUNIN	JAUJA	RICRAN
1070	11	03	26	JUNIN	JAUJA	SAN LORENZO
1071	11	03	27	JUNIN	JAUJA	SAN PEDRO DE CHUNAN
1072	11	03	28	JUNIN	JAUJA	SINCOS
1073	11	03	29	JUNIN	JAUJA	TUNAN MARCA
1074	11	03	30	JUNIN	JAUJA	YAULI
1075	11	03	31	JUNIN	JAUJA	CURICACA
1076	11	03	32	JUNIN	JAUJA	MASMA CHICCHE
1077	11	03	33	JUNIN	JAUJA	SAUSA
1078	11	03	34	JUNIN	JAUJA	YAUYOS
1079	11	04	01	JUNIN	JUNIN	JUNIN
1080	11	04	02	JUNIN	JUNIN	CARHUAMAYO
1081	11	04	03	JUNIN	JUNIN	ONDORES
1082	11	04	04	JUNIN	JUNIN	ULCUMAYO
1083	11	05	01	JUNIN	TARMA	TARMA
1084	11	05	02	JUNIN	TARMA	ACOBAMBA
1085	11	05	03	JUNIN	TARMA	HUARICOLCA
1086	11	05	04	JUNIN	TARMA	HUASAHUASI
1087	11	05	05	JUNIN	TARMA	LA UNION
1088	11	05	06	JUNIN	TARMA	PALCA
1089	11	05	07	JUNIN	TARMA	PALCAMAYO
1090	11	05	08	JUNIN	TARMA	SAN PEDRO DE CAJAS
1091	11	05	09	JUNIN	TARMA	TAPO
1092	11	06	01	JUNIN	YAULI	LA OROYA
1093	11	06	02	JUNIN	YAULI	CHACAPALPA
1094	11	06	03	JUNIN	YAULI	HUAY HUAY
1095	11	06	04	JUNIN	YAULI	MARCAPOMACOCHA
1096	11	06	05	JUNIN	YAULI	MOROCOCHA
1097	11	06	06	JUNIN	YAULI	PACCHA
1098	11	06	07	JUNIN	YAULI	SANTA BARBARA DE CARHUACAYAN
1099	11	06	08	JUNIN	YAULI	SUITUCANCHA
1100	11	06	09	JUNIN	YAULI	YAULI
1101	11	06	10	JUNIN	YAULI	SANTA ROSA DE SACCO
1102	11	07	01	JUNIN	SATIPO	SATIPO
1103	11	07	02	JUNIN	SATIPO	COVIRIALI
1104	11	07	03	JUNIN	SATIPO	LLAYLLA
1105	11	07	04	JUNIN	SATIPO	MAZAMARI
1106	11	07	05	JUNIN	SATIPO	PAMPA HERMOSA
1107	11	07	06	JUNIN	SATIPO	PANGOA
1108	11	07	07	JUNIN	SATIPO	RIO NEGRO
1109	11	07	08	JUNIN	SATIPO	RIO TAMBO
1110	11	08	01	JUNIN	CHANCHAMAYO	CHANCHAMAYO
1111	11	08	02	JUNIN	CHANCHAMAYO	SAN RAMON
1112	11	08	03	JUNIN	CHANCHAMAYO	VITOC
1113	11	08	04	JUNIN	CHANCHAMAYO	SAN LUIS DE SHUARO
1114	11	08	05	JUNIN	CHANCHAMAYO	PICHANAQUI
1115	11	08	06	JUNIN	CHANCHAMAYO	PERENE
1116	11	09	01	JUNIN	CHUPACA	CHUPACA
1117	11	09	02	JUNIN	CHUPACA	AHUAC
1118	11	09	03	JUNIN	CHUPACA	CHONGOS BAJO
1119	11	09	04	JUNIN	CHUPACA	HUACHAC
1120	11	09	05	JUNIN	CHUPACA	HUAMANCACA CHICO
1121	11	09	06	JUNIN	CHUPACA	SAN JUAN DE YSCOS
1122	11	09	07	JUNIN	CHUPACA	SAN JUAN DE JARPA
1123	11	09	08	JUNIN	CHUPACA	TRES DE DICIEMBRE
1124	11	09	09	JUNIN	CHUPACA	YANACANCHA
1125	12	01	01	LA LIBERTAD	TRUJILLO	TRUJILLO
1126	12	01	02	LA LIBERTAD	TRUJILLO	HUANCHACO
1127	12	01	03	LA LIBERTAD	TRUJILLO	LAREDO
1128	12	01	04	LA LIBERTAD	TRUJILLO	MOCHE
1129	12	01	05	LA LIBERTAD	TRUJILLO	SALAVERRY
1130	12	01	06	LA LIBERTAD	TRUJILLO	SIMBAL
1131	12	01	07	LA LIBERTAD	TRUJILLO	VICTOR LARCO HERRERA
1132	12	01	09	LA LIBERTAD	TRUJILLO	POROTO
1133	12	01	10	LA LIBERTAD	TRUJILLO	EL PORVENIR
1134	12	01	11	LA LIBERTAD	TRUJILLO	LA ESPERANZA
1135	12	01	12	LA LIBERTAD	TRUJILLO	FLORENCIA DE MORA
1136	12	01	13	LA LIBERTAD	TRUJILLO	BUENOS AIRES
1137	12	02	01	LA LIBERTAD	BOLIVAR	BOLIVAR
1138	12	02	02	LA LIBERTAD	BOLIVAR	BAMBAMARCA
1139	12	02	03	LA LIBERTAD	BOLIVAR	CONDORMARCA
1140	12	02	04	LA LIBERTAD	BOLIVAR	LONGOTEA
1141	12	02	05	LA LIBERTAD	BOLIVAR	UCUNCHA
1142	12	02	06	LA LIBERTAD	BOLIVAR	UCHUMARCA
1143	12	03	01	LA LIBERTAD	SANCHEZ CARRION	HUAMACHUCO
1144	12	03	02	LA LIBERTAD	SANCHEZ CARRION	COCHORCO
1145	12	03	03	LA LIBERTAD	SANCHEZ CARRION	CURGOS
1146	12	03	04	LA LIBERTAD	SANCHEZ CARRION	CHUGAY
1147	12	03	05	LA LIBERTAD	SANCHEZ CARRION	MARCABAL
1148	12	03	06	LA LIBERTAD	SANCHEZ CARRION	SANAGORAN
1149	12	03	07	LA LIBERTAD	SANCHEZ CARRION	SARIN
1150	12	03	08	LA LIBERTAD	SANCHEZ CARRION	SARTIMBAMBA
1151	12	04	01	LA LIBERTAD	OTUZCO	OTUZCO
1152	12	04	02	LA LIBERTAD	OTUZCO	AGALLPAMPA
1153	12	04	03	LA LIBERTAD	OTUZCO	CHARAT
1154	12	04	04	LA LIBERTAD	OTUZCO	HUARANCHAL
1155	12	04	05	LA LIBERTAD	OTUZCO	LA CUESTA
1156	12	04	08	LA LIBERTAD	OTUZCO	PARANDAY
1157	12	04	09	LA LIBERTAD	OTUZCO	SALPO
1158	12	04	10	LA LIBERTAD	OTUZCO	SINSICAP
1159	12	04	11	LA LIBERTAD	OTUZCO	USQUIL
1160	12	04	13	LA LIBERTAD	OTUZCO	MACHE
1161	12	05	01	LA LIBERTAD	PACASMAYO	SAN PEDRO DE LLOC
1162	12	05	03	LA LIBERTAD	PACASMAYO	GUADALUPE
1163	12	05	04	LA LIBERTAD	PACASMAYO	JEQUETEPEQUE
1164	12	05	06	LA LIBERTAD	PACASMAYO	PACASMAYO
1165	12	05	08	LA LIBERTAD	PACASMAYO	SAN JOSE
1166	12	06	01	LA LIBERTAD	PATAZ	TAYABAMBA
1167	12	06	02	LA LIBERTAD	PATAZ	BULDIBUYO
1168	12	06	03	LA LIBERTAD	PATAZ	CHILLIA
1169	12	06	04	LA LIBERTAD	PATAZ	HUAYLILLAS
1170	12	06	05	LA LIBERTAD	PATAZ	HUANCASPATA
1171	12	06	06	LA LIBERTAD	PATAZ	HUAYO
1172	12	06	07	LA LIBERTAD	PATAZ	ONGON
1173	12	06	08	LA LIBERTAD	PATAZ	PARCOY
1174	12	06	09	LA LIBERTAD	PATAZ	PATAZ
1175	12	06	10	LA LIBERTAD	PATAZ	PIAS
1176	12	06	11	LA LIBERTAD	PATAZ	TAURIJA
1177	12	06	12	LA LIBERTAD	PATAZ	URPAY
1178	12	06	13	LA LIBERTAD	PATAZ	SANTIAGO DE CHALLAS
1179	12	07	01	LA LIBERTAD	SANTIAGO DE CHUCO	SANTIAGO DE CHUCO
1180	12	07	02	LA LIBERTAD	SANTIAGO DE CHUCO	CACHICADAN
1181	12	07	03	LA LIBERTAD	SANTIAGO DE CHUCO	MOLLEBAMBA
1182	12	07	04	LA LIBERTAD	SANTIAGO DE CHUCO	MOLLEPATA
1183	12	07	05	LA LIBERTAD	SANTIAGO DE CHUCO	QUIRUVILCA
1184	12	07	06	LA LIBERTAD	SANTIAGO DE CHUCO	SANTA CRUZ DE CHUCA
1185	12	07	07	LA LIBERTAD	SANTIAGO DE CHUCO	SITABAMBA
1186	12	07	08	LA LIBERTAD	SANTIAGO DE CHUCO	ANGASMARCA
1187	12	08	01	LA LIBERTAD	ASCOPE	ASCOPE
1188	12	08	02	LA LIBERTAD	ASCOPE	CHICAMA
1189	12	08	03	LA LIBERTAD	ASCOPE	CHOCOPE
1190	12	08	04	LA LIBERTAD	ASCOPE	SANTIAGO DE CAO
1191	12	08	05	LA LIBERTAD	ASCOPE	MAGDALENA DE CAO
1192	12	08	06	LA LIBERTAD	ASCOPE	PAIJAN
1193	12	08	07	LA LIBERTAD	ASCOPE	RAZURI
1194	12	08	08	LA LIBERTAD	ASCOPE	CASA GRANDE
1195	12	09	01	LA LIBERTAD	CHEPEN	CHEPEN
1196	12	09	02	LA LIBERTAD	CHEPEN	PACANGA
1197	12	09	03	LA LIBERTAD	CHEPEN	PUEBLO NUEVO
1198	12	10	01	LA LIBERTAD	JULCAN	JULCAN
1199	12	10	02	LA LIBERTAD	JULCAN	CARABAMBA
1200	12	10	03	LA LIBERTAD	JULCAN	CALAMARCA
1201	12	10	04	LA LIBERTAD	JULCAN	HUASO
1202	12	11	01	LA LIBERTAD	GRAN CHIMU	CASCAS
1203	12	11	02	LA LIBERTAD	GRAN CHIMU	LUCMA
1204	12	11	03	LA LIBERTAD	GRAN CHIMU	MARMOT
1205	12	11	04	LA LIBERTAD	GRAN CHIMU	SAYAPULLO
1206	12	12	01	LA LIBERTAD	VIRU	VIRU
1207	12	12	02	LA LIBERTAD	VIRU	CHAO
1208	12	12	03	LA LIBERTAD	VIRU	GUADALUPITO
1209	13	01	01	LAMBAYEQUE	CHICLAYO	CHICLAYO
1210	13	01	02	LAMBAYEQUE	CHICLAYO	CHONGOYAPE
1211	13	01	03	LAMBAYEQUE	CHICLAYO	ETEN
1212	13	01	04	LAMBAYEQUE	CHICLAYO	ETEN PUERTO
1213	13	01	05	LAMBAYEQUE	CHICLAYO	LAGUNAS
1214	13	01	06	LAMBAYEQUE	CHICLAYO	MONSEFU
1215	13	01	07	LAMBAYEQUE	CHICLAYO	NUEVA ARICA
1216	13	01	08	LAMBAYEQUE	CHICLAYO	OYOTUN
1217	13	01	09	LAMBAYEQUE	CHICLAYO	PICSI
1218	13	01	10	LAMBAYEQUE	CHICLAYO	PIMENTEL
1219	13	01	11	LAMBAYEQUE	CHICLAYO	REQUE
1220	13	01	12	LAMBAYEQUE	CHICLAYO	JOSE LEONARDO ORTIZ
1221	13	01	13	LAMBAYEQUE	CHICLAYO	SANTA ROSA
1222	13	01	14	LAMBAYEQUE	CHICLAYO	SAÑA
1223	13	01	15	LAMBAYEQUE	CHICLAYO	LA VICTORIA
1224	13	01	16	LAMBAYEQUE	CHICLAYO	CAYALTI
1225	13	01	17	LAMBAYEQUE	CHICLAYO	PATAPO
1226	13	01	18	LAMBAYEQUE	CHICLAYO	POMALCA
1227	13	01	19	LAMBAYEQUE	CHICLAYO	PUCALA
1228	13	01	20	LAMBAYEQUE	CHICLAYO	TUMAN
1229	13	02	01	LAMBAYEQUE	FERREÑAFE	FERREÑAFE
1230	13	02	02	LAMBAYEQUE	FERREÑAFE	INCAHUASI
1231	13	02	03	LAMBAYEQUE	FERREÑAFE	CAÑARIS
1232	13	02	04	LAMBAYEQUE	FERREÑAFE	PITIPO
1233	13	02	05	LAMBAYEQUE	FERREÑAFE	PUEBLO NUEVO
1234	13	02	06	LAMBAYEQUE	FERREÑAFE	MANUEL ANTONIO MESONES MURO
1235	13	03	01	LAMBAYEQUE	LAMBAYEQUE	LAMBAYEQUE
1236	13	03	02	LAMBAYEQUE	LAMBAYEQUE	CHOCHOPE
1237	13	03	03	LAMBAYEQUE	LAMBAYEQUE	ILLIMO
1238	13	03	04	LAMBAYEQUE	LAMBAYEQUE	JAYANCA
1239	13	03	05	LAMBAYEQUE	LAMBAYEQUE	MOCHUMI
1240	13	03	06	LAMBAYEQUE	LAMBAYEQUE	MORROPE
1241	13	03	07	LAMBAYEQUE	LAMBAYEQUE	MOTUPE
1242	13	03	08	LAMBAYEQUE	LAMBAYEQUE	OLMOS
1243	13	03	09	LAMBAYEQUE	LAMBAYEQUE	PACORA
1244	13	03	10	LAMBAYEQUE	LAMBAYEQUE	SALAS
1245	13	03	11	LAMBAYEQUE	LAMBAYEQUE	SAN JOSE
1246	13	03	12	LAMBAYEQUE	LAMBAYEQUE	TUCUME
1247	14	01	01	LIMA	LIMA	LIMA
1248	14	01	02	LIMA	LIMA	ANCON
1249	14	01	03	LIMA	LIMA	ATE
1250	14	01	04	LIMA	LIMA	BREÑA
1251	14	01	05	LIMA	LIMA	CARABAYLLO
1252	14	01	06	LIMA	LIMA	COMAS
1253	14	01	07	LIMA	LIMA	CHACLACAYO
1254	14	01	08	LIMA	LIMA	CHORRILLOS
1255	14	01	09	LIMA	LIMA	LA VICTORIA
1256	14	01	10	LIMA	LIMA	LA MOLINA
1257	14	01	11	LIMA	LIMA	LINCE
1258	14	01	12	LIMA	LIMA	LURIGANCHO
1259	14	01	13	LIMA	LIMA	LURIN
1260	14	01	14	LIMA	LIMA	MAGDALENA DEL MAR
1261	14	01	15	LIMA	LIMA	MIRAFLORES
1262	14	01	16	LIMA	LIMA	PACHACAMAC
1263	14	01	17	LIMA	LIMA	PUEBLO LIBRE
1264	14	01	18	LIMA	LIMA	PUCUSANA
1265	14	01	19	LIMA	LIMA	PUENTE PIEDRA
1266	14	01	20	LIMA	LIMA	PUNTA HERMOSA
1267	14	01	21	LIMA	LIMA	PUNTA NEGRA
1268	14	01	22	LIMA	LIMA	RIMAC
1269	14	01	23	LIMA	LIMA	SAN BARTOLO
1270	14	01	24	LIMA	LIMA	SAN ISIDRO
1271	14	01	25	LIMA	LIMA	BARRANCO
1272	14	01	26	LIMA	LIMA	SAN MARTIN DE PORRES
1273	14	01	27	LIMA	LIMA	SAN MIGUEL
1274	14	01	28	LIMA	LIMA	SANTA MARIA DEL MAR
1275	14	01	29	LIMA	LIMA	SANTA ROSA
1276	14	01	30	LIMA	LIMA	SANTIAGO DE SURCO
1277	14	01	31	LIMA	LIMA	SURQUILLO
1278	14	01	32	LIMA	LIMA	VILLA MARIA DEL TRIUNFO
1279	14	01	33	LIMA	LIMA	JESUS MARIA
1280	14	01	34	LIMA	LIMA	INDEPENDENCIA
1281	14	01	35	LIMA	LIMA	EL AGUSTINO
1282	14	01	36	LIMA	LIMA	SAN JUAN DE MIRAFLORES
1283	14	01	37	LIMA	LIMA	SAN JUAN DE LURIGANCHO
1284	14	01	38	LIMA	LIMA	SAN LUIS
1285	14	01	39	LIMA	LIMA	CIENEGUILLA
1286	14	01	40	LIMA	LIMA	SAN BORJA
1287	14	01	41	LIMA	LIMA	VILLA EL SALVADOR
1288	14	01	42	LIMA	LIMA	LOS OLIVOS
1289	14	01	43	LIMA	LIMA	SANTA ANITA
1290	14	02	01	LIMA	CAJATAMBO	CAJATAMBO
1291	14	02	05	LIMA	CAJATAMBO	COPA
1292	14	02	06	LIMA	CAJATAMBO	GORGOR
1293	14	02	07	LIMA	CAJATAMBO	HUANCAPON
1294	14	02	08	LIMA	CAJATAMBO	MANAS
1295	14	03	01	LIMA	CANTA	CANTA
1296	14	03	02	LIMA	CANTA	ARAHUAY
1297	14	03	03	LIMA	CANTA	HUAMANTANGA
1298	14	03	04	LIMA	CANTA	HUAROS
1299	14	03	05	LIMA	CANTA	LACHAQUI
1300	14	03	06	LIMA	CANTA	SAN BUENAVENTURA
1301	14	03	07	LIMA	CANTA	SANTA ROSA DE QUIVES
1302	14	04	01	LIMA	CAÑETE	SAN VICENTE DE CAÑETE
1303	14	04	02	LIMA	CAÑETE	CALANGO
1304	14	04	03	LIMA	CAÑETE	CERRO AZUL
1305	14	04	04	LIMA	CAÑETE	COAYLLO
1306	14	04	05	LIMA	CAÑETE	CHILCA
1307	14	04	06	LIMA	CAÑETE	IMPERIAL
1308	14	04	07	LIMA	CAÑETE	LUNAHUANA
1309	14	04	08	LIMA	CAÑETE	MALA
1310	14	04	09	LIMA	CAÑETE	NUEVO IMPERIAL
1311	14	04	10	LIMA	CAÑETE	PACARAN
1312	14	04	11	LIMA	CAÑETE	QUILMANA
1313	14	04	12	LIMA	CAÑETE	SAN ANTONIO
1314	14	04	13	LIMA	CAÑETE	SAN LUIS
1315	14	04	14	LIMA	CAÑETE	SANTA CRUZ DE FLORES
1316	14	04	15	LIMA	CAÑETE	ZUÑIGA
1317	14	04	16	LIMA	CAÑETE	ASIA
1318	14	05	01	LIMA	HUAURA	HUACHO
1319	14	05	02	LIMA	HUAURA	AMBAR
1320	14	05	04	LIMA	HUAURA	CALETA DE CARQUIN
1321	14	05	05	LIMA	HUAURA	CHECRAS
1322	14	05	06	LIMA	HUAURA	HUALMAY
1323	14	05	07	LIMA	HUAURA	HUAURA
1324	14	05	08	LIMA	HUAURA	LEONCIO PRADO
1325	14	05	09	LIMA	HUAURA	PACCHO
1326	14	05	11	LIMA	HUAURA	SANTA LEONOR
1327	14	05	12	LIMA	HUAURA	SANTA MARIA
1328	14	05	13	LIMA	HUAURA	SAYAN
1329	14	05	16	LIMA	HUAURA	VEGUETA
1330	14	06	01	LIMA	HUAROCHIRI	MATUCANA
1331	14	06	02	LIMA	HUAROCHIRI	ANTIOQUIA
1332	14	06	03	LIMA	HUAROCHIRI	CALLAHUANCA
1333	14	06	04	LIMA	HUAROCHIRI	CARAMPOMA
1334	14	06	05	LIMA	HUAROCHIRI	CASTA
1335	14	06	06	LIMA	HUAROCHIRI	SAN JOSE DE LOS CHORRILLOS
1336	14	06	07	LIMA	HUAROCHIRI	CHICLA
1337	14	06	08	LIMA	HUAROCHIRI	HUANZA
1338	14	06	09	LIMA	HUAROCHIRI	HUAROCHIRI
1339	14	06	10	LIMA	HUAROCHIRI	LAHUAYTAMBO
1340	14	06	11	LIMA	HUAROCHIRI	LANGA
1341	14	06	12	LIMA	HUAROCHIRI	MARIATANA
1342	14	06	13	LIMA	HUAROCHIRI	RICARDO PALMA
1343	14	06	14	LIMA	HUAROCHIRI	SAN ANDRES DE TUPICOCHA
1344	14	06	15	LIMA	HUAROCHIRI	SAN ANTONIO
1345	14	06	16	LIMA	HUAROCHIRI	SAN BARTOLOME
1346	14	06	17	LIMA	HUAROCHIRI	SAN DAMIAN
1347	14	06	18	LIMA	HUAROCHIRI	SANGALLAYA
1348	14	06	19	LIMA	HUAROCHIRI	SAN JUAN DE TANTARANCHE
1349	14	06	20	LIMA	HUAROCHIRI	SAN LORENZO DE QUINTI
1350	14	06	21	LIMA	HUAROCHIRI	SAN MATEO
1351	14	06	22	LIMA	HUAROCHIRI	SAN MATEO DE OTAO
1352	14	06	23	LIMA	HUAROCHIRI	SAN PEDRO DE HUANCAYRE
1353	14	06	24	LIMA	HUAROCHIRI	SANTA CRUZ DE COCACHACRA
1354	14	06	25	LIMA	HUAROCHIRI	SANTA EULALIA
1355	14	06	26	LIMA	HUAROCHIRI	SANTIAGO DE ANCHUCAYA
1356	14	06	27	LIMA	HUAROCHIRI	SANTIAGO DE TUNA
1357	14	06	28	LIMA	HUAROCHIRI	SANTO DOMINGO DE LOS OLLEROS
1358	14	06	29	LIMA	HUAROCHIRI	SURCO
1359	14	06	30	LIMA	HUAROCHIRI	HUACHUPAMPA
1360	14	06	31	LIMA	HUAROCHIRI	LARAOS
1361	14	06	32	LIMA	HUAROCHIRI	SAN JUAN DE IRIS
1362	14	07	01	LIMA	YAUYOS	YAUYOS
1363	14	07	02	LIMA	YAUYOS	ALIS
1364	14	07	03	LIMA	YAUYOS	ALLAUCA
1365	14	07	04	LIMA	YAUYOS	AYAVIRI
1366	14	07	05	LIMA	YAUYOS	AZANGARO
1367	14	07	06	LIMA	YAUYOS	CACRA
1368	14	07	07	LIMA	YAUYOS	CARANIA
1369	14	07	08	LIMA	YAUYOS	COCHAS
1370	14	07	09	LIMA	YAUYOS	COLONIA
1371	14	07	10	LIMA	YAUYOS	CHOCOS
1372	14	07	11	LIMA	YAUYOS	HUAMPARA
1373	14	07	12	LIMA	YAUYOS	HUANCAYA
1374	14	07	13	LIMA	YAUYOS	HUANGASCAR
1375	14	07	14	LIMA	YAUYOS	HUANTAN
1376	14	07	15	LIMA	YAUYOS	HUAÑEC
1377	14	07	16	LIMA	YAUYOS	LARAOS
1378	14	07	17	LIMA	YAUYOS	LINCHA
1379	14	07	18	LIMA	YAUYOS	MIRAFLORES
1380	14	07	19	LIMA	YAUYOS	OMAS
1381	14	07	20	LIMA	YAUYOS	QUINCHES
1382	14	07	21	LIMA	YAUYOS	QUINOCAY
1383	14	07	22	LIMA	YAUYOS	SAN JOAQUIN
1384	14	07	23	LIMA	YAUYOS	SAN PEDRO DE PILAS
1385	14	07	24	LIMA	YAUYOS	TANTA
1386	14	07	25	LIMA	YAUYOS	TAURIPAMPA
1387	14	07	26	LIMA	YAUYOS	TUPE
1388	14	07	27	LIMA	YAUYOS	TOMAS
1389	14	07	28	LIMA	YAUYOS	VIÑAC
1390	14	07	29	LIMA	YAUYOS	VITIS
1391	14	07	30	LIMA	YAUYOS	HONGOS
1392	14	07	31	LIMA	YAUYOS	MADEAN
1393	14	07	32	LIMA	YAUYOS	PUTINZA
1394	14	07	33	LIMA	YAUYOS	CATAHUASI
1395	14	08	01	LIMA	HUARAL	HUARAL
1396	14	08	02	LIMA	HUARAL	ATAVILLOS ALTO
1397	14	08	03	LIMA	HUARAL	ATAVILLOS BAJO
1398	14	08	04	LIMA	HUARAL	AUCALLAMA
1399	14	08	05	LIMA	HUARAL	CHANCAY
1400	14	08	06	LIMA	HUARAL	IHUARI
1401	14	08	07	LIMA	HUARAL	LAMPIAN
1402	14	08	08	LIMA	HUARAL	PACARAOS
1403	14	08	09	LIMA	HUARAL	SAN MIGUEL DE ACOS
1404	14	08	10	LIMA	HUARAL	VEINTISIETE DE NOVIEMBRE
1405	14	08	11	LIMA	HUARAL	SANTA CRUZ DE ANDAMARCA
1406	14	08	12	LIMA	HUARAL	SUMBILCA
1407	14	09	01	LIMA	BARRANCA	BARRANCA
1408	14	09	02	LIMA	BARRANCA	PARAMONGA
1409	14	09	03	LIMA	BARRANCA	PATIVILCA
1410	14	09	04	LIMA	BARRANCA	SUPE
1411	14	09	05	LIMA	BARRANCA	SUPE PUERTO
1412	14	10	01	LIMA	OYON	OYON
1413	14	10	02	LIMA	OYON	NAVAN
1414	14	10	03	LIMA	OYON	CAUJUL
1415	14	10	04	LIMA	OYON	ANDAJES
1416	14	10	05	LIMA	OYON	PACHANGARA
1417	14	10	06	LIMA	OYON	COCHAMARCA
1418	15	01	01	LORETO	MAYNAS	IQUITOS
1419	15	01	02	LORETO	MAYNAS	ALTO NANAY
1420	15	01	03	LORETO	MAYNAS	FERNANDO LORES
1421	15	01	04	LORETO	MAYNAS	LAS AMAZONAS
1422	15	01	05	LORETO	MAYNAS	MAZAN
1423	15	01	06	LORETO	MAYNAS	NAPO
1424	15	01	07	LORETO	MAYNAS	PUTUMAYO
1425	15	01	08	LORETO	MAYNAS	TORRES CAUSANA
1426	15	01	10	LORETO	MAYNAS	INDIANA
1427	15	01	11	LORETO	MAYNAS	PUNCHANA
1428	15	01	12	LORETO	MAYNAS	BELEN
1429	15	01	13	LORETO	MAYNAS	SAN JUAN BAUTISTA
1430	15	01	14	LORETO	MAYNAS	TENIENTE MANUEL CLAVERO
1431	15	02	01	LORETO	ALTO AMAZONAS	YURIMAGUAS
1432	15	02	02	LORETO	ALTO AMAZONAS	BALSAPUERTO
1433	15	02	05	LORETO	ALTO AMAZONAS	JEBEROS
1434	15	02	06	LORETO	ALTO AMAZONAS	LAGUNAS
1435	15	02	10	LORETO	ALTO AMAZONAS	SANTA CRUZ
1436	15	02	11	LORETO	ALTO AMAZONAS	TENIENTE CESAR LOPEZ ROJAS
1437	15	03	01	LORETO	LORETO	NAUTA
1438	15	03	02	LORETO	LORETO	PARINARI
1439	15	03	03	LORETO	LORETO	TIGRE
1440	15	03	04	LORETO	LORETO	URARINAS
1441	15	03	05	LORETO	LORETO	TROMPETEROS
1442	15	04	01	LORETO	REQUENA	REQUENA
1443	15	04	02	LORETO	REQUENA	ALTO TAPICHE
1444	15	04	03	LORETO	REQUENA	CAPELO
1445	15	04	04	LORETO	REQUENA	EMILIO SAN MARTIN
1446	15	04	05	LORETO	REQUENA	MAQUIA
1447	15	04	06	LORETO	REQUENA	PUINAHUA
1448	15	04	07	LORETO	REQUENA	SAQUENA
1449	15	04	08	LORETO	REQUENA	SOPLIN
1450	15	04	09	LORETO	REQUENA	TAPICHE
1451	15	04	10	LORETO	REQUENA	JENARO HERRERA
1452	15	04	11	LORETO	REQUENA	YAQUERANA
1453	15	05	01	LORETO	UCAYALI	CONTAMANA
1454	15	05	02	LORETO	UCAYALI	VARGAS GUERRA
1455	15	05	03	LORETO	UCAYALI	PADRE MARQUEZ
1456	15	05	04	LORETO	UCAYALI	PAMPA HERMOSA
1457	15	05	05	LORETO	UCAYALI	SARAYACU
1458	15	05	06	LORETO	UCAYALI	INAHUAYA
1459	15	06	01	LORETO	MARISCAL RAMON CASTILLA	RAMON CASTILLA
1460	15	06	02	LORETO	MARISCAL RAMON CASTILLA	PEBAS
1461	15	06	03	LORETO	MARISCAL RAMON CASTILLA	YAVARI
1462	15	06	04	LORETO	MARISCAL RAMON CASTILLA	SAN PABLO
1463	15	07	01	LORETO	DATEM DEL MARAÑON	BARRANCA
1464	15	07	02	LORETO	DATEM DEL MARAÑON	ANDOAS
1465	15	07	03	LORETO	DATEM DEL MARAÑON	CAHUAPANAS
1466	15	07	04	LORETO	DATEM DEL MARAÑON	MANSERICHE
1467	15	07	05	LORETO	DATEM DEL MARAÑON	MORONA
1468	15	07	06	LORETO	DATEM DEL MARAÑON	PASTAZA
1469	16	01	01	MADRE DE DIOS	TAMBOPATA	TAMBOPATA
1470	16	01	02	MADRE DE DIOS	TAMBOPATA	INAMBARI
1471	16	01	03	MADRE DE DIOS	TAMBOPATA	LAS PIEDRAS
1472	16	01	04	MADRE DE DIOS	TAMBOPATA	LABERINTO
1473	16	02	01	MADRE DE DIOS	MANU	MANU
1474	16	02	02	MADRE DE DIOS	MANU	FITZCARRALD
1475	16	02	03	MADRE DE DIOS	MANU	MADRE DE DIOS
1476	16	02	04	MADRE DE DIOS	MANU	HUEPETUHE
1477	16	03	01	MADRE DE DIOS	TAHUAMANU	IÑAPARI
1478	16	03	02	MADRE DE DIOS	TAHUAMANU	IBERIA
1479	16	03	03	MADRE DE DIOS	TAHUAMANU	TAHUAMANU
1480	17	01	01	MOQUEGUA	MARISCAL NIETO	MOQUEGUA
1481	17	01	02	MOQUEGUA	MARISCAL NIETO	CARUMAS
1482	17	01	03	MOQUEGUA	MARISCAL NIETO	CUCHUMBAYA
1483	17	01	04	MOQUEGUA	MARISCAL NIETO	SAN CRISTOBAL
1484	17	01	05	MOQUEGUA	MARISCAL NIETO	TORATA
1485	17	01	06	MOQUEGUA	MARISCAL NIETO	SAMEGUA
1486	17	02	01	MOQUEGUA	GENERAL SANCHEZ CERRO	OMATE
1487	17	02	02	MOQUEGUA	GENERAL SANCHEZ CERRO	COALAQUE
1488	17	02	03	MOQUEGUA	GENERAL SANCHEZ CERRO	CHOJATA
1489	17	02	04	MOQUEGUA	GENERAL SANCHEZ CERRO	ICHUÑA
1490	17	02	05	MOQUEGUA	GENERAL SANCHEZ CERRO	LA CAPILLA
1491	17	02	06	MOQUEGUA	GENERAL SANCHEZ CERRO	LLOQUE
1492	17	02	07	MOQUEGUA	GENERAL SANCHEZ CERRO	MATALAQUE
1493	17	02	08	MOQUEGUA	GENERAL SANCHEZ CERRO	PUQUINA
1494	17	02	09	MOQUEGUA	GENERAL SANCHEZ CERRO	QUINISTAQUILLAS
1495	17	02	10	MOQUEGUA	GENERAL SANCHEZ CERRO	UBINAS
1496	17	02	11	MOQUEGUA	GENERAL SANCHEZ CERRO	YUNGA
1497	17	03	01	MOQUEGUA	ILO	ILO
1498	17	03	02	MOQUEGUA	ILO	EL ALGARROBAL
1499	17	03	03	MOQUEGUA	ILO	PACOCHA
1500	18	01	01	PASCO	PASCO	CHAUPIMARCA
1501	18	01	03	PASCO	PASCO	HUACHON
1502	18	01	04	PASCO	PASCO	HUARIACA
1503	18	01	05	PASCO	PASCO	HUAYLLAY
1504	18	01	06	PASCO	PASCO	NINACACA
1505	18	01	07	PASCO	PASCO	PALLANCHACRA
1506	18	01	08	PASCO	PASCO	PAUCARTAMBO
1507	18	01	09	PASCO	PASCO	SAN FCO DE ASIS DE YARUSYACAN
1508	18	01	10	PASCO	PASCO	SIMON BOLIVAR
1509	18	01	11	PASCO	PASCO	TICLACAYAN
1510	18	01	12	PASCO	PASCO	TINYAHUARCO
1511	18	01	13	PASCO	PASCO	VICCO
1512	18	01	14	PASCO	PASCO	YANACANCHA
1513	18	02	01	PASCO	DANIEL ALCIDES CARRION	YANAHUANCA
1514	18	02	02	PASCO	DANIEL ALCIDES CARRION	CHACAYAN
1515	18	02	03	PASCO	DANIEL ALCIDES CARRION	GOYLLARISQUIZGA
1516	18	02	04	PASCO	DANIEL ALCIDES CARRION	PAUCAR
1517	18	02	05	PASCO	DANIEL ALCIDES CARRION	SAN PEDRO DE PILLAO
1518	18	02	06	PASCO	DANIEL ALCIDES CARRION	SANTA ANA DE TUSI
1519	18	02	07	PASCO	DANIEL ALCIDES CARRION	TAPUC
1520	18	02	08	PASCO	DANIEL ALCIDES CARRION	VILCABAMBA
1521	18	03	01	PASCO	OXAPAMPA	OXAPAMPA
1522	18	03	02	PASCO	OXAPAMPA	CHONTABAMBA
1523	18	03	03	PASCO	OXAPAMPA	HUANCABAMBA
1524	18	03	04	PASCO	OXAPAMPA	PUERTO BERMUDEZ
1525	18	03	05	PASCO	OXAPAMPA	VILLA RICA
1526	18	03	06	PASCO	OXAPAMPA	POZUZO
1527	18	03	07	PASCO	OXAPAMPA	PALCAZU
1528	18	03	08	PASCO	OXAPAMPA	CONSTITUCION
1529	19	01	01	PIURA	PIURA	PIURA
1530	19	01	03	PIURA	PIURA	CASTILLA
1531	19	01	04	PIURA	PIURA	CATACAOS
1532	19	01	05	PIURA	PIURA	LA ARENA
1533	19	01	06	PIURA	PIURA	LA UNION
1534	19	01	07	PIURA	PIURA	LAS LOMAS
1535	19	01	09	PIURA	PIURA	TAMBO GRANDE
1536	19	01	13	PIURA	PIURA	CURA MORI
1537	19	01	14	PIURA	PIURA	EL TALLAN
1538	19	01	15	PIURA	PIURA	VEINTISEIS DE OCTUBRE
1539	19	02	01	PIURA	AYABACA	AYABACA
1540	19	02	02	PIURA	AYABACA	FRIAS
1541	19	02	03	PIURA	AYABACA	LAGUNAS
1542	19	02	04	PIURA	AYABACA	MONTERO
1543	19	02	05	PIURA	AYABACA	PACAIPAMPA
1544	19	02	06	PIURA	AYABACA	SAPILLICA
1545	19	02	07	PIURA	AYABACA	SICCHEZ
1546	19	02	08	PIURA	AYABACA	SUYO
1547	19	02	09	PIURA	AYABACA	JILILI
1548	19	02	10	PIURA	AYABACA	PAIMAS
1549	19	03	01	PIURA	HUANCABAMBA	HUANCABAMBA
1550	19	03	02	PIURA	HUANCABAMBA	CANCHAQUE
1551	19	03	03	PIURA	HUANCABAMBA	HUARMACA
1552	19	03	04	PIURA	HUANCABAMBA	SONDOR
1553	19	03	05	PIURA	HUANCABAMBA	SONDORILLO
1554	19	03	06	PIURA	HUANCABAMBA	EL CARMEN DE LA FRONTERA
1555	19	03	07	PIURA	HUANCABAMBA	SAN MIGUEL DE EL FAIQUE
1556	19	03	08	PIURA	HUANCABAMBA	LALAQUIZ
1557	19	04	01	PIURA	MORROPON	CHULUCANAS
1558	19	04	02	PIURA	MORROPON	BUENOS AIRES
1559	19	04	03	PIURA	MORROPON	CHALACO
1560	19	04	04	PIURA	MORROPON	MORROPON
1561	19	04	05	PIURA	MORROPON	SALITRAL
1562	19	04	06	PIURA	MORROPON	SANTA CATALINA DE MOSSA
1563	19	04	07	PIURA	MORROPON	SANTO DOMINGO
1564	19	04	08	PIURA	MORROPON	LA MATANZA
1565	19	04	09	PIURA	MORROPON	YAMANGO
1566	19	04	10	PIURA	MORROPON	SAN JUAN DE BIGOTE
1567	19	05	01	PIURA	PAITA	PAITA
1568	19	05	02	PIURA	PAITA	AMOTAPE
1569	19	05	03	PIURA	PAITA	ARENAL
1570	19	05	04	PIURA	PAITA	LA HUACA
1571	19	05	05	PIURA	PAITA	COLAN
1572	19	05	06	PIURA	PAITA	TAMARINDO
1573	19	05	07	PIURA	PAITA	VICHAYAL
1574	19	06	01	PIURA	SULLANA	SULLANA
1575	19	06	02	PIURA	SULLANA	BELLAVISTA
1576	19	06	03	PIURA	SULLANA	LANCONES
1577	19	06	04	PIURA	SULLANA	MARCAVELICA
1578	19	06	05	PIURA	SULLANA	MIGUEL CHECA
1579	19	06	06	PIURA	SULLANA	QUERECOTILLO
1580	19	06	07	PIURA	SULLANA	SALITRAL
1581	19	06	08	PIURA	SULLANA	IGNACIO ESCUDERO
1582	19	07	01	PIURA	TALARA	PARIÑAS
1583	19	07	02	PIURA	TALARA	EL ALTO
1584	19	07	03	PIURA	TALARA	LA BREA
1585	19	07	04	PIURA	TALARA	LOBITOS
1586	19	07	05	PIURA	TALARA	MANCORA
1587	19	07	06	PIURA	TALARA	LOS ORGANOS
1588	19	08	01	PIURA	SECHURA	SECHURA
1589	19	08	02	PIURA	SECHURA	VICE
1590	19	08	03	PIURA	SECHURA	BERNAL
1591	19	08	04	PIURA	SECHURA	BELLAVISTA DE LA UNION
1592	19	08	05	PIURA	SECHURA	CRISTO NOS VALGA
1593	19	08	06	PIURA	SECHURA	RINCONADA-LLICUAR
1594	20	01	01	PUNO	PUNO	PUNO
1595	20	01	02	PUNO	PUNO	ACORA
1596	20	01	03	PUNO	PUNO	ATUNCOLLA
1597	20	01	04	PUNO	PUNO	CAPACHICA
1598	20	01	05	PUNO	PUNO	COATA
1599	20	01	06	PUNO	PUNO	CHUCUITO
1600	20	01	07	PUNO	PUNO	HUATA
1601	20	01	08	PUNO	PUNO	MAÑAZO
1602	20	01	09	PUNO	PUNO	PAUCARCOLLA
1603	20	01	10	PUNO	PUNO	PICHACANI
1604	20	01	11	PUNO	PUNO	SAN ANTONIO
1605	20	01	12	PUNO	PUNO	TIQUILLACA
1606	20	01	13	PUNO	PUNO	VILQUE
1607	20	01	14	PUNO	PUNO	PLATERIA
1608	20	01	15	PUNO	PUNO	AMANTANI
1609	20	02	01	PUNO	AZANGARO	AZANGARO
1610	20	02	02	PUNO	AZANGARO	ACHAYA
1611	20	02	03	PUNO	AZANGARO	ARAPA
1612	20	02	04	PUNO	AZANGARO	ASILLO
1613	20	02	05	PUNO	AZANGARO	CAMINACA
1614	20	02	06	PUNO	AZANGARO	CHUPA
1615	20	02	07	PUNO	AZANGARO	JOSE DOMINGO CHOQUEHUANCA
1616	20	02	08	PUNO	AZANGARO	MUÑANI
1617	20	02	10	PUNO	AZANGARO	POTONI
1618	20	02	12	PUNO	AZANGARO	SAMAN
1619	20	02	13	PUNO	AZANGARO	SAN ANTON
1620	20	02	14	PUNO	AZANGARO	SAN JOSE
1621	20	02	15	PUNO	AZANGARO	SAN JUAN DE SALINAS
1622	20	02	16	PUNO	AZANGARO	SANTIAGO DE PUPUJA
1623	20	02	17	PUNO	AZANGARO	TIRAPATA
1624	20	03	01	PUNO	CARABAYA	MACUSANI
1625	20	03	02	PUNO	CARABAYA	AJOYANI
1626	20	03	03	PUNO	CARABAYA	AYAPATA
1627	20	03	04	PUNO	CARABAYA	COASA
1628	20	03	05	PUNO	CARABAYA	CORANI
1629	20	03	06	PUNO	CARABAYA	CRUCERO
1630	20	03	07	PUNO	CARABAYA	ITUATA
1631	20	03	08	PUNO	CARABAYA	OLLACHEA
1632	20	03	09	PUNO	CARABAYA	SAN GABAN
1633	20	03	10	PUNO	CARABAYA	USICAYOS
1634	20	04	01	PUNO	CHUCUITO	JULI
1635	20	04	02	PUNO	CHUCUITO	DESAGUADERO
1636	20	04	03	PUNO	CHUCUITO	HUACULLANI
1637	20	04	06	PUNO	CHUCUITO	PISACOMA
1638	20	04	07	PUNO	CHUCUITO	POMATA
1639	20	04	10	PUNO	CHUCUITO	ZEPITA
1640	20	04	12	PUNO	CHUCUITO	KELLUYO
1641	20	05	01	PUNO	HUANCANE	HUANCANE
1642	20	05	02	PUNO	HUANCANE	COJATA
1643	20	05	04	PUNO	HUANCANE	INCHUPALLA
1644	20	05	06	PUNO	HUANCANE	PUSI
1645	20	05	07	PUNO	HUANCANE	ROSASPATA
1646	20	05	08	PUNO	HUANCANE	TARACO
1647	20	05	09	PUNO	HUANCANE	VILQUE CHICO
1648	20	05	11	PUNO	HUANCANE	HUATASANI
1649	20	06	01	PUNO	LAMPA	LAMPA
1650	20	06	02	PUNO	LAMPA	CABANILLA
1651	20	06	03	PUNO	LAMPA	CALAPUJA
1652	20	06	04	PUNO	LAMPA	NICASIO
1653	20	06	05	PUNO	LAMPA	OCUVIRI
1654	20	06	06	PUNO	LAMPA	PALCA
1655	20	06	07	PUNO	LAMPA	PARATIA
1656	20	06	08	PUNO	LAMPA	PUCARA
1657	20	06	09	PUNO	LAMPA	SANTA LUCIA
1658	20	06	10	PUNO	LAMPA	VILAVILA
1659	20	07	01	PUNO	MELGAR	AYAVIRI
1660	20	07	02	PUNO	MELGAR	ANTAUTA
1661	20	07	03	PUNO	MELGAR	CUPI
1662	20	07	04	PUNO	MELGAR	LLALLI
1663	20	07	05	PUNO	MELGAR	MACARI
1664	20	07	06	PUNO	MELGAR	NUÑOA
1665	20	07	07	PUNO	MELGAR	ORURILLO
1666	20	07	08	PUNO	MELGAR	SANTA ROSA
1667	20	07	09	PUNO	MELGAR	UMACHIRI
1668	20	08	01	PUNO	SANDIA	SANDIA
1669	20	08	03	PUNO	SANDIA	CUYOCUYO
1670	20	08	04	PUNO	SANDIA	LIMBANI
1671	20	08	05	PUNO	SANDIA	PHARA
1672	20	08	06	PUNO	SANDIA	PATAMBUCO
1673	20	08	07	PUNO	SANDIA	QUIACA
1674	20	08	08	PUNO	SANDIA	SAN JUAN DEL ORO
1675	20	08	10	PUNO	SANDIA	YANAHUAYA
1676	20	08	11	PUNO	SANDIA	ALTO INAMBARI
1677	20	08	12	PUNO	SANDIA	SAN PEDRO DE PUTINA PUNCO
1678	20	09	01	PUNO	SAN ROMAN	JULIACA
1679	20	09	02	PUNO	SAN ROMAN	CABANA
1680	20	09	03	PUNO	SAN ROMAN	CABANILLAS
1681	20	09	04	PUNO	SAN ROMAN	CARACOTO
1682	20	10	01	PUNO	YUNGUYO	YUNGUYO
1683	20	10	02	PUNO	YUNGUYO	UNICACHI
1684	20	10	03	PUNO	YUNGUYO	ANAPIA
1685	20	10	04	PUNO	YUNGUYO	COPANI
1686	20	10	05	PUNO	YUNGUYO	CUTURAPI
1687	20	10	06	PUNO	YUNGUYO	OLLARAYA
1688	20	10	07	PUNO	YUNGUYO	TINICACHI
1689	20	11	01	PUNO	SAN ANTONIO DE PUTINA	PUTINA
1690	20	11	02	PUNO	SAN ANTONIO DE PUTINA	PEDRO VILCA APAZA
1691	20	11	03	PUNO	SAN ANTONIO DE PUTINA	QUILCAPUNCU
1692	20	11	04	PUNO	SAN ANTONIO DE PUTINA	ANANEA
1693	20	11	05	PUNO	SAN ANTONIO DE PUTINA	SINA
1694	20	12	01	PUNO	EL COLLAO	ILAVE
1695	20	12	02	PUNO	EL COLLAO	PILCUYO
1696	20	12	03	PUNO	EL COLLAO	SANTA ROSA
1697	20	12	04	PUNO	EL COLLAO	CAPASO
1698	20	12	05	PUNO	EL COLLAO	CONDURIRI
1699	20	13	01	PUNO	MOHO	MOHO
1700	20	13	02	PUNO	MOHO	CONIMA
1701	20	13	03	PUNO	MOHO	TILALI
1702	20	13	04	PUNO	MOHO	HUAYRAPATA
1703	21	01	01	SAN MARTIN	MOYOBAMBA	MOYOBAMBA
1704	21	01	02	SAN MARTIN	MOYOBAMBA	CALZADA
1705	21	01	03	SAN MARTIN	MOYOBAMBA	HABANA
1706	21	01	04	SAN MARTIN	MOYOBAMBA	JEPELACIO
1707	21	01	05	SAN MARTIN	MOYOBAMBA	SORITOR
1708	21	01	06	SAN MARTIN	MOYOBAMBA	YANTALO
1709	21	02	01	SAN MARTIN	HUALLAGA	SAPOSOA
1710	21	02	02	SAN MARTIN	HUALLAGA	PISCOYACU
1711	21	02	03	SAN MARTIN	HUALLAGA	SACANCHE
1712	21	02	04	SAN MARTIN	HUALLAGA	TINGO DE SAPOSOA
1713	21	02	05	SAN MARTIN	HUALLAGA	ALTO SAPOSOA
1714	21	02	06	SAN MARTIN	HUALLAGA	EL ESLABON
1715	21	03	01	SAN MARTIN	LAMAS	LAMAS
1716	21	03	03	SAN MARTIN	LAMAS	BARRANQUITA
1717	21	03	04	SAN MARTIN	LAMAS	CAYNARACHI
1718	21	03	05	SAN MARTIN	LAMAS	CUÑUMBUQUI
1719	21	03	06	SAN MARTIN	LAMAS	PINTO RECODO
1720	21	03	07	SAN MARTIN	LAMAS	RUMISAPA
1721	21	03	11	SAN MARTIN	LAMAS	SHANAO
1722	21	03	13	SAN MARTIN	LAMAS	TABALOSOS
1723	21	03	14	SAN MARTIN	LAMAS	ZAPATERO
1724	21	03	15	SAN MARTIN	LAMAS	ALONSO DE ALVARADO
1725	21	03	16	SAN MARTIN	LAMAS	SAN ROQUE DE CUMBAZA
1726	21	04	01	SAN MARTIN	MARISCAL CACERES	JUANJUI
1727	21	04	02	SAN MARTIN	MARISCAL CACERES	CAMPANILLA
1728	21	04	03	SAN MARTIN	MARISCAL CACERES	HUICUNGO
1729	21	04	04	SAN MARTIN	MARISCAL CACERES	PACHIZA
1730	21	04	05	SAN MARTIN	MARISCAL CACERES	PAJARILLO
1731	21	05	01	SAN MARTIN	RIOJA	RIOJA
1732	21	05	02	SAN MARTIN	RIOJA	POSIC
1733	21	05	03	SAN MARTIN	RIOJA	YORONGOS
1734	21	05	04	SAN MARTIN	RIOJA	YURACYACU
1735	21	05	05	SAN MARTIN	RIOJA	NUEVA CAJAMARCA
1736	21	05	06	SAN MARTIN	RIOJA	ELIAS SOPLIN VARGAS
1737	21	05	07	SAN MARTIN	RIOJA	SAN FERNANDO
1738	21	05	08	SAN MARTIN	RIOJA	PARDO MIGUEL
1739	21	05	09	SAN MARTIN	RIOJA	AWAJUN
1740	21	06	01	SAN MARTIN	SAN MARTIN	TARAPOTO
1741	21	06	02	SAN MARTIN	SAN MARTIN	ALBERTO LEVEAU
1742	21	06	04	SAN MARTIN	SAN MARTIN	CACATACHI
1743	21	06	06	SAN MARTIN	SAN MARTIN	CHAZUTA
1744	21	06	07	SAN MARTIN	SAN MARTIN	CHIPURANA
1745	21	06	08	SAN MARTIN	SAN MARTIN	EL PORVENIR
1746	21	06	09	SAN MARTIN	SAN MARTIN	HUIMBAYOC
1747	21	06	10	SAN MARTIN	SAN MARTIN	JUAN GUERRA
1748	21	06	11	SAN MARTIN	SAN MARTIN	MORALES
1749	21	06	12	SAN MARTIN	SAN MARTIN	PAPAPLAYA
1750	21	06	16	SAN MARTIN	SAN MARTIN	SAN ANTONIO
1751	21	06	19	SAN MARTIN	SAN MARTIN	SAUCE
1752	21	06	20	SAN MARTIN	SAN MARTIN	SHAPAJA
1753	21	06	21	SAN MARTIN	SAN MARTIN	LA BANDA DE SHILCAYO
1754	21	07	01	SAN MARTIN	BELLAVISTA	BELLAVISTA
1755	21	07	02	SAN MARTIN	BELLAVISTA	SAN RAFAEL
1756	21	07	03	SAN MARTIN	BELLAVISTA	SAN PABLO
1757	21	07	04	SAN MARTIN	BELLAVISTA	ALTO BIAVO
1758	21	07	05	SAN MARTIN	BELLAVISTA	HUALLAGA
1759	21	07	06	SAN MARTIN	BELLAVISTA	BAJO BIAVO
1760	21	08	01	SAN MARTIN	TOCACHE	TOCACHE
1761	21	08	02	SAN MARTIN	TOCACHE	NUEVO PROGRESO
1762	21	08	03	SAN MARTIN	TOCACHE	POLVORA
1763	21	08	04	SAN MARTIN	TOCACHE	SHUNTE
1764	21	08	05	SAN MARTIN	TOCACHE	UCHIZA
1765	21	09	01	SAN MARTIN	PICOTA	PICOTA
1766	21	09	02	SAN MARTIN	PICOTA	BUENOS AIRES
1767	21	09	03	SAN MARTIN	PICOTA	CASPIZAPA
1768	21	09	04	SAN MARTIN	PICOTA	PILLUANA
1769	21	09	05	SAN MARTIN	PICOTA	PUCACACA
1770	21	09	06	SAN MARTIN	PICOTA	SAN CRISTOBAL
1771	21	09	07	SAN MARTIN	PICOTA	SAN HILARION
1772	21	09	08	SAN MARTIN	PICOTA	TINGO DE PONASA
1773	21	09	09	SAN MARTIN	PICOTA	TRES UNIDOS
1774	21	09	10	SAN MARTIN	PICOTA	SHAMBOYACU
1775	21	10	01	SAN MARTIN	EL DORADO	SAN JOSE DE SISA
1776	21	10	02	SAN MARTIN	EL DORADO	AGUA BLANCA
1777	21	10	03	SAN MARTIN	EL DORADO	SHATOJA
1778	21	10	04	SAN MARTIN	EL DORADO	SAN MARTIN
1779	21	10	05	SAN MARTIN	EL DORADO	SANTA ROSA
1780	22	01	01	TACNA	TACNA	TACNA
1781	22	01	02	TACNA	TACNA	CALANA
1782	22	01	04	TACNA	TACNA	INCLAN
1783	22	01	07	TACNA	TACNA	PACHIA
1784	22	01	08	TACNA	TACNA	PALCA
1785	22	01	09	TACNA	TACNA	POCOLLAY
1786	22	01	10	TACNA	TACNA	SAMA
1787	22	01	11	TACNA	TACNA	ALTO DE LA ALIANZA
1788	22	01	12	TACNA	TACNA	CIUDAD NUEVA
1789	22	01	13	TACNA	TACNA	CORONEL GREGORIO ALBARRACIN L.
1790	22	02	01	TACNA	TARATA	TARATA
1791	22	02	05	TACNA	TARATA	HEROES ALBARRACIN
1792	22	02	06	TACNA	TARATA	ESTIQUE
1793	22	02	07	TACNA	TARATA	ESTIQUE PAMPA
1794	22	02	10	TACNA	TARATA	SITAJARA
1795	22	02	11	TACNA	TARATA	SUSAPAYA
1796	22	02	12	TACNA	TARATA	TARUCACHI
1797	22	02	13	TACNA	TARATA	TICACO
1798	22	03	01	TACNA	JORGE BASADRE	LOCUMBA
1799	22	03	02	TACNA	JORGE BASADRE	ITE
1800	22	03	03	TACNA	JORGE BASADRE	ILABAYA
1801	22	04	01	TACNA	CANDARAVE	CANDARAVE
1802	22	04	02	TACNA	CANDARAVE	CAIRANI
1803	22	04	03	TACNA	CANDARAVE	CURIBAYA
1804	22	04	04	TACNA	CANDARAVE	HUANUARA
1805	22	04	05	TACNA	CANDARAVE	QUILAHUANI
1806	22	04	06	TACNA	CANDARAVE	CAMILACA
1807	23	01	01	TUMBES	TUMBES	TUMBES
1808	23	01	02	TUMBES	TUMBES	CORRALES
1809	23	01	03	TUMBES	TUMBES	LA CRUZ
1810	23	01	04	TUMBES	TUMBES	PAMPAS DE HOSPITAL
1811	23	01	05	TUMBES	TUMBES	SAN JACINTO
1812	23	01	06	TUMBES	TUMBES	SAN JUAN DE LA VIRGEN
1813	23	02	01	TUMBES	CONTRALMIRANTE VILLAR	ZORRITOS
1814	23	02	02	TUMBES	CONTRALMIRANTE VILLAR	CASITAS
1815	23	02	03	TUMBES	CONTRALMIRANTE VILLAR	CANOAS DE PUNTA SAL
1816	23	03	01	TUMBES	ZARUMILLA	ZARUMILLA
1817	23	03	02	TUMBES	ZARUMILLA	MATAPALO
1818	23	03	03	TUMBES	ZARUMILLA	PAPAYAL
1819	23	03	04	TUMBES	ZARUMILLA	AGUAS VERDES
1820	24	01	01	CALLAO	CALLAO	CALLAO
1821	24	01	02	CALLAO	CALLAO	BELLAVISTA
1822	24	01	03	CALLAO	CALLAO	LA PUNTA
1823	24	01	04	CALLAO	CALLAO	CARMEN DE LA LEGUA-REYNOSO
1824	24	01	05	CALLAO	CALLAO	LA PERLA
1825	24	01	06	CALLAO	CALLAO	VENTANILLA
1826	25	01	01	UCAYALI	CORONEL PORTILLO	CALLERIA
1827	25	01	02	UCAYALI	CORONEL PORTILLO	YARINACOCHA
1828	25	01	03	UCAYALI	CORONEL PORTILLO	MASISEA
1829	25	01	04	UCAYALI	CORONEL PORTILLO	CAMPOVERDE
1830	25	01	05	UCAYALI	CORONEL PORTILLO	IPARIA
1831	25	01	06	UCAYALI	CORONEL PORTILLO	NUEVA REQUENA
1832	25	01	07	UCAYALI	CORONEL PORTILLO	MANANTAY
1833	25	02	01	UCAYALI	PADRE ABAD	PADRE ABAD
1834	25	02	02	UCAYALI	PADRE ABAD	IRAZOLA
1835	25	02	03	UCAYALI	PADRE ABAD	CURIMANA
1836	25	03	01	UCAYALI	ATALAYA	RAIMONDI
1837	25	03	02	UCAYALI	ATALAYA	TAHUANIA
1838	25	03	03	UCAYALI	ATALAYA	YURUA
1839	25	03	04	UCAYALI	ATALAYA	SEPAHUA
1840	25	04	01	UCAYALI	PURUS	PURUS
0	00	00	00	NO DEFINIDO	NO DEFINIDO	NO DEFINIDO
\.


--
-- TOC entry 4140 (class 0 OID 192653)
-- Dependencies: 331
-- Data for Name: webservice; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.webservice (codempresa, usuariosol, clavesol, envioemail, claveemail, certificado_pfx, certificado_clave, sunatose, serviceweb, servicesunat, servicesunat_demo, serviceose, serviceose_demo, servicesunatguia, servicesunatguia_demo, serviceoseguia, serviceoseguia_demo, servicesunatretencion, servicesunatretencion_demo, serviceoseretencion, serviceoseretencion_demo) FROM stdin;
1	TOCHO123	Tocho2023			certificado.p12	tocho2023	0	1	./sunat/billService.wsdl	https://e-beta.sunat.gob.pe/ol-ti-itcpfegem-beta/billService?wsdl	\N		https://e-guiaremision.sunat.gob.pe/ol-ti-itemision-guia-gem/billService?wsdl	https://e-beta.sunat.gob.pe/ol-ti-itemision-guia-gem-beta/billService?wsdl	\N		https://e-factura.sunat.gob.pe/ol-ti-itemision-otroscpe-gem/billService?wsdl	https://e-beta.sunat.gob.pe/ol-ti-itemision-otroscpe-gem-beta/billService?wsdl	\N	
\.


--
-- TOC entry 4141 (class 0 OID 192661)
-- Dependencies: 332
-- Data for Name: moduloperfiles; Type: TABLE DATA; Schema: seguridad; Owner: phuyu15
--

COPY seguridad.moduloperfiles (codmodulo, codperfil) FROM stdin;
11	2
12	2
21	2
22	2
31	2
32	2
33	2
34	2
35	2
36	2
37	2
38	2
39	2
40	2
41	2
42	2
43	2
44	2
51	2
52	2
53	2
54	2
61	2
62	2
63	2
64	2
65	2
66	2
67	2
68	2
71	2
72	2
73	2
74	2
75	2
81	2
102	2
103	2
12	5
15	5
10	5
31	5
33	5
34	5
35	5
71	5
11	5
32	5
11	3
12	3
13	3
15	3
9	3
10	3
21	3
22	3
23	3
31	3
32	3
33	3
34	3
35	3
36	3
37	3
38	3
39	3
40	3
17	3
18	3
19	3
41	3
42	3
43	3
44	3
51	3
52	3
53	3
54	3
61	3
62	3
63	3
64	3
65	3
66	3
67	3
68	3
16	3
20	3
71	3
72	3
73	3
74	3
75	3
104	3
81	3
102	3
103	3
11	1
12	1
13	1
15	1
9	1
10	1
21	1
22	1
23	1
31	1
32	1
33	1
34	1
35	1
36	1
37	1
38	1
39	1
40	1
17	1
18	1
19	1
41	1
42	1
43	1
44	1
51	1
52	1
53	1
54	1
61	1
62	1
63	1
64	1
65	1
66	1
67	1
68	1
16	1
20	1
71	1
72	1
73	1
74	1
75	1
104	1
81	1
102	1
103	1
106	1
107	1
\.


--
-- TOC entry 4142 (class 0 OID 192664)
-- Dependencies: 333
-- Data for Name: modulos; Type: TABLE DATA; Schema: seguridad; Owner: phuyu15
--

COPY seguridad.modulos (codmodulo, descripcion, icono, url, codpadre, orden, estado) FROM stdin;
1	AREA VENTAS	fa fa-shopping-cart	#	0	1	1
2	AREA COMPRAS	fa fa-shopping-cart	#	0	2	1
3	AREA ALMACEN	fa fa-home	#	0	3	1
4	CAJA Y BANCOS	fa fa-money	#	0	4	1
11	VENTAS	fa fa-shopping-cart	ventas/ventas	1	1	1
21	COMPRAS	fa fa-shopping-cart	compras/compras	2	1	1
31	PRODUCTOS	fa fa-home	almacen/productos	3	1	1
43	CUENTAS CTES	fa fa-money	caja/ctasctes	4	3	1
42	MOVIMIENTOS	fa fa-money	caja/movimientos	4	2	1
41	CONTROL CAJA	fa fa-money	caja/controlcajas	4	1	1
12	CLIENTES	fa fa-shopping-cart	ventas/clientes	1	2	1
22	PROVEEDORES	fa fa-shopping-cart	compras/proveedores	2	2	1
13	NOTAS DE CREDITO	fa fa-shopping-cart	ventas/notascredito	1	3	1
71	VENTAS	fa fa-print	reportes/ventas	7	1	1
61	EMPRESA	fa fa-cog	administracion/empresa	6	1	1
62	SUCURSALES	fa fa-cog	administracion/sucursales	6	2	1
63	ALMACENES	fa fa-cog	administracion/almacenes	6	3	1
64	CAJAS	fa fa-cog	administracion/cajas	6	4	1
65	COMPROBANTES	fa fa-cog	administracion/comprobantes	6	5	1
66	EMPLEADOS	fa fa-cog	administracion/empleados	6	6	1
67	USUARIOS	fa fa-cog	administracion/usuarios	6	7	1
68	PERFILES	fa fa-cog	administracion/perfiles	6	8	1
52	CUENTAS X PAGAR	fa fa-exchange	creditos/cuentaspagar	5	2	1
51	CUENTAS X COBRAR	fa fa-exchange	creditos/cuentascobrar	5	1	1
5	AREA CREDITOS	fa fa-exchange	#	0	5	1
7	AREA REPORTES	fa fa-print	#	0	7	1
72	COMPRAS	fa fa-print	reportes/compras	7	2	1
73	PRODUCTOS	fa fa-print	reportes/productos	7	3	1
8	FACTURACION SUNAT	fa fa-file-o	#	0	8	1
44	TIPO CAMBIOS	fa fa-money	caja/tipocambios	4	4	1
74	CAJA Y BANCOS	fa fa-print	reportes/cajabancos	7	4	1
75	CREDITOS	fa fa-print	reportes/creditos	7	5	1
53	LISTA X COBRAR	fa fa-exchange	creditos/listacobrar	5	3	1
54	LISTA X PAGAR	fa fa-exchange	creditos/listapagar	5	4	1
32	PRODUCTOS UNIDADES	fa fa-home	almacen/productosunidades	3	2	1
33	MARCAS	fa fa-home	almacen/marcas	3	3	1
34	LINEAS	fa fa-home	almacen/lineas	3	4	1
35	FAMILIAS	fa fa-home	almacen/familias	3	5	1
36	UNIDADES	fa fa-home	almacen/unidades	3	6	1
37	INGRESOS ALMACEN	fa fa-home	almacen/ingresos	3	7	1
38	SALIDAS ALMACEN	fa fa-home	almacen/salidas	3	8	1
39	DESPACHOS (VENTA-COMPRA)	fa fa-home	almacen/despachos	3	9	1
40	INVENTARIOS	fa fa-home	almacen/inventarios	3	10	1
15	PEDIDOS VENTAS	fa fa-shopping-cart	ventas/pedidos	1	5	1
6	ADMINIS TRACION	fa fa-cog	#	0	6	1
81	ENVIOS SUNAT	fa fa-file-o	facturacion/facturacion	8	1	1
102	COMPROBANTES	fa fa-xing-square	facturacion/comprobantes	8	2	1
103	RESUMENES	fa fa-xing-square	facturacion/resumenes	8	3	1
23	NOTAS DE CREDITO	fa fa-shopping-cart	compras/notascredito	2	3	1
9	GUIAS ELECTRONICAS	fa fa-shopping-cart	ventas/guias	1	6	1
10	PROFORMAS	fa fa-shopping	ventas/proformas	1	7	1
14	NOTAS DE DEBITO	fa fa-shopping-cart	ventas/notasdedito	1	4	0
16	VEHICULOS	fa fa-cog	administracion/vehiculos	6	9	1
104	UTILIDADES	fa fa-print	reportes/utilidades	7	6	1
17	PRINCIPIO ACTIVO	fa fa-home	almacen/principioactivo	3	11	1
18	PRESENTACION	fa fa-home	almacen/presentacion	3	12	1
19	CLASE	fa fa-home	almacen/clase	3	13	1
20	RUBROS	fa fa-home	administracion/rubros	6	10	1
105	ASISTENCIAS	fa fa-home	#	0	9	1
106	CONTROL	fa fa-home	asistencias/control	105	1	1
107	LISTA	fa fa-home	asistencias/lista	105	2	1
\.


--
-- TOC entry 4144 (class 0 OID 192670)
-- Dependencies: 335
-- Data for Name: perfiles; Type: TABLE DATA; Schema: seguridad; Owner: phuyu15
--

COPY seguridad.perfiles (codperfil, descripcion, estado) FROM stdin;
1	DESARROLLADOR	1
2	GERENTE	1
3	ADMINISTRADOR	1
4	sadadas	0
5	VENDEDOR	1
\.


--
-- TOC entry 4146 (class 0 OID 192676)
-- Dependencies: 337
-- Data for Name: sucursalusuarios; Type: TABLE DATA; Schema: seguridad; Owner: phuyu15
--

COPY seguridad.sucursalusuarios (codsucursal, codusuario) FROM stdin;
1	52
1	49
\.


--
-- TOC entry 4147 (class 0 OID 192679)
-- Dependencies: 338
-- Data for Name: usuarios; Type: TABLE DATA; Schema: seguridad; Owner: phuyu15
--

COPY seguridad.usuarios (codusuario, codempleado, codperfil, fecha, usuario, clave, estado, editar_pventa) FROM stdin;
52	6978	3	2023-03-16	tocho	tocho	1	1
49	0	1	2022-04-20	phuyu	2204	1	1
\.


--
-- TOC entry 4149 (class 0 OID 192687)
-- Dependencies: 340
-- Data for Name: guiasunat; Type: TABLE DATA; Schema: sunat; Owner: phuyu15
--

COPY sunat.guiasunat (codguiar, codsucursal, codusuario, nombre_xml, fecha, fechacreado, fechaenvio, codigorespuesta, ruta_cdr, descripcion_cdr, estado) FROM stdin;
\.


--
-- TOC entry 4150 (class 0 OID 192695)
-- Dependencies: 341
-- Data for Name: kardexsunat; Type: TABLE DATA; Schema: sunat; Owner: phuyu15
--

COPY sunat.kardexsunat (codkardex, codsucursal, codusuario, nombre_xml, fecha, fechacreado, fechaenvio, codigorespuesta, ruta_cdr, descripcion_cdr, estado) FROM stdin;
8	1	52	10701840017-01-F001-00000001	2023-03-30 11:35:56.861526	2023-03-30	2023-03-30	0	./sunat/comprobantes/2023/03/R-10701840017-01-F001-00000001	La Factura numero F001-00000001, ha sido aceptada	1
10	1	52	10701840017-01-F001-00000002	2023-04-01 10:59:42.873092	2023-04-01	2023-04-01	0	./sunat/comprobantes/2023/04/R-10701840017-01-F001-00000002	La Factura numero F001-00000002, ha sido aceptada	1
9	1	52	10701840017-03-B001-00000001	2023-04-01 10:50:06.40651	2023-04-01	2023-04-03	0	./sunat/resumenes/2023/04/R-202311258944098	El Comprobante RC-20230401-1, ha sido aceptado	1
12	1	52	10701840017-01-F001-00000003	2023-04-05 15:48:54.086873	2023-04-05	2023-04-05	0	./sunat/comprobantes/2023/04/R-10701840017-01-F001-00000003	La Factura numero F001-00000003, ha sido aceptada	1
13	1	52	10701840017-01-F001-00000004	2023-04-05 15:55:35.315612	2023-04-05	2023-04-05	0	./sunat/comprobantes/2023/04/R-10701840017-01-F001-00000004	La Factura numero F001-00000004, ha sido aceptada	1
14	1	52	10701840017-01-F001-00000005	2023-04-11 14:10:04.240921	2023-04-11	2023-04-11	0	./sunat/comprobantes/2023/04/R-10701840017-01-F001-00000005	La Factura numero F001-00000005, ha sido aceptada	1
16	1	52	10701840017-01-F001-00000006	2023-04-11 14:13:58.855806	2023-04-11	2023-04-11	0	./sunat/comprobantes/2023/04/R-10701840017-01-F001-00000006	La Factura numero F001-00000006, ha sido aceptada	1
17	1	52	10701840017-01-F001-00000007	2023-04-12 09:30:21.312989	2023-04-12	2023-04-13	0	./sunat/comprobantes/2023/04/R-10701840017-01-F001-00000007	La Factura numero F001-00000007, ha sido aceptada	1
18	1	52	10701840017-01-F001-00000008	2023-04-15 20:55:20.563551	2023-04-15	2023-04-15	0	./sunat/comprobantes/2023/04/R-10701840017-01-F001-00000008	La Factura numero F001-00000008, ha sido aceptada	1
19	1	52	10701840017-01-F001-00000009	2023-04-17 15:01:43.065799	2023-04-17	2023-04-17	0	./sunat/comprobantes/2023/04/R-10701840017-01-F001-00000009	La Factura numero F001-00000009, ha sido aceptada	1
20	1	52	10701840017-01-F001-00000010	2023-04-17 15:03:29.971804	2023-04-17	2023-04-17	0	./sunat/comprobantes/2023/04/R-10701840017-01-F001-00000010	La Factura numero F001-00000010, ha sido aceptada	1
22	1	52	10701840017-01-F001-00000011	2023-05-05 20:10:55.880303	2023-05-05	2023-05-05	0	./sunat/comprobantes/2023/05/R-10701840017-01-F001-00000011	La Factura numero F001-00000011, ha sido aceptada	1
\.


--
-- TOC entry 4151 (class 0 OID 192703)
-- Dependencies: 342
-- Data for Name: kardexsunatanulados; Type: TABLE DATA; Schema: sunat; Owner: phuyu15
--

COPY sunat.kardexsunatanulados (codkardex, codresumentipo, nrocorrelativo, periodo, codempresa, codsucursal, fechaanulacion, fechareferencia, fecha, hora, motivobaja, observaciones, tipooperacion, estado) FROM stdin;
\.


--
-- TOC entry 4152 (class 0 OID 192710)
-- Dependencies: 343
-- Data for Name: kardexsunatdetalle; Type: TABLE DATA; Schema: sunat; Owner: phuyu15
--

COPY sunat.kardexsunatdetalle (codkardex, codresumentipo, nrocorrelativo, periodo, codempresa, fecharesumen, fechaenvio, descripcion_cdr, estado) FROM stdin;
9	3	1	20230401	1	2023-04-01	2023-04-03	El Comprobante RC-20230401-1, ha sido aceptado	1
\.


--
-- TOC entry 4153 (class 0 OID 192717)
-- Dependencies: 344
-- Data for Name: resumenes; Type: TABLE DATA; Schema: sunat; Owner: phuyu15
--

COPY sunat.resumenes (codresumentipo, nrocorrelativo, periodo, codempresa, codsucursal, codusuario, nombre_xml, fecha, fecharesumen, fechaenvio, codigorespuesta, ticket, ruta_cdr, descripcion_cdr, estado) FROM stdin;
3	1	20230401	1	1	49	10701840017-RC-20230401-1	2023-04-03 15:54:50.112464	2023-04-01	2023-04-03	0	202311258944098	./sunat/resumenes/2023/04/R-202311258944098	El Comprobante RC-20230401-1, ha sido aceptado	1
\.


--
-- TOC entry 4154 (class 0 OID 192725)
-- Dependencies: 345
-- Data for Name: resumentipos; Type: TABLE DATA; Schema: sunat; Owner: phuyu15
--

COPY sunat.resumentipos (codresumentipo, descripcion, oficial, estado) FROM stdin;
1	RESUMEN FACTURAS ANULADOS	RA	1
2	RESUMEN REGISTROS FISICOS	RF	1
3	RESUMEN BOLETAS	RC	1
4	RESUMEN BOLETAS ANULADOS	RC	1
\.


--
-- TOC entry 4156 (class 0 OID 192731)
-- Dependencies: 347
-- Data for Name: det_traslado; Type: TABLE DATA; Schema: ventas; Owner: phuyu15
--

COPY ventas.det_traslado (id, producto_id, cantidad, almacen_id, precio, unidad_medida_id, precio_igv, descuento, igv_unitario, cantidadub, flete_unitario, subtotal, costo_unitario, igv_total, flete_total, subtotal_igv, traslado_id, stock_traslado, descripcion) FROM stdin;
\.


--
-- TOC entry 4158 (class 0 OID 192736)
-- Dependencies: 349
-- Data for Name: detalle_compras; Type: TABLE DATA; Schema: ventas; Owner: phuyu15
--

COPY ventas.detalle_compras (id, producto_id, compra_id, cantidad, almacen_id, precio, unidad_medida_id, precio_igv, descuento, igv_unitario, cantidadub, flete_unitario, subtotal, costos, igv_total, flete_total, subtotal_igv, descripcion) FROM stdin;
\.


--
-- TOC entry 4160 (class 0 OID 192741)
-- Dependencies: 351
-- Data for Name: detalle_ventas; Type: TABLE DATA; Schema: ventas; Owner: phuyu15
--

COPY ventas.detalle_ventas (id, producto_id, venta_id, cantidad, almacen_id, precio, unidad_medida_id, igv, descuento, cantidadub, descripcion, costo_unitario, cantidad_despachada) FROM stdin;
\.


--
-- TOC entry 4384 (class 0 OID 0)
-- Dependencies: 209
-- Name: almacenes_codalmacen_seq; Type: SEQUENCE SET; Schema: almacen; Owner: phuyu15
--

SELECT pg_catalog.setval('almacen.almacenes_codalmacen_seq', 3, true);


--
-- TOC entry 4385 (class 0 OID 0)
-- Dependencies: 211
-- Name: atenciones_codatencion_seq; Type: SEQUENCE SET; Schema: almacen; Owner: phuyu15
--

SELECT pg_catalog.setval('almacen.atenciones_codatencion_seq', 1, false);


--
-- TOC entry 4386 (class 0 OID 0)
-- Dependencies: 213
-- Name: clase_codclase_seq; Type: SEQUENCE SET; Schema: almacen; Owner: phuyu15
--

SELECT pg_catalog.setval('almacen.clase_codclase_seq', 1, true);


--
-- TOC entry 4387 (class 0 OID 0)
-- Dependencies: 215
-- Name: familias_codfamilia_seq; Type: SEQUENCE SET; Schema: almacen; Owner: phuyu15
--

SELECT pg_catalog.setval('almacen.familias_codfamilia_seq', 346, true);


--
-- TOC entry 4388 (class 0 OID 0)
-- Dependencies: 217
-- Name: guiasr_codguiar_seq; Type: SEQUENCE SET; Schema: almacen; Owner: phuyu15
--

SELECT pg_catalog.setval('almacen.guiasr_codguiar_seq', 1, false);


--
-- TOC entry 4389 (class 0 OID 0)
-- Dependencies: 220
-- Name: guiast_codguiat_seq; Type: SEQUENCE SET; Schema: almacen; Owner: phuyu15
--

SELECT pg_catalog.setval('almacen.guiast_codguiat_seq', 1, false);


--
-- TOC entry 4390 (class 0 OID 0)
-- Dependencies: 224
-- Name: inventarios_codinventario_seq; Type: SEQUENCE SET; Schema: almacen; Owner: phuyu15
--

SELECT pg_catalog.setval('almacen.inventarios_codinventario_seq', 1, false);


--
-- TOC entry 4391 (class 0 OID 0)
-- Dependencies: 228
-- Name: lineas_codlinea_seq; Type: SEQUENCE SET; Schema: almacen; Owner: phuyu15
--

SELECT pg_catalog.setval('almacen.lineas_codlinea_seq', 16, true);


--
-- TOC entry 4392 (class 0 OID 0)
-- Dependencies: 230
-- Name: marcas_codmarca_seq; Type: SEQUENCE SET; Schema: almacen; Owner: phuyu15
--

SELECT pg_catalog.setval('almacen.marcas_codmarca_seq', 324, true);


--
-- TOC entry 4393 (class 0 OID 0)
-- Dependencies: 232
-- Name: modalidadtraslado_codmodalidadtraslado_seq; Type: SEQUENCE SET; Schema: almacen; Owner: phuyu15
--

SELECT pg_catalog.setval('almacen.modalidadtraslado_codmodalidadtraslado_seq', 1, false);


--
-- TOC entry 4394 (class 0 OID 0)
-- Dependencies: 234
-- Name: motivotraslado_codmotivotraslado_seq; Type: SEQUENCE SET; Schema: almacen; Owner: phuyu15
--

SELECT pg_catalog.setval('almacen.motivotraslado_codmotivotraslado_seq', 1, false);


--
-- TOC entry 4395 (class 0 OID 0)
-- Dependencies: 236
-- Name: movimientotipos_codmovimientotipo_seq; Type: SEQUENCE SET; Schema: almacen; Owner: phuyu15
--

SELECT pg_catalog.setval('almacen.movimientotipos_codmovimientotipo_seq', 39, true);


--
-- TOC entry 4396 (class 0 OID 0)
-- Dependencies: 238
-- Name: presentacion_codpresentacion_seq; Type: SEQUENCE SET; Schema: almacen; Owner: phuyu15
--

SELECT pg_catalog.setval('almacen.presentacion_codpresentacion_seq', 22, true);


--
-- TOC entry 4397 (class 0 OID 0)
-- Dependencies: 240
-- Name: principioactivo_codprincipioactivo_seq; Type: SEQUENCE SET; Schema: almacen; Owner: phuyu15
--

SELECT pg_catalog.setval('almacen.principioactivo_codprincipioactivo_seq', 169, true);


--
-- TOC entry 4398 (class 0 OID 0)
-- Dependencies: 242
-- Name: productos_codproducto_seq; Type: SEQUENCE SET; Schema: almacen; Owner: phuyu15
--

SELECT pg_catalog.setval('almacen.productos_codproducto_seq', 42, true);


--
-- TOC entry 4399 (class 0 OID 0)
-- Dependencies: 246
-- Name: unidades_codunidad_seq; Type: SEQUENCE SET; Schema: almacen; Owner: phuyu15
--

SELECT pg_catalog.setval('almacen.unidades_codunidad_seq', 73, true);


--
-- TOC entry 4400 (class 0 OID 0)
-- Dependencies: 249
-- Name: vehiculos_codvehiculo_seq; Type: SEQUENCE SET; Schema: almacen; Owner: phuyu15
--

SELECT pg_catalog.setval('almacen.vehiculos_codvehiculo_seq', 1, false);


--
-- TOC entry 4401 (class 0 OID 0)
-- Dependencies: 251
-- Name: vehiculoscategorias_codvehiculocategoria_seq; Type: SEQUENCE SET; Schema: almacen; Owner: phuyu15
--

SELECT pg_catalog.setval('almacen.vehiculoscategorias_codvehiculocategoria_seq', 1, false);


--
-- TOC entry 4402 (class 0 OID 0)
-- Dependencies: 253
-- Name: vehiculosmarcas_codvehiculomarca_seq; Type: SEQUENCE SET; Schema: almacen; Owner: phuyu15
--

SELECT pg_catalog.setval('almacen.vehiculosmarcas_codvehiculomarca_seq', 1, false);


--
-- TOC entry 4403 (class 0 OID 0)
-- Dependencies: 255
-- Name: vehiculosmodelos_codvehiculomodelo_seq; Type: SEQUENCE SET; Schema: almacen; Owner: phuyu15
--

SELECT pg_catalog.setval('almacen.vehiculosmodelos_codvehiculomodelo_seq', 1, false);


--
-- TOC entry 4404 (class 0 OID 0)
-- Dependencies: 257
-- Name: bancos_codbanco_seq; Type: SEQUENCE SET; Schema: caja; Owner: phuyu15
--

SELECT pg_catalog.setval('caja.bancos_codbanco_seq', 1, false);


--
-- TOC entry 4405 (class 0 OID 0)
-- Dependencies: 259
-- Name: cajas_codcaja_seq; Type: SEQUENCE SET; Schema: caja; Owner: phuyu15
--

SELECT pg_catalog.setval('caja.cajas_codcaja_seq', 1, true);


--
-- TOC entry 4406 (class 0 OID 0)
-- Dependencies: 261
-- Name: centrocostos_codcentrocosto_seq; Type: SEQUENCE SET; Schema: caja; Owner: phuyu15
--

SELECT pg_catalog.setval('caja.centrocostos_codcentrocosto_seq', 1, false);


--
-- TOC entry 4407 (class 0 OID 0)
-- Dependencies: 264
-- Name: comprobantetipos_codcomprobantetipo_seq; Type: SEQUENCE SET; Schema: caja; Owner: phuyu15
--

SELECT pg_catalog.setval('caja.comprobantetipos_codcomprobantetipo_seq', 2, true);


--
-- TOC entry 4408 (class 0 OID 0)
-- Dependencies: 266
-- Name: conceptos_codconcepto_seq; Type: SEQUENCE SET; Schema: caja; Owner: phuyu15
--

SELECT pg_catalog.setval('caja.conceptos_codconcepto_seq', 1, false);


--
-- TOC entry 4409 (class 0 OID 0)
-- Dependencies: 268
-- Name: controldiario_codcontroldiario_seq; Type: SEQUENCE SET; Schema: caja; Owner: phuyu15
--

SELECT pg_catalog.setval('caja.controldiario_codcontroldiario_seq', 7, true);


--
-- TOC entry 4410 (class 0 OID 0)
-- Dependencies: 270
-- Name: ctasctes_codctacte_seq; Type: SEQUENCE SET; Schema: caja; Owner: phuyu15
--

SELECT pg_catalog.setval('caja.ctasctes_codctacte_seq', 1, false);


--
-- TOC entry 4411 (class 0 OID 0)
-- Dependencies: 272
-- Name: monedas_codmoneda_seq; Type: SEQUENCE SET; Schema: caja; Owner: phuyu15
--

SELECT pg_catalog.setval('caja.monedas_codmoneda_seq', 3, true);


--
-- TOC entry 4412 (class 0 OID 0)
-- Dependencies: 274
-- Name: movimientos_codmovimiento_seq; Type: SEQUENCE SET; Schema: caja; Owner: phuyu15
--

SELECT pg_catalog.setval('caja.movimientos_codmovimiento_seq', 22, true);


--
-- TOC entry 4413 (class 0 OID 0)
-- Dependencies: 277
-- Name: tipocambios_codtipocambio_seq; Type: SEQUENCE SET; Schema: caja; Owner: phuyu15
--

SELECT pg_catalog.setval('caja.tipocambios_codtipocambio_seq', 1, false);


--
-- TOC entry 4414 (class 0 OID 0)
-- Dependencies: 279
-- Name: tipopagos_codtipopago_seq; Type: SEQUENCE SET; Schema: caja; Owner: phuyu15
--

SELECT pg_catalog.setval('caja.tipopagos_codtipopago_seq', 8, true);


--
-- TOC entry 4415 (class 0 OID 0)
-- Dependencies: 281
-- Name: creditoconceptos_codcreditoconcepto_seq; Type: SEQUENCE SET; Schema: kardex; Owner: phuyu15
--

SELECT pg_catalog.setval('kardex.creditoconceptos_codcreditoconcepto_seq', 4, true);


--
-- TOC entry 4416 (class 0 OID 0)
-- Dependencies: 283
-- Name: creditos_codcredito_seq; Type: SEQUENCE SET; Schema: kardex; Owner: phuyu15
--

SELECT pg_catalog.setval('kardex.creditos_codcredito_seq', 1, false);


--
-- TOC entry 4417 (class 0 OID 0)
-- Dependencies: 288
-- Name: kardex_codkardex_seq; Type: SEQUENCE SET; Schema: kardex; Owner: phuyu15
--

SELECT pg_catalog.setval('kardex.kardex_codkardex_seq', 22, true);


--
-- TOC entry 4418 (class 0 OID 0)
-- Dependencies: 290
-- Name: kardexalmacen_codkardexalmacen_seq; Type: SEQUENCE SET; Schema: kardex; Owner: phuyu15
--

SELECT pg_catalog.setval('kardex.kardexalmacen_codkardexalmacen_seq', 22, true);


--
-- TOC entry 4419 (class 0 OID 0)
-- Dependencies: 298
-- Name: motivonotas_codmotivonota_seq; Type: SEQUENCE SET; Schema: kardex; Owner: phuyu15
--

SELECT pg_catalog.setval('kardex.motivonotas_codmotivonota_seq', 14, true);


--
-- TOC entry 4420 (class 0 OID 0)
-- Dependencies: 300
-- Name: pedidos_codpedido_seq; Type: SEQUENCE SET; Schema: kardex; Owner: phuyu15
--

SELECT pg_catalog.setval('kardex.pedidos_codpedido_seq', 1, false);


--
-- TOC entry 4421 (class 0 OID 0)
-- Dependencies: 303
-- Name: proformas_codproforma_seq; Type: SEQUENCE SET; Schema: kardex; Owner: phuyu15
--

SELECT pg_catalog.setval('kardex.proformas_codproforma_seq', 1, false);


--
-- TOC entry 4422 (class 0 OID 0)
-- Dependencies: 313
-- Name: areas_codarea_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.areas_codarea_seq', 2, true);


--
-- TOC entry 4423 (class 0 OID 0)
-- Dependencies: 316
-- Name: cargos_codcargo_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.cargos_codcargo_seq', 5, true);


--
-- TOC entry 4424 (class 0 OID 0)
-- Dependencies: 317
-- Name: documentotipos_coddocumentotipo_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.documentotipos_coddocumentotipo_seq', 1, false);


--
-- TOC entry 4425 (class 0 OID 0)
-- Dependencies: 320
-- Name: empresas_codempresa_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.empresas_codempresa_seq', 1, false);


--
-- TOC entry 4426 (class 0 OID 0)
-- Dependencies: 321
-- Name: personas_codpersona_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.personas_codpersona_seq', 6988, true);


--
-- TOC entry 4427 (class 0 OID 0)
-- Dependencies: 323
-- Name: rubros_codrubro_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.rubros_codrubro_seq', 6, true);


--
-- TOC entry 4428 (class 0 OID 0)
-- Dependencies: 326
-- Name: sociotipos_codsociotipo_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.sociotipos_codsociotipo_seq', 3, true);


--
-- TOC entry 4429 (class 0 OID 0)
-- Dependencies: 328
-- Name: sucursales_codsucursal_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.sucursales_codsucursal_seq', 4, true);


--
-- TOC entry 4430 (class 0 OID 0)
-- Dependencies: 330
-- Name: ubigeo_codubigeo_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.ubigeo_codubigeo_seq', 1, false);


--
-- TOC entry 4431 (class 0 OID 0)
-- Dependencies: 334
-- Name: modulos_codmodulo_seq; Type: SEQUENCE SET; Schema: seguridad; Owner: phuyu15
--

SELECT pg_catalog.setval('seguridad.modulos_codmodulo_seq', 17, true);


--
-- TOC entry 4432 (class 0 OID 0)
-- Dependencies: 336
-- Name: perfiles_codperfil_seq; Type: SEQUENCE SET; Schema: seguridad; Owner: phuyu15
--

SELECT pg_catalog.setval('seguridad.perfiles_codperfil_seq', 5, true);


--
-- TOC entry 4433 (class 0 OID 0)
-- Dependencies: 339
-- Name: usuarios_codusuario_seq; Type: SEQUENCE SET; Schema: seguridad; Owner: phuyu15
--

SELECT pg_catalog.setval('seguridad.usuarios_codusuario_seq', 52, true);


--
-- TOC entry 4434 (class 0 OID 0)
-- Dependencies: 346
-- Name: resumentipos_codresumentipo_seq; Type: SEQUENCE SET; Schema: sunat; Owner: phuyu15
--

SELECT pg_catalog.setval('sunat.resumentipos_codresumentipo_seq', 5, true);


--
-- TOC entry 4435 (class 0 OID 0)
-- Dependencies: 348
-- Name: det_traslado_id_seq; Type: SEQUENCE SET; Schema: ventas; Owner: phuyu15
--

SELECT pg_catalog.setval('ventas.det_traslado_id_seq', 1, false);


--
-- TOC entry 4436 (class 0 OID 0)
-- Dependencies: 350
-- Name: detalle_compras_id_seq; Type: SEQUENCE SET; Schema: ventas; Owner: phuyu15
--

SELECT pg_catalog.setval('ventas.detalle_compras_id_seq', 1, false);


--
-- TOC entry 4437 (class 0 OID 0)
-- Dependencies: 352
-- Name: detalle_ventas_id_seq; Type: SEQUENCE SET; Schema: ventas; Owner: phuyu15
--

SELECT pg_catalog.setval('ventas.detalle_ventas_id_seq', 1, false);


--
-- TOC entry 4239 (class 0 OID 0)
-- Data for Name: BLOBS; Type: BLOBS; Schema: -; Owner: -
--

BEGIN;

SELECT pg_catalog.lo_open('26135', 131072);
SELECT pg_catalog.lo_close(0);

SELECT pg_catalog.lo_open('26141', 131072);
SELECT pg_catalog.lo_close(0);

SELECT pg_catalog.lo_open('26144', 131072);
SELECT pg_catalog.lo_close(0);

SELECT pg_catalog.lo_open('26151', 131072);
SELECT pg_catalog.lo_close(0);

SELECT pg_catalog.lo_open('26165', 131072);
SELECT pg_catalog.lo_close(0);

SELECT pg_catalog.lo_open('26168', 131072);
SELECT pg_catalog.lo_close(0);

SELECT pg_catalog.lo_open('27117', 131072);
SELECT pg_catalog.lo_close(0);

SELECT pg_catalog.lo_open('27120', 131072);
SELECT pg_catalog.lo_close(0);

SELECT pg_catalog.lo_open('27126', 131072);
SELECT pg_catalog.lo_close(0);

SELECT pg_catalog.lo_open('27129', 131072);
SELECT pg_catalog.lo_close(0);

SELECT pg_catalog.lo_open('27135', 131072);
SELECT pg_catalog.lo_close(0);

SELECT pg_catalog.lo_open('27138', 131072);
SELECT pg_catalog.lo_close(0);

SELECT pg_catalog.lo_open('27141', 131072);
SELECT pg_catalog.lo_close(0);

SELECT pg_catalog.lo_open('27208', 131072);
SELECT pg_catalog.lo_close(0);

SELECT pg_catalog.lo_open('27211', 131072);
SELECT pg_catalog.lo_close(0);

SELECT pg_catalog.lo_open('27214', 131072);
SELECT pg_catalog.lo_close(0);

SELECT pg_catalog.lo_open('27222', 131072);
SELECT pg_catalog.lo_close(0);

SELECT pg_catalog.lo_open('27228', 131072);
SELECT pg_catalog.lo_close(0);

SELECT pg_catalog.lo_open('27232', 131072);
SELECT pg_catalog.lo_close(0);

SELECT pg_catalog.lo_open('27514', 131072);
SELECT pg_catalog.lo_close(0);

SELECT pg_catalog.lo_open('27517', 131072);
SELECT pg_catalog.lo_close(0);

SELECT pg_catalog.lo_open('27522', 131072);
SELECT pg_catalog.lo_close(0);

SELECT pg_catalog.lo_open('27526', 131072);
SELECT pg_catalog.lo_close(0);

SELECT pg_catalog.lo_open('27529', 131072);
SELECT pg_catalog.lo_close(0);

SELECT pg_catalog.lo_open('28562', 131072);
SELECT pg_catalog.lo_close(0);

SELECT pg_catalog.lo_open('31613', 131072);
SELECT pg_catalog.lo_close(0);

SELECT pg_catalog.lo_open('32629', 131072);
SELECT pg_catalog.lo_close(0);

SELECT pg_catalog.lo_open('32707', 131072);
SELECT pg_catalog.lo_close(0);

SELECT pg_catalog.lo_open('33794', 131072);
SELECT pg_catalog.lo_close(0);

SELECT pg_catalog.lo_open('34830', 131072);
SELECT pg_catalog.lo_close(0);

SELECT pg_catalog.lo_open('34842', 131072);
SELECT pg_catalog.lo_close(0);

SELECT pg_catalog.lo_open('35860', 131072);
SELECT pg_catalog.lo_close(0);

SELECT pg_catalog.lo_open('35866', 131072);
SELECT pg_catalog.lo_close(0);

SELECT pg_catalog.lo_open('36822', 131072);
SELECT pg_catalog.lo_close(0);

SELECT pg_catalog.lo_open('36834', 131072);
SELECT pg_catalog.lo_close(0);

SELECT pg_catalog.lo_open('36837', 131072);
SELECT pg_catalog.lo_close(0);

SELECT pg_catalog.lo_open('36931', 131072);
SELECT pg_catalog.lo_close(0);

SELECT pg_catalog.lo_open('36942', 131072);
SELECT pg_catalog.lo_close(0);

SELECT pg_catalog.lo_open('36980', 131072);
SELECT pg_catalog.lo_close(0);

SELECT pg_catalog.lo_open('37261', 131072);
SELECT pg_catalog.lo_close(0);

SELECT pg_catalog.lo_open('37524', 131072);
SELECT pg_catalog.lo_close(0);

SELECT pg_catalog.lo_open('39145', 131072);
SELECT pg_catalog.lo_close(0);

SELECT pg_catalog.lo_open('39232', 131072);
SELECT pg_catalog.lo_close(0);

SELECT pg_catalog.lo_open('39265', 131072);
SELECT pg_catalog.lo_close(0);

SELECT pg_catalog.lo_open('39278', 131072);
SELECT pg_catalog.lo_close(0);

SELECT pg_catalog.lo_open('40509', 131072);
SELECT pg_catalog.lo_close(0);

SELECT pg_catalog.lo_open('40833', 131072);
SELECT pg_catalog.lo_close(0);

SELECT pg_catalog.lo_open('40844', 131072);
SELECT pg_catalog.lo_close(0);

SELECT pg_catalog.lo_open('40848', 131072);
SELECT pg_catalog.lo_close(0);

SELECT pg_catalog.lo_open('41091', 131072);
SELECT pg_catalog.lo_close(0);

SELECT pg_catalog.lo_open('41220', 131072);
SELECT pg_catalog.lo_close(0);

SELECT pg_catalog.lo_open('41258', 131072);
SELECT pg_catalog.lo_close(0);

SELECT pg_catalog.lo_open('41279', 131072);
SELECT pg_catalog.lo_close(0);

SELECT pg_catalog.lo_open('41289', 131072);
SELECT pg_catalog.lo_close(0);

SELECT pg_catalog.lo_open('43323', 131072);
SELECT pg_catalog.lo_close(0);

SELECT pg_catalog.lo_open('43326', 131072);
SELECT pg_catalog.lo_close(0);

SELECT pg_catalog.lo_open('43552', 131072);
SELECT pg_catalog.lo_close(0);

SELECT pg_catalog.lo_open('43573', 131072);
SELECT pg_catalog.lo_close(0);

SELECT pg_catalog.lo_open('43597', 131072);
SELECT pg_catalog.lo_close(0);

SELECT pg_catalog.lo_open('44722', 131072);
SELECT pg_catalog.lo_close(0);

SELECT pg_catalog.lo_open('45862', 131072);
SELECT pg_catalog.lo_close(0);

SELECT pg_catalog.lo_open('45865', 131072);
SELECT pg_catalog.lo_close(0);

SELECT pg_catalog.lo_open('45911', 131072);
SELECT pg_catalog.lo_close(0);

SELECT pg_catalog.lo_open('46268', 131072);
SELECT pg_catalog.lo_close(0);

SELECT pg_catalog.lo_open('47292', 131072);
SELECT pg_catalog.lo_close(0);

SELECT pg_catalog.lo_open('47647', 131072);
SELECT pg_catalog.lo_close(0);

SELECT pg_catalog.lo_open('47800', 131072);
SELECT pg_catalog.lo_close(0);

SELECT pg_catalog.lo_open('48199', 131072);
SELECT pg_catalog.lo_close(0);

SELECT pg_catalog.lo_open('48218', 131072);
SELECT pg_catalog.lo_close(0);

SELECT pg_catalog.lo_open('48227', 131072);
SELECT pg_catalog.lo_close(0);

SELECT pg_catalog.lo_open('48324', 131072);
SELECT pg_catalog.lo_close(0);

SELECT pg_catalog.lo_open('48327', 131072);
SELECT pg_catalog.lo_close(0);

SELECT pg_catalog.lo_open('48330', 131072);
SELECT pg_catalog.lo_close(0);

SELECT pg_catalog.lo_open('48333', 131072);
SELECT pg_catalog.lo_close(0);

SELECT pg_catalog.lo_open('48409', 131072);
SELECT pg_catalog.lo_close(0);

SELECT pg_catalog.lo_open('48412', 131072);
SELECT pg_catalog.lo_close(0);

SELECT pg_catalog.lo_open('48415', 131072);
SELECT pg_catalog.lo_close(0);

COMMIT;

--
-- TOC entry 3611 (class 2606 OID 192805)
-- Name: almacenes almacenes_pkey; Type: CONSTRAINT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.almacenes
    ADD CONSTRAINT almacenes_pkey PRIMARY KEY (codalmacen);


--
-- TOC entry 3613 (class 2606 OID 192807)
-- Name: atenciones atenciones_pkey; Type: CONSTRAINT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.atenciones
    ADD CONSTRAINT atenciones_pkey PRIMARY KEY (codatencion);


--
-- TOC entry 3615 (class 2606 OID 192809)
-- Name: clase clase_pkey; Type: CONSTRAINT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.clase
    ADD CONSTRAINT clase_pkey PRIMARY KEY (codclase);


--
-- TOC entry 3617 (class 2606 OID 192811)
-- Name: familias familias_pkey; Type: CONSTRAINT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.familias
    ADD CONSTRAINT familias_pkey PRIMARY KEY (codfamilia);


--
-- TOC entry 3619 (class 2606 OID 192813)
-- Name: guiasr guiasr_pkey; Type: CONSTRAINT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.guiasr
    ADD CONSTRAINT guiasr_pkey PRIMARY KEY (codguiar);


--
-- TOC entry 3621 (class 2606 OID 192815)
-- Name: guiasrdetalle guiasrdetalle_pkey; Type: CONSTRAINT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.guiasrdetalle
    ADD CONSTRAINT guiasrdetalle_pkey PRIMARY KEY (codguiar, codproducto, codunidad, item);


--
-- TOC entry 3623 (class 2606 OID 192817)
-- Name: guiast guiast_pkey; Type: CONSTRAINT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.guiast
    ADD CONSTRAINT guiast_pkey PRIMARY KEY (codguiat);


--
-- TOC entry 3625 (class 2606 OID 192819)
-- Name: guiastdetalle guiastdetalle_pkey; Type: CONSTRAINT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.guiastdetalle
    ADD CONSTRAINT guiastdetalle_pkey PRIMARY KEY (codguiat, codproducto, codunidad, item);


--
-- TOC entry 3629 (class 2606 OID 192821)
-- Name: inventarios inventarios_pkey; Type: CONSTRAINT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.inventarios
    ADD CONSTRAINT inventarios_pkey PRIMARY KEY (codinventario);


--
-- TOC entry 3631 (class 2606 OID 192823)
-- Name: kardexguiasr kardexguiasr_pkey; Type: CONSTRAINT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.kardexguiasr
    ADD CONSTRAINT kardexguiasr_pkey PRIMARY KEY (codkardex, codguiar);


--
-- TOC entry 3633 (class 2606 OID 192825)
-- Name: kardexguiasrdetalle kardexguiasrdetalle_pkey; Type: CONSTRAINT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.kardexguiasrdetalle
    ADD CONSTRAINT kardexguiasrdetalle_pkey PRIMARY KEY (codkardex, codguiar, codproducto, codunidad, itemgr, itemgk);


--
-- TOC entry 3635 (class 2606 OID 192827)
-- Name: lineas lineas_pkey; Type: CONSTRAINT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.lineas
    ADD CONSTRAINT lineas_pkey PRIMARY KEY (codlinea);


--
-- TOC entry 3637 (class 2606 OID 192829)
-- Name: marcas marcas_pkey; Type: CONSTRAINT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.marcas
    ADD CONSTRAINT marcas_pkey PRIMARY KEY (codmarca);


--
-- TOC entry 3639 (class 2606 OID 192831)
-- Name: modalidadtraslado modalidadtraslado_pkey; Type: CONSTRAINT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.modalidadtraslado
    ADD CONSTRAINT modalidadtraslado_pkey PRIMARY KEY (codmodalidadtraslado);


--
-- TOC entry 3641 (class 2606 OID 192833)
-- Name: motivotraslado motivotraslado_pkey; Type: CONSTRAINT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.motivotraslado
    ADD CONSTRAINT motivotraslado_pkey PRIMARY KEY (codmotivotraslado);


--
-- TOC entry 3643 (class 2606 OID 192835)
-- Name: movimientotipos movimientotipos_pkey; Type: CONSTRAINT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.movimientotipos
    ADD CONSTRAINT movimientotipos_pkey PRIMARY KEY (codmovimientotipo);


--
-- TOC entry 3627 (class 2606 OID 192837)
-- Name: inventariodetalle pk_inventariodetalle; Type: CONSTRAINT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.inventariodetalle
    ADD CONSTRAINT pk_inventariodetalle PRIMARY KEY (codinventario, codproducto, codunidad);


--
-- TOC entry 3651 (class 2606 OID 192839)
-- Name: productoubicacion pk_productosubicacion; Type: CONSTRAINT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.productoubicacion
    ADD CONSTRAINT pk_productosubicacion PRIMARY KEY (codalmacen, codproducto, codunidad);


--
-- TOC entry 3653 (class 2606 OID 192841)
-- Name: productounidades pk_productosunidades; Type: CONSTRAINT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.productounidades
    ADD CONSTRAINT pk_productosunidades PRIMARY KEY (codproducto, codunidad);


--
-- TOC entry 3645 (class 2606 OID 192843)
-- Name: presentacion presentacion_pkey; Type: CONSTRAINT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.presentacion
    ADD CONSTRAINT presentacion_pkey PRIMARY KEY (codpresentacion);


--
-- TOC entry 3647 (class 2606 OID 192845)
-- Name: principioactivo principioactivo_pkey; Type: CONSTRAINT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.principioactivo
    ADD CONSTRAINT principioactivo_pkey PRIMARY KEY (codprincipioactivo);


--
-- TOC entry 3649 (class 2606 OID 192847)
-- Name: productos productos_pkey; Type: CONSTRAINT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.productos
    ADD CONSTRAINT productos_pkey PRIMARY KEY (codproducto);


--
-- TOC entry 3655 (class 2606 OID 192849)
-- Name: unidades unidades_pkey; Type: CONSTRAINT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.unidades
    ADD CONSTRAINT unidades_pkey PRIMARY KEY (codunidad);


--
-- TOC entry 3660 (class 2606 OID 192851)
-- Name: vehiculos vehiculos_pkey; Type: CONSTRAINT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.vehiculos
    ADD CONSTRAINT vehiculos_pkey PRIMARY KEY (codvehiculo);


--
-- TOC entry 3662 (class 2606 OID 192853)
-- Name: vehiculoscategorias vehiculoscategorias_pkey; Type: CONSTRAINT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.vehiculoscategorias
    ADD CONSTRAINT vehiculoscategorias_pkey PRIMARY KEY (codvehiculocategoria);


--
-- TOC entry 3664 (class 2606 OID 192855)
-- Name: vehiculosmarcas vehiculosmarcas_pkey; Type: CONSTRAINT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.vehiculosmarcas
    ADD CONSTRAINT vehiculosmarcas_pkey PRIMARY KEY (codvehiculomarca);


--
-- TOC entry 3666 (class 2606 OID 192857)
-- Name: vehiculosmodelos vehiculosmodelos_pkey; Type: CONSTRAINT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.vehiculosmodelos
    ADD CONSTRAINT vehiculosmodelos_pkey PRIMARY KEY (codvehiculomodelo);


--
-- TOC entry 3668 (class 2606 OID 192859)
-- Name: bancos bancos_pkey; Type: CONSTRAINT; Schema: caja; Owner: phuyu15
--

ALTER TABLE ONLY caja.bancos
    ADD CONSTRAINT bancos_pkey PRIMARY KEY (codbanco);


--
-- TOC entry 3670 (class 2606 OID 192861)
-- Name: cajas cajas_pkey; Type: CONSTRAINT; Schema: caja; Owner: phuyu15
--

ALTER TABLE ONLY caja.cajas
    ADD CONSTRAINT cajas_pkey PRIMARY KEY (codcaja);


--
-- TOC entry 3672 (class 2606 OID 192863)
-- Name: centrocostos centrocostos_pkey; Type: CONSTRAINT; Schema: caja; Owner: phuyu15
--

ALTER TABLE ONLY caja.centrocostos
    ADD CONSTRAINT centrocostos_pkey PRIMARY KEY (codcentrocosto);


--
-- TOC entry 3676 (class 2606 OID 192865)
-- Name: comprobantetipos comprobantetipos_pkey; Type: CONSTRAINT; Schema: caja; Owner: phuyu15
--

ALTER TABLE ONLY caja.comprobantetipos
    ADD CONSTRAINT comprobantetipos_pkey PRIMARY KEY (codcomprobantetipo);


--
-- TOC entry 3678 (class 2606 OID 192867)
-- Name: conceptos conceptos_pkey; Type: CONSTRAINT; Schema: caja; Owner: phuyu15
--

ALTER TABLE ONLY caja.conceptos
    ADD CONSTRAINT conceptos_pkey PRIMARY KEY (codconcepto);


--
-- TOC entry 3680 (class 2606 OID 192869)
-- Name: controldiario controldiario_pkey; Type: CONSTRAINT; Schema: caja; Owner: phuyu15
--

ALTER TABLE ONLY caja.controldiario
    ADD CONSTRAINT controldiario_pkey PRIMARY KEY (codcontroldiario);


--
-- TOC entry 3682 (class 2606 OID 192871)
-- Name: ctasctes ctasctes_pkey; Type: CONSTRAINT; Schema: caja; Owner: phuyu15
--

ALTER TABLE ONLY caja.ctasctes
    ADD CONSTRAINT ctasctes_pkey PRIMARY KEY (codctacte);


--
-- TOC entry 3684 (class 2606 OID 192873)
-- Name: monedas monedas_pkey; Type: CONSTRAINT; Schema: caja; Owner: phuyu15
--

ALTER TABLE ONLY caja.monedas
    ADD CONSTRAINT monedas_pkey PRIMARY KEY (codmoneda);


--
-- TOC entry 3686 (class 2606 OID 192875)
-- Name: movimientos movimientos_pkey; Type: CONSTRAINT; Schema: caja; Owner: phuyu15
--

ALTER TABLE ONLY caja.movimientos
    ADD CONSTRAINT movimientos_pkey PRIMARY KEY (codmovimiento);


--
-- TOC entry 3674 (class 2606 OID 192877)
-- Name: comprobantes pk_comprobante; Type: CONSTRAINT; Schema: caja; Owner: phuyu15
--

ALTER TABLE ONLY caja.comprobantes
    ADD CONSTRAINT pk_comprobante PRIMARY KEY (codcomprobantetipo, seriecomprobante);


--
-- TOC entry 3688 (class 2606 OID 192879)
-- Name: movimientosdetalle pk_movdetalle; Type: CONSTRAINT; Schema: caja; Owner: phuyu15
--

ALTER TABLE ONLY caja.movimientosdetalle
    ADD CONSTRAINT pk_movdetalle PRIMARY KEY (codmovimiento, codtipopago);


--
-- TOC entry 3690 (class 2606 OID 192881)
-- Name: tipocambios tipocambios_pkey; Type: CONSTRAINT; Schema: caja; Owner: phuyu15
--

ALTER TABLE ONLY caja.tipocambios
    ADD CONSTRAINT tipocambios_pkey PRIMARY KEY (codtipocambio);


--
-- TOC entry 3692 (class 2606 OID 192883)
-- Name: tipopagos tipopagos_pkey; Type: CONSTRAINT; Schema: caja; Owner: phuyu15
--

ALTER TABLE ONLY caja.tipopagos
    ADD CONSTRAINT tipopagos_pkey PRIMARY KEY (codtipopago);


--
-- TOC entry 3694 (class 2606 OID 192885)
-- Name: creditoconceptos creditoconceptos_pkey; Type: CONSTRAINT; Schema: kardex; Owner: phuyu15
--

ALTER TABLE ONLY kardex.creditoconceptos
    ADD CONSTRAINT creditoconceptos_pkey PRIMARY KEY (codcreditoconcepto);


--
-- TOC entry 3696 (class 2606 OID 192887)
-- Name: creditos creditos_pkey; Type: CONSTRAINT; Schema: kardex; Owner: phuyu15
--

ALTER TABLE ONLY kardex.creditos
    ADD CONSTRAINT creditos_pkey PRIMARY KEY (codcredito);


--
-- TOC entry 3698 (class 2606 OID 192889)
-- Name: creditosanulados creditosanulados_pkey; Type: CONSTRAINT; Schema: kardex; Owner: phuyu15
--

ALTER TABLE ONLY kardex.creditosanulados
    ADD CONSTRAINT creditosanulados_pkey PRIMARY KEY (codcredito);


--
-- TOC entry 3704 (class 2606 OID 192891)
-- Name: kardex kardex_pkey; Type: CONSTRAINT; Schema: kardex; Owner: phuyu15
--

ALTER TABLE ONLY kardex.kardex
    ADD CONSTRAINT kardex_pkey PRIMARY KEY (codkardex);


--
-- TOC entry 3706 (class 2606 OID 192893)
-- Name: kardexalmacen kardexalmacen_pkey; Type: CONSTRAINT; Schema: kardex; Owner: phuyu15
--

ALTER TABLE ONLY kardex.kardexalmacen
    ADD CONSTRAINT kardexalmacen_pkey PRIMARY KEY (codkardexalmacen);


--
-- TOC entry 3708 (class 2606 OID 192895)
-- Name: kardexalmacenanulado kardexalmacenanulado_pkey; Type: CONSTRAINT; Schema: kardex; Owner: phuyu15
--

ALTER TABLE ONLY kardex.kardexalmacenanulado
    ADD CONSTRAINT kardexalmacenanulado_pkey PRIMARY KEY (codkardexalmacen);


--
-- TOC entry 3710 (class 2606 OID 192897)
-- Name: kardexalmacendetalle kardexalmacendetalle_pkey; Type: CONSTRAINT; Schema: kardex; Owner: phuyu15
--

ALTER TABLE ONLY kardex.kardexalmacendetalle
    ADD CONSTRAINT kardexalmacendetalle_pkey PRIMARY KEY (codkardexalmacen, codproducto, codunidad, item);


--
-- TOC entry 3712 (class 2606 OID 192899)
-- Name: kardexanulados kardexanulados_pkey; Type: CONSTRAINT; Schema: kardex; Owner: phuyu15
--

ALTER TABLE ONLY kardex.kardexanulados
    ADD CONSTRAINT kardexanulados_pkey PRIMARY KEY (codkardex);


--
-- TOC entry 3716 (class 2606 OID 192901)
-- Name: kardexpedido kardexpedido_pkey; Type: CONSTRAINT; Schema: kardex; Owner: phuyu15
--

ALTER TABLE ONLY kardex.kardexpedido
    ADD CONSTRAINT kardexpedido_pkey PRIMARY KEY (codpedido, codproducto, codkardex, codunidad);


--
-- TOC entry 3718 (class 2606 OID 192903)
-- Name: kardexproforma kardexproforma_pkey; Type: CONSTRAINT; Schema: kardex; Owner: phuyu15
--

ALTER TABLE ONLY kardex.kardexproforma
    ADD CONSTRAINT kardexproforma_pkey PRIMARY KEY (codproforma, codproducto, codkardex, codunidad);


--
-- TOC entry 3720 (class 2606 OID 192905)
-- Name: motivonotas motivonotas_pkey; Type: CONSTRAINT; Schema: kardex; Owner: phuyu15
--

ALTER TABLE ONLY kardex.motivonotas
    ADD CONSTRAINT motivonotas_pkey PRIMARY KEY (codmotivonota);


--
-- TOC entry 3722 (class 2606 OID 192907)
-- Name: pedidos pedidos_pkey; Type: CONSTRAINT; Schema: kardex; Owner: phuyu15
--

ALTER TABLE ONLY kardex.pedidos
    ADD CONSTRAINT pedidos_pkey PRIMARY KEY (codpedido);


--
-- TOC entry 3700 (class 2606 OID 192909)
-- Name: cuotas pk_cuota; Type: CONSTRAINT; Schema: kardex; Owner: phuyu15
--

ALTER TABLE ONLY kardex.cuotas
    ADD CONSTRAINT pk_cuota PRIMARY KEY (codcredito, nrocuota);


--
-- TOC entry 3702 (class 2606 OID 192911)
-- Name: cuotaspagos pk_cuotaspago; Type: CONSTRAINT; Schema: kardex; Owner: phuyu15
--

ALTER TABLE ONLY kardex.cuotaspagos
    ADD CONSTRAINT pk_cuotaspago PRIMARY KEY (codcredito, nrocuota, codmovimiento);


--
-- TOC entry 3714 (class 2606 OID 192913)
-- Name: kardexdetalle pk_kardexdetalle; Type: CONSTRAINT; Schema: kardex; Owner: phuyu15
--

ALTER TABLE ONLY kardex.kardexdetalle
    ADD CONSTRAINT pk_kardexdetalle PRIMARY KEY (codkardex, codproducto, codunidad, item);


--
-- TOC entry 3724 (class 2606 OID 192915)
-- Name: pedidosdetalle pk_pedidodetalle; Type: CONSTRAINT; Schema: kardex; Owner: phuyu15
--

ALTER TABLE ONLY kardex.pedidosdetalle
    ADD CONSTRAINT pk_pedidodetalle PRIMARY KEY (codpedido, codproducto, codunidad, item);


--
-- TOC entry 3728 (class 2606 OID 192917)
-- Name: proformasdetalle pk_proformadetalle; Type: CONSTRAINT; Schema: kardex; Owner: phuyu15
--

ALTER TABLE ONLY kardex.proformasdetalle
    ADD CONSTRAINT pk_proformadetalle PRIMARY KEY (codproforma, codproducto, codunidad, item);


--
-- TOC entry 3726 (class 2606 OID 192919)
-- Name: proformas proformas_pkey; Type: CONSTRAINT; Schema: kardex; Owner: phuyu15
--

ALTER TABLE ONLY kardex.proformas
    ADD CONSTRAINT proformas_pkey PRIMARY KEY (codproforma);


--
-- TOC entry 3734 (class 2606 OID 192921)
-- Name: areas areas_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.areas
    ADD CONSTRAINT areas_pkey PRIMARY KEY (codarea);


--
-- TOC entry 3736 (class 2606 OID 192923)
-- Name: asistencias asistencias_pkey; Type: CONSTRAINT; Schema: public; Owner: phuyu15
--

ALTER TABLE ONLY public.asistencias
    ADD CONSTRAINT asistencias_pkey PRIMARY KEY (codasistencia);


--
-- TOC entry 3738 (class 2606 OID 192925)
-- Name: cargos cargos_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.cargos
    ADD CONSTRAINT cargos_pkey PRIMARY KEY (codcargo);


--
-- TOC entry 3730 (class 2606 OID 192927)
-- Name: documentotipos documentotipos_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.documentotipos
    ADD CONSTRAINT documentotipos_pkey PRIMARY KEY (coddocumentotipo);


--
-- TOC entry 3740 (class 2606 OID 192929)
-- Name: empleados empleados_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.empleados
    ADD CONSTRAINT empleados_pkey PRIMARY KEY (codpersona);


--
-- TOC entry 3742 (class 2606 OID 192931)
-- Name: empresas empresas_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.empresas
    ADD CONSTRAINT empresas_pkey PRIMARY KEY (codempresa);


--
-- TOC entry 3732 (class 2606 OID 192933)
-- Name: personas personas_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.personas
    ADD CONSTRAINT personas_pkey PRIMARY KEY (codpersona);


--
-- TOC entry 3744 (class 2606 OID 192935)
-- Name: rubros rubros_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.rubros
    ADD CONSTRAINT rubros_pkey PRIMARY KEY (codrubro);


--
-- TOC entry 3746 (class 2606 OID 192937)
-- Name: socios socios_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.socios
    ADD CONSTRAINT socios_pkey PRIMARY KEY (codpersona);


--
-- TOC entry 3748 (class 2606 OID 192939)
-- Name: sociotipos sociotipos_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.sociotipos
    ADD CONSTRAINT sociotipos_pkey PRIMARY KEY (codsociotipo);


--
-- TOC entry 3750 (class 2606 OID 192941)
-- Name: sucursales sucursales_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.sucursales
    ADD CONSTRAINT sucursales_pkey PRIMARY KEY (codsucursal);


--
-- TOC entry 3752 (class 2606 OID 192943)
-- Name: ubigeo ubigeo_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.ubigeo
    ADD CONSTRAINT ubigeo_pkey PRIMARY KEY (codubigeo);


--
-- TOC entry 3754 (class 2606 OID 192945)
-- Name: webservice webservice_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.webservice
    ADD CONSTRAINT webservice_pkey PRIMARY KEY (codempresa);


--
-- TOC entry 3756 (class 2606 OID 192947)
-- Name: moduloperfiles moduloperfil_key; Type: CONSTRAINT; Schema: seguridad; Owner: phuyu15
--

ALTER TABLE ONLY seguridad.moduloperfiles
    ADD CONSTRAINT moduloperfil_key PRIMARY KEY (codmodulo, codperfil);


--
-- TOC entry 3758 (class 2606 OID 192949)
-- Name: modulos modulos_pkey; Type: CONSTRAINT; Schema: seguridad; Owner: phuyu15
--

ALTER TABLE ONLY seguridad.modulos
    ADD CONSTRAINT modulos_pkey PRIMARY KEY (codmodulo);


--
-- TOC entry 3760 (class 2606 OID 192951)
-- Name: perfiles perfiles_pkey; Type: CONSTRAINT; Schema: seguridad; Owner: phuyu15
--

ALTER TABLE ONLY seguridad.perfiles
    ADD CONSTRAINT perfiles_pkey PRIMARY KEY (codperfil);


--
-- TOC entry 3762 (class 2606 OID 192953)
-- Name: sucursalusuarios sucursalusuario_key; Type: CONSTRAINT; Schema: seguridad; Owner: phuyu15
--

ALTER TABLE ONLY seguridad.sucursalusuarios
    ADD CONSTRAINT sucursalusuario_key PRIMARY KEY (codsucursal, codusuario);


--
-- TOC entry 3764 (class 2606 OID 192955)
-- Name: usuarios usuarios_pkey; Type: CONSTRAINT; Schema: seguridad; Owner: phuyu15
--

ALTER TABLE ONLY seguridad.usuarios
    ADD CONSTRAINT usuarios_pkey PRIMARY KEY (codusuario);


--
-- TOC entry 3766 (class 2606 OID 192957)
-- Name: guiasunat guiasunat_pkey; Type: CONSTRAINT; Schema: sunat; Owner: phuyu15
--

ALTER TABLE ONLY sunat.guiasunat
    ADD CONSTRAINT guiasunat_pkey PRIMARY KEY (codguiar);


--
-- TOC entry 3768 (class 2606 OID 192959)
-- Name: kardexsunat kardexsunat_pkey; Type: CONSTRAINT; Schema: sunat; Owner: phuyu15
--

ALTER TABLE ONLY sunat.kardexsunat
    ADD CONSTRAINT kardexsunat_pkey PRIMARY KEY (codkardex);


--
-- TOC entry 3770 (class 2606 OID 192961)
-- Name: kardexsunatanulados pk_kardexsunatanulado; Type: CONSTRAINT; Schema: sunat; Owner: phuyu15
--

ALTER TABLE ONLY sunat.kardexsunatanulados
    ADD CONSTRAINT pk_kardexsunatanulado PRIMARY KEY (codkardex, codresumentipo, nrocorrelativo, periodo, codempresa);


--
-- TOC entry 3772 (class 2606 OID 192963)
-- Name: kardexsunatdetalle pk_kardexsunatdetalle; Type: CONSTRAINT; Schema: sunat; Owner: phuyu15
--

ALTER TABLE ONLY sunat.kardexsunatdetalle
    ADD CONSTRAINT pk_kardexsunatdetalle PRIMARY KEY (codkardex, codresumentipo, nrocorrelativo, periodo, codempresa);


--
-- TOC entry 3774 (class 2606 OID 192965)
-- Name: resumenes pk_resumen; Type: CONSTRAINT; Schema: sunat; Owner: phuyu15
--

ALTER TABLE ONLY sunat.resumenes
    ADD CONSTRAINT pk_resumen PRIMARY KEY (codresumentipo, nrocorrelativo, periodo, codempresa);


--
-- TOC entry 3776 (class 2606 OID 192967)
-- Name: resumentipos resumentipos_pkey; Type: CONSTRAINT; Schema: sunat; Owner: phuyu15
--

ALTER TABLE ONLY sunat.resumentipos
    ADD CONSTRAINT resumentipos_pkey PRIMARY KEY (codresumentipo);


--
-- TOC entry 3778 (class 2606 OID 192969)
-- Name: det_traslado det_traslado_pkey; Type: CONSTRAINT; Schema: ventas; Owner: phuyu15
--

ALTER TABLE ONLY ventas.det_traslado
    ADD CONSTRAINT det_traslado_pkey PRIMARY KEY (id);


--
-- TOC entry 3780 (class 2606 OID 192971)
-- Name: detalle_compras detalle_compras_pkey; Type: CONSTRAINT; Schema: ventas; Owner: phuyu15
--

ALTER TABLE ONLY ventas.detalle_compras
    ADD CONSTRAINT detalle_compras_pkey PRIMARY KEY (id);


--
-- TOC entry 3782 (class 2606 OID 192973)
-- Name: detalle_ventas detalles_venta_pkey; Type: CONSTRAINT; Schema: ventas; Owner: phuyu15
--

ALTER TABLE ONLY ventas.detalle_ventas
    ADD CONSTRAINT detalles_venta_pkey PRIMARY KEY (id);


--
-- TOC entry 3656 (class 1259 OID 192974)
-- Name: fki_fk1_vehiculos; Type: INDEX; Schema: almacen; Owner: phuyu15
--

CREATE INDEX fki_fk1_vehiculos ON almacen.vehiculos USING btree (codvehiculocategoria);


--
-- TOC entry 3657 (class 1259 OID 192975)
-- Name: fki_fk2_vehiculos; Type: INDEX; Schema: almacen; Owner: phuyu15
--

CREATE INDEX fki_fk2_vehiculos ON almacen.vehiculos USING btree (codvehiculomarca);


--
-- TOC entry 3658 (class 1259 OID 192976)
-- Name: fki_fk3_vehiculos; Type: INDEX; Schema: almacen; Owner: phuyu15
--

CREATE INDEX fki_fk3_vehiculos ON almacen.vehiculos USING btree (codvehiculomodelo);


--
-- TOC entry 3810 (class 2606 OID 192977)
-- Name: inventariodetalle fk1_inventariodetalle; Type: FK CONSTRAINT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.inventariodetalle
    ADD CONSTRAINT fk1_inventariodetalle FOREIGN KEY (codproducto, codunidad) REFERENCES almacen.productounidades(codproducto, codunidad);


--
-- TOC entry 3816 (class 2606 OID 192982)
-- Name: principioactivo fk1_principioactivo; Type: FK CONSTRAINT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.principioactivo
    ADD CONSTRAINT fk1_principioactivo FOREIGN KEY (codlinea) REFERENCES almacen.lineas(codlinea);


--
-- TOC entry 3818 (class 2606 OID 192987)
-- Name: productos fk1_producto; Type: FK CONSTRAINT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.productos
    ADD CONSTRAINT fk1_producto FOREIGN KEY (codlinea) REFERENCES almacen.lineas(codlinea);


--
-- TOC entry 3821 (class 2606 OID 192992)
-- Name: productoubicacion fk1_productosubicacion; Type: FK CONSTRAINT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.productoubicacion
    ADD CONSTRAINT fk1_productosubicacion FOREIGN KEY (codproducto, codunidad) REFERENCES almacen.productounidades(codproducto, codunidad);


--
-- TOC entry 3823 (class 2606 OID 192997)
-- Name: productounidades fk1_productosunidades; Type: FK CONSTRAINT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.productounidades
    ADD CONSTRAINT fk1_productosunidades FOREIGN KEY (codunidad) REFERENCES almacen.unidades(codunidad);


--
-- TOC entry 3825 (class 2606 OID 193002)
-- Name: vehiculos fk1_vehiculos; Type: FK CONSTRAINT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.vehiculos
    ADD CONSTRAINT fk1_vehiculos FOREIGN KEY (codvehiculocategoria) REFERENCES almacen.vehiculoscategorias(codvehiculocategoria);


--
-- TOC entry 3812 (class 2606 OID 193007)
-- Name: inventarios fk2_inventario; Type: FK CONSTRAINT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.inventarios
    ADD CONSTRAINT fk2_inventario FOREIGN KEY (codmovimientotipo) REFERENCES almacen.movimientotipos(codmovimientotipo);


--
-- TOC entry 3819 (class 2606 OID 193012)
-- Name: productos fk2_producto; Type: FK CONSTRAINT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.productos
    ADD CONSTRAINT fk2_producto FOREIGN KEY (codmarca) REFERENCES almacen.marcas(codmarca);


--
-- TOC entry 3826 (class 2606 OID 193017)
-- Name: vehiculos fk2_vehiculos; Type: FK CONSTRAINT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.vehiculos
    ADD CONSTRAINT fk2_vehiculos FOREIGN KEY (codvehiculomarca) REFERENCES almacen.vehiculosmarcas(codvehiculomarca);


--
-- TOC entry 3827 (class 2606 OID 193022)
-- Name: vehiculos fk3_vehiculos; Type: FK CONSTRAINT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.vehiculos
    ADD CONSTRAINT fk3_vehiculos FOREIGN KEY (codvehiculomodelo) REFERENCES almacen.vehiculosmodelos(codvehiculomodelo);


--
-- TOC entry 3783 (class 2606 OID 193027)
-- Name: almacenes fk_almacen; Type: FK CONSTRAINT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.almacenes
    ADD CONSTRAINT fk_almacen FOREIGN KEY (codsucursal) REFERENCES public.sucursales(codsucursal);


--
-- TOC entry 3784 (class 2606 OID 193032)
-- Name: guiasr fk_guiasr_modalidadtraslado_1; Type: FK CONSTRAINT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.guiasr
    ADD CONSTRAINT fk_guiasr_modalidadtraslado_1 FOREIGN KEY (codmodalidadtraslado) REFERENCES almacen.modalidadtraslado(codmodalidadtraslado);


--
-- TOC entry 3785 (class 2606 OID 193037)
-- Name: guiasr fk_guiasr_motivotraslado_1; Type: FK CONSTRAINT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.guiasr
    ADD CONSTRAINT fk_guiasr_motivotraslado_1 FOREIGN KEY (codmotivotraslado) REFERENCES almacen.motivotraslado(codmotivotraslado);


--
-- TOC entry 3786 (class 2606 OID 193042)
-- Name: guiasr fk_guiasr_motivotraslado_10; Type: FK CONSTRAINT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.guiasr
    ADD CONSTRAINT fk_guiasr_motivotraslado_10 FOREIGN KEY (codalmacen) REFERENCES almacen.almacenes(codalmacen);


--
-- TOC entry 3787 (class 2606 OID 193047)
-- Name: guiasr fk_guiasr_motivotraslado_2; Type: FK CONSTRAINT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.guiasr
    ADD CONSTRAINT fk_guiasr_motivotraslado_2 FOREIGN KEY (codcomprobantetipo, seriecomprobante) REFERENCES caja.comprobantes(codcomprobantetipo, seriecomprobante);


--
-- TOC entry 3788 (class 2606 OID 193052)
-- Name: guiasr fk_guiasr_motivotraslado_3; Type: FK CONSTRAINT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.guiasr
    ADD CONSTRAINT fk_guiasr_motivotraslado_3 FOREIGN KEY (codpersona) REFERENCES public.personas(codpersona);


--
-- TOC entry 3789 (class 2606 OID 193057)
-- Name: guiasr fk_guiasr_motivotraslado_4; Type: FK CONSTRAINT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.guiasr
    ADD CONSTRAINT fk_guiasr_motivotraslado_4 FOREIGN KEY (codusuario) REFERENCES seguridad.usuarios(codusuario);


--
-- TOC entry 3790 (class 2606 OID 193062)
-- Name: guiasr fk_guiasr_motivotraslado_5; Type: FK CONSTRAINT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.guiasr
    ADD CONSTRAINT fk_guiasr_motivotraslado_5 FOREIGN KEY (codmovimientotipo) REFERENCES almacen.movimientotipos(codmovimientotipo);


--
-- TOC entry 3791 (class 2606 OID 193067)
-- Name: guiasr fk_guiasr_motivotraslado_6; Type: FK CONSTRAINT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.guiasr
    ADD CONSTRAINT fk_guiasr_motivotraslado_6 FOREIGN KEY (codubigeopartida) REFERENCES public.ubigeo(codubigeo);


--
-- TOC entry 3792 (class 2606 OID 193072)
-- Name: guiasr fk_guiasr_motivotraslado_7; Type: FK CONSTRAINT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.guiasr
    ADD CONSTRAINT fk_guiasr_motivotraslado_7 FOREIGN KEY (codubigeollegada) REFERENCES public.ubigeo(codubigeo);


--
-- TOC entry 3793 (class 2606 OID 193077)
-- Name: guiasr fk_guiasr_motivotraslado_8; Type: FK CONSTRAINT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.guiasr
    ADD CONSTRAINT fk_guiasr_motivotraslado_8 FOREIGN KEY (coddocumentotipotransportista) REFERENCES public.documentotipos(coddocumentotipo);


--
-- TOC entry 3794 (class 2606 OID 193082)
-- Name: guiasr fk_guiasr_motivotraslado_9; Type: FK CONSTRAINT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.guiasr
    ADD CONSTRAINT fk_guiasr_motivotraslado_9 FOREIGN KEY (coddocumentotipoconductor) REFERENCES public.documentotipos(coddocumentotipo);


--
-- TOC entry 3795 (class 2606 OID 193087)
-- Name: guiasrdetalle fk_guiasrdetalle_guias_electronicas_1; Type: FK CONSTRAINT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.guiasrdetalle
    ADD CONSTRAINT fk_guiasrdetalle_guias_electronicas_1 FOREIGN KEY (codguiar) REFERENCES almacen.guiasr(codguiar);


--
-- TOC entry 3796 (class 2606 OID 193092)
-- Name: guiasrdetalle fk_guiasrdetalle_guias_electronicas_2; Type: FK CONSTRAINT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.guiasrdetalle
    ADD CONSTRAINT fk_guiasrdetalle_guias_electronicas_2 FOREIGN KEY (codproducto, codunidad) REFERENCES almacen.productounidades(codproducto, codunidad);


--
-- TOC entry 3797 (class 2606 OID 193097)
-- Name: guiast fk_guiast_modalidadtraslado_1; Type: FK CONSTRAINT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.guiast
    ADD CONSTRAINT fk_guiast_modalidadtraslado_1 FOREIGN KEY (codmodalidadtraslado) REFERENCES almacen.modalidadtraslado(codmodalidadtraslado);


--
-- TOC entry 3798 (class 2606 OID 193102)
-- Name: guiast fk_guiast_motivotraslado_1; Type: FK CONSTRAINT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.guiast
    ADD CONSTRAINT fk_guiast_motivotraslado_1 FOREIGN KEY (codmotivotraslado) REFERENCES almacen.motivotraslado(codmotivotraslado);


--
-- TOC entry 3799 (class 2606 OID 193107)
-- Name: guiast fk_guiast_motivotraslado_10; Type: FK CONSTRAINT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.guiast
    ADD CONSTRAINT fk_guiast_motivotraslado_10 FOREIGN KEY (codalmacen) REFERENCES almacen.almacenes(codalmacen);


--
-- TOC entry 3800 (class 2606 OID 193112)
-- Name: guiast fk_guiast_motivotraslado_2; Type: FK CONSTRAINT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.guiast
    ADD CONSTRAINT fk_guiast_motivotraslado_2 FOREIGN KEY (codcomprobantetipo, seriecomprobante) REFERENCES caja.comprobantes(codcomprobantetipo, seriecomprobante);


--
-- TOC entry 3801 (class 2606 OID 193117)
-- Name: guiast fk_guiast_motivotraslado_3; Type: FK CONSTRAINT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.guiast
    ADD CONSTRAINT fk_guiast_motivotraslado_3 FOREIGN KEY (codpersona) REFERENCES public.personas(codpersona);


--
-- TOC entry 3802 (class 2606 OID 193122)
-- Name: guiast fk_guiast_motivotraslado_4; Type: FK CONSTRAINT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.guiast
    ADD CONSTRAINT fk_guiast_motivotraslado_4 FOREIGN KEY (codusuario) REFERENCES seguridad.usuarios(codusuario);


--
-- TOC entry 3803 (class 2606 OID 193127)
-- Name: guiast fk_guiast_motivotraslado_5; Type: FK CONSTRAINT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.guiast
    ADD CONSTRAINT fk_guiast_motivotraslado_5 FOREIGN KEY (codmovimientotipo) REFERENCES almacen.movimientotipos(codmovimientotipo);


--
-- TOC entry 3804 (class 2606 OID 193132)
-- Name: guiast fk_guiast_motivotraslado_6; Type: FK CONSTRAINT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.guiast
    ADD CONSTRAINT fk_guiast_motivotraslado_6 FOREIGN KEY (codubigeopartida) REFERENCES public.ubigeo(codubigeo);


--
-- TOC entry 3805 (class 2606 OID 193137)
-- Name: guiast fk_guiast_motivotraslado_7; Type: FK CONSTRAINT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.guiast
    ADD CONSTRAINT fk_guiast_motivotraslado_7 FOREIGN KEY (codubigeollegada) REFERENCES public.ubigeo(codubigeo);


--
-- TOC entry 3806 (class 2606 OID 193142)
-- Name: guiast fk_guiast_motivotraslado_8; Type: FK CONSTRAINT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.guiast
    ADD CONSTRAINT fk_guiast_motivotraslado_8 FOREIGN KEY (coddocumentotipotransportista) REFERENCES public.documentotipos(coddocumentotipo);


--
-- TOC entry 3807 (class 2606 OID 193147)
-- Name: guiast fk_guiast_motivotraslado_9; Type: FK CONSTRAINT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.guiast
    ADD CONSTRAINT fk_guiast_motivotraslado_9 FOREIGN KEY (coddocumentotipoconductor) REFERENCES public.documentotipos(coddocumentotipo);


--
-- TOC entry 3808 (class 2606 OID 193152)
-- Name: guiastdetalle fk_guiastdetalle_guias_electronicas_1; Type: FK CONSTRAINT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.guiastdetalle
    ADD CONSTRAINT fk_guiastdetalle_guias_electronicas_1 FOREIGN KEY (codguiat) REFERENCES almacen.guiast(codguiat);


--
-- TOC entry 3809 (class 2606 OID 193157)
-- Name: guiastdetalle fk_guiastdetalle_guias_electronicas_2; Type: FK CONSTRAINT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.guiastdetalle
    ADD CONSTRAINT fk_guiastdetalle_guias_electronicas_2 FOREIGN KEY (codproducto, codunidad) REFERENCES almacen.productounidades(codproducto, codunidad);


--
-- TOC entry 3813 (class 2606 OID 193162)
-- Name: inventarios fk_inventario; Type: FK CONSTRAINT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.inventarios
    ADD CONSTRAINT fk_inventario FOREIGN KEY (codalmacen) REFERENCES almacen.almacenes(codalmacen);


--
-- TOC entry 3811 (class 2606 OID 193167)
-- Name: inventariodetalle fk_inventariodetalle; Type: FK CONSTRAINT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.inventariodetalle
    ADD CONSTRAINT fk_inventariodetalle FOREIGN KEY (codinventario) REFERENCES almacen.inventarios(codinventario);


--
-- TOC entry 3814 (class 2606 OID 193172)
-- Name: kardexguiasr fk_kardex_guiasr_1; Type: FK CONSTRAINT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.kardexguiasr
    ADD CONSTRAINT fk_kardex_guiasr_1 FOREIGN KEY (codkardex) REFERENCES kardex.kardex(codkardex);


--
-- TOC entry 3815 (class 2606 OID 193177)
-- Name: kardexguiasrdetalle fk_kardexguiasr_1; Type: FK CONSTRAINT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.kardexguiasrdetalle
    ADD CONSTRAINT fk_kardexguiasr_1 FOREIGN KEY (codkardex, codguiar) REFERENCES almacen.kardexguiasr(codkardex, codguiar);


--
-- TOC entry 3817 (class 2606 OID 193182)
-- Name: principioactivo fk_principioactivo; Type: FK CONSTRAINT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.principioactivo
    ADD CONSTRAINT fk_principioactivo FOREIGN KEY (codfamilia) REFERENCES almacen.familias(codfamilia);


--
-- TOC entry 3820 (class 2606 OID 193187)
-- Name: productos fk_producto; Type: FK CONSTRAINT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.productos
    ADD CONSTRAINT fk_producto FOREIGN KEY (codfamilia) REFERENCES almacen.familias(codfamilia);


--
-- TOC entry 3822 (class 2606 OID 193192)
-- Name: productoubicacion fk_productosubicacion; Type: FK CONSTRAINT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.productoubicacion
    ADD CONSTRAINT fk_productosubicacion FOREIGN KEY (codalmacen) REFERENCES almacen.almacenes(codalmacen);


--
-- TOC entry 3824 (class 2606 OID 193197)
-- Name: productounidades fk_productosunidades; Type: FK CONSTRAINT; Schema: almacen; Owner: phuyu15
--

ALTER TABLE ONLY almacen.productounidades
    ADD CONSTRAINT fk_productosunidades FOREIGN KEY (codproducto) REFERENCES almacen.productos(codproducto);


--
-- TOC entry 3829 (class 2606 OID 193202)
-- Name: comprobantes fk1_comprobante; Type: FK CONSTRAINT; Schema: caja; Owner: phuyu15
--

ALTER TABLE ONLY caja.comprobantes
    ADD CONSTRAINT fk1_comprobante FOREIGN KEY (codsucursal) REFERENCES public.sucursales(codsucursal);


--
-- TOC entry 3831 (class 2606 OID 193207)
-- Name: controldiario fk1_controldiario; Type: FK CONSTRAINT; Schema: caja; Owner: phuyu15
--

ALTER TABLE ONLY caja.controldiario
    ADD CONSTRAINT fk1_controldiario FOREIGN KEY (codusuario) REFERENCES seguridad.usuarios(codusuario);


--
-- TOC entry 3833 (class 2606 OID 193212)
-- Name: ctasctes fk1_ctascte; Type: FK CONSTRAINT; Schema: caja; Owner: phuyu15
--

ALTER TABLE ONLY caja.ctasctes
    ADD CONSTRAINT fk1_ctascte FOREIGN KEY (codmoneda) REFERENCES caja.monedas(codmoneda);


--
-- TOC entry 3840 (class 2606 OID 193217)
-- Name: movimientosdetalle fk1_movdetalle; Type: FK CONSTRAINT; Schema: caja; Owner: phuyu15
--

ALTER TABLE ONLY caja.movimientosdetalle
    ADD CONSTRAINT fk1_movdetalle FOREIGN KEY (codmovimiento) REFERENCES caja.movimientos(codmovimiento);


--
-- TOC entry 3835 (class 2606 OID 193222)
-- Name: movimientos fk1_movimiento; Type: FK CONSTRAINT; Schema: caja; Owner: phuyu15
--

ALTER TABLE ONLY caja.movimientos
    ADD CONSTRAINT fk1_movimiento FOREIGN KEY (codconcepto) REFERENCES caja.conceptos(codconcepto);


--
-- TOC entry 3841 (class 2606 OID 193227)
-- Name: movimientosdetalle fk2_movdetalle; Type: FK CONSTRAINT; Schema: caja; Owner: phuyu15
--

ALTER TABLE ONLY caja.movimientosdetalle
    ADD CONSTRAINT fk2_movdetalle FOREIGN KEY (codtipopago) REFERENCES caja.tipopagos(codtipopago);


--
-- TOC entry 3836 (class 2606 OID 193232)
-- Name: movimientos fk2_movimiento; Type: FK CONSTRAINT; Schema: caja; Owner: phuyu15
--

ALTER TABLE ONLY caja.movimientos
    ADD CONSTRAINT fk2_movimiento FOREIGN KEY (codcomprobantetipo, seriecomprobante) REFERENCES caja.comprobantes(codcomprobantetipo, seriecomprobante);


--
-- TOC entry 3842 (class 2606 OID 193237)
-- Name: movimientosdetalle fk3_movdetalle; Type: FK CONSTRAINT; Schema: caja; Owner: phuyu15
--

ALTER TABLE ONLY caja.movimientosdetalle
    ADD CONSTRAINT fk3_movdetalle FOREIGN KEY (codmoneda) REFERENCES caja.monedas(codmoneda);


--
-- TOC entry 3837 (class 2606 OID 193242)
-- Name: movimientos fk3_movimiento; Type: FK CONSTRAINT; Schema: caja; Owner: phuyu15
--

ALTER TABLE ONLY caja.movimientos
    ADD CONSTRAINT fk3_movimiento FOREIGN KEY (codpersona) REFERENCES public.socios(codpersona);


--
-- TOC entry 3838 (class 2606 OID 193247)
-- Name: movimientos fk4_movimiento; Type: FK CONSTRAINT; Schema: caja; Owner: phuyu15
--

ALTER TABLE ONLY caja.movimientos
    ADD CONSTRAINT fk4_movimiento FOREIGN KEY (codusuario) REFERENCES seguridad.usuarios(codusuario);


--
-- TOC entry 3828 (class 2606 OID 193252)
-- Name: cajas fk_caja; Type: FK CONSTRAINT; Schema: caja; Owner: phuyu15
--

ALTER TABLE ONLY caja.cajas
    ADD CONSTRAINT fk_caja FOREIGN KEY (codsucursal) REFERENCES public.sucursales(codsucursal);


--
-- TOC entry 3830 (class 2606 OID 193257)
-- Name: comprobantes fk_comprobante; Type: FK CONSTRAINT; Schema: caja; Owner: phuyu15
--

ALTER TABLE ONLY caja.comprobantes
    ADD CONSTRAINT fk_comprobante FOREIGN KEY (codcomprobantetipo) REFERENCES caja.comprobantetipos(codcomprobantetipo);


--
-- TOC entry 3832 (class 2606 OID 193262)
-- Name: controldiario fk_controldiario; Type: FK CONSTRAINT; Schema: caja; Owner: phuyu15
--

ALTER TABLE ONLY caja.controldiario
    ADD CONSTRAINT fk_controldiario FOREIGN KEY (codcaja) REFERENCES caja.cajas(codcaja);


--
-- TOC entry 3834 (class 2606 OID 193267)
-- Name: ctasctes fk_ctascte; Type: FK CONSTRAINT; Schema: caja; Owner: phuyu15
--

ALTER TABLE ONLY caja.ctasctes
    ADD CONSTRAINT fk_ctascte FOREIGN KEY (codbanco) REFERENCES caja.bancos(codbanco);


--
-- TOC entry 3843 (class 2606 OID 193272)
-- Name: tipocambios fk_moneda; Type: FK CONSTRAINT; Schema: caja; Owner: phuyu15
--

ALTER TABLE ONLY caja.tipocambios
    ADD CONSTRAINT fk_moneda FOREIGN KEY (codmoneda) REFERENCES caja.monedas(codmoneda);


--
-- TOC entry 3839 (class 2606 OID 193277)
-- Name: movimientos fk_movimiento; Type: FK CONSTRAINT; Schema: caja; Owner: phuyu15
--

ALTER TABLE ONLY caja.movimientos
    ADD CONSTRAINT fk_movimiento FOREIGN KEY (codcontroldiario) REFERENCES caja.controldiario(codcontroldiario);


--
-- TOC entry 3844 (class 2606 OID 193282)
-- Name: creditos fk1_credito; Type: FK CONSTRAINT; Schema: kardex; Owner: phuyu15
--

ALTER TABLE ONLY kardex.creditos
    ADD CONSTRAINT fk1_credito FOREIGN KEY (codcreditoconcepto) REFERENCES kardex.creditoconceptos(codcreditoconcepto);


--
-- TOC entry 3850 (class 2606 OID 193287)
-- Name: kardex fk1_kardex; Type: FK CONSTRAINT; Schema: kardex; Owner: phuyu15
--

ALTER TABLE ONLY kardex.kardex
    ADD CONSTRAINT fk1_kardex FOREIGN KEY (codpersona) REFERENCES public.socios(codpersona);


--
-- TOC entry 3858 (class 2606 OID 193292)
-- Name: kardexdetalle fk1_kardexdetalle; Type: FK CONSTRAINT; Schema: kardex; Owner: phuyu15
--

ALTER TABLE ONLY kardex.kardexdetalle
    ADD CONSTRAINT fk1_kardexdetalle FOREIGN KEY (codproducto, codunidad) REFERENCES almacen.productounidades(codproducto, codunidad);


--
-- TOC entry 3860 (class 2606 OID 193297)
-- Name: pedidos fk1_pedido; Type: FK CONSTRAINT; Schema: kardex; Owner: phuyu15
--

ALTER TABLE ONLY kardex.pedidos
    ADD CONSTRAINT fk1_pedido FOREIGN KEY (codpersona) REFERENCES public.socios(codpersona);


--
-- TOC entry 3863 (class 2606 OID 193302)
-- Name: proformas fk1_proforma; Type: FK CONSTRAINT; Schema: kardex; Owner: phuyu15
--

ALTER TABLE ONLY kardex.proformas
    ADD CONSTRAINT fk1_proforma FOREIGN KEY (codpersona) REFERENCES public.socios(codpersona);


--
-- TOC entry 3848 (class 2606 OID 193307)
-- Name: cuotaspagos fk2_cuotaspago; Type: FK CONSTRAINT; Schema: kardex; Owner: phuyu15
--

ALTER TABLE ONLY kardex.cuotaspagos
    ADD CONSTRAINT fk2_cuotaspago FOREIGN KEY (codmovimiento) REFERENCES caja.movimientos(codmovimiento);


--
-- TOC entry 3851 (class 2606 OID 193312)
-- Name: kardex fk2_kardex; Type: FK CONSTRAINT; Schema: kardex; Owner: phuyu15
--

ALTER TABLE ONLY kardex.kardex
    ADD CONSTRAINT fk2_kardex FOREIGN KEY (codmovimientotipo) REFERENCES almacen.movimientotipos(codmovimientotipo);


--
-- TOC entry 3852 (class 2606 OID 193317)
-- Name: kardex fk3_kardex; Type: FK CONSTRAINT; Schema: kardex; Owner: phuyu15
--

ALTER TABLE ONLY kardex.kardex
    ADD CONSTRAINT fk3_kardex FOREIGN KEY (codmotivonota) REFERENCES kardex.motivonotas(codmotivonota);


--
-- TOC entry 3845 (class 2606 OID 193322)
-- Name: creditos fk_credito; Type: FK CONSTRAINT; Schema: kardex; Owner: phuyu15
--

ALTER TABLE ONLY kardex.creditos
    ADD CONSTRAINT fk_credito FOREIGN KEY (codpersona) REFERENCES public.socios(codpersona);


--
-- TOC entry 3846 (class 2606 OID 193327)
-- Name: creditosanulados fk_creditosanulados; Type: FK CONSTRAINT; Schema: kardex; Owner: phuyu15
--

ALTER TABLE ONLY kardex.creditosanulados
    ADD CONSTRAINT fk_creditosanulados FOREIGN KEY (codcredito) REFERENCES kardex.creditos(codcredito);


--
-- TOC entry 3847 (class 2606 OID 193332)
-- Name: cuotas fk_cuota; Type: FK CONSTRAINT; Schema: kardex; Owner: phuyu15
--

ALTER TABLE ONLY kardex.cuotas
    ADD CONSTRAINT fk_cuota FOREIGN KEY (codcredito) REFERENCES kardex.creditos(codcredito);


--
-- TOC entry 3849 (class 2606 OID 193337)
-- Name: cuotaspagos fk_cuotaspago; Type: FK CONSTRAINT; Schema: kardex; Owner: phuyu15
--

ALTER TABLE ONLY kardex.cuotaspagos
    ADD CONSTRAINT fk_cuotaspago FOREIGN KEY (codcredito, nrocuota) REFERENCES kardex.cuotas(codcredito, nrocuota);


--
-- TOC entry 3853 (class 2606 OID 193342)
-- Name: kardex fk_kardex; Type: FK CONSTRAINT; Schema: kardex; Owner: phuyu15
--

ALTER TABLE ONLY kardex.kardex
    ADD CONSTRAINT fk_kardex FOREIGN KEY (codsucursal) REFERENCES public.sucursales(codsucursal);


--
-- TOC entry 3854 (class 2606 OID 193347)
-- Name: kardexalmacen fk_kardexalmacen; Type: FK CONSTRAINT; Schema: kardex; Owner: phuyu15
--

ALTER TABLE ONLY kardex.kardexalmacen
    ADD CONSTRAINT fk_kardexalmacen FOREIGN KEY (codkardex) REFERENCES kardex.kardex(codkardex);


--
-- TOC entry 3855 (class 2606 OID 193352)
-- Name: kardexalmacenanulado fk_kardexalmacenanulado; Type: FK CONSTRAINT; Schema: kardex; Owner: phuyu15
--

ALTER TABLE ONLY kardex.kardexalmacenanulado
    ADD CONSTRAINT fk_kardexalmacenanulado FOREIGN KEY (codkardexalmacen) REFERENCES kardex.kardexalmacen(codkardexalmacen);


--
-- TOC entry 3856 (class 2606 OID 193357)
-- Name: kardexalmacendetalle fk_kardexalmacendetalle; Type: FK CONSTRAINT; Schema: kardex; Owner: phuyu15
--

ALTER TABLE ONLY kardex.kardexalmacendetalle
    ADD CONSTRAINT fk_kardexalmacendetalle FOREIGN KEY (codkardexalmacen) REFERENCES kardex.kardexalmacen(codkardexalmacen);


--
-- TOC entry 3857 (class 2606 OID 193362)
-- Name: kardexanulados fk_kardexanulado; Type: FK CONSTRAINT; Schema: kardex; Owner: phuyu15
--

ALTER TABLE ONLY kardex.kardexanulados
    ADD CONSTRAINT fk_kardexanulado FOREIGN KEY (codkardex) REFERENCES kardex.kardex(codkardex);


--
-- TOC entry 3859 (class 2606 OID 193367)
-- Name: kardexdetalle fk_kardexdetalle; Type: FK CONSTRAINT; Schema: kardex; Owner: phuyu15
--

ALTER TABLE ONLY kardex.kardexdetalle
    ADD CONSTRAINT fk_kardexdetalle FOREIGN KEY (codkardex) REFERENCES kardex.kardex(codkardex);


--
-- TOC entry 3861 (class 2606 OID 193372)
-- Name: pedidos fk_pedido; Type: FK CONSTRAINT; Schema: kardex; Owner: phuyu15
--

ALTER TABLE ONLY kardex.pedidos
    ADD CONSTRAINT fk_pedido FOREIGN KEY (codsucursal) REFERENCES public.sucursales(codsucursal);


--
-- TOC entry 3862 (class 2606 OID 193377)
-- Name: pedidosdetalle fk_pedidodetalle; Type: FK CONSTRAINT; Schema: kardex; Owner: phuyu15
--

ALTER TABLE ONLY kardex.pedidosdetalle
    ADD CONSTRAINT fk_pedidodetalle FOREIGN KEY (codpedido) REFERENCES kardex.pedidos(codpedido);


--
-- TOC entry 3864 (class 2606 OID 193382)
-- Name: proformas fk_proforma; Type: FK CONSTRAINT; Schema: kardex; Owner: phuyu15
--

ALTER TABLE ONLY kardex.proformas
    ADD CONSTRAINT fk_proforma FOREIGN KEY (codsucursal) REFERENCES public.sucursales(codsucursal);


--
-- TOC entry 3865 (class 2606 OID 193387)
-- Name: proformasdetalle fk_proformadetalle; Type: FK CONSTRAINT; Schema: kardex; Owner: phuyu15
--

ALTER TABLE ONLY kardex.proformasdetalle
    ADD CONSTRAINT fk_proformadetalle FOREIGN KEY (codproforma) REFERENCES kardex.proformas(codproforma);


--
-- TOC entry 3868 (class 2606 OID 193392)
-- Name: asistencias fk1_asistencia; Type: FK CONSTRAINT; Schema: public; Owner: phuyu15
--

ALTER TABLE ONLY public.asistencias
    ADD CONSTRAINT fk1_asistencia FOREIGN KEY (codempleado) REFERENCES public.empleados(codpersona);


--
-- TOC entry 3869 (class 2606 OID 193397)
-- Name: empleados fk1_empleado; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.empleados
    ADD CONSTRAINT fk1_empleado FOREIGN KEY (codarea) REFERENCES public.areas(codarea);


--
-- TOC entry 3866 (class 2606 OID 193402)
-- Name: personas fk1_persona; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.personas
    ADD CONSTRAINT fk1_persona FOREIGN KEY (coddocumentotipo) REFERENCES public.documentotipos(coddocumentotipo);


--
-- TOC entry 3874 (class 2606 OID 193407)
-- Name: socios fk1_socio; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.socios
    ADD CONSTRAINT fk1_socio FOREIGN KEY (codsociotipo) REFERENCES public.sociotipos(codsociotipo);


--
-- TOC entry 3870 (class 2606 OID 193412)
-- Name: empleados fk2_empleado; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.empleados
    ADD CONSTRAINT fk2_empleado FOREIGN KEY (codcargo) REFERENCES public.cargos(codcargo);


--
-- TOC entry 3871 (class 2606 OID 193417)
-- Name: empleados fk3_empleado; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.empleados
    ADD CONSTRAINT fk3_empleado FOREIGN KEY (codsucursal) REFERENCES public.sucursales(codsucursal);


--
-- TOC entry 3872 (class 2606 OID 193422)
-- Name: empleados fk_empleado; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.empleados
    ADD CONSTRAINT fk_empleado FOREIGN KEY (codpersona) REFERENCES public.personas(codpersona);


--
-- TOC entry 3873 (class 2606 OID 193427)
-- Name: empresas fk_empresa; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.empresas
    ADD CONSTRAINT fk_empresa FOREIGN KEY (codpersona) REFERENCES public.personas(codpersona);


--
-- TOC entry 3867 (class 2606 OID 193432)
-- Name: personas fk_persona; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.personas
    ADD CONSTRAINT fk_persona FOREIGN KEY (codubigeo) REFERENCES public.ubigeo(codubigeo);


--
-- TOC entry 3875 (class 2606 OID 193437)
-- Name: socios fk_socio; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.socios
    ADD CONSTRAINT fk_socio FOREIGN KEY (codpersona) REFERENCES public.personas(codpersona);


--
-- TOC entry 3876 (class 2606 OID 193442)
-- Name: sucursales fk_sucursal; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.sucursales
    ADD CONSTRAINT fk_sucursal FOREIGN KEY (codempresa) REFERENCES public.empresas(codempresa);


--
-- TOC entry 3877 (class 2606 OID 193447)
-- Name: webservice fk_webservice; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.webservice
    ADD CONSTRAINT fk_webservice FOREIGN KEY (codempresa) REFERENCES public.empresas(codempresa);


--
-- TOC entry 3878 (class 2606 OID 193452)
-- Name: moduloperfiles fk1_moduloperfil; Type: FK CONSTRAINT; Schema: seguridad; Owner: phuyu15
--

ALTER TABLE ONLY seguridad.moduloperfiles
    ADD CONSTRAINT fk1_moduloperfil FOREIGN KEY (codperfil) REFERENCES seguridad.perfiles(codperfil);


--
-- TOC entry 3880 (class 2606 OID 193457)
-- Name: sucursalusuarios fk1_sucursalusuario; Type: FK CONSTRAINT; Schema: seguridad; Owner: phuyu15
--

ALTER TABLE ONLY seguridad.sucursalusuarios
    ADD CONSTRAINT fk1_sucursalusuario FOREIGN KEY (codusuario) REFERENCES seguridad.usuarios(codusuario);


--
-- TOC entry 3882 (class 2606 OID 193462)
-- Name: usuarios fk1_usuario; Type: FK CONSTRAINT; Schema: seguridad; Owner: phuyu15
--

ALTER TABLE ONLY seguridad.usuarios
    ADD CONSTRAINT fk1_usuario FOREIGN KEY (codperfil) REFERENCES seguridad.perfiles(codperfil);


--
-- TOC entry 3879 (class 2606 OID 193467)
-- Name: moduloperfiles fk_moduloperfil; Type: FK CONSTRAINT; Schema: seguridad; Owner: phuyu15
--

ALTER TABLE ONLY seguridad.moduloperfiles
    ADD CONSTRAINT fk_moduloperfil FOREIGN KEY (codmodulo) REFERENCES seguridad.modulos(codmodulo);


--
-- TOC entry 3881 (class 2606 OID 193472)
-- Name: sucursalusuarios fk_sucursalusuario; Type: FK CONSTRAINT; Schema: seguridad; Owner: phuyu15
--

ALTER TABLE ONLY seguridad.sucursalusuarios
    ADD CONSTRAINT fk_sucursalusuario FOREIGN KEY (codsucursal) REFERENCES public.sucursales(codsucursal);


--
-- TOC entry 3883 (class 2606 OID 193477)
-- Name: usuarios fk_usuario; Type: FK CONSTRAINT; Schema: seguridad; Owner: phuyu15
--

ALTER TABLE ONLY seguridad.usuarios
    ADD CONSTRAINT fk_usuario FOREIGN KEY (codempleado) REFERENCES public.empleados(codpersona);


--
-- TOC entry 3886 (class 2606 OID 193482)
-- Name: kardexsunatanulados fk1_kardexsunatanulado; Type: FK CONSTRAINT; Schema: sunat; Owner: phuyu15
--

ALTER TABLE ONLY sunat.kardexsunatanulados
    ADD CONSTRAINT fk1_kardexsunatanulado FOREIGN KEY (codresumentipo, nrocorrelativo, periodo, codempresa) REFERENCES sunat.resumenes(codresumentipo, nrocorrelativo, periodo, codempresa);


--
-- TOC entry 3888 (class 2606 OID 193487)
-- Name: kardexsunatdetalle fk1_kardexsunatdetalle; Type: FK CONSTRAINT; Schema: sunat; Owner: phuyu15
--

ALTER TABLE ONLY sunat.kardexsunatdetalle
    ADD CONSTRAINT fk1_kardexsunatdetalle FOREIGN KEY (codresumentipo, nrocorrelativo, periodo, codempresa) REFERENCES sunat.resumenes(codresumentipo, nrocorrelativo, periodo, codempresa);


--
-- TOC entry 3884 (class 2606 OID 193492)
-- Name: guiasunat fk_guiaanulado; Type: FK CONSTRAINT; Schema: sunat; Owner: phuyu15
--

ALTER TABLE ONLY sunat.guiasunat
    ADD CONSTRAINT fk_guiaanulado FOREIGN KEY (codguiar) REFERENCES almacen.guiasr(codguiar);


--
-- TOC entry 3885 (class 2606 OID 193497)
-- Name: kardexsunat fk_kardexanulado; Type: FK CONSTRAINT; Schema: sunat; Owner: phuyu15
--

ALTER TABLE ONLY sunat.kardexsunat
    ADD CONSTRAINT fk_kardexanulado FOREIGN KEY (codkardex) REFERENCES kardex.kardex(codkardex);


--
-- TOC entry 3887 (class 2606 OID 193502)
-- Name: kardexsunatanulados fk_kardexsunatanulado; Type: FK CONSTRAINT; Schema: sunat; Owner: phuyu15
--

ALTER TABLE ONLY sunat.kardexsunatanulados
    ADD CONSTRAINT fk_kardexsunatanulado FOREIGN KEY (codkardex) REFERENCES sunat.kardexsunat(codkardex);


--
-- TOC entry 3889 (class 2606 OID 193507)
-- Name: kardexsunatdetalle fk_kardexsunatdetalle; Type: FK CONSTRAINT; Schema: sunat; Owner: phuyu15
--

ALTER TABLE ONLY sunat.kardexsunatdetalle
    ADD CONSTRAINT fk_kardexsunatdetalle FOREIGN KEY (codkardex) REFERENCES sunat.kardexsunat(codkardex);


--
-- TOC entry 3890 (class 2606 OID 193512)
-- Name: resumenes fk_resumen; Type: FK CONSTRAINT; Schema: sunat; Owner: phuyu15
--

ALTER TABLE ONLY sunat.resumenes
    ADD CONSTRAINT fk_resumen FOREIGN KEY (codresumentipo) REFERENCES sunat.resumentipos(codresumentipo);


--
-- TOC entry 4245 (class 0 OID 0)
-- Dependencies: 208
-- Name: TABLE almacenes; Type: ACL; Schema: almacen; Owner: phuyu15
--

GRANT ALL ON TABLE almacen.almacenes TO phuyu15_bayer;


--
-- TOC entry 4247 (class 0 OID 0)
-- Dependencies: 210
-- Name: TABLE atenciones; Type: ACL; Schema: almacen; Owner: phuyu15
--

GRANT ALL ON TABLE almacen.atenciones TO phuyu15_bayer;


--
-- TOC entry 4249 (class 0 OID 0)
-- Dependencies: 212
-- Name: TABLE clase; Type: ACL; Schema: almacen; Owner: phuyu15
--

GRANT ALL ON TABLE almacen.clase TO phuyu15_bayer;


--
-- TOC entry 4251 (class 0 OID 0)
-- Dependencies: 214
-- Name: TABLE familias; Type: ACL; Schema: almacen; Owner: phuyu15
--

GRANT ALL ON TABLE almacen.familias TO phuyu15_bayer;


--
-- TOC entry 4253 (class 0 OID 0)
-- Dependencies: 216
-- Name: TABLE guiasr; Type: ACL; Schema: almacen; Owner: phuyu15
--

GRANT ALL ON TABLE almacen.guiasr TO phuyu15_bayer;


--
-- TOC entry 4255 (class 0 OID 0)
-- Dependencies: 218
-- Name: TABLE guiasrdetalle; Type: ACL; Schema: almacen; Owner: phuyu15
--

GRANT ALL ON TABLE almacen.guiasrdetalle TO phuyu15_bayer;


--
-- TOC entry 4256 (class 0 OID 0)
-- Dependencies: 219
-- Name: TABLE guiast; Type: ACL; Schema: almacen; Owner: phuyu15
--

GRANT ALL ON TABLE almacen.guiast TO phuyu15_bayer;


--
-- TOC entry 4258 (class 0 OID 0)
-- Dependencies: 221
-- Name: TABLE guiastdetalle; Type: ACL; Schema: almacen; Owner: phuyu15
--

GRANT ALL ON TABLE almacen.guiastdetalle TO phuyu15_bayer;


--
-- TOC entry 4259 (class 0 OID 0)
-- Dependencies: 222
-- Name: TABLE inventariodetalle; Type: ACL; Schema: almacen; Owner: phuyu15
--

GRANT ALL ON TABLE almacen.inventariodetalle TO phuyu15_bayer;


--
-- TOC entry 4260 (class 0 OID 0)
-- Dependencies: 223
-- Name: TABLE inventarios; Type: ACL; Schema: almacen; Owner: phuyu15
--

GRANT ALL ON TABLE almacen.inventarios TO phuyu15_bayer;


--
-- TOC entry 4262 (class 0 OID 0)
-- Dependencies: 225
-- Name: TABLE kardexguiasr; Type: ACL; Schema: almacen; Owner: phuyu15
--

GRANT ALL ON TABLE almacen.kardexguiasr TO phuyu15_bayer;


--
-- TOC entry 4263 (class 0 OID 0)
-- Dependencies: 226
-- Name: TABLE kardexguiasrdetalle; Type: ACL; Schema: almacen; Owner: phuyu15
--

GRANT ALL ON TABLE almacen.kardexguiasrdetalle TO phuyu15_bayer;


--
-- TOC entry 4264 (class 0 OID 0)
-- Dependencies: 227
-- Name: TABLE lineas; Type: ACL; Schema: almacen; Owner: phuyu15
--

GRANT ALL ON TABLE almacen.lineas TO phuyu15_bayer;


--
-- TOC entry 4266 (class 0 OID 0)
-- Dependencies: 229
-- Name: TABLE marcas; Type: ACL; Schema: almacen; Owner: phuyu15
--

GRANT ALL ON TABLE almacen.marcas TO phuyu15_bayer;


--
-- TOC entry 4268 (class 0 OID 0)
-- Dependencies: 231
-- Name: TABLE modalidadtraslado; Type: ACL; Schema: almacen; Owner: phuyu15
--

GRANT ALL ON TABLE almacen.modalidadtraslado TO phuyu15_bayer;


--
-- TOC entry 4270 (class 0 OID 0)
-- Dependencies: 233
-- Name: TABLE motivotraslado; Type: ACL; Schema: almacen; Owner: phuyu15
--

GRANT ALL ON TABLE almacen.motivotraslado TO phuyu15_bayer;


--
-- TOC entry 4272 (class 0 OID 0)
-- Dependencies: 235
-- Name: TABLE movimientotipos; Type: ACL; Schema: almacen; Owner: phuyu15
--

GRANT ALL ON TABLE almacen.movimientotipos TO phuyu15_bayer;


--
-- TOC entry 4274 (class 0 OID 0)
-- Dependencies: 237
-- Name: TABLE presentacion; Type: ACL; Schema: almacen; Owner: phuyu15
--

GRANT ALL ON TABLE almacen.presentacion TO phuyu15_bayer;


--
-- TOC entry 4276 (class 0 OID 0)
-- Dependencies: 239
-- Name: TABLE principioactivo; Type: ACL; Schema: almacen; Owner: phuyu15
--

GRANT ALL ON TABLE almacen.principioactivo TO phuyu15_bayer;


--
-- TOC entry 4287 (class 0 OID 0)
-- Dependencies: 241
-- Name: TABLE productos; Type: ACL; Schema: almacen; Owner: phuyu15
--

GRANT ALL ON TABLE almacen.productos TO phuyu15_bayer;


--
-- TOC entry 4289 (class 0 OID 0)
-- Dependencies: 243
-- Name: TABLE productoubicacion; Type: ACL; Schema: almacen; Owner: phuyu15
--

GRANT ALL ON TABLE almacen.productoubicacion TO phuyu15_bayer;


--
-- TOC entry 4290 (class 0 OID 0)
-- Dependencies: 244
-- Name: TABLE productounidades; Type: ACL; Schema: almacen; Owner: phuyu15
--

GRANT ALL ON TABLE almacen.productounidades TO phuyu15_bayer;


--
-- TOC entry 4291 (class 0 OID 0)
-- Dependencies: 245
-- Name: TABLE unidades; Type: ACL; Schema: almacen; Owner: phuyu15
--

GRANT ALL ON TABLE almacen.unidades TO phuyu15_bayer;


--
-- TOC entry 4294 (class 0 OID 0)
-- Dependencies: 248
-- Name: TABLE vehiculos; Type: ACL; Schema: almacen; Owner: phuyu15
--

GRANT ALL ON TABLE almacen.vehiculos TO phuyu15_bayer;


--
-- TOC entry 4296 (class 0 OID 0)
-- Dependencies: 250
-- Name: TABLE vehiculoscategorias; Type: ACL; Schema: almacen; Owner: phuyu15
--

GRANT ALL ON TABLE almacen.vehiculoscategorias TO phuyu15_bayer;


--
-- TOC entry 4298 (class 0 OID 0)
-- Dependencies: 252
-- Name: TABLE vehiculosmarcas; Type: ACL; Schema: almacen; Owner: phuyu15
--

GRANT ALL ON TABLE almacen.vehiculosmarcas TO phuyu15_bayer;


--
-- TOC entry 4300 (class 0 OID 0)
-- Dependencies: 254
-- Name: TABLE vehiculosmodelos; Type: ACL; Schema: almacen; Owner: phuyu15
--

GRANT ALL ON TABLE almacen.vehiculosmodelos TO phuyu15_bayer;


--
-- TOC entry 4302 (class 0 OID 0)
-- Dependencies: 256
-- Name: TABLE bancos; Type: ACL; Schema: caja; Owner: phuyu15
--

GRANT ALL ON TABLE caja.bancos TO phuyu15_bayer;


--
-- TOC entry 4304 (class 0 OID 0)
-- Dependencies: 258
-- Name: TABLE cajas; Type: ACL; Schema: caja; Owner: phuyu15
--

GRANT ALL ON TABLE caja.cajas TO phuyu15_bayer;


--
-- TOC entry 4306 (class 0 OID 0)
-- Dependencies: 260
-- Name: TABLE centrocostos; Type: ACL; Schema: caja; Owner: phuyu15
--

GRANT ALL ON TABLE caja.centrocostos TO phuyu15_bayer;


--
-- TOC entry 4308 (class 0 OID 0)
-- Dependencies: 262
-- Name: TABLE comprobantes; Type: ACL; Schema: caja; Owner: phuyu15
--

GRANT ALL ON TABLE caja.comprobantes TO phuyu15_bayer;


--
-- TOC entry 4309 (class 0 OID 0)
-- Dependencies: 263
-- Name: TABLE comprobantetipos; Type: ACL; Schema: caja; Owner: phuyu15
--

GRANT ALL ON TABLE caja.comprobantetipos TO phuyu15_bayer;


--
-- TOC entry 4311 (class 0 OID 0)
-- Dependencies: 265
-- Name: TABLE conceptos; Type: ACL; Schema: caja; Owner: phuyu15
--

GRANT ALL ON TABLE caja.conceptos TO phuyu15_bayer;


--
-- TOC entry 4313 (class 0 OID 0)
-- Dependencies: 267
-- Name: TABLE controldiario; Type: ACL; Schema: caja; Owner: phuyu15
--

GRANT ALL ON TABLE caja.controldiario TO phuyu15_bayer;


--
-- TOC entry 4315 (class 0 OID 0)
-- Dependencies: 269
-- Name: TABLE ctasctes; Type: ACL; Schema: caja; Owner: phuyu15
--

GRANT ALL ON TABLE caja.ctasctes TO phuyu15_bayer;


--
-- TOC entry 4317 (class 0 OID 0)
-- Dependencies: 271
-- Name: TABLE monedas; Type: ACL; Schema: caja; Owner: phuyu15
--

GRANT ALL ON TABLE caja.monedas TO phuyu15_bayer;


--
-- TOC entry 4319 (class 0 OID 0)
-- Dependencies: 273
-- Name: TABLE movimientos; Type: ACL; Schema: caja; Owner: phuyu15
--

GRANT ALL ON TABLE caja.movimientos TO phuyu15_bayer;


--
-- TOC entry 4321 (class 0 OID 0)
-- Dependencies: 275
-- Name: TABLE movimientosdetalle; Type: ACL; Schema: caja; Owner: phuyu15
--

GRANT ALL ON TABLE caja.movimientosdetalle TO phuyu15_bayer;


--
-- TOC entry 4322 (class 0 OID 0)
-- Dependencies: 276
-- Name: TABLE tipocambios; Type: ACL; Schema: caja; Owner: phuyu15
--

GRANT ALL ON TABLE caja.tipocambios TO phuyu15_bayer;


--
-- TOC entry 4324 (class 0 OID 0)
-- Dependencies: 278
-- Name: TABLE tipopagos; Type: ACL; Schema: caja; Owner: phuyu15
--

GRANT ALL ON TABLE caja.tipopagos TO phuyu15_bayer;


--
-- TOC entry 4326 (class 0 OID 0)
-- Dependencies: 280
-- Name: TABLE creditoconceptos; Type: ACL; Schema: kardex; Owner: phuyu15
--

GRANT ALL ON TABLE kardex.creditoconceptos TO phuyu15_bayer;


--
-- TOC entry 4328 (class 0 OID 0)
-- Dependencies: 282
-- Name: TABLE creditos; Type: ACL; Schema: kardex; Owner: phuyu15
--

GRANT ALL ON TABLE kardex.creditos TO phuyu15_bayer;


--
-- TOC entry 4330 (class 0 OID 0)
-- Dependencies: 284
-- Name: TABLE creditosanulados; Type: ACL; Schema: kardex; Owner: phuyu15
--

GRANT ALL ON TABLE kardex.creditosanulados TO phuyu15_bayer;


--
-- TOC entry 4331 (class 0 OID 0)
-- Dependencies: 285
-- Name: TABLE cuotas; Type: ACL; Schema: kardex; Owner: phuyu15
--

GRANT ALL ON TABLE kardex.cuotas TO phuyu15_bayer;


--
-- TOC entry 4332 (class 0 OID 0)
-- Dependencies: 286
-- Name: TABLE cuotaspagos; Type: ACL; Schema: kardex; Owner: phuyu15
--

GRANT ALL ON TABLE kardex.cuotaspagos TO phuyu15_bayer;


--
-- TOC entry 4334 (class 0 OID 0)
-- Dependencies: 287
-- Name: TABLE kardex; Type: ACL; Schema: kardex; Owner: phuyu15
--

GRANT ALL ON TABLE kardex.kardex TO phuyu15_bayer;


--
-- TOC entry 4336 (class 0 OID 0)
-- Dependencies: 289
-- Name: TABLE kardexalmacen; Type: ACL; Schema: kardex; Owner: phuyu15
--

GRANT ALL ON TABLE kardex.kardexalmacen TO phuyu15_bayer;


--
-- TOC entry 4338 (class 0 OID 0)
-- Dependencies: 291
-- Name: TABLE kardexalmacenanulado; Type: ACL; Schema: kardex; Owner: phuyu15
--

GRANT ALL ON TABLE kardex.kardexalmacenanulado TO phuyu15_bayer;


--
-- TOC entry 4339 (class 0 OID 0)
-- Dependencies: 292
-- Name: TABLE kardexalmacendetalle; Type: ACL; Schema: kardex; Owner: phuyu15
--

GRANT ALL ON TABLE kardex.kardexalmacendetalle TO phuyu15_bayer;


--
-- TOC entry 4340 (class 0 OID 0)
-- Dependencies: 293
-- Name: TABLE kardexanulados; Type: ACL; Schema: kardex; Owner: phuyu15
--

GRANT ALL ON TABLE kardex.kardexanulados TO phuyu15_bayer;


--
-- TOC entry 4341 (class 0 OID 0)
-- Dependencies: 294
-- Name: TABLE kardexdetalle; Type: ACL; Schema: kardex; Owner: phuyu15
--

GRANT ALL ON TABLE kardex.kardexdetalle TO phuyu15_bayer;


--
-- TOC entry 4342 (class 0 OID 0)
-- Dependencies: 295
-- Name: TABLE kardexpedido; Type: ACL; Schema: kardex; Owner: phuyu15
--

GRANT ALL ON TABLE kardex.kardexpedido TO phuyu15_bayer;


--
-- TOC entry 4343 (class 0 OID 0)
-- Dependencies: 296
-- Name: TABLE kardexproforma; Type: ACL; Schema: kardex; Owner: phuyu15
--

GRANT ALL ON TABLE kardex.kardexproforma TO phuyu15_bayer;


--
-- TOC entry 4344 (class 0 OID 0)
-- Dependencies: 297
-- Name: TABLE motivonotas; Type: ACL; Schema: kardex; Owner: phuyu15
--

GRANT ALL ON TABLE kardex.motivonotas TO phuyu15_bayer;


--
-- TOC entry 4346 (class 0 OID 0)
-- Dependencies: 299
-- Name: TABLE pedidos; Type: ACL; Schema: kardex; Owner: phuyu15
--

GRANT ALL ON TABLE kardex.pedidos TO phuyu15_bayer;


--
-- TOC entry 4348 (class 0 OID 0)
-- Dependencies: 301
-- Name: TABLE pedidosdetalle; Type: ACL; Schema: kardex; Owner: phuyu15
--

GRANT ALL ON TABLE kardex.pedidosdetalle TO phuyu15_bayer;


--
-- TOC entry 4349 (class 0 OID 0)
-- Dependencies: 302
-- Name: TABLE proformas; Type: ACL; Schema: kardex; Owner: phuyu15
--

GRANT ALL ON TABLE kardex.proformas TO phuyu15_bayer;


--
-- TOC entry 4351 (class 0 OID 0)
-- Dependencies: 304
-- Name: TABLE proformasdetalle; Type: ACL; Schema: kardex; Owner: phuyu15
--

GRANT ALL ON TABLE kardex.proformasdetalle TO phuyu15_bayer;


--
-- TOC entry 4363 (class 0 OID 0)
-- Dependencies: 332
-- Name: TABLE moduloperfiles; Type: ACL; Schema: seguridad; Owner: phuyu15
--

GRANT ALL ON TABLE seguridad.moduloperfiles TO phuyu15_bayer;


--
-- TOC entry 4364 (class 0 OID 0)
-- Dependencies: 333
-- Name: TABLE modulos; Type: ACL; Schema: seguridad; Owner: phuyu15
--

GRANT ALL ON TABLE seguridad.modulos TO phuyu15_bayer;


--
-- TOC entry 4366 (class 0 OID 0)
-- Dependencies: 335
-- Name: TABLE perfiles; Type: ACL; Schema: seguridad; Owner: phuyu15
--

GRANT ALL ON TABLE seguridad.perfiles TO phuyu15_bayer;


--
-- TOC entry 4368 (class 0 OID 0)
-- Dependencies: 337
-- Name: TABLE sucursalusuarios; Type: ACL; Schema: seguridad; Owner: phuyu15
--

GRANT ALL ON TABLE seguridad.sucursalusuarios TO phuyu15_bayer;


--
-- TOC entry 4369 (class 0 OID 0)
-- Dependencies: 338
-- Name: TABLE usuarios; Type: ACL; Schema: seguridad; Owner: phuyu15
--

GRANT ALL ON TABLE seguridad.usuarios TO phuyu15_bayer;


--
-- TOC entry 4371 (class 0 OID 0)
-- Dependencies: 340
-- Name: TABLE guiasunat; Type: ACL; Schema: sunat; Owner: phuyu15
--

GRANT ALL ON TABLE sunat.guiasunat TO phuyu15_bayer;


--
-- TOC entry 4372 (class 0 OID 0)
-- Dependencies: 341
-- Name: TABLE kardexsunat; Type: ACL; Schema: sunat; Owner: phuyu15
--

GRANT ALL ON TABLE sunat.kardexsunat TO phuyu15_bayer;


--
-- TOC entry 4373 (class 0 OID 0)
-- Dependencies: 342
-- Name: TABLE kardexsunatanulados; Type: ACL; Schema: sunat; Owner: phuyu15
--

GRANT ALL ON TABLE sunat.kardexsunatanulados TO phuyu15_bayer;


--
-- TOC entry 4374 (class 0 OID 0)
-- Dependencies: 343
-- Name: TABLE kardexsunatdetalle; Type: ACL; Schema: sunat; Owner: phuyu15
--

GRANT ALL ON TABLE sunat.kardexsunatdetalle TO phuyu15_bayer;


--
-- TOC entry 4375 (class 0 OID 0)
-- Dependencies: 344
-- Name: TABLE resumenes; Type: ACL; Schema: sunat; Owner: phuyu15
--

GRANT ALL ON TABLE sunat.resumenes TO phuyu15_bayer;


--
-- TOC entry 4376 (class 0 OID 0)
-- Dependencies: 345
-- Name: TABLE resumentipos; Type: ACL; Schema: sunat; Owner: phuyu15
--

GRANT ALL ON TABLE sunat.resumentipos TO phuyu15_bayer;


--
-- TOC entry 4378 (class 0 OID 0)
-- Dependencies: 347
-- Name: TABLE det_traslado; Type: ACL; Schema: ventas; Owner: phuyu15
--

GRANT ALL ON TABLE ventas.det_traslado TO PUBLIC;
GRANT ALL ON TABLE ventas.det_traslado TO phuyu15_bayer;


--
-- TOC entry 4380 (class 0 OID 0)
-- Dependencies: 349
-- Name: TABLE detalle_compras; Type: ACL; Schema: ventas; Owner: phuyu15
--

GRANT ALL ON TABLE ventas.detalle_compras TO PUBLIC;
GRANT ALL ON TABLE ventas.detalle_compras TO phuyu15_bayer;


--
-- TOC entry 4382 (class 0 OID 0)
-- Dependencies: 351
-- Name: TABLE detalle_ventas; Type: ACL; Schema: ventas; Owner: phuyu15
--

GRANT ALL ON TABLE ventas.detalle_ventas TO PUBLIC;
GRANT ALL ON TABLE ventas.detalle_ventas TO phuyu15_bayer;


-- Completed on 2023-05-08 17:25:22

--
-- PostgreSQL database dump complete
--

