var phuyu_ingresos = new Vue({
	el: "#phuyu_ingresos",
	data: {
		cargando: true, registro:0, buscar: "", datos: [], 
		paginacion: {"total":0, "actual":1, "ultima":0, "desde":0, "hasta":0}, offset: 3,
		estado_envio:0,	kardex_ref:0, transferencias:1, texto_transferencia:"", listatransferencias:[], detalletransferencia:[]
	},
	computed: {
		phuyu_actual: function(){
			return this.paginacion.actual;
		},
		phuyu_paginas: function(){
			if (!this.paginacion.hasta) {
				return [];
			}
			var desde = this.paginacion.actual - this.offset;
			if (desde < 1) {
				desde = 1;
			}
			var hasta = desde + (this.offset * 2);
			if (hasta >= this.paginacion.ultima) {
				hasta = this.paginacion.ultima;
			}

			var paginas = [];
			while(desde <= hasta){
				paginas.push(desde); desde++;
			}
			return paginas;
		}
	},
	methods: {
		phuyu_datos: function(){
			this.cargando = true; this.registro = 0;
			this.$http.post(url+phuyu_controller+"/lista",{"buscar":this.buscar, "pagina":this.paginacion.actual}).then(function(data){
				this.datos = data.body.lista; this.paginacion = data.body.paginacion;
				this.cargando = false; phuyu_sistema.phuyu_fin();
			},function(){
				phuyu_sistema.phuyu_alerta("ESTAMOS TENIENDO PROBLEMAS", "ERROR DE RED","error"); this.cargando = false;
			});
		},
		phuyu_buscar: function(){
			this.paginacion.actual = 1; this.phuyu_datos();
		},
		phuyu_paginacion: function(pagina){
			this.paginacion.actual = pagina; this.phuyu_datos();
		},
		
		phuyu_nuevo:function(){
			phuyu_sistema.phuyu_inicio();
			this.$http.post(url+phuyu_controller+"/nuevo").then(function(data){
				$("#phuyu_sistema").empty().html(data.body);
			},function(){
				phuyu_sistema.phuyu_alerta("ESTAMOS TENIENDO PROBLEMAS LO SENTIMOS", "ERROR DE RED","error"); 
				phuyu_sistema.phuyu_fin();
			});
		},
		phuyu_seleccionar: function(registro){
			this.registro = registro;
		},
		phuyu_ver: function(){
			if (this.registro==0) {
				phuyu_sistema.phuyu_alerta("DEBE SELECCIONAR UN INGRESO", "PARA VER EN EL SISTEMA EL INGRESO!!!","error");
			}else{
				$(".compose").slideToggle(); phuyu_sistema.phuyu_loader("phuyu_formulario",180);
				this.$http.get(url+phuyu_controller+"/ver/"+this.registro).then(function(data){
					$("#phuyu_formulario").empty().html(data.body);
				},function(){
					phuyu_sistema.phuyu_alerta("ESTAMOS TENIENDO PROBLEMAS LO SENTIMOS", "ERROR DE RED","error"); phuyu_sistema.phuyu_fin();
				});
			}
		},
		phuyu_editar: function(){
			if (this.registro==0) {
				phuyu_sistema.phuyu_alerta("DEBE SELECCIONAR UN INGRESO", "PARA EDITAR EN EL SISTEMA EL INGRESO ALMACEN !!!","error");
			}else{
				$(".compose").slideToggle(); phuyu_sistema.phuyu_loader("phuyu_formulario",180);
				this.$http.post(url+phuyu_controller+"/editar",{"codregistro":this.registro}).then(function(data){
					$("#phuyu_formulario").empty().html(data.body);
				},function(){
					phuyu_sistema.phuyu_alerta("ESTAMOS TENIENDO PROBLEMAS LO SENTIMOS", "ERROR DE RED","error"); 
					phuyu_sistema.phuyu_fin();
				});
			}
		},
		phuyu_eliminar: function(){
			if (this.registro==0) {
				phuyu_sistema.phuyu_alerta("DEBE SELECCIONAR UN REGISTRO", "PARA ELIMINAR EN EL SISTEMA UN REGISTRO!!!","error");
			}else{
				swal({
					title: "SEGURO ELIMINAR INGRESO DE ALMACEN ?",   
					text: "USTED ESTA POR ELIMINAR UNA INGRESO DE ALMACEN", 
					icon: "warning",
					dangerMode: true,
					buttons: ["CANCELAR", "SI, ELIMINAR"],
				}).then((willDelete) => {
					if (willDelete) {
						this.$http.post(url+phuyu_controller+"/eliminar",{"codregistro":this.registro}).then(function(data){
							if (data.body==1) {
								phuyu_sistema.phuyu_alerta("ELIMINADO CORRECTAMENTE", "UN REGISTRO ELIMINADO EN EL SISTEMA","success");
							}
							else if(data.body==2){
								phuyu_sistema.phuyu_alerta("OCURRIO UN ERROR !!!", "EL INGRESO ESTÁ SUJETO A UNA SALIDA, ELIMINE LA SALIDA Y VUELVE A INTENTARLO","error");
							}else{
								phuyu_sistema.phuyu_alerta("OCURRIO UN ERROR !!!", "SE PERDIÓ LA CONEXION !!! LO SENTIMOS","error");
							}
							this.phuyu_datos();
						}, function(){
							alerta("ESTAMOS TENIENDO PROBLEMAS LO SENTIMOS", "ERROR DE RED","error");
						});
					}
				});
			}
		},

		phuyu_trasferencias: function(){
			this.transferencias = 1; $("#modal_transferencias").modal("show");
			this.$http.get(url+phuyu_controller+"/transferencias").then(function(data){
				this.listatransferencias = data.body;
			},function(){
				phuyu_sistema.phuyu_alerta("NO SE PUEDE ABRIR LA VENTANA DE TRANSAFERENCIAS DE ALMACEN", "ERROR DE RED","error"); 
				$("#modal_transferencias").modal("hide");
			});
		},
		phuyu_detalle: function(campo){
			this.texto_transferencia = "ALM: "+campo.almacen + " *** REF: "+campo.seriecomprobante+" - "+campo.nrocomprobante;
			this.$http.get(url+phuyu_controller+"/transferencia_detalle/"+campo.codkardex).then(function(data){
				this.transferencias = 0; this.detalletransferencia = data.body; this.kardex_ref = campo.codkardex; this.estado_envio = 0;
			},function(){
				phuyu_sistema.phuyu_alerta("NO SE PUEDE ABRIR LA VENTANA DEL DETALLE DE LA TRANSAFERENCIA", "ERROR DE RED","error"); 
				this.transferencias = 1;
			});
		},
		phuyu_calcular: function(campo){
			this.detalletransferencia.subtotal = this.detalletransferencia.subtotal - campo.subtotal;
			campo.subtotal = campo.cantidad * campo.precio;
			this.detalletransferencia.subtotal = this.detalletransferencia.subtotal + campo.subtotal;
		},
		phuyu_guardartransferencia: function(){
			this.estado_envio = 1; phuyu_sistema.phuyu_inicio_guardar("GUARDANDO Y ACEPTANDO LA TRANSFERENCIA DE ALMACEN . . .");
			this.$http.post(url+phuyu_controller+"/guardar_transferencia", {"kardex_ref":this.kardex_ref,"detalle":this.detalletransferencia}).then(function(data){
				if (data.body=="e") {
					phuyu_sistema.phuyu_alerta("SU SESION DE USUARIO A TERMINADO","DEBE INICIAR SESION NUEVAMENTE","error");
				}else{
					if (data.body==1) {
						phuyu_sistema.phuyu_alerta("TRANSFERENCIA DE ALMACEN REGISTRADO","INGRESO DE ALMACEN EN EL SISTEMA","success");
					}else{
						phuyu_sistema.phuyu_alerta("ERROR AL ACEPTAR LA TRANSFERENCIA DE ALMACEN","ERROR DE RED","error");
					}
				}
				phuyu_sistema.phuyu_fin(); this.phuyu_datos(); $("#modal_transferencias").modal("hide");
			}, function(){
				phuyu_sistema.phuyu_alerta("ERROR AL ACEPTAR LA TRANSFERENCIA DE ALMACEN","ERROR DE RED","error"); phuyu_sistema.phuyu_fin();
			});
		}
	},
	created: function(){
		this.phuyu_datos();
	}
});