var phuyu_datos = new Vue({
  el: "#phuyu_datos",
  data: {
    cargando: true,
    registro: 0,
    buscar: "",
    datos: [],
    paginacion: { total: 0, actual: 1, ultima: 0, desde: 0, hasta: 0 },
    offset: 3,
  },
  computed: {
    phuyu_actual: function () {
      return this.paginacion.actual;
    },
    phuyu_paginas: function () {
      if (!this.paginacion.hasta) {
        return [];
      }
      var desde = this.paginacion.actual - this.offset;
      if (desde < 1) {
        desde = 1;
      }
      var hasta = desde + this.offset * 2;
      if (hasta >= this.paginacion.ultima) {
        hasta = this.paginacion.ultima;
      }

      var paginas = [];
      while (desde <= hasta) {
        paginas.push(desde);
        desde++;
      }
      return paginas;
    },
  },
  methods: {
    phuyu_opcion: function () {
      if ($("#phuyu_opcion").val() == 1) {
        this.phuyu_empleados();
      } else {
        this.phuyu_datos_2();
      }
    },
    phuyu_empleados: function () {
      this.cargando = true;
      this.registro = 0;
      this.$http
        .post(url + "administracion/empleados/lista", {
          buscar: this.buscar,
          pagina: this.paginacion.actual,
          sucursal: $("#sucursal_search").val(),
        })
        .then(
          function (data) {
            this.datos = data.body.lista;
            this.paginacion = data.body.paginacion;
            this.cargando = false;
            phuyu_sistema.phuyu_fin();
          },
          function () {
            phuyu_sistema.phuyu_alerta(
              "ESTAMOS TENIENDO PROBLEMAS",
              "ERROR DE RED",
              "error"
            );
            this.cargando = false;
          }
        );
    },
    phuyu_datos_2: function () {
      phuyu_sistema.phuyu_fin();
    },
    phuyu_buscar: function () {
      this.paginacion.actual = 1;
      this.phuyu_opcion();
    },
    phuyu_paginacion: function (pagina) {
      this.paginacion.actual = pagina;
      this.phuyu_opcion();
    },

    phuyu_seleccionar: function (registro) {
      console.log(registro);
      this.registro = registro;
    },

    phuyu_controlar: function () {
      if (this.registro == 0) {
        phuyu_sistema.phuyu_alerta(
          "DEBE SELECCIONAR UN REGISTRO",
          "PARA MARCAR UNA ASISTENCIA!!!",
          "error"
        );
      } else {
        $(".compose").slideToggle();
        phuyu_sistema.phuyu_loader("phuyu_formulario", 180);
        this.$http
          .post(url + phuyu_controller + "/nuevo", {
            codempleado: this.registro,
          })
          .then(
            function (data) {
              $("#phuyu_formulario").empty().html(data.body);
            },
            function () {
              phuyu_sistema.phuyu_alerta(
                "ESTAMOS TENIENDO PROBLEMAS LO SENTIMOS",
                "ERROR DE RED",
                "error"
              );
              phuyu_sistema.phuyu_fin();
            }
          );
      }
    },

    phuyu_sueldo: function () {
      if (this.registro == 0) {
        phuyu_sistema.phuyu_alerta(
          "DEBE SELECCIONAR UN REGISTRO",
          "PARA MARCAR UNA ASISTENCIA!!!",
          "error"
        );
      } else {
        $(".compose").slideToggle();
        phuyu_sistema.phuyu_loader("phuyu_formulario", 180);
        this.$http
          .post(url + phuyu_controller + "/sueldo", {
            codempleado: this.registro,
            // fecha1: this.fecha1,
            // fecha2: this.fecha2
          })
          .then(
            function (data) {
              $("#phuyu_formulario").empty().html(data.body);
            },
            function () {
              phuyu_sistema.phuyu_alerta(
                "ESTAMOS TENIENDO PROBLEMAS LO SENTIMOS",
                "ERROR DE RED",
                "error"
              );
              phuyu_sistema.phuyu_fin();
            }
          );
      }
    },

  },
  created: function () {
    this.phuyu_opcion();
    phuyu_sistema.phuyu_fin();
  },
});
