var phuyu_creditos = new Vue({
	el: "#phuyu_creditos",
	data: {
		cargando: true, registro:0, buscar: "", datos: [],  sessioncaja:0, 
		paginacion: {"total":0, "actual":1, "ultima":0, "desde":0, "hasta":0}, offset: 3
	},
	computed: {
		phuyu_actual: function(){
			return this.paginacion.actual;
		},
		phuyu_paginas: function(){
			if (!this.paginacion.hasta) {
				return [];
			}
			var desde = this.paginacion.actual - this.offset;
			if (desde < 1) {
				desde = 1;
			}
			var hasta = desde + (this.offset * 2);
			if (hasta >= this.paginacion.ultima) {
				hasta = this.paginacion.ultima;
			}

			var paginas = [];
			while(desde <= hasta){
				paginas.push(desde); desde++;
			}
			return paginas;
		}
	},
	methods: {
		phuyu_datos: function(){
			this.cargando = true; this.registro = 0;
			this.$http.post(url+phuyu_controller+"/lista",{"buscar":this.buscar, "pagina":this.paginacion.actual}).then(function(data){
				this.datos = data.body.lista; this.paginacion = data.body.paginacion;
				this.cargando = false; phuyu_sistema.phuyu_fin();
			},function(){
				phuyu_sistema.phuyu_alerta("ESTAMOS TENIENDO PROBLEMAS", "ERROR DE RED","error"); this.cargando = false;
			});

			// VERIFICAMOS EL ESTADO DE LA CAJA //
			if ($("#sessioncaja").val()==0) {
				this.sessioncaja = 0;
			}else{
				this.sessioncaja = 1;
			}
		},
		phuyu_buscar: function(){
			this.paginacion.actual = 1; this.phuyu_datos();
		},
		phuyu_paginacion: function(pagina){
			this.paginacion.actual = pagina; this.phuyu_datos();
		},
		
		phuyu_seleccionar: function(registro){
			this.registro = registro;
		},
		phuyu_nuevo: function(){
			if (this.registro==0) {
				phuyu_sistema.phuyu_alerta("DEBE SELECCIONAR UN REGISTRO", "PARA REGISTRAR UN NUEVO CREDITO !!!","error");
			}else{
				phuyu_sistema.phuyu_inicio();
				this.$http.get(url+phuyu_controller+"/nuevo/"+this.registro).then(function(data){
					$("#phuyu_sistema").empty().html(data.body);
				},function(){
					phuyu_sistema.phuyu_alerta("ESTAMOS TENIENDO PROBLEMAS LO SENTIMOS", "ERROR DE RED","error"); 
					phuyu_sistema.phuyu_fin();
				});
			}
		},
		phuyu_cobranza: function(){
			if (this.registro==0) {
				phuyu_sistema.phuyu_alerta("DEBE SELECCIONAR UN REGISTRO", "PARA REALIZAR LA COBRANZA DE UN CREDITO !!!","error");
			}else{
				phuyu_sistema.phuyu_inicio();
				this.$http.get(url+phuyu_controller+"/cobranza/"+this.registro).then(function(data){
					$("#phuyu_sistema").empty().html(data.body);
				},function(){
					phuyu_sistema.phuyu_alerta("ESTAMOS TENIENDO PROBLEMAS LO SENTIMOS", "ERROR DE RED","error"); 
					phuyu_sistema.phuyu_fin();
				});
			}
		},
		phuyu_historial: function(){
			if (this.registro==0) {
				phuyu_sistema.phuyu_alerta("DEBE SELECCIONAR UN REGISTRO", "PARA VER LOS CREDITOS DEL SOCIO EN EL SISTEMA !!!","error");
			}else{
				phuyu_sistema.phuyu_inicio();
				this.$http.get(url+phuyu_controller+"/historial/"+this.registro).then(function(data){
					$("#phuyu_sistema").empty().html(data.body);
				},function(){
					phuyu_sistema.phuyu_alerta("ESTAMOS TENIENDO PROBLEMAS LO SENTIMOS", "ERROR DE RED","error");
					phuyu_sistema.phuyu_fin();
				});
			}
		},
		phuyu_persona: function(){
			$(".compose").slideToggle(); phuyu_sistema.phuyu_loader("phuyu_formulario",180);
			$(".phuyu_radio").removeAttr('checked'); this.registro = 0;
			this.$http.post(url+"ventas/clientes/nuevo_1").then(function(data){
				$("#phuyu_formulario").empty().html(data.body);
			},function(){
				phuyu_sistema.phuyu_alerta("ESTAMOS TENIENDO PROBLEMAS LO SENTIMOS", "ERROR DE RED","error"); phuyu_sistema.phuyu_fin();
			});
		}
	},
	created: function(){
		this.phuyu_datos();
	}
});