var phuyu_nuevocredito = new Vue({
	el: "#phuyu_nuevocredito",
	data: {
		campos:{
			"codregistro":"","codpersona":phuyu_creditos.registro,"codempleado":0,"fechacredito":$("#fecha").val(),"fechainicio":$("#fecha").val(),
			"nrodias":30,"nrocuotas":1,"codcreditoconcepto":1,"codcajaconcepto":7,"codtipopago":1,"fechadocbanco":$("#fechadocbanco_ref").val(),
			"nrodocbanco":"","importe":"","tasainteres":0,"interes":0,"total":0,"tipocuota":0,"afectacaja":true,"referencia":""
		},
		estado:0, cuotas: []
	},
	methods: {
		phuyu_fecha: function(){
			this.campos.fechainicio = $("#fechainicio").val();
			this.campos.fechacredito = $("#fechacredito").val();
		},
		phuyu_fechamovimiento: function(){
			this.campos.fechadocbanco = $("#fechadocbanco").val();
		},

		phuyu_calcular: function(){
			var importe = Number((this.campos.importe/this.campos.nrocuotas).toFixed(1));
			var interes = Number(( (this.campos.tasainteres*importe/100) ).toFixed(1));
			var total = Number((importe + interes).toFixed(1));
			
			var fechainicio = String(this.campos.fechainicio).split("-");
    		var fecha = new Date(fechainicio[0]+"/"+fechainicio[1]+"/"+fechainicio[2]);

    		this.campos.interes = Number(( (this.campos.tasainteres * this.campos.importe/100) ).toFixed(1));
    		if (this.campos.importe=="") {
    			this.campos.total = 0;
    		}else{
    			this.campos.total = Number(( parseFloat(this.campos.importe) + parseFloat(this.campos.interes) ).toFixed(1));
    		}

			this.cuotas = []; var suma_importe = 0; var suma_total = 0;
			for (var i = 1; i <= this.campos.nrocuotas; i++) {
				if (this.campos.nrodias=="") {
					fecha.setDate(fecha.getDate() + 0);
				}else{
					fecha.setDate(fecha.getDate() + parseInt(this.campos.nrodias));
				}

				year = fecha.getFullYear(); month = String(fecha.getMonth() + 1); day = String(fecha.getDate());
				if (month.length < 2) month = "0"+month;
				if (day.length < 2) day = "0"+day;

				fechavence = year+"-"+month+"-"+day; 

				if (this.campos.nrocuotas==i) {
					importe = Number(( this.campos.importe - parseFloat(suma_importe) ).toFixed(1));
					total = Number(( this.campos.total - parseFloat(suma_total) ).toFixed(1));
				}else{
					suma_importe = Number(( parseFloat(suma_importe) + parseFloat(importe) ).toFixed(1));
					suma_total = Number(( parseFloat(suma_total) + parseFloat(total) ).toFixed(1));
				}

				if (this.campos.tipocuota==1 && i!=1){
					importe = Number((total/this.campos.nrocuotas).toFixed(1));
					interes = Number(( (this.campos.tasainteres*importe/100) ).toFixed(1));
					total = Number((importe + interes).toFixed(1));
				}

				this.cuotas.push({
					"nrocuota":i,"fechavence":fechavence,"importe":importe,"tasa":this.campos.tasainteres,
					"interes":interes,"total":total
				});
			}
		},
		phuyu_guardar: function(){
			if (this.cuotas.length==0) {
				phuyu_sistema.phuyu_noti("DEBE INGRESAR UN MONTO","NO SE ENCONTRARON CUOTAS","error"); 
				return false;
			}

			this.estado = 1; phuyu_sistema.phuyu_inicio_guardar("GUARDANDO CREDITO POR COBRAR . . .");
			this.$http.post(url+phuyu_controller+"/guardar", {"campos":this.campos,"cuotas":this.cuotas}).then(function(data){
				if (data.body=="e") {
					phuyu_sistema.phuyu_alerta("SU SESION DE USUARIO A TERMINADO","DEBE INICIAR SESION NUEVAMENTE","error");
				}else{
					if (data.body==1) {
						phuyu_sistema.phuyu_alerta("CREDITO POR COBRAR REGISTRADO","CREDITO REGISTRADO EN EL SISTEMA","success");
					}else{
						phuyu_sistema.phuyu_alerta("ERROR AL REGISTRAR CREDITO","ERROR DE RED","error");
					}
				}
				phuyu_sistema.phuyu_fin(); phuyu_sistema.phuyu_modulo();
			}, function(){
				phuyu_sistema.phuyu_alerta("ERROR AL CUENTA POR COBRAR","ERROR DE RED","error");
			});
		},
		phuyu_cerrar: function(){
			phuyu_sistema.phuyu_modulo();
		}
	},
	created: function(){
		phuyu_sistema.phuyu_fin();
	}
});