var phuyu_datos = new Vue({
	el: "#phuyu_datos",
	data: {
		cargando:true, campos:campos, cajas:[]
	},
	methods: {
		phuyu_fecha: function(){
			this.campos.fechadesde = $("#fechadesde").val(); 
			this.campos.fechahasta = $("#fechahasta").val(); 
		},
		phuyu_cajas: function(){
			this.campos.cajas = [];
			if (this.campos.codsucursal==0) {
				this.campos.codcaja = 0;
			}else{
				this.$http.get(url+"caja/controlcajas/phuyu_cajas/"+this.campos.codsucursal).then(function(data){
					this.cajas = data.body; this.ver_grafico();
				});
			}
		},
		ver_grafico: function(){
			if (this.campos.fechadesde>this.campos.fechahasta) {
				phuyu_sistema.phuyu_noti("LA FECHA DESDE DEBE SER MAYOR","QUE LA FECHA HASTA","error"); return false;
			}
			ver_grafico(JSON.stringify(this.campos));
		},
		pdf_compras: function(){
			// window.open(url+phuyu_controller+"/pdf_compras?datos="+JSON.stringify(this.campos), "_blank"); //
			var phuyu_url = url+phuyu_controller+"/pdf_compras?datos="+JSON.stringify(this.campos); 
            $("#phuyu_pdf").attr("src",phuyu_url); $("#modal_reportes").modal("show");
		},
		mas_reportes: function(){
			phuyu_sistema.phuyu_noti("OPCION PARA GENERAR REPORTES","MAS PERSONALIZADOS","success");
		}
	},
	created: function(){
		this.phuyu_cajas(); phuyu_sistema.phuyu_fin();
	}
});

function ver_grafico(datos){
	$.getJSON(url+phuyu_controller+"/ver_grafico?datos="+datos, function(data) {
		Highcharts.chart("reporte_compras", {
		    title: {text: "REPORTE GRAFICO DE COMPRAS"},
		    subtitle: {text: "REPORTE DESDE "+$("#fechadesde").val()+" HASTA "+$("#fechahasta").val() },
		    xAxis: {
		        categories: data.categorias
		    },
		    yAxis: {
		        title: { text: "S/. TOTAL EN SOLES" }
		    },
		    series: [{
		        type: "column",
		        name: "S/ ",
		        colorByPoint: true,
		        data: data.totales,
		        showInLegend: false
		    }]
		});
	});
}