var phuyu_operacion = new Vue({
	el: "#phuyu_operacion",
	data: {
		itemlote:0, itemindex: 0,estado:0, codigobarra: "",codtipodocumento:0,codpedido: $("#codpedido").val(),codpersonaref:0,codproforma:$("#codproforma").val(),codimprimir:0,precioingresado:0,
		stockalmacen: $("#stockalmacen").val(), igvsunat:$("#igvsunat").val(), icbpersunat:$("#icbpersunat").val(), rubro:0, series:[], detalle:[],detallelote:[], cuotas:[], putunidades:[],
		campos:{
			codkardex:0, codpersona:2, codmovimientotipo:20, codcomprobantetipo:$("#comprobante").val(),seriecomprobante:$("#serie").val(), nro:"",
			fechacomprobante:"", fechakardex:"", codconcepto:13, descripcion:"REGISTRO POR VENTA", cliente:"CLIENTES VARIOS", direccion:"-",
			codempleado:0, codmoneda:1, tipocambio:0.00, codcentrocosto:0, nroplaca:"", retirar:true, afectacaja:true,nrodocumento:"",
			condicionpago:1, nrodias:30, nrocuotas:1, codcreditoconcepto:3, tasainteres:0, interes:0, totalcredito:0, porcdescuento:0.00, terminarpedido:true
		},
		item:{
			producto:"", unidad:"", cantidad:0, cantidadlote:0,preciobruto:0, descuento:0, porcdescuento:0, preciosinigv:0, precio:0, 
			codafectacionigv:"", igv:0, valorventa:0, conicbper: 0, icbper:0, subtotal:0, descripcion:""
		},
		itemdetalle:{
			producto:"", unidades:"", cantidad:0, cantidadlote:0,preciobruto:0, descuento:0, porcdescuento:0, preciosinigv:0, precio:0, 
			codafectacionigv:"", igv:0, valorventa:0, conicbper: 0, icbper:0, subtotal:0, descripcion:""
		},
		pagos:{
			codtipopago_efectivo:1, monto_efectivo:0, vuelto_efectivo:0, codtipopago_tarjeta:0, monto_tarjeta:0, nrovoucher:""
		},
		operaciones:{
			gravadas:0.00, exoneradas:0.00, inafectas:0.00, gratuitas:0.00
		},
		totales:{
			flete:0.00, gastos:0.00, bruto:0.00, descuentos:0.00, descglobal:0.00, valorventa:0.00, igv:0.00, isc:0.00, icbper:0.00, 
			subtotal:0.00, importe:0.00
		}
	},
	methods: {

		/* FUNCIONES GENERALES DE LA VENTA */

		phuyu_venta: function(){
			swal({
				title: "SEGURO REGISTRAR NUEVA VENTA?",   
				text: "LOS CAMPOS SE QUEDARAN VACIOS ", 
				icon: "warning",
				dangerMode: true,
				buttons: ["CANCELAR", "SI, NUEVA VENTA"],
			}).then((willDelete) => {
				if (willDelete){
					this.phuyu_nueva_venta();
				}
			});
		},
		phuyu_nueva_venta: function(){
			phuyu_sistema.phuyu_inicio(); $(".in").remove();
			this.$http.post(url+phuyu_controller+"/nuevo").then(function(data){
				$("#phuyu_sistema").empty().html(data.body);
			});
		},
		phuyu_lista: function(){
			$("#modal_finventa").modal('hide');
			if ($('.modal-backdrop').is(':visible')) {
			  $('body').removeClass('modal-open'); 
			  $('.modal-backdrop').remove(); 
			};
			phuyu_sistema.phuyu_modulo();
		},
		phuyu_atras: function(){
			phuyu_sistema.phuyu_modulo();
		},
		phuyu_addcliente: function(){
			$(".compose").slideToggle(); $("#phuyu_tituloform").text("CREAR CLIENTE");  phuyu_sistema.phuyu_loader("phuyu_formulario",180); 
			this.$http.post(url+"ventas/clientes/nuevo_1").then(function(data){
				$("#phuyu_formulario").empty().html(data.body);
			},function(){ 
				phuyu_sistema.phuyu_error_operacion(); 
			});
		},
		phuyu_searchpedido: function(){
			$(".compose").slideToggle();$("#phuyu_tituloform").text("BUSCAR PEDIDO");
			phuyu_sistema.phuyu_loader("phuyu_formulario",180); 
			this.$http.post(url+"ventas/pedidos/buscar").then(function(data){
				$("#phuyu_formulario").empty().html(data.body);
			},function(){ 
				phuyu_sistema.phuyu_error_operacion(); 
			});
		},
		phuyu_searchproforma: function(){
			$(".compose").slideToggle();$("#phuyu_tituloform").text("BUSCAR PROFORMA");
			phuyu_sistema.phuyu_loader("phuyu_formulario",180); 
			this.$http.post(url+"ventas/proformas/buscar").then(function(data){
				$("#phuyu_formulario").empty().html(data.body);
			},function(){ 
				phuyu_sistema.phuyu_error_operacion(); 
			});
		},
		phuyu_infocliente: function(){
			if(this.codpersonaref == 0){
				var cliente = $("#codpersona option:selected").text();
				this.campos.cliente = cliente
				this.$http.get(url+"ventas/clientes/infocliente/"+this.campos.codpersona).then(function(data){
					console.log(this.campos.codpersona)
					if (this.campos.codpersona==2) {
						$("#cliente").removeAttr("readonly"); $("#direccion").removeAttr("readonly");
					}else{
						$("#cliente").attr("readonly","true"); $("#direccion").removeAttr("readonly");
						this.campos.direccion = data.body[0].direccion
					}
					this.codtipodocumento = data.body[0].coddocumentotipo; 
					this.campos.nrodocumento = data.body[0].documento;
				});
			}else{
				this.codpersonaref = this.campos.codpersona
				var cliente = $("#codpersona option:selected").text();
				this.campos.cliente = cliente
				this.$http.get(url+"ventas/clientes/infocliente/"+this.codpersonaref).then(function(data){
					if (this.codpersonaref==2) {
						$("#cliente").removeAttr("readonly"); $("#direccion").removeAttr("readonly");
					}else{
						$("#cliente").attr("readonly","true");
					}
					this.codtipodocumento = data.body[0].coddocumentotipo; 
					this.campos.nrodocumento = data.body[0].documento;
				});
			}
        },

		/* DETALLE DE LA VENTA Y TOTALES */

		phuyu_codigobarra: function(){
			if (this.codigobarra!="") {
				this.$http.get(url+"almacen/productos/buscar_codigobarra/"+this.codigobarra).then(function(data){
					if (data.body.cantidad==0) {
						phuyu_sistema.phuyu_alerta("NO EXISTE CODIGO DE BARRA", "REGISTRA EL CODIGO DE BARRA", "error");
					}else{
						if (data.body.cantidad==1) {
							this.phuyu_additem(data.body.info[0],data.body.precio); this.codigobarra = "";
						}else{
							phuyu_sistema.phuyu_alerta("EL CODIGO DE BARRA EXISTE EN MÁS DE UN PRODUCTO", "REGISTRADO MAS DE UNA VEZ", "error");
						}
					}
				});
			}
		},
		phuyu_item: function(){
			$(".compose").slideToggle(); $("#phuyu_tituloform").text("BUSCAR PRODUCTO"); 
			phuyu_sistema.phuyu_loader("phuyu_formulario",180); 

			this.$http.post(url+"almacen/productos/buscar/ventas").then(function(data){
				$("#phuyu_formulario").empty().html(data.body);
			},function(){
				phuyu_sistema.phuyu_error(); 
			});
		},
		phuyu_addpedido: function(pedido){
            var existe_pedido = [];
            if(this.codpedido == pedido.codpedido){
            	phuyu_sistema.phuyu_noti("CUIDADO","EL PEDIDO YA FUE SELECCIONADO","error"); return false;
            }
            this.codpedido = pedido.codpedido
            $("#codpersona").empty().html("<option value='"+pedido.codpersona+"'>"+pedido.cliente+"</option>");

			$(".filter-option").text(pedido.cliente); 
			$("#codpersona").val(pedido.codpersona);
            this.campos.nrodocumento = pedido.documento
            this.campos.cliente = pedido.cliente
            this.campos.direccion = pedido.direccion
            this.campos.codpersona = parseInt(pedido.codpersona)
            this.campos.codcomprobantetipo = pedido.codcomprobantetiporeferencia
            this.campos.codempleado = pedido.codempleado
            if(this.codpedido != ""){
            	this.$http.get(url+"ventas/pedidos/buscarproductos/"+this.codpedido).then(function(data){
            		//console.log(data.body)
					if (data.body.length==0) {
						phuyu_sistema.phuyu_alerta("NO EXISTE EL DETALLE DEL PEDIDO", "CORREGIR POR FAVOR", "error");return;
					}else{

						var datos = data.body
						var filas = [];
						$.each( datos, function( k, v ) {

							var unidades = []; var factores = []; var logo = []; arreglo = [];
					    	unidades = (v.unidades).split(";"); var funidades = [];

					    	for (var i = 0; i < unidades.length; i++) {
			                    factores = (unidades[i]).split("|");
					    		logo = {descripcion:factores[1],codunidad:factores[0],factor:factores[8]};
					    		funidades.push(logo)
					    	}

					    	this.putunidades = funidades;

						    var cantidad_faltante =  parseFloat(v.cantidad) - parseFloat(v.cantidadcomprobante);
					    	v.valorventa = v.preciounitario * cantidad_faltante; v.subtotal = v.preciounitario * cantidad_faltante;

                             filas.push({codproducto: v.codproducto, producto: v.descripcion, codunidad: v.codunidad,unidades: this.putunidades,
					unidad: v.unidad, cantidad: cantidad_faltante, preciobruto: parseFloat(v.preciosinigv).toFixed(2), 
					preciosinigv: parseFloat(v.preciosinigv).toFixed(2), conicbper: v.conicbper, icbper: v.icbper,
					precio: parseFloat(v.preciounitario).toFixed(2),preciorefunitario: v.preciorefunitario, porcdescuento: v.porcdescuento, 
					descuento: v.descuento,codafectacionigv: v.codafectacionigv, igv: v.igv, 
					valorventa: v.valorventa, subtotal:v.subtotal, subtotal_tem:v.subtotal, 
					descripcion:v.descripcion,itempedido:v.item,stock: v.stock,control: v.control})
                             this.putunidades = [];
						});

						this.detalle = filas
						this.phuyu_totales();
					}
					this.phuyu_series(true,pedido.codpersona)
				});
            }

		},
		phuyu_addproforma: function(proforma){
            var existe_proforma = [];
            if(this.codproforma == proforma.codproforma){
            	phuyu_sistema.phuyu_noti("CUIDADO","LA PROFORMA YA FUE SELECCIONADO","error"); return false;
            }
            $("#codpersona").empty().html("<option value='"+proforma.codpersona+"'>"+proforma.razonsocial+"</option>");

			$(".selectpicker").selectpicker("refresh"); $(".filter-option").text(proforma.razonsocial); 
			$("#codpersona").val(proforma.codpersona);
            this.codproforma = proforma.codproforma
            this.campos.cliente = proforma.razonsocial
            this.campos.direccion = proforma.direccion
            this.campos.codpersona = parseInt(proforma.codpersona)
            this.campos.codempleado = proforma.codempleado
            if(this.codproforma != ""){
            	this.$http.get(url+"ventas/proformas/buscarproductos/"+this.codproforma).then(function(data){
            		//console.log(data.body)
					if (data.body.length==0) {
						phuyu_sistema.phuyu_alerta("NO EXISTE EL DETALLE DE LA PROFORMA", "CORREGIR POR FAVOR", "error");return;
					}else{
						var datos = data.body
						var filas = [];
						$.each( datos, function( k, v ) {

							var unidades = []; var factores = []; var logo = []; arreglo = [];
					    	unidades = (v.unidades).split(";"); var funidades = [];

					    	for (var i = 0; i < unidades.length; i++) {
			                    factores = (unidades[i]).split("|");
					    		logo = {descripcion:factores[1],codunidad:factores[0],factor:factores[8]};
					    		funidades.push(logo)
					    	}

					    	this.putunidades = funidades;

						    var cantidad_faltante =  parseFloat(v.cantidad) - parseFloat(v.cantidadcomprobante);
					    	v.valorventa = v.preciounitario * cantidad_faltante; v.subtotal = v.preciounitario * cantidad_faltante;

                             filas.push({codproducto: v.codproducto, producto: v.descripcion, codunidad: v.codunidad,unidades: this.putunidades,
					unidad: v.unidad, cantidad: cantidad_faltante, preciobruto: parseFloat(v.preciosinigv).toFixed(2), 
					preciosinigv: parseFloat(v.preciosinigv).toFixed(2), conicbper: v.conicbper, icbper: parseFloat(v.icbper).toFixed(2),
					precio: parseFloat(v.preciounitario).toFixed(2),preciorefunitario: v.preciorefunitario, porcdescuento: v.porcdescuento, 
					descuento: v.descuento,codafectacionigv: v.codafectacionigv, igv: parseFloat(v.igv).toFixed(2), 
					valorventa: v.valorventa, subtotal:(v.subtotal).toFixed(2), subtotal_tem:v.subtotal, 
					descripcion:v.descripcion,itemproforma:v.item,stock: v.stock,control: v.control})

                             this.putunidades = [];
						});

						this.detalle = filas
						this.phuyu_totales();
					}
					this.phuyu_series(true,proforma.codpersona)
				});
            }

		},
		phuyu_adddetalle: function(producto, precio, lotes){            
			var existe_item = []; flag = false; mensaje1="";mensaje2="";
			if ($("#itemrepetir").val()==0) {
				var existe_item = this.detalle.filter(function(p){
				    if(p.codproducto == producto.codproducto && p.codunidad == producto.codunidad ){
				    	p.cantidad = p.cantidad + 1; return p;
				    };
				});
			}

		    if (existe_item.length==0 || $("#itemrepetir").val()==1) {
                var existe_item = this.detalle.filter(function(p){
				    if(p.codproducto == producto.codproducto && p.codunidad == producto.codunidad && p.codkardexorigen == producto.codkardexorigen){
				    	mensaje1 = 'ALTO!';
				    	mensaje2 = 'EL PRODUCTO CON EL LOTE SELECCIONADO YA SE ENCUENTRA EN EL DETALLE, SELECCIONE OTRO POR FAVOR';
				    	flag = true;
				    };
				});
				if(flag){
					phuyu_sistema.phuyu_noti(mensaje1,mensaje2,"error");return false;
				}
		    	var unidades = []; var factores = []; var logo = []; arreglo = [];
		    	unidades = (producto.unidades).split(";");

		    	for (var i = 0; i < unidades.length; i++) {
                    factores = (unidades[i]).split("|");
		    		logo = {descripcion:factores[1],codunidad:factores[0],factor:factores[8]};
		    		this.putunidades.push(logo)
		    		if(factores[8]==1){
		    			producto.codunidad = factores[0];
		    			producto.unidad = factores[1];
		    			producto.factor = factores[8]
		    		}
		    	}

		    	producto.preciosinigv = producto.precio; producto.precio = precio; 
		    	producto.valorventa = producto.precio; producto.subtotal = producto.precio;
		    	
		    	producto.afectacionigv = 20; producto.igv = 0; var porcentaje = 1;
				if (producto.afectoigvventa==1) {
					var porcentaje = (1 + this.igvsunat) / 100;

					producto.afectacionigv = 10;
					producto.preciosinigv = Number((producto.precio / porcentaje).toFixed(4));
					producto.valorventa = Number((producto.precio / porcentaje).toFixed(2));
					producto.igv = Number((producto.subtotal - producto.valorventa).toFixed(2));
				}
				
				producto.icbper = 0; producto.isc = 0;
				if (producto.afectoicbper==1) {
					producto.icbper = Number((1 * this.icbpersunat).toFixed(2));;
				}

				producto.control = 0;
				if (this.stockalmacen==1) {
					if (producto.controlstock==1) {
						producto.control = 1;
					}
				}
                producto.stock = parseFloat(producto.stock).toFixed(2);
				this.detalle.push({
					codproducto: producto.codproducto, producto: producto.descripcion, codunidad: producto.codunidad,unidadesrec: this.putunidades,
					unidad: producto.unidad, cantidad: 1, stock:producto.stock, control:producto.control, unidades: producto.unidades,
					preciobruto: producto.preciosinigv, preciosinigv: producto.preciosinigv, precio: producto.precio,lote: producto.lote,
					preciorefunitario: producto.precio, porcdescuento: 0, descuento: 0, concaducidad: producto.concaducidad,
					codafectacionigv: producto.afectacionigv, igv: producto.igv, conicbper: producto.afectoicbper, icbper: producto.icbper,
					valorventa: producto.valorventa, subtotal:producto.subtotal, subtotal_tem:producto.subtotal, cantidadlote:0, codkardexorigen:producto.codkardexorigen,
					descripcion:"", calcular: producto.calcular, lotes: this.detallelote, factor: producto.factor, itemorigen:producto.itemorigen
				});
				this.phuyu_totales();
				this.putunidades = [];
				this.detallelote = [];
		    }else{
		    	this.phuyu_calcular(existe_item[0]);
		    }
		},
		phuyu_additem: function(producto,precio){
			if(producto.concaducidad==1){
                this.$http.post(url+"almacen/productos/informacion_lote/"+producto.codproducto).then(function(data){
					var datos = data.body
					var filas = [];
					$.each( datos, function( k, v ) {
						if(v.stockkardex != 0){
                     		filas.push({codkardex:v.codkardex,codproducto: v.codproducto, codunidad: v.codunidad,
							loteproduccion: v.loteproduccion, fechavencimiento: v.fechavencimiento
							, fechaproduccion: v.fechaproduccion,item:v.item, unidad:v.unidad,
							stockkardexconvertido: v.stockkardexconvertido,stockkardex:v.stockkardex});
						}
					});
					this.detallelote = filas;
					this.itemdetalle = producto; this.precioingresado = precio;
					this.itemlote = 0; 
					$("#modal_itemlote").modal({backdrop: 'static', keyboard: false});
				});
			}else{
				producto.lote = "";
				producto.codkardexorigen = 0;
				producto.itemorigen = 0;
				this.phuyu_adddetalle(producto, precio, this.detallelote)
			}
		},
		informacion_unidad: function(index,producto,val){
			var codunidad = this.detalle[index].codunidad;
            var codproducto = producto.codproducto;
            //console.log(producto.codkardexorigen)
            this.$http.post(url+"almacen/productos/informacion_item",{"codunidad": codunidad, "codproducto": codproducto
            	,"concaducidad": producto.concaducidad,"itemorigen":producto.itemorigen,"codkardexorigen":producto.codkardexorigen}).then(function(data){
				//console.log(data)
				producto.preciosinigv = data.body[0].precio; producto.precio = data.body[0].precio; 
		    	producto.valorventa = data.body[0].precio; producto.subtotal = data.body[0].precio;
		    	producto.subtotal_tem = data.body[0].precio;
		    	
		    	this.detalle[index].afectacionigv = 20; this.detalle[index].igv = 0; var porcentaje = 1;
				if (this.detalle[index].afectoigvventa==1) {
					var porcentaje = (1 + this.igvsunat) / 100;

					this.detalle[index].afectacionigv = 10;
					producto.preciosinigv = Number((producto.precio / porcentaje).toFixed(4));
					producto.valorventa = Number((producto.precio / porcentaje).toFixed(2));
					producto.igv = Number((producto.subtotal - producto.valorventa).toFixed(2));
				}
				this.detalle[index].codunidad = codunidad;
				this.detalle[index].stock = (data.body[0].stock).toFixed(2);
				this.detalle[index].factor = data.body[0].factor;

				this.phuyu_itemcalcular(producto,1)
			});
		},
		phuyu_deleteitem: function(index,producto){
			this.detalle.splice(index,1); this.phuyu_totales();
			this.putunidades = []; this.detallelote = [];
		},
		phuyu_itemdetalle: function(index,producto){
			this.item = producto; $("#modal_itemdetalle").modal({backdrop: 'static', keyboard: false});
		},
		phuyu_lotes: function(index,producto){
			this.itemlote = 1;
			this.itemindex = index;
			this.itemdetalle = producto; this.detallelote = producto.lotes; $("#modal_itemlote").modal({backdrop: 'static', keyboard: false});
		},
		phuyu_calcularitem: function(item){
			item.cantidad = item.cantidadlote
			this.phuyu_itemcalcular(item,1)
		},
		phuyu_itemcalcular: function (item,tipoprecio) {
			var porcentaje = 1;
			if (item.codafectacionigv==21) {
				item.preciobruto = 0; item.porcdescuento = 0; item.descuento = 0; item.preciosinigv = 0; item.precio = 0; 
				item.igv = 0; item.valorventa = 0; item.subtotal = 0; 
			}
			if (item.codafectacionigv==10) {
				var porcentaje = (1 + this.igvsunat) / 100;
			}

			if (tipoprecio==-1) {
				item.porcdescuento = Number((item.descuento / item.preciobruto * 100).toFixed(2));
				item.precio = Number((item.preciobruto - item.descuento).toFixed(4)); tipoprecio = 2;
			}
			if (tipoprecio==-2) {
				item.descuento = Number((item.preciobruto * item.porcdescuento / 100).toFixed(4));
				item.precio = Number((item.preciobruto - item.descuento).toFixed(4)); tipoprecio = 2;
			}
			if(tipoprecio==0){
				item.precio = Number((item.preciobruto - item.descuento).toFixed(4));
			}
			
			var descuento = item.descuento;
			if (item.descuento=="") {
				var descuento = 0;
			}
			
			if (tipoprecio==1) {
				item.precio = Number((item.preciosinigv * porcentaje).toFixed(4));
				item.preciobruto = Number((item.precio + descuento).toFixed(4));
			}
			if (tipoprecio==2) {
				item.preciosinigv = Number((item.precio / porcentaje).toFixed(4));
				item.preciobruto = Number((item.precio + descuento).toFixed(4));
			}

			item.icbper = 0;
			if (item.conicbper==1) {
				item.icbper = Number((item.cantidad * this.icbpersunat).toFixed(2));
			}

			item.valorventa = Number((item.cantidad * item.preciosinigv).toFixed(2));
			item.subtotal = Number((item.cantidad * item.precio).toFixed(2));
			item.igv = Number((item.subtotal - item.valorventa).toFixed(2));
			this.phuyu_totales();
		},
		phuyu_itemcalcular_cerrar: function (item) {
			if (parseFloat(item.subtotal) < 0) {
				phuyu_sistema.phuyu_noti("EL SUBTOTAL DEBE SER MAYOR A CERO","REVISAR LOS CAMPOS DEL ITEM","error"); return false;
			}
			$("#modal_itemdetalle").modal("hide");
		},
		phuyu_itemlote_cerrar: function (item,producto) {

			$("#modal_itemlote").modal("hide");
			if(this.itemlote==1){
				var flag = false;
				var index = this.itemindex;
				var existe_item = this.detalle.filter(function(p,i){
				    if(p.codproducto == producto.codproducto && p.codunidad == producto.codunidad && p.codkardexorigen == producto.codkardex && i!=index){
				    	mensaje1 = 'ALTO!';
				    	mensaje2 = 'EL PRODUCTO CON EL LOTE SELECCIONADO YA SE ENCUENTRA EN EL DETALLE, SELECCIONE OTRO POR FAVOR';
				    	flag = true;
				    };
				});
				if(flag){
					phuyu_sistema.phuyu_noti(mensaje1,mensaje2,"error");return false;
				}
				var stockkardex = parseFloat(producto.stockkardexconvertido)/parseFloat(this.detalle[index].factor);
				this.detalle[index].lote = producto.loteproduccion;
				this.detalle[index].stock = (stockkardex).toFixed(2);
				this.detalle[index].codkardexorigen = producto.codkardex;
				this.detalle[index].itemorigen = producto.item;
			}else{
				this.itemdetalle.stock = producto.stockkardexconvertido;
				this.itemdetalle.lote = producto.loteproduccion;
				this.itemdetalle.codkardexorigen = producto.codkardex;
				this.itemdetalle.itemorigen = producto.item;
				this.phuyu_adddetalle(this.itemdetalle, this.precioingresado);
			}
		},
		phuyu_calcular: function(producto){
			console.log(producto)
			var porcentaje = 1;
			if (producto.codafectacionigv==10) {
				var porcentaje = (1 + this.igvsunat) / 100;
			}
			producto.preciosinigv = Number((parseFloat(producto.precio) / porcentaje).toFixed(4));
			producto.preciobruto = Number((parseFloat(producto.precio) + parseFloat(producto.descuento)).toFixed(4));

			producto.valorventa = Number((parseFloat(producto.cantidad) * parseFloat(producto.preciosinigv)).toFixed(2));
			producto.subtotal = Number((parseFloat(producto.cantidad) * parseFloat(producto.precio)).toFixed(2));
			producto.igv = Number((parseFloat(producto.subtotal) - parseFloat(producto.valorventa)).toFixed(2));
			producto.icbper = 0;
			if (producto.conicbper==1) {
				producto.icbper = Number((parseFloat(producto.cantidad) * this.icbpersunat).toFixed(2));
			}
			this.phuyu_totales();
		},
		phuyu_subtotal: function(producto){
			// SI producto.calcular = 1 calcula cantidad, producto.calcular = 2 calcula precio //
			if (producto.calcular==1) {
				if (producto.precio!=0) {
					producto.cantidad = Number((producto.subtotal / producto.precio).toFixed(4));
				}
			}else{
				if (producto.cantidad!=0) {
					producto.precio = Number((producto.subtotal / producto.cantidad).toFixed(4));
				}
			}

			var porcentaje = 1;
			if (producto.codafectacionigv==10) {
				var porcentaje = (1 + this.igvsunat) / 100;
			}
			producto.preciosinigv = Number((producto.precio / porcentaje).toFixed(4));
			producto.preciobruto = Number((producto.precio + producto.descuento).toFixed(4));

			producto.valorventa = Number((producto.cantidad * producto.preciosinigv).toFixed(2));
			producto.igv = Number((producto.subtotal - producto.valorventa).toFixed(2));
			producto.icbper = 0;
			if (producto.conicbper==1) {
				producto.icbper = Number((producto.cantidad * this.icbpersunat).toFixed(2));
			}
			this.phuyu_totales();
		},
		phuyu_totales: function () {
			this.totales.bruto = 0.00; this.totales.descuentos = 0.00; this.totales.descglobal = 0.00;
			this.operaciones.gravadas = 0.00; this.operaciones.inafectas = 0.00; 
			this.operaciones.exoneradas = 0.00; this.operaciones.gratuitas = 0.00;
			this.totales.igv = 0.00; this.totales.isc = 0.00; this.totales.icbper = 0.00;
			this.totales.valorventa = 0.00; this.totales.subtotal = 0.00; this.totales.importe = 0.00;
			t = this;
			var detalle = this.detalle.filter(function(p){
				//console.log('ñpk')
				//console.log(p.preciobruto)
				t.totales.bruto = Number((t.totales.bruto + (p.cantidad * p.preciobruto) ).toFixed(2));
				//console.log('bruto: '+p.preciobruto)
				t.totales.descuentos = Number((t.totales.descuentos + (p.cantidad * p.descuento) ).toFixed(2));

				if (p.codafectacionigv==10) {
					t.operaciones.gravadas = Number((t.operaciones.gravadas + p.subtotal - p.igv).toFixed(2));
				}
				if (p.codafectacionigv==20) {
					//console.log(p.subtotal)
					t.operaciones.exoneradas = Number((t.operaciones.exoneradas + parseFloat(p.subtotal)).toFixed(2));
				}
				if (p.codafectacionigv==30) {
					t.operaciones.inafectas = Number((t.operaciones.inafectas + p.subtotal).toFixed(2));
				}
				if (p.codafectacionigv==21) {
					t.operaciones.gratuitas = Number((t.operaciones.gratuitas + p.subtotal).toFixed(2));
				}

				t.totales.igv = Number((t.totales.igv + parseFloat(p.igv)).toFixed(2));
				t.totales.icbper = Number((t.totales.icbper + parseFloat(p.icbper)).toFixed(2));

				t.totales.valorventa = Number((t.totales.valorventa + parseFloat(p.valorventa) ).toFixed(2));
				t.totales.subtotal = Number((t.totales.subtotal + parseFloat(p.subtotal) ).toFixed(2));
			});

			var subtotal_tem = this.operaciones.gravadas + this.operaciones.inafectas + this.operaciones.exoneradas + this.operaciones.gratuitas;
			//console.log(subtotal_tem)
			this.totales.importe = Number((subtotal_tem + this.totales.igv + this.totales.icbper).toFixed(2));
		},

		/* DATOS GENERALES DE LA VENTA */

		phuyu_guardar: function(){
			if (this.detalle.length==0) {
				phuyu_sistema.phuyu_noti("REGISTRAR UN PRODUCTO EN EL DETALLE", "REGISTRAR ITEM PARA LA VENTA","error"); return false;
			}
			var mensaje = '';
			var flag = false
			var detalle = this.detalle.filter(function(p){
				console.log(p.concaducidad)
				if(p.concaducidad==1){
					if(p.codkardexorigen==""){
						mensaje+='*Ingresar el lote del producto: '+p.producto+'\n';
						flag = true
					}
				}
			});

			if(flag){
				swal("CUIDADO!",mensaje,"warning");return false;
			}

			this.campos.fechacomprobante = $("#fechacomprobante").val();
			this.campos.fechakardex = $("#fechakardex").val();
			this.pagos.monto_efectivo = this.totales.importe;

			this.phuyu_vuelto(); this.phuyu_condicionpago();
			$("#modal_finventa").modal({backdrop: 'static', keyboard: false});
		},

		/* PAGO DE LA VENTA */

		phuyu_series: function($pedido = false, $codpersona = ""){
			if (this.campos.codcomprobantetipo!=undefined) {
				this.estado = 1;
				this.$http.get(url+"caja/controlcajas/phuyu_seriescaja/"+this.campos.codcomprobantetipo).then(function(data){
					this.series = data.body.series; this.estado = 0;
					// this.campos.seriecomprobante = $("#serie").val(); this.phuyu_correlativo();
					this.campos.seriecomprobante = data.body.serie; this.phuyu_correlativo();
				});

                if($pedido){
                	this.codpersonaref = $codpersona
                	this.phuyu_infocliente()
                }else{
					if (this.campos.codcomprobantetipo==10) {
						this.$http.get(url+"ventas/clientes/infocliente/"+this.campos.codpersona).then(function(data){
							this.codtipodocumento = data.body[0].coddocumentotipo;
						});
					}
				}
			}
		},
		phuyu_correlativo: function(){
			if (this.campos.codcomprobantetipo!=undefined) {
				if (this.campos.seriecomprobante!="") {
					this.$http.get(url+"caja/controlcajas/phuyu_correlativo/"+this.campos.codcomprobantetipo+"/"+this.campos.seriecomprobante).then(function(data){
						this.campos.nro = data.body;
					});
				}
			}
		},

		phuyu_pagotarjeta: function(){
			if (this.pagos.codtipopago_tarjeta==0) {
				this.pagos.monto_tarjeta = 0; this.pago.nrovoucher = "";
				$("#monto_tarjeta").attr("readonly","true"); $("#monto_tarjeta").removeAttr("required");
				$("#nrovoucher").attr("readonly","true"); $("#nrovoucher").removeAttr("required");
			}else{
				$("#monto_tarjeta").removeAttr("readonly"); $("#monto_tarjeta").attr("required","true");
				$("#nrovoucher").removeAttr("readonly"); $("#nrovoucher").attr("required","true");
			}
		},
		phuyu_vuelto: function(){
			this.pagos.vuelto_efectivo = Number((this.pagos.monto_efectivo - this.totales.importe).toFixed(2));
			if (this.pagos.vuelto_efectivo<=0) {
				this.pagos.vuelto_efectivo = 0;
			}
		},

		phuyu_condicionpago: function(){
			if (this.campos.condicionpago==2) {
				this.phuyu_cuotas(); this.campos.codconcepto = 15;
			}else{
				this.campos.codconcepto = 13;
			}
		},
		phuyu_cuotas: function(){
			var importe = Number((this.totales.importe/this.campos.nrocuotas).toFixed(1));
			var interes = Number(( (this.campos.tasainteres*importe/100) ).toFixed(1));
			var total = Number((importe + interes).toFixed(1));

    		var fecha = new Date();
    		this.totales.interes = Number(( (this.campos.tasainteres * this.totales.importe/100) ).toFixed(1));
			this.campos.totalcredito = Number(( parseFloat(this.totales.importe) + parseFloat(this.totales.interes) ).toFixed(1));
    		
			this.cuotas = []; var suma_importe = 0; var suma_total = 0;
			for (var i = 1; i <= this.campos.nrocuotas; i++) {
				if (this.campos.nrodias=="") {
					fecha.setDate(fecha.getDate() + 0);
				}else{
					fecha.setDate(fecha.getDate() + parseInt(this.campos.nrodias));
				}

				year = fecha.getFullYear(); month = String(fecha.getMonth() + 1); day = String(fecha.getDate());
				if (month.length < 2) month = "0"+month;
				if (day.length < 2) day = "0"+day;

				fechavence = year+"-"+month+"-"+day;

				if (this.campos.nrocuotas==i) {
					importe = Number(( this.totales.importe - parseFloat(suma_importe) ).toFixed(1));
					total = Number(( this.campos.totalcredito - parseFloat(suma_total) ).toFixed(1));
				}else{
					suma_importe = Number(( parseFloat(suma_importe) + parseFloat(importe) ).toFixed(1));
					suma_total = Number(( parseFloat(suma_total) + parseFloat(total) ).toFixed(1));
				}

				this.cuotas.push({
					"nrocuota":i,"fechavence":fechavence,"importe":importe,"interes":interes,"total":total
				});
			}
		},

		phuyu_pagar: function(){
			if ((this.campos.codcomprobantetipo==10 || this.campos.codcomprobantetipo==25) && this.codtipodocumento!=4) {
				phuyu_sistema.phuyu_noti("PARA EMITIR UNA FACTURA", "DEBE SELECCIONAR UN CLIENTE CON RUC","error"); return false;
			}

			if (this.campos.codcomprobantetipo==12 && this.codtipodocumento==4) {
				phuyu_sistema.phuyu_noti("ALTO! NO PUEDE EMITIR LA BOLETA", "DEBE CAMBIAR DE CLIENTE QUE NO TENGA RUC","error"); return false;
			}

			if (parseFloat(this.totales.importe)>=700) {
				if ((this.campos.codcomprobantetipo==12 || this.campos.codcomprobantetipo==26) && this.codtipodocumento==0) {
					phuyu_sistema.phuyu_noti("PARA EMITIR UNA BOLETA CON MONTO MAYOR A 700.00 SOLES","DEBE SELECCIONAR UN CLIENTE CON DNI","error");
					return false;
				}
			}

			if (this.campos.condicionpago==1) {
				if (this.pagos.codtipopago_tarjeta==0) {
					if (parseFloat(this.pagos.monto_efectivo) < parseFloat(this.totales.importe)) {
						phuyu_sistema.phuyu_noti("EL IMPORTE DEBE SER MAYOR O IGUAL AL TOTAL DE LA VENTA","FALTAN S/. "+
						Number(( parseFloat(this.totales.importe - this.pagos.monto_efectivo) ).toFixed(2)),"error"); return false;
					}
				}else{
					var suma_importe = parseFloat(this.pagos.monto_efectivo) + parseFloat(this.pagos.monto_tarjeta);
					if (parseFloat(suma_importe)!=parseFloat(this.totales.importe)) {
						phuyu_sistema.phuyu_noti("LA SUMA DE LOS IMPORTES DEBE SER IGUAL AL TOTAL DE LA VENTA","DIFERENCIA S/. "+
						Number(( parseFloat(this.totales.importe - suma_importe) ).toFixed(2)),"error"); return false;
					}
				}
			}else{
				if (this.campos.codpersona==2) {
					phuyu_sistema.phuyu_noti("ATENCION USUARIO: EL SISTEMA NO PERMITE REGISTRAR UN CREDITO A CLIENTES VARIOS","","error");
					return false;
				}
			}
			
			this.estado = 1; $(".cargando").show(); $(".formulario").hide(); $(".div_ventarealizada").hide()
			this.$http.post(url+phuyu_controller+"/guardar", {"codpedido":this.codpedido,"codproforma":this.codproforma,"codpersonapedido":this.codpersonaref,"campos":this.campos,"detalle":this.detalle,"cuotas":this.cuotas,"pagos":this.pagos,"totales":this.totales,"detallelote":this.detallelote}).then(function(data){
				if (data.body=="e") {
					phuyu_sistema.phuyu_alerta("SESION DEL USUARIO TERMINADA","DEBE INICIAR SESION NUEVAMENTE","error");
				}else{
					if (data.body.estado==1) {
						this.codimprimir = data.body.codkardex
						$("#modal_finventa").hide();
						if ($('.modal-backdrop').is(':visible')) {
						  $('body').removeClass('modal-open'); 
						  $('.modal-backdrop').remove(); 
						};
						this.phuyu_imprimir(data.body.codkardex)
						if (this.campos.codcomprobantetipo == 10) {
							var codoficial = '01';
							this.phuyu_enviar_comprobante(data.body.codkardex,codoficial);
						}
						this.phuyu_nueva_venta();
					}else{
						if(data.body.estado==0){
							$("#modal_finventa").hide();
							if ($('.modal-backdrop').is(':visible')) {
							  $('body').removeClass('modal-open'); 
							  $('.modal-backdrop').remove(); 
							};
							var informacion = data.body.informacion;
							var mensaje = '';
							$.each(informacion.producto,function(indice, elemento) {
							  mensaje += '* '+elemento+': '+informacion.stock[indice]+' '+informacion.unidad[indice]+'\n';
							});
                           phuyu_sistema.phuyu_alerta("PRODUCTOS SIN STOCK, STOCK ACTUAL DE LOS PRODUCTOS:",mensaje,"error");
                           this.estado = 0;
						}else{
						   phuyu_sistema.phuyu_alerta("ERROR AL REGISTRAR VENTA","ERROR DE RED","error");
						}
					}
				}
				phuyu_sistema.phuyu_fin();
			}, function(){
				phuyu_sistema.phuyu_alerta("ERROR AL REGISTRAR VENTA","ERROR DE RED","error");
				phuyu_sistema.phuyu_fin();
			});
		},
		phuyu_imprimir: function(codkardex){
			/*$(".botones").removeClass('btn-danger');
			if ($("#formato").val()=="ticket") {
				$(".ticket").removeClass('btn-default');
				$(".ticket").addClass('btn-danger');
				window.open(url+"facturacion/formato/ticket/"+codkardex,"_blank");
			}else{
				if($("#formato").val()=="a5"){
					$(".a5").removeClass('btn-default');
				    $(".a5").addClass('btn-danger');
				}else{
					$(".a4").removeClass('btn-default');
				    $(".a4").addClass('btn-danger');
				}
				var phuyu_url = url+"facturacion/formato/"+$("#formato").val()+"/"+codkardex;
				$("#phuyu_pdf").attr("src",phuyu_url);
			}*/

			if ($("#phuyu_formato").val()=='a4') {
				window.open(url+"facturacion/formato/a4/"+codkardex,"_blank");
			}else{
				if ($("#phuyu_formato").val()=='a5') {
					window.open(url+"facturacion/formato/a5/"+codkardex,"_blank");
				}else{
					window.open(url+"facturacion/formato/ticket/"+codkardex,"_blank");
				}
			}
        },
        phuyu_imprimir2: function(formato){
            $(".botones").removeClass('btn-danger');
            $(".botones").addClass('btn-default');
            $("."+formato).addClass('btn-danger');
            if (formato=="ticket") {
                window.open(url+"facturacion/formato/ticket/"+this.codimprimir,"_blank");
                $("#phuyu_pdf").attr("src","");
            }else{
	            var phuyu_url = url+"facturacion/formato/"+formato+"/"+this.codimprimir;
				$("#phuyu_pdf").attr("src",phuyu_url);
            }
        },
        phuyu_enviar_comprobante: function(codkardex,codoficial){
            this.$http.get(url+"facturacion/facturacion/comprobantes_enviar/"+codkardex+"/"+codoficial).then(function(data){
				if (data.body=="e") {
					phuyu_sistema.phuyu_alerta("SESION DEL USUARIO TERMINADA","DEBE INICIAR SESION NUEVAMENTE","error");
				}else{
					phuyu_sistema.phuyu_noti("ATENCION USUARIO:",data.body.mensaje,data.body.alerta);
				}
			}, function(){
				phuyu_sistema.phuyu_alerta("NO SE PUEDE ENVIAR EL COMPROBANTE","SIN CONEXION DE INTERNET","error");
				$("#"+codkardex).removeAttr("disabled"); phuyu_sistema.phuyu_fin(); 				 
			});
        },
        resetear_formulario: function(pedido = false){
        	if(pedido){
        		$(".terminarpedido").show()
        	}else{
        		$(".terminarpedido").hide()
        	}
        	/*if(pedido){
               $(".selectpicker").attr('disabled',pedido)
        	}else{
        	   $(".selectpicker").removeAttr('disabled')
        	   $(".selectpicker").removeClass('disabled')
        	   var len = $(".selectpicker").siblings('button').removeClass('disabled')

        	}*/
            this.detalle = []
            this.phuyu_totales();
            this.codpersonaref = 0;
            this.codpedido = 0;
            this.codproforma = 0;
            phuyu_sistema.phuyu_fin_flavio();
        },
        phuyu_pedido: function(){
			phuyu_sistema.phuyu_inicio()
        	var pedido = false
			if ($("#ventac").is(':checked')) {
				$(".btnpedido").show()
				$(".btnproforma").hide()
				pedido = true
			}
			else if ($("#ventap").is(':checked')) {
				$(".btnproforma").show()
				$(".btnpedido").hide()
				pedido = true
			}else{
				$(".btnpedido").hide()
				$(".btnproforma").hide()
			}
			this.resetear_formulario(pedido)
		}
	},
	created: function(){
		this.phuyu_series(); phuyu_sistema.phuyu_fin(); this.phuyu_pedido();
	}
});

document.addEventListener("keyup", buscar_f11, false);
function buscar_f11(e){
    var keyCode = e.keyCode;
    if(keyCode==122){
    	phuyu_operacion.phuyu_item();
    }
}